/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventListModel;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.SearchTextField;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.Range;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

class DTDocumentList
implements ComponentBuilder {
    private final Range fShowingRange;
    private final FilterList<DTClient> fFilterList;
    private final ListModel fListModel;
    private JList fList;
    private Action fCloseAction;
    private static final Font SYSTEM_FONT = FontUtils.getSystemUIFont();
    private static final Font SELECTED_FONT = SYSTEM_FONT.deriveFont(1);

    DTDocumentList(List<DTClient> list, Range range) {
        BasicEventList basicEventList = new BasicEventList();
        for (DTClient dTClient : list) {
            basicEventList.add((Object)dTClient);
        }
        this.fFilterList = new FilterList((EventList)basicEventList);
        this.fListModel = new EventListModel(this.fFilterList);
        this.fShowingRange = range;
    }

    @Override
    public JComponent getComponent() {
        final SearchTextField searchTextField = new SearchTextField();
        JComponent jComponent = (JComponent)searchTextField.getComponent().getComponent(0);
        jComponent.getInputMap(0).put(KeyStroke.getKeyStroke("ESCAPE"), null);
        jComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 40) {
                    DTDocumentList.this.fList.setSelectedIndex(0);
                    DTDocumentList.this.fList.requestFocusInWindow();
                }
            }
        });
        TextComponentMatcherEditor<DTClient> textComponentMatcherEditor = searchTextField.createTextComponentMatcherEditor(new TextFilterator<DTClient>(){

            public void getFilterStrings(List<String> list, DTClient dTClient) {
                list.add(dTClient.getShortTitle());
            }
        });
        textComponentMatcherEditor.addMatcherEditorListener((MatcherEditor.Listener)new MatcherEditor.Listener<DTClient>(){

            public void changedMatcher(MatcherEditor.Event<DTClient> event) {
                DTDocumentList.this.fFilterList.setMatcher(event.getMatcher());
            }
        });
        this.fList = new MJList(this.fListModel);
        this.fList.setCellRenderer(new Renderer());
        this.fList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter-action");
        this.fList.getActionMap().put("enter-action", (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = DTDocumentList.this.fList.getSelectedValue();
                if (e instanceof DTClient) {
                    DTDocumentList.this.select((DTClient)e);
                }
            }
        });
        MJScrollPane mJScrollPane = new MJScrollPane(this.fList, 20, 31){

            public Dimension getPreferredSize() {
                return DTDocumentList.this.fList.getPreferredSize();
            }
        };
        mJScrollPane.setBorder(null);
        MJPanel mJPanel = new MJPanel(new BorderLayout()){

            public void requestFocus() {
                searchTextField.requestFocus();
            }
        };
        Border border = UIManager.getBorder("PopupMenu.border");
        if (border == null || PlatformInfo.isMacintosh()) {
            border = BorderFactory.createLineBorder(Color.gray);
        }
        mJPanel.setBorder(border);
        mJPanel.add((Component)searchTextField.getComponent(), "North");
        mJPanel.add((Component)mJScrollPane, "Center");
        mJPanel.putClientProperty("mwjavaguitest.instance", this);
        return mJPanel;
    }

    void setCloseAction(Action action) {
        this.fCloseAction = action;
    }

    private void select(DTClient dTClient) {
        dTClient.getSelectAction().actionPerformed(new ActionEvent(this, 1001, "select"));
        if (this.fCloseAction != null) {
            this.fCloseAction.actionPerformed(new ActionEvent(this, 1001, "close"));
        }
    }

    private class Renderer
    extends MJLabel
    implements ListCellRenderer,
    MouseListener,
    MouseMotionListener {
        private DTClient iOverDocument;

        private Renderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 6, 1, 6));
            DTDocumentList.this.fList.addMouseListener(this);
            DTDocumentList.this.fList.addMouseMotionListener(this);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DTClient dTClient = (DTClient)object;
            this.setText(dTClient.getShortTitle());
            bl = dTClient.getSelectAction().isSelected();
            this.setFont(bl ? SELECTED_FONT : SYSTEM_FONT);
            Color color = bl2 || dTClient == this.iOverDocument ? ToolstripTheme.getInstance().getPopupItemHoverFocusColor() : (DTDocumentList.this.fShowingRange == null || DTDocumentList.this.fShowingRange.contains(n) ? UIManager.getColor("control") : Color.white);
            this.setBackground(color);
            this.setToolTipText(dTClient.getShortTitle().equals(dTClient.getTitle()) ? null : dTClient.getTitle());
            return this;
        }

        private DTClient getDocumentAt(Point point) {
            int n = DTDocumentList.this.fList.locationToIndex(point);
            return n >= 0 ? (DTClient)DTDocumentList.this.fList.getModel().getElementAt(n) : null;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) {
                return;
            }
            DTClient dTClient = this.getDocumentAt(mouseEvent.getPoint());
            if (dTClient != null) {
                DTDocumentList.this.select(dTClient);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            DTClient dTClient = this.getDocumentAt(mouseEvent.getPoint());
            if (dTClient != this.iOverDocument) {
                this.iOverDocument = dTClient;
                DTDocumentList.this.fList.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }
    }
}

