/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDragDetector;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DTDragUtilities {
    static final int OUTLINE_THICKNESS = 4;
    static final int TAB_HEIGHT = 20;
    static final int TAB_WIDTH = 70;
    static final int TAB_SHOULDER = 5;
    static final int TAB_BEVEL = 2;
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private static final Color TRANSLUCENT_BACKGROUND = new Color(128, 192, 255, 64);
    private static final Color OPAQUE_OUTLINE = new Color(64, 128, 255);
    private static boolean sIsDraggingWithKeys;
    private static DTDropOutlinePainter sDropOutlinePainter;

    private DTDragUtilities() {
    }

    static void setIsDraggingWithKeys(boolean bl) {
        sIsDraggingWithKeys = bl;
    }

    static boolean isDraggingWithKeys() {
        return sIsDraggingWithKeys;
    }

    static String getToMoveThis(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.ToMoveThisWithKeys" : "status.ToMoveThis");
    }

    static String getToResizeThis(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.ToResizeThisWithKeys" : "status.ToResizeThis");
    }

    static String getToNorth(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoNorth" : "status.ReleasetoNorth");
    }

    static String getToSouth(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoSouth" : "status.ReleasetoSouth");
    }

    static String getToEast(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoEast" : "status.ReleasetoEast");
    }

    static String getToWest(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoWest" : "status.ReleasetoWest");
    }

    static String getToTab(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoTab" : "status.ReleasetoTab");
    }

    static String getToLeaveHint(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoLeave" : "status.ReleasetoLeave");
    }

    static String getToOutlineHint(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoOutline" : "status.ReleasetoOutline");
    }

    static String getToOutsideHint(Object object) {
        return DTDragUtilities.getMessage(object, "status.ReleasetoOutside");
    }

    static String getMinimizeToNorth(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoMinimizeNorth" : "status.ReleasetoMinimizeNorth");
    }

    static String getMinimizeToSouth(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoMinimizeSouth" : "status.ReleasetoMinimizeSouth");
    }

    static String getMinimizeToEast(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoMinimizeEast" : "status.ReleasetoMinimizeEast");
    }

    static String getMinimizeToWest(Object object) {
        return DTDragUtilities.getMessage(object, sIsDraggingWithKeys ? "status.EntertoMinimizeWest" : "status.ReleasetoMinimizeWest");
    }

    static String getMessage(Object object, String string) {
        Desktop desktop;
        String string2;
        if (object instanceof DTOccupant) {
            string2 = ((DTOccupant)object).getShortTitle();
            desktop = ((DTOccupant)object).getDesktop();
        } else if (object instanceof DTDocumentContainer) {
            desktop = ((DTDocumentContainer)object).getDesktop();
            string2 = desktop.getString("title.Documents");
        } else {
            return null;
        }
        Object[] objectArray = new Object[]{string2};
        return MessageFormat.format(desktop.getString(string), objectArray);
    }

    static void showHint(DTFrame dTFrame, String string) {
        if (Desktop.dragAndDropHintsEnabled() && dTFrame != null) {
            dTFrame.setStatusText(string);
        }
    }

    static DTDropOutlinePainter getDropOutlinePainter() {
        if (sDropOutlinePainter == null) {
            sDropOutlinePainter = DTDragUtilities.isTranslucencySupported() ? new WindowOutlinePainter(true) : (DTDragUtilities.isTransparencySupported() ? new WindowOutlinePainter(false) : new XOROutlinePainter());
        }
        return sDropOutlinePainter;
    }

    static boolean usesWindow(DTDropOutlinePainter dTDropOutlinePainter) {
        return dTDropOutlinePainter instanceof WindowOutlinePainter;
    }

    static boolean usesTransparentWindow(DTDropOutlinePainter dTDropOutlinePainter) {
        return dTDropOutlinePainter instanceof WindowOutlinePainter && !((WindowOutlinePainter)dTDropOutlinePainter).fTranslucent;
    }

    private static int getTabWidth(int n) {
        return Math.min(150, n / 3);
    }

    private static boolean isTranslucencySupported() {
        if (PlatformInfo.getVersion() < 7) {
            return false;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
            if (((Boolean)method.invoke(null, graphicsConfiguration)).booleanValue()) {
                new TranslucentOutlineWindow(null).dispose();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isTransparencySupported() {
        if (PlatformInfo.getVersion() < 7) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Class<?> clazz2 = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            Object obj = Enum.valueOf(clazz2, "PERPIXEL_TRANSPARENT");
            Method method = clazz.getMethod("isTranslucencySupported", clazz2);
            return (Boolean)method.invoke(null, obj);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Color getOutlineColor() {
        return MJUtilities.isHighContrast() ? ColorUtils.getBlackOrWhiteContrasting((Color)UIManager.getColor("control")) : OPAQUE_OUTLINE;
    }

    static Point getDragStartPoint(DTTitleBar dTTitleBar) {
        Point point = new Point(dTTitleBar.getWidth() / 2 - DTDragDetector.DEFAULT_THRESHOLD.width - 2, dTTitleBar.getHeight() / 2);
        Component component = dTTitleBar.getComponentAt(point);
        if (component != dTTitleBar && (component = dTTitleBar.getComponentAt(point = new Point(0, 0))) != dTTitleBar) {
            point.x = component.getX() + component.getWidth() + 1;
            point.y = dTTitleBar.getHeight() / 2;
        }
        return point;
    }

    static int getNearestEdge(Point point, Dimension dimension, float f) {
        boolean bl;
        int n = (int)(f * (float)dimension.width);
        int n2 = (int)(f * (float)dimension.height);
        if (point.x > n && point.x < dimension.width - n && point.y > n2 && point.y < dimension.height - n2) {
            return 0;
        }
        int n3 = dimension.height * point.x;
        int n4 = dimension.width * point.y;
        boolean bl2 = n3 > n4;
        boolean bl3 = bl = n3 < dimension.height * dimension.width - n4;
        if (bl2) {
            return bl ? 1 : 3;
        }
        return bl ? 7 : 5;
    }

    private static class TransparentOutlineWindow
    extends OutlineWindow {
        protected DTDropOutlinePainter.OutlineType fPreviousOutlineType = DTDropOutlinePainter.OutlineType.RECTANGLE;
        protected boolean fPreviouslyHadClip;

        TransparentOutlineWindow(Window window) throws Exception {
            super(window);
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            boolean bl = this.fClipRect != null;
            super.setBounds(n, n2, n3, n4);
            if (n3 != n5 || n4 != n6 || this.fPreviousOutlineType != this.fOutlineType || bl || this.fPreviouslyHadClip) {
                this.fPreviousOutlineType = this.fOutlineType;
                this.fPreviouslyHadClip = bl;
                Rectangle rectangle = new Rectangle(0, 0, n3, n4);
                Area area = new Area(rectangle);
                if (this.fOutlineType == DTDropOutlinePainter.OutlineType.RECTANGLE) {
                    rectangle.grow(-4, -4);
                    area.subtract(new Area(rectangle));
                } else {
                    int n7 = Math.min(150, n3 / 3);
                    int n8 = n3 - n7;
                    area.subtract(new Area(new Rectangle(0, 0, n8, 20)));
                    area.subtract(new Area(new Rectangle(n8 + 4, 4, n7 - 8, 24)));
                    area.subtract(new Area(new Rectangle(4, 24, n3 - 8, n4 - 8 - 20)));
                }
                if (this.fClipRect != null) {
                    area.intersect(new Area(this.fClipRect));
                }
                try {
                    Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                    Method method = clazz.getMethod("setWindowShape", Window.class, Shape.class);
                    method.invoke(null, this, area);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    Log.logException((Exception)exception);
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            this.drawOutline((Graphics2D)graphics, this.getWidth(), this.getHeight());
        }
    }

    private static class TranslucentOutlineWindow
    extends OutlineWindow {
        TranslucentOutlineWindow(Window window) throws Exception {
            super(window);
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(null, this, false);
        }

        @Override
        public void paint(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(AlphaComposite.Src);
            if (this.fClipRect != null) {
                graphics2D.setClip(this.fClipRect.x, this.fClipRect.y, this.fClipRect.width, this.fClipRect.height);
            }
            if (this.fOutlineType == DTDropOutlinePainter.OutlineType.RECTANGLE) {
                graphics.setColor(TRANSLUCENT_BACKGROUND);
                graphics.fillRect(0, 0, n, n2);
            } else {
                int n3 = DTDragUtilities.getTabWidth(n);
                int n4 = n - n3;
                graphics.setColor(TRANSPARENT_COLOR);
                graphics.fillRect(0, 0, n4, 20);
                graphics.setColor(TRANSLUCENT_BACKGROUND);
                graphics.fillRect(n4, 0, n3, 20);
                graphics.fillRect(0, 20, n, n2 - 20);
            }
            this.drawOutline(graphics2D, n, n2);
        }
    }

    private static class OutlineWindow
    extends Window {
        protected DTDropOutlinePainter.OutlineType fOutlineType = DTDropOutlinePainter.OutlineType.RECTANGLE;
        protected Rectangle fClipRect;

        OutlineWindow(Window window) throws Exception {
            super(window);
            this.setFocusable(false);
            if (DTDragUtilities.isDraggingWithKeys()) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        void setOutlineType(DTDropOutlinePainter.OutlineType outlineType) {
            if (outlineType != this.fOutlineType) {
                this.fOutlineType = outlineType;
                this.repaint();
            }
        }

        void setClipRect(Rectangle rectangle) {
            this.fClipRect = rectangle;
        }

        protected void drawOutline(Graphics2D graphics2D, int n, int n2) {
            int n3 = 2;
            graphics2D.setColor(DTDragUtilities.getOutlineColor());
            graphics2D.setStroke(new BasicStroke(4.0f));
            if (this.fOutlineType == DTDropOutlinePainter.OutlineType.RECTANGLE) {
                graphics2D.drawRect(n3, n3, n - 4, n2 - 4);
            } else {
                int n4 = DTDragUtilities.getTabWidth(n);
                int n5 = n - n4;
                int[] nArray = new int[6];
                int[] nArray2 = new int[6];
                nArray[0] = n3;
                nArray2[0] = 20 + n3;
                nArray[1] = n5 + n3;
                nArray2[1] = nArray2[0];
                nArray[2] = nArray[1];
                nArray2[2] = n3;
                nArray[3] = n - n3;
                nArray2[3] = nArray2[2];
                nArray[4] = nArray[3];
                nArray2[4] = n2 - n3;
                nArray[5] = nArray[0];
                nArray2[5] = nArray2[4];
                graphics2D.drawPolygon(nArray, nArray2, nArray.length);
            }
        }
    }

    private static class WindowOutlinePainter
    implements DTDropOutlinePainter {
        private OutlineWindow fOutlineWindow;
        private boolean fTranslucent;

        WindowOutlinePainter(boolean bl) {
            this.fTranslucent = bl;
        }

        @Override
        public void show(Component component, int n, int n2, int n3, int n4, DTDropOutlinePainter.OutlineType outlineType) {
            Serializable serializable;
            if (this.fOutlineWindow != null && (this.fOutlineWindow.getWidth() != n3 || this.fOutlineWindow.getHeight() != n4)) {
                this.fOutlineWindow.dispose();
                this.fOutlineWindow = null;
            }
            if (this.fOutlineWindow == null) {
                try {
                    serializable = component == null ? null : SwingUtilities.windowForComponent(component);
                    this.fOutlineWindow = this.fTranslucent ? new TranslucentOutlineWindow((Window)serializable) : new TransparentOutlineWindow((Window)serializable);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    Log.logException((Exception)exception);
                }
            }
            serializable = new Point(n, n2);
            Rectangle rectangle = null;
            if (component != null) {
                SwingUtilities.convertPointToScreen((Point)serializable, component);
                Rectangle rectangle2 = new Rectangle(0, 0, component.getWidth(), component.getHeight());
                Rectangle rectangle3 = new Rectangle(n, n2, n3, n4);
                if (!rectangle2.contains(rectangle3)) {
                    rectangle2.x -= n;
                    rectangle2.y -= n2;
                    rectangle = rectangle2;
                }
            }
            this.fOutlineWindow.setOutlineType(outlineType);
            this.fOutlineWindow.setClipRect(rectangle);
            this.fOutlineWindow.setBounds(((Point)serializable).x, ((Point)serializable).y, n3, n4);
            if (!this.fOutlineWindow.isVisible()) {
                this.fOutlineWindow.setVisible(true);
            }
        }

        @Override
        public void hide(boolean bl) {
            if (this.fOutlineWindow != null) {
                if (bl) {
                    this.fOutlineWindow.dispose();
                    this.fOutlineWindow = null;
                } else {
                    this.fOutlineWindow.setVisible(false);
                }
            }
        }
    }

    private static class XOROutlinePainter
    implements DTDropOutlinePainter {
        private Rectangle fPreviousBounds;
        private DTDropOutlinePainter.OutlineType fPreviousType;
        private Component fPreviousComponent;

        private XOROutlinePainter() {
        }

        @Override
        public void show(Component component, int n, int n2, int n3, int n4, DTDropOutlinePainter.OutlineType outlineType) {
            Graphics2D graphics2D = null;
            if (this.fPreviousBounds != null) {
                graphics2D = (Graphics2D)this.fPreviousComponent.getGraphics();
                XOROutlinePainter.drawOutline(graphics2D, this.fPreviousBounds, this.fPreviousType);
            }
            if (graphics2D != null && component != this.fPreviousComponent) {
                graphics2D.dispose();
                graphics2D = null;
            }
            if (component == null) {
                this.fPreviousBounds = null;
                this.fPreviousComponent = null;
                return;
            }
            if (graphics2D == null) {
                graphics2D = (Graphics2D)component.getGraphics();
            }
            this.fPreviousBounds = new Rectangle(n, n2, n3, n4);
            this.fPreviousType = outlineType;
            this.fPreviousComponent = component;
            XOROutlinePainter.drawOutline(graphics2D, this.fPreviousBounds, outlineType);
            graphics2D.dispose();
        }

        @Override
        public void hide(boolean bl) {
            if (this.fPreviousBounds != null) {
                Graphics2D graphics2D = (Graphics2D)this.fPreviousComponent.getGraphics();
                XOROutlinePainter.drawOutline(graphics2D, this.fPreviousBounds, this.fPreviousType);
                this.fPreviousBounds = null;
                this.fPreviousComponent = null;
                graphics2D.dispose();
            }
        }

        private static void drawOutline(Graphics2D graphics2D, Rectangle rectangle, DTDropOutlinePainter.OutlineType outlineType) {
            if (outlineType == DTDropOutlinePainter.OutlineType.RECTANGLE) {
                XOROutlinePainter.drawRectOutline(graphics2D, rectangle);
            } else {
                XOROutlinePainter.drawTabOutline(graphics2D, rectangle);
            }
        }

        private static void drawRectOutline(Graphics2D graphics2D, Rectangle rectangle) {
            graphics2D.setXORMode(Color.gray);
            graphics2D.setStroke(new BasicStroke(4.0f));
            int n = 2;
            int n2 = 6;
            graphics2D.drawRect(rectangle.x + n, rectangle.y + n, rectangle.width - n2, rectangle.height - n2);
        }

        private static void drawTabOutline(Graphics2D graphics2D, Rectangle rectangle) {
            Point point = rectangle.getLocation();
            int n = 2;
            int n2 = 6;
            point.x += n;
            point.y += n;
            int n3 = rectangle.width - n2;
            int n4 = rectangle.height - n2;
            int[] nArray = new int[7];
            int[] nArray2 = new int[7];
            nArray[0] = point.x;
            nArray2[0] = point.y + 20;
            nArray[1] = point.x;
            nArray2[1] = point.y + n4;
            nArray[2] = point.x + n3;
            nArray2[2] = nArray2[1];
            nArray[3] = nArray[2];
            nArray2[3] = point.y;
            nArray[4] = nArray[3] - DTDragUtilities.getTabWidth(n3);
            nArray2[4] = nArray2[3];
            nArray[5] = nArray[4];
            nArray2[5] = nArray2[0];
            nArray[6] = nArray[0];
            nArray2[6] = nArray2[0];
            graphics2D.setXORMode(Color.gray);
            graphics2D.setStroke(new BasicStroke(4.0f));
            graphics2D.drawPolygon(nArray, nArray2, nArray.length - 1);
        }
    }
}

