/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDocumentArranger;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTRelativeLocation;
import com.mathworks.widgets.desk.DTTabbedDocumentPane;
import com.mathworks.widgets.desk.DTTiledLocation;
import java.awt.Dimension;
import java.util.List;

class DTMaximizedPane
extends DTTabbedDocumentPane {
    DTMaximizedPane(DTDocumentContainer dTDocumentContainer) {
        super(dTDocumentContainer, dTDocumentContainer.getTabProperties());
        this.setNewAction(this.fDocumentContainer.getGroup().getNewAction());
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        DTLocation dTLocation2 = dTClient.getLastFloatingInLocation();
        if (dTLocation2 == null) {
            dTLocation2 = DTLocation.createInternal(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        dTLocation2.setFrame(this.fDocumentContainer.getFrame());
        dTLocation2.setContainer(this.fDocumentContainer);
        ((DTFloatingLocation)dTLocation2).setMaximized(true);
        super.add(dTOccupant, dTLocation);
        dTClient.setLocation(dTLocation2);
        dTClient.locationChanged();
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        super.remove(dTOccupant);
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)dTClient.getLocation();
        if (dTFloatingLocation.isMaximized()) {
            dTFloatingLocation.setMaximized(false);
            dTFloatingLocation.setFrameBounds(dTFloatingLocation.getRestoreBounds());
        }
    }

    @Override
    public List<DTClient> removeAllDocuments() {
        List<DTClient> list = super.removeAllDocuments();
        for (DTClient dTClient : list) {
            DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)dTClient.getLocation();
            if (!dTFloatingLocation.isMaximized()) continue;
            dTFloatingLocation.setMaximized(false);
            dTFloatingLocation.setFrameBounds(dTFloatingLocation.getRestoreBounds());
        }
        return list;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.fVisibleDocument != null) {
            Dimension dimension = this.fVisibleDocument.getInternalFrame().getSize();
            for (DTClient dTClient : this.getOrderedDocuments()) {
                if (dTClient.getLocation() == null) continue;
                dTClient.getLocation().setFrameBounds(0, 0, dimension.width, dimension.height);
            }
        }
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
        if (dTLocation instanceof DTRelativeLocation) {
            DTClient dTClient = (DTClient)object;
            int n = ((DTRelativeLocation)dTLocation).getDirection();
            if (n == 0) {
                dTClient.setSelected(true);
            } else {
                DTClient dTClient2 = this.fDocumentContainer.getMostRecentlySelected();
                List<DTClient> list = this.getOrderedDocuments();
                this.fDocumentContainer.setArrangement(2, n == 1 || n == 5 ? new Dimension(1, 2) : new Dimension(2, 1), false);
                this.fDocumentContainer.continueArrangementChange();
                int n2 = n == 1 || n == 7 ? 0 : 1;
                DTDocumentArranger dTDocumentArranger = this.fDocumentContainer.getArranger();
                for (DTClient dTClient3 : list) {
                    if (dTClient3 == dTClient) continue;
                    dTDocumentArranger.add(dTClient3, new DTTiledLocation(1 - n2));
                }
                dTDocumentArranger.add(dTClient, new DTTiledLocation(n2));
                if (dTClient2 != null) {
                    dTClient2.requestFocusInWindow();
                }
                this.fDocumentContainer.endArrangementChange();
            }
        }
    }
}

