/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTAsyncWindowCloser;
import com.mathworks.widgets.desk.DTBorderLocation;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTCloseReplyListener;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTNestedLocation;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTPropertyBridge;
import com.mathworks.widgets.desk.DTPropertyProvider;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarFactory;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolBarRegistry;
import com.mathworks.widgets.desk.DTToolBarUtilities;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public abstract class DTOccupant
implements DTSelectable,
PropertyChangeListener,
DTAsyncWindowCloser,
DTToolBarRegistry.Registrant {
    protected Desktop fDesktop;
    protected String fTitle;
    protected String fName;
    protected boolean fIsGuest;
    protected DTLocation fLocation;
    protected DTLocation fLastLocation;
    protected DTLocation fLastDockedLocation;
    protected DTFloatingLocation fLastUndockedLocation;
    protected DTNestedLocation fLastNestedLocation;
    protected DTInternalFrame fInternalFrame;
    private ComponentListener fInternalFrameVisibilityListener = new InternalFrameVisibilityListener();
    protected DTPropertyProvider fPropertyProvider;
    protected List<PropertyChangeListener> fPropertyListeners;
    protected DTCloseReplyListener fCloseReplyListener;
    protected boolean fIsConsideringSelection;
    protected int fSelectionOrder;
    protected Object fToolBarState;
    protected HashMap<String, ToolBarData> fToolBarDataMap = new HashMap();
    protected List<OccupantAction> fActions = new ArrayList<OccupantAction>();
    protected boolean fIsOpen;
    protected boolean fIsEnabled = true;
    protected boolean fIsClosing;
    protected boolean fIsMinimizing;
    protected boolean fIsMaximizing;
    protected boolean fIsRestoring;
    protected boolean fWasSelectedWhenCloseInitiated;
    private volatile boolean fHasBeenFlushed;
    protected OccupantAction fOpenAction;
    protected OccupantAction fCloseAction;
    protected OccupantAction fDockAction;
    protected OccupantAction fUndockAction;
    protected OccupantAction fMinimizeAction;
    protected OccupantAction fMaximizeAction;
    protected OccupantAction fMoveAction;
    protected OccupantAction fResizeAction;
    protected OccupantAction fSelectAction;
    protected OccupantAction fToggleAction;
    public static final String SELECTED_PROPERTY = "Occupant Selected";
    static final String IN_FRONT_PROPERTY = "Occupant In Front";
    static final String ENABLED_PROPERTY = "Occupant Enabled";
    static final String CONSIDERING_SELECTION_PROPERTY = "Occupant Considering Selection";
    private static final List<String> emptyListOfStrings = Collections.emptyList();
    private static final DTToolBarConfiguration NULL_CONFIG = new DTToolBarConfiguration(emptyListOfStrings);
    protected static final String NAME_ATTRIBUTE = "Name";
    protected static final String TITLE_ATTRIBUTE = "Title";
    protected static final String TITLE_RESOURCE_ATTRIBUTE = "TitleResource";
    protected static final String GUEST_ATTRIBUTE = "Guest";
    protected static final String YES_VALUE = "yes";
    protected static final String NO_VALUE = "no";
    protected static final String SHOW_ATTRIBUTE = "Show";
    protected static final String DOCK_ATTRIBUTE = "Dock";
    protected static final String CONTEXT_ATTRIBUTE = "Context";
    protected static final String DOCKED_VALUE = "docked";
    protected static final String UNDOCKED_VALUE = "undocked";
    protected static final String NESTED_VALUE = "nested";
    protected static final String SELECTION_ORDER_ATTRIBUTE = "SelectionOrder";

    DTOccupant(Desktop desktop) {
        this.fDesktop = desktop;
    }

    Desktop getDesktop() {
        return this.fDesktop;
    }

    abstract DTInternalFrame getInternalFrame();

    void setInternalFrame(DTInternalFrame dTInternalFrame) {
        if (this.fInternalFrame != dTInternalFrame) {
            if (this.fInternalFrame != null) {
                this.fInternalFrame.removeComponentListener(this.fInternalFrameVisibilityListener);
            }
            if (dTInternalFrame != null) {
                dTInternalFrame.addComponentListener(this.fInternalFrameVisibilityListener);
                dTInternalFrame.setFrameEnabled(this.fIsEnabled);
            }
            this.fInternalFrame = dTInternalFrame;
        }
    }

    void setEnabled(boolean bl) {
        if (this.fIsEnabled != bl) {
            this.fIsEnabled = bl;
            if (this.fInternalFrame != null) {
                this.fInternalFrame.setFrameEnabled(bl);
            }
            this.forwardPropertyChange(new PropertyChangeEvent(this, ENABLED_PROPERTY, !bl, bl));
        }
    }

    boolean isEnabled() {
        return this.fIsEnabled;
    }

    boolean isSingleton() {
        return true;
    }

    public boolean hasInternalFrame() {
        return this.fInternalFrame != null;
    }

    synchronized DTLocation getLocation() {
        return this.fLocation;
    }

    public boolean isShowingInMainFrame() {
        return this.fLocation != null && (this.fLocation.isDocked() || this.isSingleton() && this.onTopWhenUndocked());
    }

    synchronized void setLocation(DTLocation dTLocation) {
        this.fLocation = dTLocation;
        for (OccupantAction occupantAction : this.fActions) {
            occupantAction.locationChanged(this.fLastLocation, dTLocation);
        }
        if (dTLocation != null) {
            this.fLastLocation = dTLocation;
            if (dTLocation.isDocked()) {
                this.setLastDockedLocation(dTLocation);
                if (this.hasInternalFrame()) {
                    this.getInternalFrame().promoteTitleBarRestore(dTLocation.isMaximized());
                }
            } else {
                this.setLastUndockedLocation(dTLocation);
            }
        }
        if (this.fLastUndockedLocation != this.fLocation && this.fLastUndockedLocation != null) {
            this.fLastUndockedLocation.setFrame(null);
            this.fLastUndockedLocation.setContainer(null);
        }
        if (this.fLastDockedLocation != this.fLocation && this.fLastDockedLocation != null) {
            this.fLastDockedLocation.setFrame(null);
            this.fLastDockedLocation.setContainer(null);
        }
        if (this.fLastLocation != this.fLocation && this.fLastLocation instanceof DTFloatingLocation) {
            this.fLastLocation.setFrame(null);
            this.fLastLocation.setContainer(null);
        }
    }

    synchronized DTLocation getLastLocation() {
        return this.fLastLocation;
    }

    public synchronized void setLastLocation(DTLocation dTLocation) {
        this.fLastLocation = dTLocation;
        if (dTLocation == null) {
            return;
        }
        if (dTLocation.isDocked()) {
            this.setLastDockedLocation(dTLocation);
        } else {
            this.setLastUndockedLocation(dTLocation);
        }
    }

    synchronized DTLocation getLastDockedLocation() {
        return this.fLastDockedLocation;
    }

    public synchronized void setLastDockedLocation(DTLocation dTLocation) {
        this.fLastDockedLocation = dTLocation;
        if (dTLocation instanceof DTNestedLocation) {
            this.fLastNestedLocation = (DTNestedLocation)dTLocation;
        }
    }

    synchronized DTFloatingLocation getLastUndockedLocation() {
        return this.fLastUndockedLocation;
    }

    public synchronized void setLastUndockedLocation(DTLocation dTLocation) {
        if (dTLocation instanceof DTFloatingLocation) {
            this.fLastUndockedLocation = (DTFloatingLocation)dTLocation;
        }
    }

    synchronized DTNestedLocation getLastNestedLocation() {
        return this.fLastNestedLocation;
    }

    public synchronized void setLastNestedLocation(DTNestedLocation dTNestedLocation) {
        this.fLastNestedLocation = dTNestedLocation;
    }

    void locationChanged() {
        for (OccupantAction occupantAction : this.fActions) {
            occupantAction.locationChanged(this.fLocation, this.fLocation);
        }
    }

    @Override
    public boolean isConsideringSelection() {
        return this.fIsConsideringSelection;
    }

    @Override
    public void setConsideringSelection(boolean bl) {
        if (bl != this.fIsConsideringSelection) {
            boolean bl2 = this.fIsConsideringSelection;
            this.fIsConsideringSelection = bl;
            this.forwardPropertyChange(new PropertyChangeEvent(this, CONSIDERING_SELECTION_PROPERTY, bl2, bl));
        }
    }

    void saveToolBarState() {
        if (this.fInternalFrame != null) {
            this.fToolBarState = this.fInternalFrame.getToolBarContainer().getState();
        }
    }

    Object getToolBarState() {
        return this.fToolBarState;
    }

    void clearToolBarState() {
        this.fToolBarState = null;
    }

    boolean isClosing() {
        return this.fIsClosing;
    }

    boolean wasSelectedWhenCloseInitiated() {
        return this.fWasSelectedWhenCloseInitiated;
    }

    boolean isMinimizing() {
        return this.fIsMinimizing;
    }

    void setMinimizing(boolean bl) {
        this.fIsMinimizing = bl;
    }

    boolean isMaximizing() {
        return this.fIsMaximizing;
    }

    void setMaximizing(boolean bl) {
        this.fIsMaximizing = bl;
    }

    boolean isRestoring() {
        return this.fIsRestoring;
    }

    void setRestoring(boolean bl) {
        this.fIsRestoring = bl;
    }

    boolean isShowing() {
        return this.fLocation != null;
    }

    boolean isInFront() {
        return this.isShowing() && this.hasInternalFrame() && this.getInternalFrame().isShowing();
    }

    public String getTitle() {
        String string;
        if (this.fPropertyProvider != null && (string = (String)this.fPropertyProvider.getProperty(DTProperty.TITLE)) != null) {
            this.fTitle = string;
        }
        return this.fTitle;
    }

    public String getShortTitle() {
        return this.getTitle();
    }

    public String getName() {
        if (this.fName == null) {
            String string = null;
            if (this.fPropertyProvider != null) {
                string = (String)this.fPropertyProvider.getProperty(DTProperty.NAME);
            }
            if (string == null) {
                string = this.getShortTitle();
            }
            if (this.isSingleton()) {
                this.fName = string;
            } else {
                return string;
            }
        }
        return this.fName;
    }

    boolean isGuest() {
        return this.fIsGuest || this.isSessionGuest();
    }

    boolean isSessionGuest() {
        return this.getBooleanProperty(DTProperty.SESSION_GUEST);
    }

    String getConstrainedTitle() {
        return this.getShortTitle();
    }

    Icon getIcon() {
        return (Icon)this.getProperty(DTProperty.ICON);
    }

    Icon getSmallIcon() {
        return (Icon)this.getProperty(DTProperty.SMALL_ICON);
    }

    JMenuBar getMenuBar() {
        return (JMenuBar)this.getProperty(DTProperty.MENU_BAR);
    }

    boolean isMenuMergeEnabled() {
        return !this.getBooleanProperty(DTProperty.DONT_MERGE_MENU);
    }

    JToolBar[] getToolBars() {
        JToolBar[] jToolBarArray = new JToolBar[]{};
        if (this.getToolBarAlternative() != null || this.getToolstripTabs().length > 0) {
            return jToolBarArray;
        }
        Object object = this.getProperty(DTProperty.TOOL_BAR);
        LinkedList<DTToolBarInfo> linkedList = new LinkedList<DTToolBarInfo>();
        if (object instanceof JToolBar) {
            jToolBarArray = new JToolBar[]{(JToolBar)object};
        } else if (object instanceof JToolBar[]) {
            jToolBarArray = (JToolBar[])object;
        } else if (object instanceof DTToolBarInfo) {
            jToolBarArray = new JToolBar[1];
            linkedList.add((DTToolBarInfo)object);
        } else if (object instanceof DTToolBarInfo[]) {
            DTToolBarInfo[] dTToolBarInfoArray = (DTToolBarInfo[])object;
            jToolBarArray = new JToolBar[dTToolBarInfoArray.length];
            linkedList.addAll(Arrays.asList(dTToolBarInfoArray));
        }
        for (int i = 0; i < jToolBarArray.length; ++i) {
            if (jToolBarArray[i] != null) continue;
            DTToolBarInfo dTToolBarInfo = (DTToolBarInfo)linkedList.removeFirst();
            ToolBarData toolBarData = this.fToolBarDataMap.get(dTToolBarInfo.getKey());
            if (toolBarData == null) {
                toolBarData = new ToolBarData();
                this.fToolBarDataMap.put(dTToolBarInfo.getKey(), toolBarData);
                if (this.isSingleton()) {
                    this.fDesktop.getToolBarRegistry().register(dTToolBarInfo.getKey(), this);
                }
            }
            if (toolBarData.iInfo != dTToolBarInfo) {
                toolBarData.iInfo = dTToolBarInfo;
                if (toolBarData.iToolBar instanceof MJToolBar) {
                    ((MJToolBar)toolBarData.iToolBar).dispose();
                }
                toolBarData.iToolBar = null;
            }
            if (toolBarData.iToolBar == null) {
                toolBarData.iToolBar = DTToolBarFactory.createToolBar(dTToolBarInfo, this.getToolBarConfiguration(dTToolBarInfo.getKey()), this.getUnderlyingPropertyProvider());
            }
            jToolBarArray[i] = toolBarData.iToolBar;
        }
        return jToolBarArray;
    }

    ToolstripTab[] getToolstripTabs() {
        ToolstripTab[] toolstripTabArray = (ToolstripTab[])this.getProperty(DTProperty.TOOLSTRIP_TABS);
        return toolstripTabArray == null ? new ToolstripTab[]{} : toolstripTabArray;
    }

    JComponent getToolBarAlternative() {
        return (JComponent)this.getProperty(DTProperty.TOOL_BAR_ALTERNATIVE);
    }

    private Object getUnderlyingPropertyProvider() {
        if (this.fPropertyProvider instanceof DTPropertyBridge) {
            return ((DTPropertyBridge)this.fPropertyProvider).getUnderlyingProvider();
        }
        return this.fPropertyProvider;
    }

    String[] getToolBarKeys() {
        JToolBar[] jToolBarArray = this.getToolBars();
        String[] stringArray = new String[jToolBarArray.length];
        for (int i = 0; i < jToolBarArray.length; ++i) {
            stringArray[i] = (String)jToolBarArray[i].getClientProperty("ToolBarKey");
        }
        return stringArray;
    }

    String[] getToolBarLabels() {
        JToolBar[] jToolBarArray = this.getToolBars();
        String[] stringArray = new String[jToolBarArray.length];
        for (int i = 0; i < jToolBarArray.length; ++i) {
            stringArray[i] = (String)jToolBarArray[i].getClientProperty("ToolBarLabel");
            if (stringArray[i] == null) {
                stringArray[i] = jToolBarArray[i].getName();
            }
            if (stringArray[i] != null) continue;
            stringArray[i] = this.getDefaultToolBarLabel();
            if (i <= 0) continue;
            int n = i;
            stringArray[n] = stringArray[n] + " " + (i + 1);
        }
        return stringArray;
    }

    String getDefaultToolBarLabel() {
        return this.getTitle();
    }

    boolean offerToolBarToggles() {
        return this.getBooleanProperty(DTProperty.OFFER_TOOLBAR_TOGGLES);
    }

    MJStatusBar getStatusBar() {
        return (MJStatusBar)this.getProperty(DTProperty.STATUS_BAR);
    }

    List<Action> getContextActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Action[] actionArray = (Action[])this.getProperty(DTProperty.CONTEXT_ACTIONS);
        if (actionArray != null) {
            arrayList.addAll(Arrays.asList(actionArray));
        }
        return arrayList;
    }

    JMenu getContextMenu() {
        return (JMenu)this.getProperty(DTProperty.CONTEXT_MENU);
    }

    boolean permitUserClose() {
        return !this.fDesktop.isLayoutLocked() && this.getBooleanProperty(DTProperty.PERMIT_USER_CLOSE);
    }

    boolean permitUserUndock() {
        return !this.fDesktop.isLayoutLocked() && this.getBooleanProperty(DTProperty.PERMIT_USER_UNDOCK);
    }

    boolean permitUserMinimize() {
        return !this.fDesktop.isLayoutLocked() && this.fDesktop.isDockedMinMaxSupportedAndEnabled() && this.getBooleanProperty(DTProperty.PERMIT_USER_MINIMIZE);
    }

    boolean permitUserMaximize() {
        return !this.fDesktop.isLayoutLocked() && this.fDesktop.isDockedMinMaxSupportedAndEnabled() && this.getBooleanProperty(DTProperty.PERMIT_USER_MAXIMIZE);
    }

    boolean hideTitleWhenDocked() {
        return this.getBooleanProperty(DTProperty.HIDE_TITLE_WHEN_DOCKED);
    }

    boolean hideTitleWhenSolo() {
        return this.getBooleanProperty(DTProperty.HIDE_TITLE_WHEN_SOLO);
    }

    boolean mayHaveHeavyContent() {
        return this.getBooleanProperty(DTProperty.HEAVYWEIGHT);
    }

    boolean allowForcedClose() {
        return this.getBooleanProperty(DTProperty.ALLOW_FORCED_CLOSE);
    }

    DTProperty.Bounding getUndockedBounding() {
        return (DTProperty.Bounding)((Object)this.getProperty(DTProperty.UNDOCKED_BOUNDING));
    }

    boolean onTopWhenUndocked() {
        boolean bl = false;
        if (!(this.getPropertyProvider() == null || PlatformInfo.isXWindows() && "sun.awt.motif.MToolkit".equals(Toolkit.getDefaultToolkit().getClass().getName()) || this.getMenuBar() != null)) {
            bl = this.getBooleanProperty(DTProperty.ON_TOP_WHEN_UNDOCKED);
        }
        return bl;
    }

    boolean isDockable() {
        return this.getBooleanProperty(DTProperty.DOCKABLE);
    }

    Object createPropertyProvider() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportCreateError(String string, Throwable throwable) {
        String string2 = DTUtilities.getTempDirectory() + "MATLABDesktopCreateError.log";
        Object[] objectArray = new Object[]{string, string2};
        String string3 = MessageFormat.format(this.getDesktop().getString("error.UnableToCreate"), objectArray);
        this.fDesktop.getErrorReportingStream().println(string3);
        PrintStream printStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            printStream = new PrintStream(fileOutputStream);
            throwable.printStackTrace(printStream);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            if (printStream != null) {
                printStream.flush();
                printStream.close();
            }
        }
    }

    DTPropertyProvider getPropertyProvider() {
        return this.fPropertyProvider;
    }

    void setPropertyProvider(DTPropertyProvider dTPropertyProvider) {
        this.fPropertyProvider = dTPropertyProvider;
        this.fIsGuest = this.getBooleanProperty(DTProperty.GUEST);
    }

    public Object getProperty(DTProperty dTProperty) {
        Object object = null;
        if (this.getPropertyProvider() != null) {
            object = this.getPropertyProvider().getProperty(dTProperty);
        }
        if (object == null) {
            object = dTProperty.getDefaultValue();
        }
        return object;
    }

    boolean getBooleanProperty(DTProperty dTProperty) {
        Boolean bl = null;
        if (this.getPropertyProvider() != null) {
            bl = (Boolean)this.getPropertyProvider().getProperty(dTProperty);
        }
        if (bl == null) {
            bl = (Boolean)dTProperty.getDefaultValue();
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public void addPropertyListener(PropertyChangeListener propertyChangeListener) {
        if (this.fPropertyListeners == null) {
            this.fPropertyListeners = new ArrayList<PropertyChangeListener>();
        }
        if (!this.fPropertyListeners.contains(propertyChangeListener)) {
            this.fPropertyListeners.add(propertyChangeListener);
        }
    }

    public void removePropertyListener(PropertyChangeListener propertyChangeListener) {
        if (this.fPropertyListeners != null) {
            this.fPropertyListeners.remove(propertyChangeListener);
        }
    }

    void prepareToShow() {
    }

    @Override
    public void setSelected(boolean bl) {
        this.setSelected(bl, true);
    }

    void setSelected(boolean bl, boolean bl2) {
        this.setSelected(bl, bl2, bl2);
    }

    abstract void setSelected(boolean var1, boolean var2, boolean var3);

    abstract void requestFocus();

    void requestFocusLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DTOccupant.this.requestFocus();
            }
        });
    }

    void setSelectionOrder(int n) {
        this.fSelectionOrder = n;
    }

    int getSelectionOrder() {
        return this.fSelectionOrder;
    }

    @Override
    public boolean canClose() {
        return this.canClose(new DTCloseReplyListener(){

            @Override
            public void closeReply(DTAsyncWindowCloser dTAsyncWindowCloser, boolean bl) {
                if (bl) {
                    dTAsyncWindowCloser.close();
                }
            }
        }) == 1;
    }

    @Override
    public int canClose(DTCloseReplyListener dTCloseReplyListener) {
        this.fCloseReplyListener = dTCloseReplyListener;
        if (this.fPropertyProvider != null) {
            this.fPropertyProvider.putProperty(DTProperty.VETO_CLOSE, null);
            this.fPropertyProvider.putProperty(DTProperty.DEFER_CLOSE, null);
            this.fPropertyProvider.putProperty(DTProperty.APPROVE_CLOSE, null);
        }
        return 1;
    }

    protected void flush() {
        this.fHasBeenFlushed = true;
        if (this.fPropertyProvider != null) {
            this.fPropertyProvider.removePropertyChangeListener(this);
            this.fPropertyProvider = null;
        }
        if (this.fInternalFrame != null) {
            this.fInternalFrame.remove(this);
        }
        if (this.fCloseReplyListener != null) {
            this.fCloseReplyListener.closeReply(this, true);
        }
        this.fCloseReplyListener = null;
        this.setInternalFrame(null);
        this.fOpenAction = null;
        this.fCloseAction = null;
        this.fDockAction = null;
        this.fUndockAction = null;
        this.fMinimizeAction = null;
        this.fMaximizeAction = null;
        this.fMoveAction = null;
        this.fResizeAction = null;
        this.fSelectAction = null;
        this.fToggleAction = null;
        this.fActions.clear();
        if (this.fPropertyListeners != null) {
            this.fPropertyListeners.clear();
        }
        for (ToolBarData toolBarData : this.fToolBarDataMap.values()) {
            if (!(toolBarData.iToolBar instanceof MJToolBar)) continue;
            ((MJToolBar)toolBarData.iToolBar).dispose();
        }
        this.fToolBarDataMap.clear();
    }

    boolean hasBeenFlushed() {
        return this.fHasBeenFlushed;
    }

    public MJAbstractAction getCloseAction() {
        if (this.fCloseAction == null) {
            this.fCloseAction = this.createCloseAction();
            if (this.fCloseAction != null) {
                this.fActions.add(this.fCloseAction);
            }
        }
        return this.fCloseAction;
    }

    public MJAbstractAction getOpenAction() {
        if (this.fOpenAction == null) {
            this.fOpenAction = this.createOpenAction();
            if (this.fOpenAction != null) {
                this.fActions.add(this.fOpenAction);
            }
        }
        return this.fOpenAction;
    }

    MJAbstractAction getDockAction() {
        if (this.fDockAction == null) {
            this.fDockAction = this.createDockAction();
            if (this.fDockAction != null) {
                this.fActions.add(this.fDockAction);
            }
        }
        return this.fDockAction;
    }

    MJAbstractAction getUndockAction() {
        if (this.fUndockAction == null) {
            this.fUndockAction = this.createUndockAction();
            if (this.fUndockAction != null) {
                this.fActions.add(this.fUndockAction);
            }
        }
        return this.fUndockAction;
    }

    MJAbstractAction getMinimizeAction() {
        if (this.fMinimizeAction == null) {
            this.fMinimizeAction = this.createMinimizeAction();
            if (this.fMinimizeAction != null) {
                this.fActions.add(this.fMinimizeAction);
            }
        }
        return this.fMinimizeAction;
    }

    MJAbstractAction getMaximizeAction() {
        if (this.fMaximizeAction == null) {
            this.fMaximizeAction = this.createMaximizeAction();
            if (this.fMaximizeAction != null) {
                this.fActions.add(this.fMaximizeAction);
            }
        }
        return this.fMaximizeAction;
    }

    MJAbstractAction getMoveAction() {
        if (this.fMoveAction == null) {
            this.fMoveAction = this.createMoveAction();
            if (this.fMoveAction != null) {
                this.fActions.add(this.fMoveAction);
            }
        }
        return this.fMoveAction;
    }

    MJAbstractAction getResizeAction() {
        if (this.fResizeAction == null) {
            this.fResizeAction = this.createResizeAction();
            if (this.fResizeAction != null) {
                this.fActions.add(this.fResizeAction);
            }
        }
        return this.fResizeAction;
    }

    MJAbstractAction getSelectAction() {
        if (this.fSelectAction == null) {
            this.fSelectAction = this.createSelectAction();
            if (this.fSelectAction != null) {
                this.fActions.add(this.fSelectAction);
            }
        }
        return this.fSelectAction;
    }

    MJAbstractAction getToggleAction() {
        if (this.fToggleAction == null) {
            this.fToggleAction = this.createToggleAction();
            if (this.fToggleAction != null) {
                this.fActions.add(this.fToggleAction);
            }
        }
        return this.fToggleAction;
    }

    protected abstract OccupantAction createOpenAction();

    protected abstract OccupantAction createCloseAction();

    protected abstract OccupantAction createDockAction();

    protected abstract OccupantAction createUndockAction();

    protected abstract OccupantAction createMinimizeAction();

    protected abstract OccupantAction createMaximizeAction();

    protected OccupantAction createMoveAction() {
        return new MoveAction();
    }

    protected OccupantAction createResizeAction() {
        return new ResizeAction();
    }

    protected abstract OccupantAction createSelectAction();

    protected abstract OccupantAction createToggleAction();

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doPropertyChange(propertyChangeEvent);
        } else {
            SwingUtilities.invokeLater(new DeferredPropertyChange(propertyChangeEvent));
        }
    }

    protected void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (this.hasBeenFlushed()) {
            return;
        }
        for (OccupantAction occupantAction : this.fActions) {
            occupantAction.propertyChange(propertyChangeEvent);
        }
        if (DTProperty.VETO_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
            object = propertyChangeEvent.getNewValue();
            if (object == this.fCloseReplyListener && object != null) {
                this.fCloseReplyListener = null;
                ((DTCloseReplyListener)object).closeReply(this, false);
            }
            return;
        }
        if (DTProperty.APPROVE_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
            object = propertyChangeEvent.getNewValue();
            if (object == this.fCloseReplyListener && object != null) {
                this.fCloseReplyListener = null;
                ((DTCloseReplyListener)object).closeReply(this, true);
            }
            return;
        }
        if (DTProperty.DEFER_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        this.forwardPropertyChange(new PropertyChangeEvent(this, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
    }

    protected void forwardPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fPropertyListeners == null) {
            return;
        }
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[this.fPropertyListeners.size()];
        this.fPropertyListeners.toArray(propertyChangeListenerArray);
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
            if (this.fPropertyListeners.indexOf(propertyChangeListener) == -1) continue;
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public String getToolBarLabel(String string) {
        ToolBarData toolBarData = this.fToolBarDataMap.get(string);
        if (toolBarData.iLabel != null) {
            return toolBarData.iLabel;
        }
        if (toolBarData.iInfo != null) {
            return toolBarData.iInfo.getLabel();
        }
        return null;
    }

    @Override
    public DTToolBarInfo getToolBarInfo(String string) {
        ToolBarData toolBarData = this.fToolBarDataMap.get(string);
        if (toolBarData.iInfo == null) {
            if (this.fPropertyProvider == null) {
                this.createPropertyProvider();
            }
            Object object = this.getProperty(DTProperty.TOOL_BAR);
            ArrayList<DTToolBarInfo> arrayList = new ArrayList<DTToolBarInfo>();
            if (object instanceof DTToolBarInfo) {
                arrayList.add((DTToolBarInfo)object);
            } else if (object instanceof DTToolBarInfo[]) {
                arrayList.addAll(Arrays.asList((DTToolBarInfo[])object));
            }
            for (DTToolBarInfo dTToolBarInfo : arrayList) {
                ToolBarData toolBarData2 = this.fToolBarDataMap.get(dTToolBarInfo.getKey());
                if (toolBarData2 == null) {
                    toolBarData2 = new ToolBarData();
                    this.fToolBarDataMap.put(dTToolBarInfo.getKey(), toolBarData2);
                    if (this.isSingleton()) {
                        this.fDesktop.getToolBarRegistry().register(dTToolBarInfo.getKey(), this);
                    }
                }
                toolBarData2.iInfo = dTToolBarInfo;
            }
        }
        return toolBarData.iInfo;
    }

    @Override
    public DTToolBarConfiguration getToolBarConfiguration(String string) {
        ToolBarData toolBarData = this.fToolBarDataMap.get(string);
        if (toolBarData == null) {
            return null;
        }
        if (toolBarData.iConfig == null) {
            toolBarData.iConfig = DTToolBarUtilities.recallConfiguration(this.fDesktop, this.getToolBarInfo(string));
        }
        if (toolBarData.iConfig == null) {
            toolBarData.iConfig = NULL_CONFIG;
        }
        return toolBarData.iConfig == NULL_CONFIG ? null : toolBarData.iConfig;
    }

    @Override
    public void updateToolBars(String string, DTToolBarConfiguration dTToolBarConfiguration) {
        ToolBarData toolBarData = this.fToolBarDataMap.get(string);
        if (dTToolBarConfiguration.getVisibleItemKeys().size() == 0) {
            if (this.fInternalFrame != null) {
                this.fInternalFrame.getToolBarContainer().setToolBarVisible(string, toolBarData.iLabel, false);
            }
        } else {
            toolBarData.iConfig = dTToolBarConfiguration;
            if (toolBarData.iToolBar != null) {
                DTToolBarFactory.udpateToolBar(toolBarData.iToolBar, toolBarData.iInfo.getToolSet(), dTToolBarConfiguration, this.getUnderlyingPropertyProvider());
                toolBarData.iToolBar.revalidate();
                toolBarData.iToolBar.repaint();
            }
            if (this.isSingleton()) {
                DTToolBarUtilities.saveConfiguration(this.fDesktop, toolBarData.iInfo, dTToolBarConfiguration);
            }
        }
    }

    abstract class ToggleAction
    extends OccupantAction {
        public ToggleAction() {
            super(null);
            this.setName(DTOccupant.this.getConstrainedTitle());
            this.setComponentName("Toggle" + DTOccupant.this.getName());
            this.setSelected(DTOccupant.this.isShowing());
            this.setEnabled(!DTOccupant.this.isShowing() || DTOccupant.this.permitUserClose());
        }

        @Override
        void updateName(String string) {
            this.setName(DTOccupant.this.getConstrainedTitle());
        }

        @Override
        void locationChanged(DTLocation dTLocation, DTLocation dTLocation2) {
            this.setSelected(dTLocation2 != null);
            this.setEnabled(!DTOccupant.this.isShowing() || DTOccupant.this.permitUserClose());
        }

        @Override
        void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (DTProperty.PERMIT_USER_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    abstract class SelectAction
    extends OccupantAction {
        public SelectAction() {
            super(null);
            this.setName(DTOccupant.this.getConstrainedTitle());
            this.setComponentName("Select" + DTOccupant.this.getName());
            this.setEnabled(DTOccupant.this.isShowing());
        }

        @Override
        void updateName(String string) {
            this.setName(DTOccupant.this.getConstrainedTitle());
        }

        @Override
        void locationChanged(DTLocation dTLocation, DTLocation dTLocation2) {
            this.setEnabled(dTLocation2 != null);
        }
    }

    class ResizeAction
    extends OccupantAction {
        public ResizeAction() {
            super("menuitem.ResizeThis");
            this.setComponentName("Resize" + DTOccupant.this.getName());
            this.putValue("SmallIcon", Desktop.RESIZE_ICON);
            this.locationChanged(null, DTOccupant.this.getLocation());
        }

        @Override
        void locationChanged(DTLocation dTLocation, DTLocation dTLocation2) {
            this.setEnabled(dTLocation2 != null && dTLocation2.getContainer() != null && dTLocation2.getContainer().canResizeWithKeys(DTOccupant.this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DTOccupant.this.fLocation != null && DTOccupant.this.fLocation.getContainer() != null && DTOccupant.this.fLocation.getContainer().canResizeWithKeys(DTOccupant.this)) {
                DTOccupant.this.fLocation.getContainer().startKeyResize(DTOccupant.this);
            }
        }
    }

    class MoveAction
    extends OccupantAction {
        public MoveAction() {
            super("menuitem.MoveThis");
            this.setComponentName("Move" + DTOccupant.this.getName());
            this.putValue("SmallIcon", Desktop.MOVE_ICON);
            this.locationChanged(null, DTOccupant.this.getLocation());
        }

        @Override
        void locationChanged(DTLocation dTLocation, DTLocation dTLocation2) {
            this.setEnabled(dTLocation2 != null && dTLocation2.getContainer() != null && dTLocation2.getContainer().canMoveWithKeys(DTOccupant.this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DTOccupant.this.fLocation != null && DTOccupant.this.fLocation.getContainer() != null && DTOccupant.this.fLocation.getContainer().canMoveWithKeys(DTOccupant.this)) {
                DTOccupant.this.fLocation.getContainer().startKeyMove(DTOccupant.this);
            }
        }
    }

    abstract class MaximizeAction
    extends OccupantAction {
        public MaximizeAction() {
            super("menuitem.MaximizeThis");
            DTKeyBindings.getInstance().getManager().addKeyBindingAndActionInfo("MATLABDesktop", "maximize", (ExtendedAction)this);
            this.locationChanged(null, DTOccupant.this.getLocation());
        }

        @Override
        void locationChanged(DTLocation dTLocation, DTLocation dTLocation2) {
            if (dTLocation2 == null || !dTLocation2.isMaximized()) {
                this.setComponentName("Maximize" + DTOccupant.this.getName());
                this.iResourceKey = "menuitem.MaximizeThis";
                this.putValue("SmallIcon", Desktop.MAXIMIZE_ICON);
            } else {
                this.setComponentName("Restore" + DTOccupant.this.getName());
                this.iResourceKey = "menuitem.RestoreThis";
                this.putValue("SmallIcon", Desktop.RESTORE_TO_DOCKED_ICON);
            }
            this.setName(this.createLabel(DTOccupant.this.getConstrainedTitle()));
        }
    }

    abstract class MinimizeAction
    extends OccupantAction {
        int iEdge;

        public MinimizeAction() {
            super("menuitem.MinimizeThis");
            this.iEdge = 7;
            DTKeyBindings.getInstance().getManager().addKeyBindingAndActionInfo("MATLABDesktop", "minimize", (ExtendedAction)this);
            this.locationChanged(null, DTOccupant.this.getLocation());
        }

        @Override
        void locationChanged(DTLocation dTLocation, DTLocation dTLocation2) {
            if (dTLocation2 == null || !dTLocation2.isMinimized()) {
                this.setComponentName("Minimize" + DTOccupant.this.getName());
                this.iResourceKey = "menuitem.MinimizeThis";
                Icon icon = Desktop.MINIMIZE_ICON;
                DTNestedLocation dTNestedLocation = null;
                if (dTLocation2 instanceof DTNestedLocation) {
                    dTNestedLocation = (DTNestedLocation)dTLocation2;
                } else if (dTLocation2 instanceof DTBorderLocation && dTLocation2.isMaximized()) {
                    dTNestedLocation = DTOccupant.this.getLastNestedLocation();
                }
                if (dTNestedLocation != null) {
                    this.iEdge = dTNestedLocation.getDirection(0);
                    if (this.iEdge == 2) {
                        this.iEdge = 7;
                    } else if (this.iEdge == 1) {
                        int n;
                        this.iEdge = 7;
                        if (dTNestedLocation.getPathLength() > 1 && ((n = dTNestedLocation.getDirection(1)) == 3 || n == 7)) {
                            this.iEdge = n;
                        }
                    }
                    switch (this.iEdge) {
                        case 1: {
                            icon = Desktop.MINIMIZE_TO_NORTH_ICON;
                            break;
                        }
                        case 5: {
                            icon = Desktop.MINIMIZE_TO_SOUTH_ICON;
                            break;
                        }
                        case 3: {
                            icon = Desktop.MINIMIZE_TO_EAST_ICON;
                            break;
                        }
                        case 7: {
                            icon = Desktop.MINIMIZE_TO_WEST_ICON;
                        }
                    }
                }
                this.putValue("SmallIcon", icon);
            } else {
                this.setComponentName("Restore");
                this.iResourceKey = "menuitem.RestoreThis";
                this.putValue("SmallIcon", Desktop.RESTORE_TO_DOCKED_ICON);
            }
            this.setName(this.createLabel(DTOccupant.this.getConstrainedTitle()));
        }
    }

    abstract class UndockAction
    extends OccupantAction {
        public UndockAction() {
            super("menuitem.UndockThis");
            DTKeyBindings.getInstance().getManager().addKeyBindingAndActionInfo("MATLABDesktop", "undock", (ExtendedAction)this);
            this.updateName(DTOccupant.this.getConstrainedTitle());
            this.setComponentName("Undock" + DTOccupant.this.getName());
            this.putValue("SmallIcon", Desktop.UNDOCK_ICON);
        }
    }

    abstract class DockAction
    extends OccupantAction {
        public DockAction() {
            super("menuitem.DockThis");
            DTKeyBindings.getInstance().getManager().addKeyBindingAndActionInfo("MATLABDesktop", "dock", (ExtendedAction)this);
            this.updateName(DTOccupant.this.getConstrainedTitle());
            this.setComponentName(DTOccupant.DOCK_ATTRIBUTE + DTOccupant.this.getName());
            this.putValue("SmallIcon", Desktop.DOCK_ICON);
        }
    }

    abstract class CloseAction
    extends OccupantAction {
        public CloseAction() {
            super("menuitem.CloseThis");
            this.setComponentName("Close" + DTOccupant.this.getName());
            this.putValue("SmallIcon", Desktop.CLOSE_ICON);
            this.setEnabled(DTOccupant.this.permitUserClose());
        }

        @Override
        void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (DTProperty.PERMIT_USER_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    abstract class OpenAction
    extends OccupantAction {
        public OpenAction() {
            super(null);
            this.setName(DTOccupant.this.getConstrainedTitle());
            this.setComponentName("Open" + DTOccupant.this.getName());
        }

        @Override
        void updateName(String string) {
            this.setName(DTOccupant.this.getConstrainedTitle());
        }
    }

    protected abstract class OccupantAction
    extends MJAbstractAction {
        String iResourceKey;

        OccupantAction(String string) {
            this.iResourceKey = string;
            if (this.iResourceKey != null) {
                this.setName(this.createLabel(DTOccupant.this.getConstrainedTitle()));
            }
        }

        void updateName(String string) {
            if (this.iResourceKey != null) {
                this.setName(this.createLabel(string));
            }
        }

        String createLabel(String string) {
            Object[] objectArray = new Object[]{string};
            return MessageFormat.format(DTOccupant.this.getDesktop().getString(this.iResourceKey), objectArray);
        }

        void locationChanged(DTLocation dTLocation, DTLocation dTLocation2) {
        }

        void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (DTProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName()) || DTClientProperty.SHORT_TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.updateName(DTOccupant.this.getConstrainedTitle());
            }
        }
    }

    protected class ToolBarData {
        String iLabel;
        DTToolBarInfo iInfo;
        DTToolBarConfiguration iConfig;
        JToolBar iToolBar;

        protected ToolBarData() {
        }
    }

    private class InternalFrameVisibilityListener
    extends ComponentAdapter {
        private InternalFrameVisibilityListener() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            DTOccupant.this.forwardPropertyChange(new PropertyChangeEvent(DTOccupant.this, DTOccupant.IN_FRONT_PROPERTY, false, true));
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            DTOccupant.this.forwardPropertyChange(new PropertyChangeEvent(DTOccupant.this, DTOccupant.IN_FRONT_PROPERTY, true, false));
        }
    }

    private class DeferredPropertyChange
    implements Runnable {
        PropertyChangeEvent fEvent;

        DeferredPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fEvent = propertyChangeEvent;
        }

        @Override
        public void run() {
            DTOccupant.this.doPropertyChange(this.fEvent);
        }
    }
}

