/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DTToolBarRegistry {
    private List<String> fKeyList = new ArrayList<String>();
    private HashMap<String, Registrant> fRegistrantMap = new HashMap();

    public void register(String string, Registrant registrant) {
        if (!this.fKeyList.contains(string)) {
            this.fKeyList.add(string);
        }
        this.fRegistrantMap.put(string, registrant);
    }

    public void register(String string, Registrant registrant, int n) {
        if (!this.fKeyList.contains(string)) {
            this.fKeyList.add(n, string);
        }
        this.fRegistrantMap.put(string, registrant);
    }

    public void unregister(String string) {
        this.fKeyList.remove(string);
        this.fRegistrantMap.remove(string);
    }

    public boolean isRegistered(String string) {
        return this.fRegistrantMap.get(string) != null;
    }

    public List<String> getKeys() {
        return Collections.unmodifiableList(this.fKeyList);
    }

    public String getLabel(String string) {
        Registrant registrant = this.fRegistrantMap.get(string);
        return registrant == null ? null : registrant.getToolBarLabel(string);
    }

    public DTToolBarInfo getToolBarInfo(String string) {
        Registrant registrant = this.fRegistrantMap.get(string);
        DTToolBarInfo dTToolBarInfo = null;
        if (registrant != null) {
            dTToolBarInfo = registrant.getToolBarInfo(string);
        }
        if (dTToolBarInfo != null) {
            dTToolBarInfo.getToolSet().setImmutable();
        }
        return dTToolBarInfo;
    }

    public DTToolBarConfiguration getToolBarConfiguration(String string) {
        Registrant registrant = this.fRegistrantMap.get(string);
        return registrant == null ? null : registrant.getToolBarConfiguration(string);
    }

    public Registrant getRegistrant(String string) {
        return this.fRegistrantMap.get(string);
    }

    public static interface Registrant {
        public String getToolBarLabel(String var1);

        public DTToolBarInfo getToolBarInfo(String var1);

        public DTToolBarConfiguration getToolBarConfiguration(String var1);

        public void updateToolBars(String var1, DTToolBarConfiguration var2);
    }
}

