/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.editor.breakpoints;

import com.mathworks.matlab.api.debug.Breakpoint;
import com.mathworks.matlab.api.debug.BreakpointMarginPopUpMenu;
import com.mathworks.matlab.api.debug.BreakpointModel;
import com.mathworks.matlab.api.debug.BreakpointStyle;
import com.mathworks.matlab.api.debug.BreakpointUiInfoProvider;
import com.mathworks.matlab.api.debug.ContextMenuListener;
import com.mathworks.matlab.api.debug.ViewProviderKey;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.PopupListener;
import com.mathworks.util.Log;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.editor.breakpoints.BreakpointRenderUtils;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.MWEditorUIUtils;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.mcode.CmdManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.apache.commons.lang.Validate;

public class BreakpointView<T extends Breakpoint>
implements ComponentBuilder {
    private final JComponent fComponent;
    private final PopupListener fPopupListener;
    private final STPInterface fSyntaxTextPane;
    private final CmdManager fCommandManager;
    private final ViewProviderKey fKey;
    private final BreakpointModel<T> fBreakpointModel;
    private final ContextMenuListener fContextMenuListener;
    private final BreakpointUiInfoProvider<T> fBreakpointUiInfoProvider;
    private int fPressedLine = -1;
    private int fIntermediateBreakpointLine = -1;
    private final MouseListener fMouseListener = this.createMouseListener();
    private final MouseMotionListener fMouseMotionListener = this.createMouseMotionListener();
    private final Map<Integer, VisualBreakpoint<T>> fVisualBreakpoints = new TreeMap<Integer, VisualBreakpoint<T>>();
    private static final int BORDER_PAD = 2;
    private static final int NO_LINE = -1;
    public static final String NAME = "BreakpointView";
    private final BreakpointMarginPopUpMenu<T> fBreakpointMarginPopUpMenu;

    public BreakpointView(BreakpointModel<T> breakpointModel, ContextMenuListener contextMenuListener, STPInterface sTPInterface, CmdManager cmdManager, ViewProviderKey viewProviderKey, BreakpointUiInfoProvider<T> breakpointUiInfoProvider, BreakpointMarginPopUpMenu<T> breakpointMarginPopUpMenu) {
        Validate.notNull(breakpointModel, (String)"BreakpointProvider cannot be null.");
        Validate.notNull(breakpointModel, (String)"ContextMenuListener cannot be null.");
        Validate.notNull((Object)sTPInterface, (String)"STPInterface cannot be null.");
        Validate.notNull((Object)cmdManager, (String)"CmdManager cannot be null.");
        Validate.notNull((Object)viewProviderKey, (String)"ViewProviderKey cannot be null.");
        Validate.notNull(breakpointMarginPopUpMenu, (String)"PopUp Menu can not be null");
        this.fBreakpointModel = breakpointModel;
        this.fContextMenuListener = contextMenuListener;
        this.fSyntaxTextPane = sTPInterface;
        this.fCommandManager = cmdManager;
        this.fKey = viewProviderKey;
        this.fBreakpointUiInfoProvider = breakpointUiInfoProvider;
        this.fComponent = this.createComponent();
        this.fPopupListener = this.createPopupListener();
        this.initListeners();
        this.fComponent.setToolTipText("");
        this.fComponent.getAccessibleContext().setAccessibleName("Breakpoint display");
        this.fBreakpointMarginPopUpMenu = breakpointMarginPopUpMenu;
    }

    private void initListeners() {
        this.fComponent.addMouseListener(this.fMouseListener);
        this.fComponent.addMouseMotionListener(this.fMouseMotionListener);
        this.fComponent.addMouseListener((MouseListener)this.fPopupListener);
    }

    public void dispose() {
        this.fComponent.removeMouseListener(this.fMouseListener);
        this.fComponent.removeMouseMotionListener(this.fMouseMotionListener);
        this.fComponent.removeMouseListener((MouseListener)this.fPopupListener);
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    public List<VisualBreakpoint<T>> getBreakpointVisuals() {
        return new ArrayList<VisualBreakpoint<T>>(this.fVisualBreakpoints.values());
    }

    private PopupListener createPopupListener() {
        return new PopupListener(){

            protected void showPopup(MouseEvent mouseEvent) {
                BreakpointView.this.doShowPopup(mouseEvent);
            }
        };
    }

    private void doShowPopup(MouseEvent mouseEvent) {
        int n;
        int n2 = this.pointToLineNumber(mouseEvent.getPoint());
        assert (n2 >= 0) : "It is not be possible to bring up the popup for a negative line.";
        Collection collection = this.fBreakpointModel.getBreakpointsAt(n2);
        JPopupMenu jPopupMenu = this.fBreakpointMarginPopUpMenu.buildPopupMenu(n2, collection, n = this.fBreakpointModel.getNumberOfPossibleInLineBreakpoints(n2));
        if (jPopupMenu != null) {
            jPopupMenu.show(this.fComponent, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public ViewProviderKey getKey() {
        return this.fKey;
    }

    private int pointToLineNumber(Point point) {
        try {
            return MWEditorUIUtils.convertYToLineNbr(point.y, this.fKey.getEditorUI());
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private int lineNumberToY(int n) {
        try {
            return MWEditorUIUtils.convertLineNbrToY(n, this.fKey.getEditorUI());
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private int quietlyConvertScreenYToViewIndex(int n) {
        try {
            return MWEditorUIUtils.getViewIndexFromY(n, this.fKey.getEditorUI());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private static int quietlyGetYPositionOfView(View view, JTextComponent jTextComponent) {
        try {
            Rectangle rectangle = jTextComponent.getUI().modelToView(jTextComponent, view.getStartOffset());
            return rectangle.y;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private JComponent createComponent() {
        Background background = new Background(this.fSyntaxTextPane){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                BreakpointView.this.paintBreakpointView(graphics);
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = null;
                int n = BreakpointView.this.pointToLineNumber(mouseEvent.getPoint());
                if (n >= 0) {
                    Collection collection = BreakpointView.this.fBreakpointModel.getBreakpointsAt(n);
                    boolean bl = BreakpointView.this.fBreakpointModel.areBreakpointsLive();
                    boolean bl2 = BreakpointView.this.fBreakpointModel.wasThereAnError();
                    String string2 = BreakpointView.this.fBreakpointUiInfoProvider.generateToolTipText(collection, bl, bl2);
                    string = string2 == null ? null : StringUtils.convertToHTML((String)string2, (boolean)true);
                }
                return string;
            }
        };
        background.putClientProperty("mwjavaguitest.instance", this);
        return background;
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                BreakpointView.this.fKey.requestFocusInWindow();
                int n = BreakpointView.this.pointToLineNumber(mouseEvent.getPoint());
                if (BreakpointView.isValidLineNumber(n) && BreakpointView.shouldHandlePressedEvent(mouseEvent)) {
                    BreakpointView.this.fPressedLine = n;
                    BreakpointView.this.fIntermediateBreakpointLine = BreakpointView.this.fPressedLine;
                    BreakpointView.this.fComponent.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = BreakpointView.this.pointToLineNumber(mouseEvent.getPoint());
                if (BreakpointView.isValidLineNumber(n) && n == BreakpointView.this.fPressedLine) {
                    BreakpointView.this.doMouseClickedOnLine(n);
                }
                BreakpointView.this.fPressedLine = -1;
                BreakpointView.this.fIntermediateBreakpointLine = -1;
                BreakpointView.this.fComponent.repaint();
            }
        };
    }

    private MouseMotionListener createMouseMotionListener() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = BreakpointView.this.pointToLineNumber(mouseEvent.getPoint());
                BreakpointView.this.fIntermediateBreakpointLine = BreakpointView.isValidLineNumber(n) && n == BreakpointView.this.fPressedLine ? n : -1;
                BreakpointView.this.fComponent.repaint();
            }
        };
    }

    private void doMouseClickedOnLine(int n) {
        this.fContextMenuListener.respondToClick(n);
    }

    private void clearBreakpointVisual(int n) {
        this.fVisualBreakpoints.remove(n);
    }

    private void storeBreakpointVisual(int n, VisualBreakpoint<T> visualBreakpoint) {
        this.fVisualBreakpoints.put(n, visualBreakpoint);
    }

    protected void paintBreakpointView(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintMarginIfNecessary(graphics2D);
        graphics2D.dispose();
    }

    private void paintMarginIfNecessary(Graphics2D graphics2D) {
        MWEditorUI mWEditorUI = (MWEditorUI)this.fKey.getEditorUI();
        JTextComponent jTextComponent = mWEditorUI == null ? null : mWEditorUI.getComponent();
        View view = MWEditorUIUtils.getRootView(jTextComponent);
        if (jTextComponent != null && view != null) {
            AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
            abstractDocument.readLock();
            this.quietlyPaintMargin(graphics2D, jTextComponent, view);
            abstractDocument.readUnlock();
        }
    }

    private void quietlyPaintMargin(Graphics2D graphics2D, JTextComponent jTextComponent, View view) {
        try {
            this.paintMargin(graphics2D, jTextComponent, view);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    private void paintMargin(Graphics2D graphics2D, JTextComponent jTextComponent, View view) {
        Element element = view.getElement();
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = this.quietlyConvertScreenYToViewIndex(rectangle.y);
        int n2 = this.quietlyConvertScreenYToViewIndex(rectangle.y + rectangle.height);
        int n3 = BreakpointView.quietlyGetYPositionOfView(view.getView(n), jTextComponent);
        for (int i = n; i <= n2; ++i) {
            View view2 = view.getView(i);
            int n4 = element.getElementIndex(view2.getStartOffset());
            int n5 = this.fKey.getEditorUI().getLineHeight();
            Rectangle rectangle2 = new Rectangle(this.fComponent.getX(), n3, this.fComponent.getWidth(), n5);
            this.paintMarginForLine(graphics2D, n4, rectangle2);
            n3 += n5;
        }
        this.paintIntermediateBreakpointIfNecessary(graphics2D);
    }

    private void paintMarginForLine(Graphics2D graphics2D, int n, Rectangle rectangle) {
        boolean bl = !this.fBreakpointModel.getBreakpointsAt(n).isEmpty();
        boolean bl2 = this.fCommandManager.isExecutableLine(n);
        this.clearBreakpointVisual(n);
        if (bl) {
            this.paintBreakpoint(graphics2D, n, rectangle);
        } else if (bl2) {
            BreakpointRenderUtils.paintExecutableMark(graphics2D, this.fSyntaxTextPane.getLineNumberForeColor(), BreakpointRenderUtils.getBreakpointWidth(this.fSyntaxTextPane), rectangle);
        }
    }

    private void paintBreakpoint(Graphics2D graphics2D, int n, Rectangle rectangle) {
        Collection collection = this.fBreakpointModel.getBreakpointsAt(n);
        boolean bl = ((Breakpoint)collection.iterator().next()).isEnabled();
        boolean bl2 = collection.size() > 1;
        boolean bl3 = !bl && !bl2 && DebuggerManager.getInstance().supportsDisabledBreakpoints();
        BreakpointStyle breakpointStyle = this.getBreakpointStyle(n);
        BreakpointRenderUtils.paintBreakpoint(graphics2D, this.fSyntaxTextPane.getLineNumberForeColor(), BreakpointRenderUtils.getBreakpointWidth(this.fSyntaxTextPane), rectangle, bl3, breakpointStyle);
        this.storeBreakpointVisual(n, new VisualBreakpoint(collection, rectangle, breakpointStyle));
    }

    private void paintIntermediateBreakpointIfNecessary(Graphics2D graphics2D) {
        int n = this.lineNumberToY(this.fIntermediateBreakpointLine);
        if (n >= 0) {
            int n2 = this.fKey.getEditorUI().getLineHeight();
            Rectangle rectangle = new Rectangle(this.fComponent.getX(), n, this.fComponent.getWidth(), n2);
            BreakpointStyle breakpointStyle = this.getBreakpointStyle(this.fIntermediateBreakpointLine);
            BreakpointRenderUtils.paintIntermediateBreakpoint(graphics2D, this.fSyntaxTextPane.getLineNumberForeColor(), BreakpointRenderUtils.getBreakpointWidth(this.fSyntaxTextPane), rectangle, breakpointStyle);
        }
    }

    private static boolean isValidLineNumber(int n) {
        return n >= 0;
    }

    private static boolean shouldHandlePressedEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isShiftDown() && !mouseEvent.isAltDown() && !mouseEvent.isControlDown();
    }

    private BreakpointStyle getBreakpointStyle(int n) {
        Collection collection = this.fBreakpointModel.getBreakpointsAt(n);
        return this.fBreakpointUiInfoProvider.getBreakpointStyle(collection, this.fBreakpointModel.areBreakpointsLive());
    }

    public static class VisualBreakpoint<T extends Breakpoint> {
        private final Collection<Breakpoint> fBreakpoint;
        private final Rectangle fVisualBounds;
        private final BreakpointStyle fStyle;

        private VisualBreakpoint(Collection<T> collection, Rectangle rectangle, BreakpointStyle breakpointStyle) {
            this.fBreakpoint = new ArrayList<T>(collection);
            this.fVisualBounds = rectangle;
            this.fStyle = breakpointStyle;
        }

        public Collection<Breakpoint> getBreakpoints() {
            return Collections.unmodifiableCollection(this.fBreakpoint);
        }

        public Rectangle getVisualBounds() {
            return this.fVisualBounds;
        }

        public BreakpointStyle getStyle() {
            return this.fStyle;
        }
    }

    public static class Background
    extends MJPanel {
        private final STPInterface fSyntaxTextPane;

        public Background(STPInterface sTPInterface) {
            this.fSyntaxTextPane = sTPInterface;
            this.setName(BreakpointView.NAME);
            this.setForeground(this.fSyntaxTextPane.getLineNumberForeColor());
            this.setBackground(this.fSyntaxTextPane.getLineNumberBackgroundColor());
            this.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.WHITE));
        }

        public Dimension getPreferredSize() {
            int n = BreakpointRenderUtils.getBreakpointWidth(this.fSyntaxTextPane) + 4;
            return new Dimension(n, -1);
        }
    }
}

