/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.editor.highlights;

import com.mathworks.matlab.api.editor.EditorRegion;
import com.mathworks.matlab.api.editor.highlighting.EditorHighlighter;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.text.ClearableMarkChain;
import com.mathworks.widgets.text.PrintableDocument;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.ArrayUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.Utilities;

public class HighlighterManager {
    public static final int VISIBILITY = 2045;
    private static final String PLUGIN_LAYER_NO_CELL_NAME = "EDITOR_HIGHLIGHTER_PLUGIN";
    private static final String PLUGIN_LAYER_CELL_NAME = "EDITOR_HIGHLIGHTER_PLUGIN_WITH_CODE_SECTION_OVERLAP";
    private BaseDocument fDocument;
    private ClearableMarkChain fBaseLayerOverlapMarkChain;
    private ClearableMarkChain fActiveHighlighterMarkChain;
    private int[] fPreviousActiveHighlighterLines;
    private int[] fPreviousOverlappingLines;
    private final List<EditorHighlighter> fHighlighters = new ArrayList<EditorHighlighter>();
    private List<EditorHighlighter.HighlighterUpdateListener> fHighlighterListeners = new ArrayList<EditorHighlighter.HighlighterUpdateListener>();
    private EditorHighlighter.HighlighterUpdateListener fHighlighterUpdateListener = this.createHighlighterUpdateListener();
    private EditorHighlighter fBaseHighlighter = HighlighterManager.createDummyHighlighter();
    private boolean fAutomaticallyRepainting = true;
    private final DocumentListener fDocumentChangeListener = this.createDocumentChangeListener();
    private boolean fHasInitializedHighlighters = false;

    public HighlighterManager(BaseDocument baseDocument) {
        this.setDocument(baseDocument);
    }

    public final void setDocument(BaseDocument baseDocument) {
        if (baseDocument != null) {
            this.documentCleanup();
            this.fDocument = baseDocument;
            this.updateDocument();
        }
    }

    private void updateDocument() {
        this.configureDrawingLayers();
        this.fDocument.addDocumentListener(this.fDocumentChangeListener);
    }

    private DocumentListener createDocumentChangeListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!HighlighterManager.this.fHasInitializedHighlighters) {
                    HighlighterManager.this.initializeHighlighters();
                }
                if (HighlighterManager.this.fAutomaticallyRepainting) {
                    HighlighterManager.this.repaint();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (HighlighterManager.this.fAutomaticallyRepainting) {
                    HighlighterManager.this.repaint();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    private void initializeHighlighters() {
        for (EditorHighlighter editorHighlighter : this.fHighlighters) {
            this.initializeHighlighter(editorHighlighter);
        }
        this.fHasInitializedHighlighters = true;
    }

    private void initializeHighlighter(EditorHighlighter editorHighlighter) {
        editorHighlighter.setDocument(this.fDocument);
        editorHighlighter.initialize();
    }

    public void setBaseHighlighter(EditorHighlighter editorHighlighter) {
        this.fBaseHighlighter = editorHighlighter;
        this.repaint();
    }

    private Color getCompositeColor() {
        Color color = this.getActiveHighlighter().getHighlightColor();
        Color color2 = this.fBaseHighlighter.getHighlightColor();
        return new Color(HighlighterManager.getMultiplyEffect(color2.getRed(), color.getRed()), HighlighterManager.getMultiplyEffect(color2.getGreen(), color.getGreen()), HighlighterManager.getMultiplyEffect(color2.getBlue(), color.getBlue()));
    }

    private static int getMultiplyEffect(int n, int n2) {
        return (int)(255.0f * ((float)n / 255.0f * ((float)n2 / 255.0f)));
    }

    private EditorHighlighter.HighlighterUpdateListener createHighlighterUpdateListener() {
        return new EditorHighlighter.HighlighterUpdateListener(){

            public void highlightsUpdated() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (EditorHighlighter.HighlighterUpdateListener highlighterUpdateListener : HighlighterManager.this.fHighlighterListeners) {
                            highlighterUpdateListener.highlightsUpdated();
                        }
                    }
                });
            }
        };
    }

    private EditorHighlighter getActiveHighlighter() {
        ArrayList<EditorHighlighter> arrayList = new ArrayList<EditorHighlighter>();
        for (EditorHighlighter editorHighlighter : this.fHighlighters) {
            if (!editorHighlighter.isEnabled()) continue;
            arrayList.add(editorHighlighter);
        }
        assert (arrayList.size() <= 1) : "There should only be, at most, one active EditorHighlighter";
        return arrayList.isEmpty() ? HighlighterManager.createDummyHighlighter() : (EditorHighlighter)arrayList.get(0);
    }

    private static EditorHighlighter createDummyHighlighter() {
        return new EditorHighlighter(){

            public EditorRegion addRegion(int n, int n2) {
                return null;
            }

            public void removeRegion(EditorRegion editorRegion) {
            }

            public void removeRegions(List<EditorRegion> list, boolean bl) {
            }

            public boolean isEnabled() {
                return false;
            }

            public void addListener(EditorHighlighter.HighlighterUpdateListener highlighterUpdateListener) {
            }

            public void removeListener(EditorHighlighter.HighlighterUpdateListener highlighterUpdateListener) {
            }

            public List<EditorRegion> getEditorRegions() {
                return Collections.emptyList();
            }

            public Color getHighlightColor() {
                return Color.WHITE;
            }

            public void dispose() {
            }

            public void setDocument(BaseDocument baseDocument) {
            }

            public void initialize() {
            }
        };
    }

    public void setAutomaticallyRepainting(boolean bl) {
        this.fAutomaticallyRepainting = bl;
    }

    public static int[] expandToLines(BaseDocument baseDocument, EditorRegion editorRegion) {
        int n;
        int n2;
        int n3 = editorRegion.getStart();
        int n4 = editorRegion.getEnd();
        try {
            n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3);
            n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
        int[] nArray = new int[n - n2 + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + n2;
        }
        return nArray;
    }

    private void repaint() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        List list = this.fBaseHighlighter.getEditorRegions();
        EditorRegion editorRegion = !list.isEmpty() ? (EditorRegion)list.get(0) : null;
        int n = -1;
        int n2 = -1;
        if (editorRegion != null) {
            try {
                n = Utilities.getLineOffset((BaseDocument)this.fDocument, (int)editorRegion.getStart());
                n2 = Utilities.getLineOffset((BaseDocument)this.fDocument, (int)editorRegion.getEnd());
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
        }
        ArrayList<EditorRegion> arrayList3 = new ArrayList<EditorRegion>();
        for (EditorRegion editorRegion2 : this.getActiveHighlighter().getEditorRegions()) {
            if (editorRegion2.isValid()) {
                int[] nArray;
                for (int n3 : nArray = HighlighterManager.expandToLines(this.fDocument, editorRegion2)) {
                    if (editorRegion != null && n3 >= n && n3 <= n2) {
                        arrayList2.add(n3);
                        continue;
                    }
                    arrayList.add(n3);
                }
                continue;
            }
            arrayList3.add(editorRegion2);
        }
        this.getActiveHighlighter().removeRegions(arrayList3, false);
        if (this.fBaseLayerOverlapMarkChain != null) {
            this.fPreviousOverlappingLines = ((PrintableDocument)this.fDocument).updateLines(this.fPreviousOverlappingLines, HighlighterManager.convertListToArray(arrayList2), this.fBaseLayerOverlapMarkChain);
        }
        if (this.fActiveHighlighterMarkChain != null) {
            this.fPreviousActiveHighlighterLines = ((PrintableDocument)this.fDocument).updateLines(this.fPreviousActiveHighlighterLines, HighlighterManager.convertListToArray(arrayList), this.fActiveHighlighterMarkChain);
        }
    }

    private static int[] convertListToArray(List<Integer> list) {
        Integer[] integerArray = list.toArray(new Integer[list.size()]);
        return ArrayUtils.toPrimitive((Integer[])integerArray);
    }

    public void addHighlighterUpdateListener(EditorHighlighter.HighlighterUpdateListener highlighterUpdateListener) {
        this.fHighlighterListeners.add(highlighterUpdateListener);
    }

    public void addHighlighter(EditorHighlighter editorHighlighter) {
        this.fHighlighters.add(editorHighlighter);
        editorHighlighter.addListener(this.fHighlighterUpdateListener);
        if (this.fHasInitializedHighlighters) {
            this.initializeHighlighter(editorHighlighter);
        }
    }

    private void configureDrawingLayers() {
        this.fBaseLayerOverlapMarkChain = new ClearableMarkChain(this.fDocument, PLUGIN_LAYER_CELL_NAME);
        this.fActiveHighlighterMarkChain = new ClearableMarkChain(this.fDocument, PLUGIN_LAYER_NO_CELL_NAME);
        DrawLayerFactory.ColorLineLayer colorLineLayer = new DrawLayerFactory.ColorLineLayer(PLUGIN_LAYER_CELL_NAME){

            protected Coloring getColoring(DrawContext drawContext) {
                return new Coloring(null, null, HighlighterManager.this.getCompositeColor());
            }
        };
        DrawLayerFactory.ColorLineLayer colorLineLayer2 = new DrawLayerFactory.ColorLineLayer(PLUGIN_LAYER_NO_CELL_NAME){

            protected Coloring getColoring(DrawContext drawContext) {
                return new Coloring(null, null, HighlighterManager.this.getActiveHighlighter().getHighlightColor());
            }
        };
        this.fDocument.addLayer((DrawLayer)colorLineLayer, 2045);
        this.fDocument.addLayer((DrawLayer)colorLineLayer2, 2045);
    }

    public void dispose() {
        for (EditorHighlighter editorHighlighter : this.fHighlighters) {
            editorHighlighter.removeListener(this.fHighlighterUpdateListener);
            editorHighlighter.dispose();
        }
        this.fHighlighterListeners.clear();
        this.documentCleanup();
    }

    private void documentCleanup() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentChangeListener);
        }
    }
}

