/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login.logging;

import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.login.LoginUtils;
import com.mathworks.widgets.login.UniversalLoginComponent;
import com.mathworks.widgets.login.logging.LoginFormatter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Log {
    private static final String DEFAULT_LOG_FILE_NAME = "MATLAB_Login_Error.log";
    private static final String LOG_TO_FILE_KEY = "com.mathworks.widgets.login.LoginProperties.logtofile";
    private static Log sInstance;
    private final Logger fLogger = this.initializeLogger();
    private FileHandler fFileHandler = null;
    private String fAbsFilePath = null;

    private Log() {
        this.enableLogging(Prefs.getBooleanPref((String)LOG_TO_FILE_KEY, (boolean)false));
        Prefs.addListener((PrefListener)new LoginPrefsListener(), (String)LOG_TO_FILE_KEY);
    }

    public static synchronized Log getInstance() {
        if (sInstance == null) {
            sInstance = new Log();
        }
        return sInstance;
    }

    public Logger getLogger() {
        return this.fLogger;
    }

    private Logger initializeLogger() {
        Logger logger = Logger.getLogger(Log.class.getName());
        logger.setLevel(Level.OFF);
        return logger;
    }

    private synchronized void enableLogging(boolean bl) {
        if (bl) {
            try {
                this.enableFileLogging(this.getAbsFilePath());
                String string = LoginUtils.getString("universalLogin.logging");
                String string2 = LoginUtils.getClientVersion(UniversalLoginComponent.DEFAULT_CLIENT_STRING) + ":";
                string = MessageFormat.format(string, string2, this.getAbsFilePath());
                System.out.println(string);
            }
            catch (IOException iOException) {
                String string = LoginUtils.getString("universalLogin.cannot.log");
                String string3 = LoginUtils.getClientVersion(UniversalLoginComponent.DEFAULT_CLIENT_STRING);
                String string4 = string3 + ": " + iOException.getClass().getName() + " " + iOException.getLocalizedMessage() + ",";
                string = MessageFormat.format(string, string4, this.getAbsFilePath());
                System.out.println(string);
            }
        } else {
            this.disableFileLogging();
        }
    }

    private void enableFileLogging(String string) throws IOException {
        if (this.fFileHandler != null) {
            this.fFileHandler.close();
            this.fLogger.removeHandler(this.fFileHandler);
        }
        this.fFileHandler = new FileHandler(string, 0, 1, true);
        this.fFileHandler.setLevel(Level.ALL);
        this.fFileHandler.setFormatter(new LoginFormatter());
        this.fLogger.setLevel(Level.ALL);
        this.fLogger.addHandler(this.fFileHandler);
    }

    private void disableFileLogging() {
        this.fLogger.setLevel(Level.OFF);
        if (this.fFileHandler != null) {
            this.fFileHandler.close();
            this.fLogger.removeHandler(this.fFileHandler);
        }
    }

    private synchronized String getAbsFilePath() {
        if (this.fAbsFilePath == null) {
            this.fAbsFilePath = Log.getTempDirectory() + DEFAULT_LOG_FILE_NAME;
        }
        return this.fAbsFilePath;
    }

    private static String getTempDirectory() {
        String string = System.getProperties().getProperty("java.io.tmpdir");
        char c = System.getProperties().getProperty("file.separator").charAt(0);
        if (string.charAt(string.length() - 1) != c) {
            string = string + c;
        }
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private class LoginPrefsListener
    implements PrefListener {
        private LoginPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equalsIgnoreCase(Log.LOG_TO_FILE_KEY)) {
                boolean bl = Prefs.getBooleanPref((String)Log.LOG_TO_FILE_KEY, (boolean)false);
                Log.getInstance().enableLogging(bl);
            }
        }
    }
}

