/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.widgets.spreadsheet.data.ComplexIntegralScalar;
import com.mathworks.widgets.spreadsheet.format.FormatUtils;
import java.math.BigInteger;

public final class ComplexScalarLong
extends ComplexIntegralScalar {
    private final long fR;
    private final long fI;
    private static final BigInteger UNSIGNED_LONG_MAX = BigInteger.valueOf(Long.MIN_VALUE).multiply(BigInteger.valueOf(-2L));
    private static final ComplexScalarLong ZERO_REAL_SIGNED = new ComplexScalarLong(0L, true);
    private static final ComplexScalarLong ONE_REAL_SIGNED = new ComplexScalarLong(1L, true);
    private static final ComplexScalarLong ZERO_COMPLEX_SIGNED = new ComplexScalarLong(0L, 0L, true);
    private static final ComplexScalarLong ONE_COMPLEX_SIGNED = new ComplexScalarLong(1L, 0L, true);
    private static final ComplexScalarLong I_COMPLEX_SIGNED = new ComplexScalarLong(0L, 1L, true);
    private static final ComplexScalarLong ZERO_REAL_UNSIGNED = new ComplexScalarLong(0L, false);
    private static final ComplexScalarLong ONE_REAL_UNSIGNED = new ComplexScalarLong(1L, false);
    private static final ComplexScalarLong ZERO_COMPLEX_UNSIGNED = new ComplexScalarLong(0L, 0L, false);
    private static final ComplexScalarLong ONE_COMPLEX_UNSIGNED = new ComplexScalarLong(1L, 0L, false);
    private static final ComplexScalarLong I_COMPLEX_UNSIGNED = new ComplexScalarLong(0L, 1L, false);

    public static ComplexScalarLong valueOf(long l) {
        return ComplexScalarLong.valueOf(l, true);
    }

    public static ComplexScalarLong valueOf(long l, boolean bl) {
        if (l == 0L) {
            return bl ? ZERO_REAL_SIGNED : ZERO_REAL_UNSIGNED;
        }
        if (l == 1L) {
            return bl ? ONE_REAL_SIGNED : ONE_REAL_UNSIGNED;
        }
        return new ComplexScalarLong(l, bl);
    }

    public static ComplexScalarLong valueOf(long l, long l2) {
        return ComplexScalarLong.valueOf(l, l2, true);
    }

    public static ComplexScalarLong valueOf(long l, long l2, boolean bl) {
        if (l == 0L) {
            if (l2 == 1L) {
                return bl ? I_COMPLEX_SIGNED : I_COMPLEX_UNSIGNED;
            }
            if (l2 == 0L) {
                return bl ? ZERO_COMPLEX_SIGNED : ZERO_COMPLEX_UNSIGNED;
            }
        }
        if (l == 1L && l2 == 0L) {
            return bl ? ONE_COMPLEX_SIGNED : ONE_COMPLEX_UNSIGNED;
        }
        return new ComplexScalarLong(l, l2, bl);
    }

    private ComplexScalarLong(long l, boolean bl) {
        super(true, bl);
        this.fR = l;
        this.fI = 0L;
    }

    private ComplexScalarLong(long l, long l2, boolean bl) {
        super(false, bl);
        this.fR = l;
        this.fI = l2;
    }

    @Override
    public long longValueReal() {
        return this.fR;
    }

    @Override
    public long longValueImaginary() {
        return this.fI;
    }

    @Override
    public double doubleValueReal() {
        return this.fR;
    }

    @Override
    public double doubleValueImaginary() {
        return this.fI;
    }

    @Override
    public String formatAsIntegral() {
        long l = this.longValueReal();
        Number number = this.isSigned() || l > -1L ? Long.valueOf(l) : UNSIGNED_LONG_MAX.add(BigInteger.valueOf(l));
        if (this.isReal()) {
            return FormatUtils.formatAsIntegral(number);
        }
        long l2 = this.longValueImaginary();
        Number number2 = this.isSigned() || l2 > -1L ? Long.valueOf(l2) : UNSIGNED_LONG_MAX.add(BigInteger.valueOf(l2));
        return FormatUtils.formatAsIntegral(number, number2);
    }
}

