/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.matlab.comment.CommentWrappingUtils;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;

public abstract class MatlabEditorKit
extends MWKit {
    @Override
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new MWKit.MWCommentAction("% "), new MWKit.MWUncommentAction("% ", "%"), new MDefaultKeyTypedAction(), new MatlabWrapCommentsAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public static class MatlabWrapCommentsAction
    extends MWKit.MWWrapCommentsAction {
        public MatlabWrapCommentsAction() {
            super(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            CommentWrappingUtils.wrapComments(jTextComponent);
        }
    }

    public static class MDefaultKeyTypedAction
    extends MWKit.MWDefaultKeyTypedAction {
        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            super.insertString(baseDocument, n, caret, string, bl);
            CommentWrappingUtils.autoWrapCommentLine(baseDocument, caret.getDot());
        }

        protected void checkIndentHotChars(JTextComponent jTextComponent, String string) {
            ExtFormatter extFormatter;
            int[] nArray;
            Formatter formatter;
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            if (baseDocument != null && (formatter = baseDocument.getFormatter()) instanceof ExtFormatter && (nArray = (extFormatter = (ExtFormatter)formatter).getReformatBlock(jTextComponent, string)) != null) {
                try {
                    nArray[0] = Utilities.getRowStart((BaseDocument)baseDocument, (int)nArray[0]);
                    nArray[1] = Utilities.getRowEnd((BaseDocument)baseDocument, (int)nArray[1]);
                    if (Utilities.getLineOffset((BaseDocument)baseDocument, (int)nArray[0]) == Utilities.getLineOffset((BaseDocument)baseDocument, (int)nArray[1])) {
                        extFormatter.reformat(baseDocument, nArray[0], nArray[1], true);
                    } else {
                        extFormatter.reformat(baseDocument, nArray[0], nArray[1], false);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
                catch (IOException iOException) {
                    Log.logException((Exception)iOException);
                }
            }
        }
    }
}

