/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.print;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.AttributedCharacters;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.text.print.GraphicsUtils;
import com.mathworks.widgets.text.print.PrintSettings;
import com.mathworks.widgets.text.print.PrintableTextDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.print.DocPrintJob;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public final class TextPrintable
implements Printable {
    private static int sBlockSize = 400;
    private Document fDocument;
    private int fLastPagePrinted;
    private ArrayList fPageStyledTexts;
    private AttributedTextLayout fLastTextLayout;
    private int startPage;
    private int currentStyledText;
    private LineBreakMeasurer lineBreakMeasurer;
    private int maxPage;
    private static final int ARG_SIZE = 4;
    private Object[] pageArgs;
    private boolean printHeader;
    private static PrintSettings printSettings;
    private CancellationPanel cancellationPanel;
    private MJDialog fCancellationDialog;
    private Frame fParentFrame;
    private boolean fCountPages = true;
    private int fStartPos;
    private int fEndPos;
    private int fHeaderHeight = 0;
    private String fTitle;
    private String fTitle2;
    private String fDateStr;
    private String fTimeStr;
    private MessageFormat fPageNoFormat;
    private Object[] fPageNoArgs;
    private Color fBoxColor;
    private static Font fontInstance;

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public void setPrintHeader(boolean bl) {
        this.printHeader = bl;
    }

    public TextPrintable(Document document, int n, int n2, Frame frame) {
        this.fStartPos = n;
        this.fEndPos = n2;
        this.fDocument = document;
        this.fParentFrame = frame;
        this.initializeClassVariables();
        if (printSettings == null) {
            printSettings = PrintSettings.getInstance();
        }
        this.pageArgs = new Object[4];
        this.pageArgs[2] = TextPrintable.getFilename(document);
        this.pageArgs[1] = new Date(System.currentTimeMillis());
        this.pageArgs[3] = "";
        this.printHeader = printSettings.isPrintHeader();
    }

    public TextPrintable(Document document, int n, int n2, Frame frame, DocPrintJob docPrintJob) {
        this(document, n, n2, frame);
        PrintJobAdapter printJobAdapter = new PrintJobAdapter(){

            @Override
            public void printDataTransferCompleted(PrintJobEvent printJobEvent) {
                this.printJobDone();
            }

            private void printJobDone() {
                if (TextPrintable.this.fCancellationDialog != null) {
                    TextPrintable.closeDialog(TextPrintable.this.fCancellationDialog);
                }
            }
        };
        docPrintJob.addPrintJobListener(printJobAdapter);
    }

    private void initializeClassVariables() {
        this.fLastPagePrinted = -1;
        if (this.fDocument instanceof PrintableTextDocument) {
            ((PrintableTextDocument)this.fDocument).startingPrinting(this.fStartPos, this.fEndPos);
        }
        if (this.fPageStyledTexts != null) {
            this.fPageStyledTexts.clear();
        }
        this.fPageStyledTexts = new ArrayList();
        AttributedCharacterIterator[] attributedCharacterIteratorArray = TextPrintable.getIterators(this.fDocument);
        if (attributedCharacterIteratorArray == null || attributedCharacterIteratorArray.length == 0) {
            throw new IllegalArgumentException();
        }
        TextPrintable.replaceEmptyIterators(attributedCharacterIteratorArray);
        this.fPageStyledTexts.addAll(Arrays.asList(attributedCharacterIteratorArray));
        this.fLastTextLayout = null;
        this.startPage = -1;
        this.currentStyledText = 0;
        this.lineBreakMeasurer = null;
        this.maxPage = Integer.MAX_VALUE;
        this.fHeaderHeight = 0;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (Graphics2D.class.isAssignableFrom(graphics.getClass())) {
            GraphicsUtils.applyPrintScale((Graphics2D)graphics);
        }
        if (this.fLastPagePrinted != -1 && this.fLastPagePrinted < n) {
            this.fCountPages = false;
        }
        if (this.fCountPages) {
            int n2 = n;
            int n3 = this.printWrapper(graphics, pageFormat, n2, false);
            while (n3 != 1) {
                n3 = this.printWrapper(graphics, pageFormat, ++n2, false);
            }
            int n4 = n2;
            this.pageArgs[3] = new Integer(n4);
            if (this.cancellationPanel != null) {
                this.cancellationPanel.setTotalPages(n4);
            }
            this.initializeClassVariables();
        }
        return this.printWrapper(graphics, pageFormat, n, true);
    }

    private int printWrapper(Graphics graphics, PageFormat pageFormat, int n, boolean bl) throws PrinterException {
        int n2;
        if (this.cancellationPanel == null && graphics instanceof PrinterGraphics && this.fParentFrame != null) {
            this.createCancellationPanel(((PrinterGraphics)((Object)graphics)).getPrinterJob(), n);
        }
        boolean bl2 = false;
        if (this.fLastPagePrinted == -1) {
            this.fLastPagePrinted = n;
        }
        if (this.startPage == -1) {
            bl2 = true;
            this.startPage = n;
        }
        if (bl2) {
            n2 = 0;
            while (n2 < this.startPage) {
                if (n2 > 0) {
                    this.updateVariablesForNewPage(true);
                }
                this.printImpl(graphics, pageFormat, n2, false);
                this.fLastPagePrinted = n2++;
            }
        }
        n2 = n > this.fLastPagePrinted ? 1 : 0;
        this.updateVariablesForNewPage(n2 != 0);
        if (n2 != 0) {
            this.fLastPagePrinted = n;
        }
        return this.printImpl(graphics, pageFormat, n, bl);
    }

    private void updateVariablesForNewPage(boolean bl) {
        if (bl) {
            int n;
            if (this.currentStyledText > 0) {
                for (n = this.currentStyledText - 1; n >= 0; --n) {
                    this.fPageStyledTexts.remove(n);
                    --this.currentStyledText;
                }
            }
            if (this.fLastTextLayout != null && this.fLastTextLayout.fStartingIndex > 0) {
                n = this.fLastTextLayout.fStartingIndex;
                AttributedCharacterIterator attributedCharacterIterator = (AttributedCharacterIterator)this.fPageStyledTexts.get(this.currentStyledText);
                AttributedCharacters attributedCharacters = new AttributedCharacters();
                char c = attributedCharacterIterator.current();
                if (attributedCharacterIterator.getIndex() > n) {
                    c = attributedCharacterIterator.first();
                }
                while (attributedCharacterIterator.getIndex() < n) {
                    c = attributedCharacterIterator.next();
                }
                while (c != '\uffff') {
                    attributedCharacters.append(c, (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT), (Color)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND));
                    c = attributedCharacterIterator.next();
                }
                this.fPageStyledTexts.set(this.currentStyledText, attributedCharacters.iterator());
            }
        } else {
            this.currentStyledText = 0;
        }
        this.lineBreakMeasurer = null;
        this.fLastTextLayout = null;
    }

    private int printImpl(Graphics graphics, PageFormat pageFormat, int n, boolean bl) throws PrinterException {
        if (n > this.maxPage) {
            if (bl) {
                TextPrintable.closeDialog(this.fCancellationDialog);
            }
            return 1;
        }
        if (n < 0) {
            TextPrintable.closeDialog(this.fCancellationDialog);
            throw new IllegalArgumentException("Illegal page number=" + n);
        }
        if (graphics instanceof PrinterGraphics && this.isCancelled(((PrinterGraphics)((Object)graphics)).getPrinterJob())) {
            TextPrintable.closeDialog(this.fCancellationDialog);
            throw new PrinterAbortException("User aborted print job.");
        }
        if (this.cancellationPanel != null) {
            if (bl) {
                int n2 = bl ? n : this.startPage;
                this.cancellationPanel.setPageno(n2, false, this.fCancellationDialog);
            } else {
                this.cancellationPanel.setPageno(-1, false, this.fCancellationDialog);
            }
        }
        graphics.setColor(Color.black);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (PrintSettings.useMacNativeFixes()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        float f = GraphicsUtils.getScaleAdjustedImageableX(graphics2D, pageFormat);
        float f2 = GraphicsUtils.getScaleAdjustedImageableY(graphics2D, pageFormat);
        float f3 = GraphicsUtils.getScaleAdjustedImageableWidth(graphics2D, pageFormat);
        float f4 = GraphicsUtils.getScaleAdjustedImageableHeight(graphics2D, pageFormat);
        Point2D.Float float_ = new Point2D.Float(f, f2);
        this.pageArgs[0] = n + 1;
        float f5 = 0.0f;
        int n3 = 3;
        if (this.printHeader) {
            f5 += (float)this.setupHeader(graphics, (String)this.pageArgs[2], (int)f3 - n3);
        }
        float f6 = TextPrintable.wrap() ? f3 - (float)(2 * n3) - (float)this.getLineBreakMarkWidth(graphics2D, TextPrintable.getHeaderFont()) : Float.MAX_VALUE;
        float f7 = f4 + f2 - f5;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        boolean bl2 = false;
        AttributedTextLayout attributedTextLayout = this.nextLayout(f6, fontRenderContext);
        while (attributedTextLayout == null || float_.y < f7) {
            float f8;
            if (attributedTextLayout == null) {
                this.maxPage = n;
                break;
            }
            this.maxPage = Integer.MAX_VALUE;
            TextLayout textLayout = attributedTextLayout.getLayout();
            if (!bl2) {
                if (this.printHeader) {
                    float_.y += (float)this.drawHeader(graphics2D, n, (int)f3 - n3, (int)float_.x, (int)float_.y, bl);
                    float_.y += (float)graphics2D.getFontMetrics(TextPrintable.getHeaderFont()).getAscent();
                }
                bl2 = true;
            }
            float_.y += textLayout.getAscent() * TextPrintable.getLineAscentCorrection();
            if (float_.y >= f7) break;
            float f9 = f8 = textLayout.isLeftToRight() ? 0.0f : f6 - textLayout.getAdvance();
            if (bl) {
                double d = this.drawLineText(attributedTextLayout, float_, (float)n3 + f8, graphics2D);
                if (attributedTextLayout.fStartingIndex + attributedTextLayout.fLayout.getCharacterCount() < attributedTextLayout.fIterator.getEndIndex()) {
                    this.drawLineBreakMark(graphics, (int)Math.ceil(d), (int)float_.y, TextPrintable.getHeaderFont());
                }
            }
            float_.y += (textLayout.getDescent() + textLayout.getLeading()) * TextPrintable.getLineAscentCorrection();
            attributedTextLayout = this.nextLayout(f6, fontRenderContext);
        }
        if (graphics instanceof PrinterGraphics && this.isCancelled(((PrinterGraphics)((Object)graphics)).getPrinterJob())) {
            TextPrintable.closeDialog(this.fCancellationDialog);
            throw new PrinterAbortException();
        }
        if (!bl2) {
            if (bl) {
                TextPrintable.closeDialog(this.fCancellationDialog);
            }
            return 1;
        }
        return 0;
    }

    private double drawLineText(AttributedTextLayout attributedTextLayout, Point2D.Float float_, float f, Graphics2D graphics2D) {
        double d;
        AttributedCharacterIterator attributedCharacterIterator = attributedTextLayout.getIterator();
        TextLayout textLayout = attributedTextLayout.getLayout();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        char c = attributedCharacterIterator.current();
        int n = attributedTextLayout.getStartingIndex();
        int n2 = n + textLayout.getCharacterCount();
        if (attributedCharacterIterator.getIndex() > n) {
            c = attributedCharacterIterator.first();
        }
        while (attributedCharacterIterator.getIndex() < n) {
            c = attributedCharacterIterator.next();
        }
        double d2 = d = (double)(float_.x + f);
        while (c != '\uffff' && attributedCharacterIterator.getIndex() < n2) {
            int n3 = attributedCharacterIterator.getIndex();
            int n4 = attributedCharacterIterator.getRunLimit() - n3;
            if (n4 < 1) {
                n4 = 1;
            }
            if (n3 + n4 > n2) {
                n4 = n2 - n3;
            }
            graphics2D.setFont((Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT));
            graphics2D.setColor((Color)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND));
            char[] cArray = new char[n4];
            int n5 = -1;
            for (int i = 0; i != n4; ++i) {
                cArray[i] = c;
                if (!Character.isWhitespace(c)) {
                    n5 = i + 1;
                }
                c = attributedCharacterIterator.next();
            }
            GraphicsUtils.drawStringToGraphics(graphics2D, String.valueOf(cArray), d, float_.y);
            if (n3 + n4 >= attributedCharacterIterator.getEndIndex()) continue;
            try {
                if (n5 != -1) {
                    d2 = d + textLayout.getLogicalHighlightShape(n3 - n, n3 + n5 - n).getBounds2D().getWidth();
                }
                d += textLayout.getLogicalHighlightShape(n3 - n, n3 + n4 - n).getBounds2D().getWidth();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        graphics2D.setColor(color);
        graphics2D.setFont(font);
        return d2;
    }

    private float getImageableXPatch(PageFormat pageFormat) {
        return (float)pageFormat.getImageableX();
    }

    private float getImageableYPatch(PageFormat pageFormat) {
        return (float)pageFormat.getImageableY();
    }

    private AttributedTextLayout nextLayout(float f, FontRenderContext fontRenderContext) {
        LineBreakMeasurer lineBreakMeasurer = this.getMeasurer(fontRenderContext);
        if (lineBreakMeasurer == null) {
            return null;
        }
        AttributedTextLayout attributedTextLayout = new AttributedTextLayout(lineBreakMeasurer.nextLayout(f), (AttributedCharacterIterator)this.fPageStyledTexts.get(this.currentStyledText));
        if (this.fLastTextLayout != null && this.fLastTextLayout.getIterator().equals(attributedTextLayout.getIterator())) {
            attributedTextLayout.setStartingIndex(this.fLastTextLayout.getStartingIndex() + this.fLastTextLayout.getLayout().getCharacterCount());
        }
        this.fLastTextLayout = attributedTextLayout;
        return attributedTextLayout;
    }

    private LineBreakMeasurer getMeasurer(FontRenderContext fontRenderContext) {
        if (this.lineBreakMeasurer == null) {
            this.lineBreakMeasurer = new LineBreakMeasurer((AttributedCharacterIterator)this.fPageStyledTexts.get(this.currentStyledText), fontRenderContext);
        } else if (this.lineBreakMeasurer.getPosition() >= ((AttributedCharacterIterator)this.fPageStyledTexts.get(this.currentStyledText)).getEndIndex()) {
            if (this.currentStyledText == this.fPageStyledTexts.size() - 1) {
                AttributedCharacterIterator[] attributedCharacterIteratorArray = TextPrintable.getIterators(this.fDocument);
                if (attributedCharacterIteratorArray == null) {
                    return null;
                }
                TextPrintable.replaceEmptyIterators(attributedCharacterIteratorArray);
                this.fPageStyledTexts.addAll(Arrays.asList(attributedCharacterIteratorArray));
                ++this.currentStyledText;
                this.lineBreakMeasurer = new LineBreakMeasurer((AttributedCharacterIterator)this.fPageStyledTexts.get(this.currentStyledText), fontRenderContext);
            } else {
                this.lineBreakMeasurer = new LineBreakMeasurer((AttributedCharacterIterator)this.fPageStyledTexts.get(++this.currentStyledText), fontRenderContext);
            }
        }
        return this.lineBreakMeasurer;
    }

    private static boolean wrap() {
        return printSettings.getWrap();
    }

    private static Font getHeaderFont() {
        return printSettings.getHeaderFont();
    }

    private static float getLineAscentCorrection() {
        return printSettings.getLineAscentCorrection();
    }

    private static AttributedCharacterIterator[] getIterators(Document document) {
        AttributedCharacterIterator[] attributedCharacterIteratorArray;
        if (document instanceof PrintableTextDocument) {
            return ((PrintableTextDocument)document).createPrintIterators(sBlockSize);
        }
        Font font = new Font("Courier", 0, 8);
        AttributedCharacters attributedCharacters = null;
        char[] cArray = null;
        ArrayList<AttributedCharacterIterator> arrayList = new ArrayList<AttributedCharacterIterator>(300);
        try {
            attributedCharacterIteratorArray = document.getText(0, document.getLength());
            int n = 0;
            for (int i = 0; i < attributedCharacterIteratorArray.length(); ++i) {
                if (attributedCharacterIteratorArray.charAt(i) != '\n') continue;
                cArray = new char[i - n + 1];
                attributedCharacterIteratorArray.getChars(n, cArray.length + n, cArray, 0);
                attributedCharacters = new AttributedCharacters();
                attributedCharacters.append(cArray, font, Color.black);
                arrayList.add(attributedCharacters.iterator());
                n = i + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        attributedCharacterIteratorArray = new AttributedCharacterIterator[arrayList.size()];
        arrayList.toArray(attributedCharacterIteratorArray);
        return attributedCharacterIteratorArray;
    }

    private static String getFilename(Document document) {
        String string = (String)document.getProperty("title");
        return string == null ? "UNKNOWN" : string;
    }

    private void createCancellationPanel(PrinterJob printerJob, int n) {
        if (this.fParentFrame != null) {
            this.cancellationPanel = new CancellationPanel(n);
            this.fCancellationDialog = new CancelDialog(this.fParentFrame, TextPrintable.getFilename(this.fDocument), this.cancellationPanel, printerJob);
            this.setDialog(this.fCancellationDialog);
        }
    }

    private static void closeDialog(final MJDialog mJDialog) {
        if (mJDialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (mJDialog != null && mJDialog.isShowing()) {
                        mJDialog.setVisible(false);
                        mJDialog.dispose();
                    }
                }
            });
        }
    }

    void setDialog(MJDialog mJDialog) {
        mJDialog.pack();
        mJDialog.show();
        this.fCancellationDialog = mJDialog;
    }

    private static void setCancelled(PrinterJob printerJob) {
        printerJob.cancel();
    }

    boolean isCancelled(PrinterJob printerJob) {
        return printerJob.isCancelled();
    }

    private int setupHeader(Graphics graphics, String string, int n) {
        if (this.fHeaderHeight == 0 && this.printHeader) {
            int n2;
            int n3;
            DateFormat dateFormat;
            String string2;
            Date date = null;
            FontMetrics fontMetrics = graphics.getFontMetrics(TextPrintable.getHeaderFont());
            if (printSettings.isPrintShadedBox()) {
                this.fBoxColor = new Color(240, 240, 240);
            }
            this.fHeaderHeight = fontMetrics.getAscent() + 10;
            if (printSettings.isPrintTwoLineHeader()) {
                this.fHeaderHeight += fontMetrics.getHeight();
            }
            if (printSettings.isPageNum2Style()) {
                string2 = PrintSettings.getString("text.header.pageno2");
                this.fPageNoArgs = new Object[2];
                this.fPageNoArgs[1] = this.pageArgs[3];
            } else if (printSettings.isPageNum3Style()) {
                string2 = PrintSettings.getString("text.header.pageno3");
                this.fPageNoArgs = new Object[2];
                this.fPageNoArgs[1] = this.pageArgs[3];
            } else {
                string2 = PrintSettings.getString("text.header.pageno");
                this.fPageNoArgs = new Object[1];
            }
            this.fPageNoFormat = new MessageFormat(string2);
            this.fPageNoFormat.setLocale(Locale.getDefault());
            if (!printSettings.isPrintHeader3Style()) {
                date = new Date();
                dateFormat = printSettings.isPrintHeader1Style() ? DateFormat.getDateInstance(3) : DateFormat.getDateInstance(1);
                dateFormat.setTimeZone(TimeZone.getDefault());
                this.fDateStr = dateFormat.format(date);
            }
            if (printSettings.isPrintHeader1Style() || printSettings.isPrintHeader2Style()) {
                if (date == null) {
                    date = new Date();
                }
                dateFormat = printSettings.isPrintHeader1Style() ? DateFormat.getTimeInstance(3) : DateFormat.getTimeInstance(2);
                dateFormat.setTimeZone(TimeZone.getDefault());
                this.fTimeStr = dateFormat.format(date);
            }
            if (printSettings.isPrintHeader4Style()) {
                n3 = string.lastIndexOf(System.getProperty("file.separator"));
                if (n3 == -1) {
                    n3 = string.lastIndexOf(47);
                }
                this.fTitle = string.substring(n3 + 1);
                this.fTitle2 = n3 < 0 ? "" : string.substring(0, n3);
            } else {
                this.fTitle = string;
            }
            this.fPageNoArgs[0] = this.fPageNoArgs.length == 1 ? "000" : this.fPageNoArgs[1];
            string2 = this.fPageNoFormat.format(this.fPageNoArgs);
            n3 = n - fontMetrics.stringWidth(string2) - fontMetrics.charWidth(' ') * 4;
            if (printSettings.isPrintHeader1Style()) {
                int n4 = fontMetrics.stringWidth(this.fDateStr) + fontMetrics.stringWidth(this.fTimeStr);
                if (n4 < fontMetrics.stringWidth(string2)) {
                    n4 = fontMetrics.stringWidth(string2);
                }
                n3 -= n4 + fontMetrics.charWidth(' ') * 2;
            }
            if (fontMetrics.stringWidth(this.fTitle) > n3) {
                n3 -= fontMetrics.stringWidth("...");
                char[] cArray = string.toCharArray();
                n2 = this.fTitle.lastIndexOf(System.getProperty("file.separator"));
                if (n2 == -1) {
                    n2 = this.fTitle.lastIndexOf(47);
                }
                if (n2 == -1 || fontMetrics.charsWidth(cArray, n2, cArray.length - n2) > n3) {
                    for (n2 = cArray.length; n2 > 0 && fontMetrics.charsWidth(cArray, 0, n2) > n3; --n2) {
                    }
                    this.fTitle = new String(cArray, 0, n2) + "...";
                } else {
                    int n5;
                    n3 -= fontMetrics.charsWidth(cArray, n2, cArray.length - n2);
                    for (n5 = n2; n5 > 0 && fontMetrics.charsWidth(cArray, 0, n5) > n3; --n5) {
                    }
                    this.fTitle = new String(cArray, 0, n5) + "..." + new String(cArray, n2, cArray.length - n2);
                }
            }
            if (printSettings.isPrintHeader4Style()) {
                n3 = n - fontMetrics.stringWidth(this.fDateStr) - fontMetrics.charWidth(' ') * 6;
                if (fontMetrics.stringWidth(this.fTitle2) > n3) {
                    n3 -= fontMetrics.stringWidth("...");
                    char[] cArray = this.fTitle2.toCharArray();
                    for (n2 = cArray.length; n2 > 0 && fontMetrics.charsWidth(cArray, 0, n2) > n3; --n2) {
                    }
                    this.fTitle2 = new String(cArray, 0, n2) + "...";
                }
            }
        }
        return this.fHeaderHeight;
    }

    private int drawHeader(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.fHeaderHeight;
        if (bl) {
            Font font = graphics2D.getFont();
            graphics2D.setFont(TextPrintable.getHeaderFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n6 = 2;
            int n7 = 3;
            if (printSettings.isPrintBox() || printSettings.isPrintShadedBox()) {
                graphics2D.drawRect(n3, n4, n2, n5 - 4);
                if (printSettings.isPrintShadedBox()) {
                    graphics2D.setColor(this.fBoxColor);
                    graphics2D.fillRect(n3 + 1, n4 + 1, n2 - 2, n5 - 6);
                    graphics2D.setColor(Color.black);
                }
                n3 += n6;
                n4 += n7;
            }
            this.fPageNoArgs[0] = Integer.toString(n + 1);
            String string = this.fPageNoFormat.format(this.fPageNoArgs);
            n4 += fontMetrics.getAscent();
            n7 += fontMetrics.getAscent();
            if (printSettings.isPrintHeader1Style()) {
                int n8 = n3;
                int n9 = fontMetrics.charWidth(' ');
                int n10 = n9 == fontMetrics.charWidth('M') ? n9 : n9 * 2;
                GraphicsUtils.drawStringToGraphics(graphics2D, this.fDateStr, n8, n4);
                GraphicsUtils.drawStringToGraphics(graphics2D, this.fTimeStr, n8 += fontMetrics.stringWidth(this.fDateStr) + n10, n4);
                n8 += fontMetrics.stringWidth(this.fTimeStr) + n9 * 2;
                n9 = (n2 - n8 - n8 - fontMetrics.stringWidth(this.fTitle)) / 2;
                if (n9 > 0) {
                    n8 += n9;
                }
                GraphicsUtils.drawStringToGraphics(graphics2D, this.fTitle, n8, n4);
                n10 = n2 - fontMetrics.stringWidth(string);
                GraphicsUtils.drawStringToGraphics(graphics2D, string, n3 + n10 - n6 * 2, n4);
            } else {
                GraphicsUtils.drawStringToGraphics(graphics2D, this.fTitle, n3, n4);
                GraphicsUtils.drawStringToGraphics(graphics2D, string, n3 - n6 * 2 + n2 - fontMetrics.stringWidth(string), n4);
            }
            n4 += fontMetrics.getHeight();
            n7 += fontMetrics.getHeight();
            if (printSettings.isPrintHeader2Style()) {
                GraphicsUtils.drawStringToGraphics(graphics2D, this.fDateStr, n3, n4);
                GraphicsUtils.drawStringToGraphics(graphics2D, this.fTimeStr, n3 - n6 * 2 + n2 - fontMetrics.stringWidth(this.fTimeStr), n4);
            } else if (printSettings.isPrintHeader4Style()) {
                GraphicsUtils.drawStringToGraphics(graphics2D, this.fTitle2, n3, n4);
                GraphicsUtils.drawStringToGraphics(graphics2D, this.fDateStr, n3 - n6 * 2 + n2 - fontMetrics.stringWidth(this.fDateStr), n4);
            }
            if (printSettings.isPrintDoubleLine()) {
                graphics2D.drawLine(n3, n4 + n5 - 4 - n7, n3 + n2, n4 + n5 - 4 - n7);
                graphics2D.drawLine(n3, n4 + n5 - 2 - n7, n3 + n2, n4 + n5 - 2 - n7);
            } else if (printSettings.isPrintSingleLine()) {
                graphics2D.drawLine(n3, n4 + n5 - 4 - n7, n3 + n2, n4 + n5 - 4 - n7);
                graphics2D.drawLine(n3, n4 + n5 - 3 - n7, n3 + n2, n4 + n5 - 3 - n7);
            }
            graphics2D.setFont(font);
        }
        return n5;
    }

    private int getLineBreakMarkWidth(Graphics graphics, Font font) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getAscent() - fontMetrics.getDescent();
        int n2 = fontMetrics.getLeading();
        if (n2 == 0 && n > 3) {
            n2 = fontMetrics.getDescent();
        }
        if (n < 6) {
            n = fontMetrics.getAscent();
            n = n > 6 ? n - 2 : (n > 4 ? n - 1 : n);
        }
        return n - n2 + 2;
    }

    private void drawLineBreakMark(Graphics graphics, int n, int n2, Font font) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        n += 2;
        int n3 = fontMetrics.getAscent() - fontMetrics.getDescent();
        int n4 = fontMetrics.getLeading();
        if (n4 == 0 && n3 > 3) {
            n4 = fontMetrics.getDescent();
        }
        int n5 = n2 = n3 > 5 ? n2 - 1 : n2;
        if (n3 < 6) {
            n3 = fontMetrics.getAscent();
            n3 = n3 > 6 ? n3 - 2 : (n3 > 4 ? n3 - 1 : n3);
        }
        int n6 = n3 > 4 ? 3 : 2;
        graphics.drawLine(n, n2, n + n3 - n4, n2 - n3 + n4);
        graphics.drawLine(n, n2 - n6, n, n2);
        graphics.drawLine(n, n2, n + n6, n2);
    }

    private static void replaceEmptyIterators(AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        for (int i = 0; i < attributedCharacterIteratorArray.length; ++i) {
            AttributedCharacterIterator attributedCharacterIterator = attributedCharacterIteratorArray[i];
            if (attributedCharacterIterator.getBeginIndex() != attributedCharacterIterator.getEndIndex()) continue;
            AttributedCharacters attributedCharacters = new AttributedCharacters();
            attributedCharacters.append(' ', TextPrintable.getFontInstance(), Color.white);
            attributedCharacterIteratorArray[i] = attributedCharacters.iterator();
        }
    }

    static Font getFontInstance() {
        if (fontInstance == null) {
            fontInstance = new Font("Dialog", 0, 14);
        }
        return fontInstance;
    }

    private static class CancelDialog
    extends MJDialog {
        private MJButton fCancelButton;

        public CancelDialog(Frame frame, String string, CancellationPanel cancellationPanel, final PrinterJob printerJob) {
            super(frame, PrintSettings.getString("print.printProgressTitle"), false);
            this.getContentPane().setLayout(new BorderLayout());
            int n = 5;
            MJLabel mJLabel = new MJLabel((Icon)DialogIcon.INFO_32x32.getIcon());
            mJLabel.setBorder(BorderFactory.createEmptyBorder(n, n * 2, n, n));
            this.getContentPane().add((Component)mJLabel, "West");
            MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(4, 0, 0, 0, 131072));
            MJLabel mJLabel2 = new MJLabel(string);
            mJLabel2.setBorder(BorderFactory.createEmptyBorder(n * 3, 0, n, n));
            mJPanel.add((Component)mJLabel2);
            mJPanel.setBorder(BorderFactory.createEmptyBorder(n, 0, n * 3, n));
            mJPanel.add((Component)((Object)cancellationPanel));
            this.getContentPane().add((Component)mJPanel, "Center");
            MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout());
            this.fCancelButton = new MJButton(MJUtilities.intlString((String)"labelCancel"));
            this.fCancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TextPrintable.setCancelled(printerJob);
                    TextPrintable.closeDialog(CancelDialog.this);
                }
            });
            mJPanel2.add((Component)this.fCancelButton);
            this.getContentPane().add((Component)mJPanel2, "South");
            this.addWindowListener(new WindowEventHandler());
            this.setResizable(false);
            cancellationPanel.setPageno(-1, true, this);
            this.pack();
            this.setLocation(frame);
        }

        private void setLocation(Frame frame) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            Rectangle rectangle = frame.getBounds();
            rectangle.x += rectangle.width / 2 - n / 2;
            rectangle.y += rectangle.height / 2 - n2 / 2;
            this.setBounds(rectangle.x, rectangle.y, n, n2);
        }

        private class WindowEventHandler
        extends WindowAdapter {
            private WindowEventHandler() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n;
                if (CancelDialog.this.isShowing() && (n = MJOptionPane.showConfirmDialog((Component)((Object)CancelDialog.this), (Object)PrintSettings.getString("print.cancelPrintJob"), (String)PrintSettings.getString("print.closeProgressDialog"), (int)0)) == 0 && CancelDialog.this.isShowing()) {
                    CancelDialog.this.fCancelButton.doClick();
                }
            }
        }
    }

    private static final class CancellationPanel
    extends MJProgressBar {
        private final MessageFormat format = new MessageFormat(PrintSettings.getString("CTL_Print_progress"));
        private final Object[] msgParams = new Object[2];
        private int fStartingPage;

        public CancellationPanel(int n) {
            this.setStringPainted(true);
            this.fStartingPage = n;
        }

        public void setTotalPages(final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((CancellationPanel)CancellationPanel.this).msgParams[1] = new Integer(n);
                    CancellationPanel.this.setMaximum(n);
                }
            });
        }

        public void setPageno(final int n, boolean bl, MJDialog mJDialog) {
            String string;
            if (n != -1 && n > this.fStartingPage) {
                this.msgParams[0] = new Integer(n + 1);
                string = this.format.format(this.msgParams);
            } else {
                string = PrintSettings.getString("print.preparingToPrint");
            }
            if (bl) {
                this.setString(string);
                this.getAccessibleContext().setAccessibleDescription(string);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CancellationPanel.this.setString(string);
                        if (n != -1) {
                            CancellationPanel.this.setValue(n);
                        }
                        CancellationPanel.this.getAccessibleContext().setAccessibleDescription(string);
                    }
                });
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Object[] objectArray;
            Dimension dimension = super.getMinimumSize();
            objectArray = new Object[]{new Integer(9999), objectArray[0]};
            MJLabel mJLabel = new MJLabel(this.format.format(objectArray));
            dimension.width = Math.max(dimension.width, (int)mJLabel.getPreferredSize().getWidth() + 10);
            return dimension;
        }
    }

    private static class AttributedTextLayout {
        public AttributedCharacterIterator fIterator;
        public TextLayout fLayout;
        public int fStartingIndex = 0;

        private AttributedTextLayout(TextLayout textLayout, AttributedCharacterIterator attributedCharacterIterator) {
            this.fIterator = attributedCharacterIterator;
            this.fLayout = textLayout;
        }

        public int getStartingIndex() {
            return this.fStartingIndex;
        }

        private void setStartingIndex(int n) {
            this.fStartingIndex = n;
        }

        public AttributedCharacterIterator getIterator() {
            return this.fIterator;
        }

        public TextLayout getLayout() {
            return this.fLayout;
        }
    }
}

