/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.tooltip;

import com.mathworks.widgets.tooltip.BalloonToolTip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class ToolTipManager {
    private static final int SCROLL_DELAY = 500;
    private static final int CLICK_DELAY = 150;
    private Timer fScrollTimer;
    private Timer fClickTimer;
    private BalloonToolTip fTip;

    public ToolTipManager() {
        TimerListener timerListener = new TimerListener();
        this.fScrollTimer = new Timer(500, timerListener);
        this.fClickTimer = new Timer(150, timerListener);
        this.fScrollTimer.setRepeats(false);
        this.fClickTimer.setRepeats(false);
    }

    public void dispose() {
        this.hideTip();
        this.fTip = null;
    }

    public void showTipFromClick(BalloonToolTip balloonToolTip) {
        this.hideTip();
        this.fTip = balloonToolTip;
        this.fClickTimer.restart();
    }

    public void showTipFromScroll(BalloonToolTip balloonToolTip) {
        this.hideTip();
        this.fTip = balloonToolTip;
        this.fScrollTimer.restart();
    }

    public void hideTip() {
        this.fScrollTimer.stop();
        this.fClickTimer.stop();
        if (this.fTip != null) {
            this.fTip.hide();
        }
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.fTip.show();
        }
    }
}

