/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.fixedpoint;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.toolbox.fixedpoint.FixedPointFunctionAbstractPanel;
import com.mathworks.toolbox.fixedpoint.FixedPointMenuAction;
import com.mathworks.toolbox.fixedpoint.SyntaxEnum;
import com.mathworks.toolbox.fixedpoint.TextWidget;
import com.mathworks.toolbox.fixedpoint.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class NumericTypePanel
extends FixedPointFunctionAbstractPanel {
    public static final String DATA_TYPE_LABEL_NAME = "DataTypeModeLabel";
    public static final String DATA_TYPE_COMBOBOX_NAME = "DataTypeModeComboBox";
    public static final String SIGNED_MODE_COMBOBOX_NAME = "SignedModeComboBox";
    public static final String WORD_LENGTH_FIELD_NAME = "WordLengthField";
    public static final String FRACTION_LENGTH_FIELD_NAME = "FractionLengthField";
    public static final String SLOPE_FIELD_NAME = "SlopeLengthField";
    public static final String BIAS_FIELD_NAME = "BiasField";
    public static final String WORD_LENGTH_DEFAULT = "16";
    public static final String FRACTION_LENGTH_DEFAULT = "15";
    public static final String SLOPE_DEFAULT = "2^-15";
    public static final String BIAS_DEFAULT = "0";
    public static final String BUNDLE_STR = "com.mathworks.toolbox.fixedpoint.resources.RES_fixedpoint";
    public static final ResourceBundle LOCAL_BUNDLE = ResourceBundle.getBundle("com.mathworks.toolbox.fixedpoint.resources.RES_fixedpoint");
    public static final Properties ENGLISH_BUNDLE = Utilities.getEnglishResourceBundle("com.mathworks.toolbox.fixedpoint.resources.RES_fixedpoint");
    private ParamValueMode fParamValueMode = ParamValueMode.PAIR;
    private final boolean fSimpleMode;
    private MJComboBox fDataTypeModeComboBox;
    private MJCheckBox fSignedCheckBox;
    private MJComboBox fSignedModeComboBox;
    private TextWidget fBiasTextField;
    private TextWidget fFractionLengthTextField;
    private TextWidget fSlopeTextField;
    private TextWidget fWordLengthTextField;
    private MJLabel fBiasLabel;
    private MJLabel fSignedModeLabel;
    private MJLabel fFractionLengthLabel;
    private MJLabel fSlopeLabel;
    private MJLabel fWordLengthLabel;

    public NumericTypePanel(ParamValueMode paramValueMode, boolean bl) {
        this.fParamValueMode = paramValueMode;
        this.fSimpleMode = bl;
        this.getComponent().setName("NumericTypePanel");
        this.initComponents();
    }

    @Override
    public String getFunctionName() {
        return "numerictype";
    }

    @Override
    public Map<String, String> getParameterMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        ParamValueMode paramValueMode = this.fParamValueMode;
        boolean bl = false;
        if (this.fSignedModeComboBox.isVisible() && this.fSignedModeComboBox.getSelectedItem() == SignedMode.AUTO) {
            bl = true;
        }
        if (!this.fSimpleMode && ((DataTypeMode)this.fDataTypeModeComboBox.getSelectedItem()).isForceParamValue()) {
            bl = true;
        }
        if (paramValueMode == ParamValueMode.PAIR || bl) {
            linkedHashMap.put("DataTypeMode", Utilities.quoteSelection(this.fDataTypeModeComboBox));
            if (this.fSignedModeComboBox.isVisible()) {
                linkedHashMap.put("Signedness", Utilities.quoteSelection(this.fSignedModeComboBox));
            }
            if (this.fWordLengthTextField.isVisible()) {
                linkedHashMap.put("WordLength", this.fWordLengthTextField.getText());
            }
            if (this.fFractionLengthTextField.isVisible()) {
                linkedHashMap.put("FractionLength", this.fFractionLengthTextField.getText());
            }
            if (this.fSlopeTextField.isVisible()) {
                linkedHashMap.put("Slope", this.fSlopeTextField.getText());
            }
            if (this.fBiasTextField.isVisible()) {
                linkedHashMap.put("Bias", this.fBiasTextField.getText());
            }
        } else {
            DataTypeMode dataTypeMode = (DataTypeMode)this.fDataTypeModeComboBox.getSelectedItem();
            if (dataTypeMode.isLiteralValue()) {
                linkedHashMap.put("", Utilities.quoteSelection(this.fDataTypeModeComboBox));
            } else {
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append(this.fSignedModeComboBox.getSelectedItem() == SignedMode.SIGNED ? "1" : BIAS_DEFAULT);
                if (this.fWordLengthTextField.isVisible()) {
                    stringBuilder.append(", ").append(this.fWordLengthTextField.getText());
                }
                if (this.fFractionLengthTextField.isVisible()) {
                    stringBuilder.append(", ").append(this.fFractionLengthTextField.getText());
                }
                if (this.fSlopeTextField.isVisible()) {
                    stringBuilder.append(", ").append(this.fSlopeTextField.getText());
                }
                if (this.fBiasTextField.isVisible()) {
                    stringBuilder.append(", ").append(this.fBiasTextField.getText());
                }
                linkedHashMap.put("", stringBuilder.toString());
            }
        }
        return linkedHashMap;
    }

    @Override
    public String getHelpFunction() {
        return "ref/numerictype.html";
    }

    @Override
    protected void updateComponents() {
        DataTypeMode dataTypeMode = (DataTypeMode)this.fDataTypeModeComboBox.getSelectedItem();
        boolean bl = dataTypeMode != DataTypeMode.BOOLEAN && dataTypeMode != DataTypeMode.SINGLE && dataTypeMode != DataTypeMode.DOUBLE;
        this.fSignedCheckBox.setVisible(bl);
        this.fSignedModeLabel.setVisible(bl);
        this.fSignedModeComboBox.setVisible(bl);
        this.fWordLengthLabel.setVisible(bl);
        this.fWordLengthTextField.setVisible(bl);
        boolean bl2 = dataTypeMode == DataTypeMode.FIXED_BINARY || dataTypeMode == DataTypeMode.SCALED_BINARY;
        this.fFractionLengthLabel.setVisible(bl2);
        this.fFractionLengthTextField.setVisible(bl2);
        boolean bl3 = dataTypeMode == DataTypeMode.FIXED_SLOPE_AND_BIAS || dataTypeMode == DataTypeMode.SCALED_SLOPE_AND_BIAS;
        this.fSlopeLabel.setVisible(bl3);
        this.fSlopeTextField.setVisible(bl3);
        this.fBiasLabel.setVisible(bl3);
        this.fBiasTextField.setVisible(bl3);
    }

    private void initComponents() {
        MJLabel mJLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("DataTypeModePromptStr"));
        mJLabel.setName(DATA_TYPE_LABEL_NAME);
        this.fDataTypeModeComboBox = FimathPanel.createSyntaxEnumComboBox((Enum[])(this.fSimpleMode ? DataTypeMode.getSimpleValues() : DataTypeMode.values()));
        this.fDataTypeModeComboBox.setName(DATA_TYPE_COMBOBOX_NAME);
        this.fDataTypeModeComboBox.setSelectedItem((Object)(this.fSimpleMode ? DataTypeMode.FIXED_UNSPECIFIED : DataTypeMode.FIXED_BINARY));
        this.fSignedModeLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SignednessPromptStr"));
        this.fSignedModeLabel.setName("SignedModeLabel");
        this.fSignedModeComboBox = FimathPanel.createSyntaxEnumComboBox((Enum[])SignedMode.values());
        this.fSignedModeComboBox.setName(SIGNED_MODE_COMBOBOX_NAME);
        this.fWordLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("WordLengthPromptStr"));
        this.fWordLengthLabel.setName("WordLenLabel");
        this.fSignedCheckBox = new MJCheckBox(FixedPointMenuAction.BUNDLE.getString("SignedStr"), true);
        this.fSignedCheckBox.setName("SignedCheckBox");
        this.fFractionLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("FractionLengthPromptStr"));
        this.fFractionLengthLabel.setName("FracLenLabel");
        this.fSlopeLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SlopePromptStr"));
        this.fSlopeLabel.setName("SlopeLabel");
        this.fBiasLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("BiasPromptStr"));
        this.fBiasLabel.setName("BiasLabel");
        this.fWordLengthTextField = new TextWidget(WORD_LENGTH_DEFAULT, WORD_LENGTH_FIELD_NAME);
        this.fFractionLengthTextField = new TextWidget(FRACTION_LENGTH_DEFAULT, FRACTION_LENGTH_FIELD_NAME);
        this.fSlopeTextField = new TextWidget(SLOPE_DEFAULT, SLOPE_FIELD_NAME);
        this.fBiasTextField = new TextWidget(BIAS_DEFAULT, BIAS_FIELD_NAME);
        this.addComponentPair((Component)mJLabel, (Component)this.fDataTypeModeComboBox);
        this.addComponentPair((Component)this.fSignedModeLabel, (Component)this.fSignedModeComboBox);
        this.addComponentPair((Component)this.fWordLengthLabel, this.fWordLengthTextField.getComponent());
        this.addComponentPair((Component)this.fFractionLengthLabel, this.fFractionLengthTextField.getComponent());
        this.addComponentPair((Component)this.fSlopeLabel, this.fSlopeTextField.getComponent());
        this.addComponentPair((Component)this.fBiasLabel, this.fBiasTextField.getComponent());
        this.fDataTypeModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumericTypePanel.this.updatePanel();
            }
        });
    }

    public static enum SignedMode implements SyntaxEnum
    {
        SIGNED("Signed", "SignedStr"),
        UNSIGNED("Unsigned", "UnsignedStr"),
        AUTO("Auto", "AutoStr");

        private final String fValue;
        private final String fKey;

        @Override
        public String toString() {
            return this.toSyntaxString();
        }

        @Override
        public String toSyntaxString() {
            return this.fValue;
        }

        @Override
        public String toDisplayString() {
            return LOCAL_BUNDLE.getString(this.fKey);
        }

        private SignedMode(String string2, String string3) {
            this.fValue = string2;
            this.fKey = string3;
        }
    }

    public static enum DataTypeMode implements SyntaxEnum
    {
        BOOLEAN("Boolean", "DTModeBooleanStr", false, true),
        SINGLE("Single", "DTModeSingleStr", false, true),
        DOUBLE("Double", "DTModeDoubleStr", false, true),
        FIXED_UNSPECIFIED("Fixed-point: unspecified scaling", "DTModeFixPtUnspecSclStr"),
        FIXED_BINARY("Fixed-point: binary point scaling", "DTModeFixPtBinarySclStr"),
        FIXED_SLOPE_AND_BIAS("Fixed-point: slope and bias scaling", "DTModeFixPtSlopeBiasStr"),
        SCALED_UNSPECIFIED("Scaled double: unspecified scaling", "DTModeScDblUnspecSclStr", true),
        SCALED_BINARY("Scaled double: binary point scaling", "DTModeScDblBinarySclStr", true),
        SCALED_SLOPE_AND_BIAS("Scaled double: slope and bias scaling", "DTModeScDblSlopeBiasStr", true);

        private final String fValue;
        private final String fKey;
        private final boolean fForceParamValue;
        private final boolean fIsLiteralValue;

        public static DataTypeMode[] getSimpleValues() {
            return new DataTypeMode[]{FIXED_UNSPECIFIED, FIXED_BINARY, FIXED_SLOPE_AND_BIAS};
        }

        @Override
        public String toString() {
            return this.toSyntaxString();
        }

        @Override
        public String toSyntaxString() {
            return this.fValue;
        }

        @Override
        public String toDisplayString() {
            return LOCAL_BUNDLE.getString(this.fKey);
        }

        public boolean isForceParamValue() {
            return this.fForceParamValue;
        }

        public boolean isLiteralValue() {
            return this.fIsLiteralValue;
        }

        private DataTypeMode(String string2, String string3) {
            this(string2, string3, false);
        }

        private DataTypeMode(String string2, String string3, boolean bl) {
            this(string2, string3, bl, false);
        }

        private DataTypeMode(String string2, String string3, boolean bl, boolean bl2) {
            this.fValue = string2;
            this.fKey = string3;
            this.fIsLiteralValue = bl2;
            this.fForceParamValue = bl;
        }
    }

    public static enum ParamValueMode {
        PAIR,
        CONDENSED;

    }
}

