/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorMessageBarContributor;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolbox.coder.app.CoderMessageModel;
import com.mathworks.widgets.messagepanel.DefaultMessagePanelPainter;
import com.mathworks.widgets.text.STPInterface;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import org.netbeans.editor.SettingsUtil;

public abstract class AbstractCoderMessageBarContributor
implements EditorMessageBarContributor {
    private final CoderMessageModel fModel;
    private final STPInterface fStp;

    public AbstractCoderMessageBarContributor(CoderMessageModel coderMessageModel, STPInterface sTPInterface) {
        this.fModel = coderMessageModel;
        this.fStp = sTPInterface;
    }

    public void configureModel(Editor editor) {
    }

    public CoderMessageModel getModel() {
        return this.fModel;
    }

    public void contributeToContextMenu(MenuBuilder menuBuilder) {
    }

    public boolean isPaintingSummary() {
        return false;
    }

    public Paint getSummaryPaint() {
        return DefaultMessagePanelPainter.NO_MESSAGES_PAINT;
    }

    public EditorMessageBarContributor.Priority getPriority() {
        return EditorMessageBarContributor.Priority.ALWAYS_ON_PROVIDING_SUMMARY;
    }

    public boolean isValid() {
        return true;
    }

    Paint createErrorPaint() {
        return new GradientPaint(0.0f, 0.0f, Color.WHITE, 15.0f, 15.0f, this.getCodeAnalyzerColor(ColorPrefs.MatlabColor.ERROR));
    }

    Paint createWarningPaint() {
        return new GradientPaint(0.0f, 0.0f, Color.WHITE, 15.0f, 15.0f, this.getCodeAnalyzerColor(ColorPrefs.MatlabColor.WARNING));
    }

    private Color getCodeAnalyzerColor(ColorPrefs.MatlabColor matlabColor) {
        return (Color)SettingsUtil.getValue(this.fStp.getEditorKit().getClass(), (String)ColorPrefs.MatlabColor.ERROR.getKey(), (Object)matlabColor.getPreferredColor());
    }
}

