/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointTool;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class CoderRegistry {
    public static final String PROPERTY_INSTANCES_CHANGED = "instances-added-or-removed";
    private static final CoderRegistry SINGLETON = new CoderRegistry(false);
    private final Collection<Runnable> fChangeCallbacks;
    private final Map<CoderKey, CoderInstance> fContexts;
    private final Collection<Predicate<CloseContext>> fClosePredicates;
    private final Object fLock;
    private final boolean fAllowMultiple;

    private CoderRegistry(boolean bl) {
        this.fAllowMultiple = bl;
        this.fContexts = new HashMap<CoderKey, CoderInstance>();
        this.fChangeCallbacks = new LinkedList<Runnable>();
        this.fClosePredicates = new LinkedList<Predicate<CloseContext>>();
        this.fLock = new Object();
    }

    public static CoderRegistry getInstance() {
        return SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CoderApp getOpenApp(File file) {
        Object object = this.fLock;
        synchronized (object) {
            for (CoderInstance coderInstance : this.fContexts.values()) {
                if (coderInstance.getApp() == null || Utilities.areValuesDifferent(file, coderInstance.getProjectFile())) continue;
                return coderInstance.getApp();
            }
            for (CoderInstance coderInstance : this.fContexts.values()) {
                if (coderInstance.getApp() == null || !FileUtils.areFilesTheSame((File)file, (File)coderInstance.getProjectFile())) continue;
                return coderInstance.getApp();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fContexts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCoderWindow(Window window) {
        Object object = this.fLock;
        synchronized (object) {
            for (CoderInstance coderInstance : this.fContexts.values()) {
                if (!window.equals(coderInstance.getWindow())) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClosePredicate(Predicate<CloseContext> predicate) {
        Object object = this.fLock;
        synchronized (object) {
            this.fClosePredicates.add(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeObserver(Runnable runnable) {
        Object object = this.fLock;
        synchronized (object) {
            this.fChangeCallbacks.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeObserver(Runnable runnable) {
        Object object = this.fLock;
        synchronized (object) {
            this.fChangeCallbacks.remove(runnable);
        }
    }

    public boolean isAllowMultiple() {
        return this.fAllowMultiple;
    }

    private void fireChange() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CoderRegistry.this.fLock;
                synchronized (object) {
                    for (Runnable runnable : new LinkedList(CoderRegistry.this.fChangeCallbacks)) {
                        runnable.run();
                    }
                }
            }
        });
    }

    private void updateRegistration(final CoderKey coderKey) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CoderInstance coderInstance = (CoderInstance)CoderRegistry.this.fContexts.remove(coderKey);
                CoderRegistry.this.addCoderInstance(coderInstance);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOpenGuis(boolean bl) {
        MJUtilities.assertEventDispatchThread();
        if (this.isAllowMultiple()) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            for (CoderInstance coderInstance : new LinkedList<CoderInstance>(this.fContexts.values())) {
                CloseContext closeContext = new CloseContext(coderInstance);
                boolean bl2 = true;
                if (bl) {
                    Predicate<CloseContext> predicate;
                    Iterator<Predicate<CloseContext>> iterator = this.fClosePredicates.iterator();
                    while (iterator.hasNext() && (bl2 = (predicate = iterator.next()).accept((Object)closeContext))) {
                    }
                }
                if (!bl2) continue;
                this.removeCoderInstance(coderInstance.getKey());
                coderInstance.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasUnified() {
        Object object = this.fLock;
        synchronized (object) {
            for (CoderInstance coderInstance : this.fContexts.values()) {
                if (!coderInstance.isUnifiedUI()) continue;
                return true;
            }
            return false;
        }
    }

    private void addCoderInstance(final CoderInstance coderInstance) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CoderRegistry.this.fLock;
                synchronized (object) {
                    if (CoderRegistry.this.fContexts.containsKey(coderInstance.getKey())) {
                        return;
                    }
                    if (!CoderRegistry.this.isAllowMultiple() && (coderInstance.isUnifiedUI() || CoderRegistry.this.hasUnified())) {
                        CoderRegistry.this.closeOpenGuis(true);
                    }
                    if (CoderRegistry.this.fContexts.isEmpty()) {
                        CoderFileSupport.setFileCachingEnabled(true);
                    }
                    CoderRegistry.this.fContexts.put(coderInstance.getKey(), coderInstance);
                    CoderRegistry.this.fireChange();
                }
            }
        });
    }

    public void register(CoderApp coderApp) {
        this.addCoderInstance(new UnifiedInstance(coderApp));
    }

    public void register(Project project) {
        this.addCoderInstance(new ProjectGuiInstance(project));
    }

    public void unregister(CoderApp coderApp) {
        this.removeCoderInstance(new CoderKey(coderApp));
    }

    public void unregister(Project project) {
        if (project != null && project.getConfiguration() != null) {
            this.removeCoderInstance(new CoderKey(project.getConfiguration()));
        }
    }

    private void removeCoderInstance(final CoderKey coderKey) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CoderRegistry.this.fLock;
                synchronized (object) {
                    if (CoderRegistry.this.fContexts.containsKey(coderKey)) {
                        ((CoderInstance)CoderRegistry.this.fContexts.remove(coderKey)).close(false);
                        CoderRegistry.this.fireChange();
                    }
                    if (CoderRegistry.this.fContexts.isEmpty()) {
                        CoderFileSupport.setFileCachingEnabled(false);
                    }
                }
            }
        });
    }

    public static final class CloseContext {
        private final Component fRepresentativeComponent;
        private final GenericArtifact fProduct;
        private final File fProjectFile;
        private final CoderApp fApp;

        public CloseContext(CoderInstance coderInstance) {
            this.fRepresentativeComponent = coderInstance.getWindow();
            this.fProduct = coderInstance.getProduct();
            this.fProjectFile = coderInstance.getProjectFile();
            this.fApp = coderInstance.getApp();
        }

        public Component getRepresentativeComponent() {
            return this.fRepresentativeComponent;
        }

        public GenericArtifact getProduct() {
            return this.fProduct;
        }

        public File getProjectFile() {
            return this.fProjectFile;
        }

        public CoderApp getApp() {
            return this.fApp;
        }
    }

    private static class CoderKey {
        private final CoderApp fApp;
        private final File fFile;

        CoderKey(CoderApp coderApp) {
            this.fApp = coderApp;
            this.fFile = null;
        }

        CoderKey(Configuration configuration) {
            this(configuration.getFile());
        }

        CoderKey(File file) {
            this.fFile = file;
            this.fApp = null;
            assert (this.fFile != null);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CoderKey coderKey = (CoderKey)object;
            if (this.fApp != null ? !this.fApp.equals(coderKey.fApp) : coderKey.fApp != null) {
                return false;
            }
            return !(this.fFile != null ? !this.fFile.equals(coderKey.fFile) : coderKey.fFile != null);
        }

        public int hashCode() {
            int n = this.fApp != null ? this.fApp.hashCode() : 0;
            n = 31 * n + (this.fFile != null ? this.fFile.hashCode() : 0);
            return n;
        }
    }

    private class ProjectGuiInstance
    extends CoderInstance {
        private final Project fProject;

        ProjectGuiInstance(Project project) {
            super(project.getConfiguration(), null);
            this.fProject = project;
        }

        @Override
        void closeGUI() {
            ProjectGUI.getInstance().closeProjectAndClient();
        }

        @Override
        Window getWindow() {
            Container container;
            if (WorkflowDialog.getInstance() != null && WorkflowDialog.getInstance().getDialog().isActive()) {
                return WorkflowDialog.getInstance().getDialog();
            }
            if (FixedPointTool.getInstance() != null && (container = SwingUtilities.getWindowAncestor(FixedPointTool.getInstance().getPanel().getComponent())) != null && ((Window)container).isActive()) {
                return container;
            }
            if (ProjectGUI.getInstance().getCurrentClient() != null) {
                container = ProjectGUI.getInstance().getCurrentClient().getComponent();
                if (container instanceof Window) {
                    return (Window)container;
                }
                return SwingUtilities.getWindowAncestor(container);
            }
            return null;
        }

        @Override
        GenericArtifact getProduct() {
            Target target = this.fProject.getConfiguration().getTarget();
            if (target != null && target.getKey().contains("hdlcoder")) {
                return GenericArtifact.HDL;
            }
            return GenericArtifact.C;
        }
    }

    private class UnifiedInstance
    extends CoderInstance {
        UnifiedInstance(CoderApp coderApp) {
            super(coderApp.getModel().getConfiguration(), coderApp);
        }

        @Override
        void closeGUI() {
            this.getApp().close();
        }

        @Override
        Window getWindow() {
            return this.getApp().getWindow();
        }

        @Override
        GenericArtifact getProduct() {
            return this.getApp().getModel().getGenericArtifact();
        }
    }

    private abstract class CoderInstance {
        private final Configuration fConfiguration;
        private final CoderApp fApp;
        private final PropertyChangeListener fChangeListener;
        private CoderKey fKey;

        CoderInstance(@Nullable Configuration configuration, CoderApp coderApp) {
            this.fConfiguration = configuration;
            this.fApp = coderApp;
            this.fChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (propertyChangeEvent.getPropertyName().equals("@file")) {
                                CoderKey coderKey = CoderInstance.this.fKey;
                                CoderInstance.this.fKey = CoderInstance.this.createKey();
                                CoderRegistry.this.updateRegistration(coderKey);
                            }
                        }
                    });
                }
            };
            this.fConfiguration.addPropertyChangeListener(this.fChangeListener);
            this.fKey = this.createKey();
        }

        private CoderKey createKey() {
            return this.getApp() != null ? new CoderKey(this.getApp()) : new CoderKey(this.fConfiguration);
        }

        CoderKey getKey() {
            return this.fKey;
        }

        CoderApp getApp() {
            return this.fApp;
        }

        boolean isUnifiedUI() {
            return this.fApp != null;
        }

        File getProjectFile() {
            return this.fConfiguration.getFile();
        }

        final void close(boolean bl) {
            this.fConfiguration.removePropertyChangeListener(this.fChangeListener);
            if (bl) {
                this.closeGUI();
            }
        }

        abstract void closeGUI();

        abstract GenericArtifact getProduct();

        @Nullable
        abstract Window getWindow();
    }
}

