/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.workflowui.WorkflowSplitPane;
import com.mathworks.toolbox.coder.app.Artifact;
import com.mathworks.toolbox.coder.app.BuildManager;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.FindAdapter;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.PopupHintProvider;
import com.mathworks.toolbox.coder.app.TabbedPane;
import com.mathworks.toolbox.coder.app.ide.AbstractCodeInfoView;
import com.mathworks.toolbox.coder.app.ide.CallSiteSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.CoderContextActionProvider;
import com.mathworks.toolbox.coder.app.ide.DefaultIDEFileSidebar;
import com.mathworks.toolbox.coder.app.ide.EditManager;
import com.mathworks.toolbox.coder.app.ide.EditorFileViewProvider;
import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.ErrorSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.FileSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.FunctionSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.IDEContext;
import com.mathworks.toolbox.coder.app.ide.IDELayout;
import com.mathworks.toolbox.coder.app.ide.IDEPropertyBinder;
import com.mathworks.toolbox.coder.app.ide.SelectionAdapter;
import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.app.ide.Selector;
import com.mathworks.toolbox.coder.app.ide.VariableSelectionEvent;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.wfa.CoderStepModel;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.files.FileSetSidebarWidget;
import com.mathworks.toolbox.coder.wfa.files.FileSetViewGroup;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.SyntaxTextPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IDEView {
    private final CoderApp fApp;
    private final MJPanel fComponent;
    private final CodeInfoView fCodeInfoView;
    private final DefaultIDEFileSidebar fSidebarContext;
    private final FileSetSidebarWidget fFilesPanel;
    private final JComponent fVariablesTableWrapper;
    private final SaveMediator fSaveMediator;
    private final IDEPropertyBinder fModelPropertyBinder;
    private final SelectionHandler fSelectionHandler;
    private final List<Runnable> fInstallListeners;
    private final List<Selector> fSelectors;
    private boolean fInitialized;
    private IDEContext fContext;
    public static final String VARIABLES_TAB_KEY = "variables";
    public static final String OUTPUT_TAB_KEY = "output";
    public static final String INPUT_FILES_KEY = "input-files";
    public static final String OUTPUT_FILES_KEY = "output-files";

    public IDEView(CoderApp coderApp) {
        this.fApp = coderApp;
        this.fSelectors = new LinkedList<Selector>();
        this.fComponent = new MJPanel(new BorderLayout(0, 0)){

            public void addNotify() {
                super.addNotify();
                for (Runnable runnable : new ArrayList(IDEView.this.fInstallListeners)) {
                    runnable.run();
                }
            }
        };
        this.fSaveMediator = new SaveMediator();
        this.fSelectionHandler = new SelectionHandler();
        this.fVariablesTableWrapper = new MJPanel();
        this.fCodeInfoView = new CodeInfoView();
        this.fFilesPanel = new FileSetSidebarWidget(coderApp.getModel().getConfiguration());
        this.fSidebarContext = new DefaultIDEFileSidebar(this.fApp, this.fCodeInfoView.getEditorView(), this.fFilesPanel, this);
        this.fModelPropertyBinder = new IDEPropertyBinder(this.fApp, this.fCodeInfoView.getEditorView(), this.fSidebarContext, this);
        this.fCodeInfoView.getEditorView().removeBorder();
        this.fInstallListeners = new LinkedList<Runnable>();
        this.fSidebarContext.getFileSets().addSelectionListener(this.createSidebarListener());
        this.layoutIDEView(new Layout());
        coderApp.getModel().bind(this.fModelPropertyBinder);
        this.getCodeInfoView().getEditorView().installContextActionProvider(new CoderContextActionProvider(this.fSidebarContext));
        this.getCodeInfoView().getEditorView().setEditabilityPredicate(new Predicate<File>(){

            public boolean accept(File file) {
                return IDEView.this.shouldFileBeEditable(file);
            }
        });
        this.installSelector(this.fCodeInfoView.getEditorView());
        this.installSelector(this.fSidebarContext.getSidebarSelector());
    }

    private void layoutIDEView(Layout layout) {
        if (layout.getRootComponent() == null) {
            layout.useDefaultLayout();
        }
        this.fComponent.removeAll();
        this.fComponent.add(layout.getRootComponent());
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void addInstallListener(Runnable runnable) {
        this.fInstallListeners.add(runnable);
    }

    public FileSetViewGroup getFileSets() {
        return this.fSidebarContext.getFileSets();
    }

    public AbstractCodeInfoView getCodeInfoView() {
        return this.fCodeInfoView;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    void installSelector(Selector selector) {
        this.fSelectors.add(selector);
        selector.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                IDEView.this.fireSelect(selectionEvent);
            }
        });
    }

    public void setContext(IDEContext iDEContext) {
        if (!this.fInitialized) {
            this.fModelPropertyBinder.initToModel();
            this.fInitialized = true;
        }
        if (Utilities.areValuesDifferent(iDEContext, this.fContext) && this.fContext != null) {
            this.fContext.deactivate();
        }
        this.fContext = iDEContext;
        this.fContext.init(this);
        OutputPane outputPane = this.fContext.getOutputPane();
        if (outputPane == null) {
            this.fCodeInfoView.setOutputPane(null);
            outputPane = this.fCodeInfoView.getOutputPane();
        } else {
            this.fCodeInfoView.setOutputPane(outputPane);
        }
        Layout layout = new Layout();
        this.fContext.activate(this.fSidebarContext, layout, outputPane, this.fCodeInfoView.getEditorView());
        this.layoutIDEView(layout);
        EditorView editorView = this.fCodeInfoView.getEditorView();
        editorView.setPopupController(this.fContext.createCodePopupController(this.fApp.getWindow(), editorView));
        this.fSidebarContext.updateAll();
    }

    public void fireSelect(SelectionEvent selectionEvent) {
        this.getCodeInfoView().getEditorView().setEditable(selectionEvent.getFile() != null && this.fApp.getModel().getActiveInputSourceSet().getFiles().contains(selectionEvent.getFile()));
        for (Selector selector : this.fSelectors) {
            if (!Utilities.areValuesDifferent(selector, selectionEvent.getSource())) continue;
            selector.select(selectionEvent);
        }
        if (this.fContext != null) {
            for (Selector selector : this.fContext.getSelectors()) {
                if (!Utilities.areValuesDifferent(selector, selectionEvent.getSource())) continue;
                selector.select(selectionEvent);
            }
        }
        this.fSelectionHandler.selectionChanged(selectionEvent);
    }

    void selectFile(boolean bl, boolean bl2) {
        if (bl2 && this.getFileSets().getSelectedFile() != null) {
            return;
        }
        File file = null;
        Function function = null;
        if (bl) {
            file = this.fApp.getModel().getEntryPoint();
            if (file != null) {
                function = new Function(file, new FileLocation(file).getNameBeforeDot());
            }
        } else {
            Set<File> set = this.fSidebarContext.getFileSetIntegrationContext(OUTPUT_FILES_KEY).getFiles();
            if (!set.isEmpty()) {
                file = set.iterator().next();
            }
        }
        if (function != null) {
            this.fireSelect(new FunctionSelectionEvent(null, function));
        }
        if (file != null) {
            this.fireSelect(new FileSelectionEvent(null, file));
        }
    }

    public void dispose() {
        this.fSaveMediator.processAll();
        this.fCodeInfoView.dispose();
        this.fApp.getModel().unbind(this.fModelPropertyBinder);
    }

    private ChangeListener createSidebarListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (IDEView.this.fContext != null) {
                    IDEView.this.fContext.sidebarFunctionChanged(IDEView.this.getFileSets().getSelectedFunction());
                }
            }
        };
    }

    private boolean shouldFileBeEditable(@Nullable File file) {
        return file != null && this.fApp.getModel().getActiveInputSourceSet().getFiles().contains(file);
    }

    private class Layout
    implements IDELayout {
        private Component fRootComponent;
        private Component fConfigurationView;

        private Layout() {
        }

        @Override
        public JComponent createCodePane(Component component, Component component2) {
            IDEView.this.fCodeInfoView.rebuildSplitPane(component, component2);
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel.add(IDEView.this.fCodeInfoView.getComponent());
            mJPanel.setBorder(new EmptyBorder(0, 0, 4, 0));
            return mJPanel;
        }

        @Override
        public Component getEditorComponent() {
            return IDEView.this.fCodeInfoView.getEditorView().getComponent();
        }

        @Override
        public Component getOutputAreaComponent() {
            return IDEView.this.fCodeInfoView.getOutputPane().getComponent();
        }

        @Override
        public Component getFileSetSidebarComponent() {
            return IDEView.this.fFilesPanel.getComponent();
        }

        @Override
        public void useDefaultLayout() {
            JComponent jComponent = IDEView.this.fFilesPanel.getComponent();
            if (this.fConfigurationView != null) {
                MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
                mJPanel.add(IDEView.this.fFilesPanel.getComponent());
                mJPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                FileSetSidebarWidget fileSetSidebarWidget = new FileSetSidebarWidget(IDEView.this.fApp.getModel().getConfiguration(), false);
                fileSetSidebarWidget.addFileSetPanel(this.fConfigurationView.getClass().toString(), CoderResources.getString("wfa.ide.buildConfig.label"), this.fConfigurationView);
                jComponent = new MJPanel((LayoutManager)new BorderLayout());
                jComponent.add((Component)mJPanel);
                jComponent.add((Component)fileSetSidebarWidget.getComponent(), "South");
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
            }
            this.setRootComponent(this.createPrimarySplitPane(jComponent, this.useDefaultCodePaneLayout()));
        }

        @Override
        public Component useDefaultCodePaneLayout() {
            return this.createCodePane(IDEView.this.fCodeInfoView.getEditorView().getComponent(), IDEView.this.fCodeInfoView.getOutputPane().getComponent());
        }

        @Override
        public JComponent createPrimarySplitPane(Component component, Component component2) {
            return new WorkflowSplitPane(component2, component, 200, true).getComponent();
        }

        @Override
        public JComponent createSecondarySplitPane(Component component, Component component2) {
            return new WorkflowSplitPane(component2, component, 500, true).getComponent();
        }

        @Override
        public void setRootComponent(Component component) {
            this.fRootComponent = component;
        }

        @Override
        public void setCustomConfigurationView(Component component) {
            this.fConfigurationView = component;
        }

        @Override
        public void setShowMilestoneSequence(boolean bl) {
        }

        private Component getRootComponent() {
            return this.fRootComponent;
        }
    }

    private class AntiMexEditorFileViewProvider
    extends EditorFileViewProvider {
        private boolean fShowMessage;

        AntiMexEditorFileViewProvider() {
            super(new String[0]);
            this.fShowMessage = true;
            IDEView.this.fApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("built")) {
                        AntiMexEditorFileViewProvider.this.fShowMessage = true;
                    }
                }
            });
        }

        @Override
        public boolean isShowDisclaimer() {
            if (!this.fShowMessage || this.getFile() == null || IDEView.this.fApp.getAdvisor() == null) {
                return false;
            }
            Step step = IDEView.this.fApp.getModel().getCurrentWorkflowStep(IDEView.this.fApp.getAdvisor().getModel());
            return (step.equals(CoderStepModel.GENERATE_CODE_STEP) || step.equals(CoderStepModel.HDL_CHOOSE_TARGET_STEP)) && IDEView.this.fApp.getModel().getOutputFiles().contains(this.getFile()) && IDEView.this.fApp.getModel().getArtifact() == Artifact.MEX_FILE;
        }

        @Override
        public String getDisclaimer() {
            return CoderResources.getString("wfa.editor.mexDisclaimer");
        }

        @Override
        public ParameterRunnable<Boolean> getDisclaimerCallback() {
            return new ParameterRunnable<Boolean>(){

                public void run(Boolean bl) {
                    AntiMexEditorFileViewProvider.this.fShowMessage = bl == false;
                }
            };
        }
    }

    private static class HintProvider
    implements PopupHintProvider {
        private HintProvider() {
        }

        @Override
        public String getCurrentHint() {
            return null;
        }

        @Override
        public String getInitialHint() {
            return null;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private class SaveMediator
    implements EditManager.EditStateMediator {
        private final Map<File, Runnable> fOutdated = new LinkedHashMap<File, Runnable>();

        SaveMediator() {
            IDEView.this.fApp.getWindow().addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    SaveMediator.this.processAll();
                }
            });
        }

        private void processAll() {
            LinkedList<Runnable> linkedList = new LinkedList<Runnable>(this.fOutdated.values());
            this.fOutdated.clear();
            for (Runnable runnable : linkedList) {
                runnable.run();
            }
        }

        private void processConflict(EditorLoadContext editorLoadContext, Runnable runnable) {
            if (IDEView.this.fApp.getWindow().isActive()) {
                runnable.run();
            } else {
                assert (editorLoadContext.getFile() != null);
                this.fOutdated.put(editorLoadContext.getFile(), runnable);
            }
        }

        @Override
        public void fileOutdated(final EditorLoadContext editorLoadContext, final boolean bl) {
            this.processConflict(editorLoadContext, new Runnable(){

                @Override
                public void run() {
                    String string = MessageFormat.format(CoderResources.getString("wfa.load.message.outdated"), editorLoadContext.getFile());
                    String string2 = CoderResources.getString("wfa.load.title");
                    int n = 0;
                    if (bl) {
                        n = MJOptionPane.showConfirmDialog((Component)IDEView.this.getComponent(), (Object)string, (String)string2, (int)0, (int)3);
                    }
                    if (n == 0) {
                        File file = IDEView.this.getCodeInfoView().getEditorView().getCurrentFile();
                        if (file != null && file.equals(editorLoadContext.getFile())) {
                            if (IDEView.this.getCodeInfoView().getEditorView().getEntityLocator() != null) {
                                IDEView.this.getCodeInfoView().getEditorView().getEntityLocator().reset(file);
                            }
                            IDEView.this.getCodeInfoView().getEditorView().reload();
                        } else if (bl) {
                            IDEView.this.fApp.getEditManager().setInactive(editorLoadContext);
                        }
                        IDEView.this.getCodeInfoView().getEditorView().getTextMapper().invalidate(editorLoadContext.getFile());
                    }
                }
            });
        }

        @Override
        public void fileSaving(final EditorLoadContext editorLoadContext, final boolean bl, final boolean bl2, final @NotNull ParameterRunnable<Boolean> parameterRunnable) {
            this.processConflict(editorLoadContext, new Runnable(){

                @Override
                public void run() {
                    File file = editorLoadContext.getFile();
                    if (bl || !bl2) {
                        String string = CoderResources.getString("wfa.save.message." + (bl ? "outdated" : "readOnly"));
                        String string2 = CoderResources.getString("wfa.save.overwrite");
                        String string3 = BuiltInResources.getString((String)"button.cancel");
                        Object[] objectArray = new String[]{string2, string3};
                        int n = MJOptionPane.showOptionDialog((Component)IDEView.this.getComponent(), (Object)MessageFormat.format(string, file.getName()), (String)CoderResources.getString("wfa.save.title"), (int)2, (int)3, null, (Object[])objectArray, (Object)string2);
                        parameterRunnable.run((Object)(n == 0 ? 1 : 0));
                        IDEView.this.getCodeInfoView().getEditorView().reload(true);
                    } else {
                        parameterRunnable.run((Object)true);
                    }
                }
            });
        }

        @Override
        public void fileSavingErrored(final EditorLoadContext editorLoadContext, final IOException iOException) {
            this.processConflict(editorLoadContext, new Runnable(){

                @Override
                public void run() {
                    MJOptionPane.showMessageDialog((Component)IDEView.this.getComponent(), (Object)MessageFormat.format(CoderResources.getString("wfa.save.error"), editorLoadContext.getFile().getName(), iOException.getMessage()), (String)CoderResources.getString("wfa.save.title"), (int)0);
                }
            });
        }
    }

    private class SelectionHandler
    extends SelectionAdapter {
        private Runnable fErrorCleanup;
        private boolean fErrorCloseable;

        private SelectionHandler() {
        }

        @Override
        public void selectionChanged(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource() == null || !selectionEvent.getSource().equals(IDEView.this.getCodeInfoView().getEditorView())) {
                super.selectionChanged(selectionEvent);
            }
        }

        @Override
        protected void onVariableSelected(VariableSelectionEvent variableSelectionEvent) {
            if (variableSelectionEvent.getSelectedValue() != null) {
                IDEView.this.getCodeInfoView().getEditorView().displayVariable(variableSelectionEvent.getSelectedValue());
            } else {
                IDEView.this.getCodeInfoView().getEditorView().displayFile(variableSelectionEvent.getFile());
            }
            this.enableOrDisableEditor(variableSelectionEvent.getFile());
        }

        @Override
        protected void onCallSiteSelected(CallSiteSelectionEvent callSiteSelectionEvent) {
            IDEView.this.getCodeInfoView().getEditorView().displayCallSite(callSiteSelectionEvent.getSelectedValue());
            this.enableOrDisableEditor(callSiteSelectionEvent.getFile());
        }

        @Override
        protected void onFunctionSelected(FunctionSelectionEvent functionSelectionEvent) {
            if (functionSelectionEvent.getSelectedValue() != null) {
                Function function = functionSelectionEvent.getSelectedValue();
                IDEView.this.getCodeInfoView().getEditorView().displayFunction(function, true);
            } else {
                IDEView.this.getCodeInfoView().getEditorView().displayFile(functionSelectionEvent.getFile());
            }
            this.enableOrDisableEditor(functionSelectionEvent.getFile());
        }

        @Override
        protected void onFileSelected(FileSelectionEvent fileSelectionEvent) {
            IDEView.this.getCodeInfoView().getEditorView().displayFile(fileSelectionEvent.getSelectedValue());
            this.enableOrDisableEditor(fileSelectionEvent.getSelectedValue());
        }

        @Override
        protected void onErrorSelected(ErrorSelectionEvent errorSelectionEvent) {
            IDEView.this.getCodeInfoView().getEditorView().displayError(errorSelectionEvent.getSelectedValue(), this.fErrorCloseable, this.fErrorCleanup);
            this.fErrorCleanup = null;
        }

        private void enableOrDisableEditor(File file) {
            IDEView.this.getCodeInfoView().getEditorView().setEditable(IDEView.this.shouldFileBeEditable(file));
        }

        void setErrorContext(boolean bl, Runnable runnable) {
            this.fErrorCloseable = bl;
            this.fErrorCleanup = runnable;
        }
    }

    private class CodeInfoView
    extends AbstractCodeInfoView {
        CodeInfoView() {
            super(IDEView.this.fApp.getWindow(), IDEView.this.fApp.getGlassPaneManager(), IDEView.this.fApp.getAnimator(), false, true);
            IDEView.this.fApp.getEditManager().setHandler(IDEView.this.fSaveMediator);
            this.getEditorView().setEditManager(IDEView.this.fApp.getEditManager());
            this.getEditorView().setEditable(true);
        }

        @Override
        protected void configureEditor(EditorView editorView) {
        }

        @Override
        protected void showErrorInCodePane(BuildError buildError, boolean bl, Runnable runnable) {
            IDEView.this.fSelectionHandler.setErrorContext(bl, runnable);
            IDEView.this.fireSelect(new ErrorSelectionEvent(null, buildError));
        }

        @Override
        protected boolean isFunctionInTargetCodeBase(Function function) {
            return IDEView.this.fApp.getModel().getInputFiles().contains(function.getFile()) || IDEView.this.fApp.getModel().getOutputFiles().contains(function.getFile()) || IDEView.this.fApp.getModel().getEntryPointFileSet().getFiles().contains(function.getFile());
        }

        @Override
        protected PopupHintProvider createHintProvider(PopupBarManager popupBarManager, FindAdapter findAdapter) {
            return new HintProvider();
        }

        @Override
        protected BuildManager createBuildManager(OutputPane outputPane) {
            return null;
        }

        @Override
        protected CodePopupController createCodePopupController(Window window, EditorView editorView, SyntaxTextPane syntaxTextPane, Function function) {
            return IDEView.this.fContext == null ? null : IDEView.this.fContext.createCodePopupController(window, editorView);
        }

        @Override
        protected FunctionScopedEntityLocator createEntityLocator() {
            return new FunctionScopedEntityLocator(IDEView.this.fApp.getModel(), IDEView.this.fApp.getModel().getInferenceModel());
        }

        @Override
        protected void initializeTabbedPane(TabbedPane tabbedPane) {
            tabbedPane.addTab(IDEView.VARIABLES_TAB_KEY, CoderResources.getString("wfa.tab.variables"), IDEView.this.fVariablesTableWrapper);
            tabbedPane.addTab(IDEView.OUTPUT_TAB_KEY, CoderResources.getString("wfa.tab.output"));
            tabbedPane.setVisible(IDEView.VARIABLES_TAB_KEY, false);
        }

        @Override
        protected boolean isEntryPoint(File file) {
            return IDEView.this.fApp.getModel().getEntryPointFileSet().getFiles().contains(file);
        }

        @Override
        protected EditorFileViewProvider createEditorFileViewProvider() {
            return new AntiMexEditorFileViewProvider();
        }
    }
}

