/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.desktop.HelpAction;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.Pair;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Histogram {
    private final MJPanel fComponent;
    private final MJCheckBox fSignedCheck;
    private final Color fBackground;
    private final int fTotalPositive;
    private final int fTotalNegative;
    private final boolean fDefaultSigned;
    private final int fDefaultWordLength;
    private final int fDefaultFractionLength;
    private final int fMaxCount;
    private final boolean fAnyNegative;
    private final MJAbstractAction fResetAction;
    private final Map<Integer, Integer> fPositiveCounts;
    private final Map<Integer, Integer> fNegativeCounts;
    private final Map<Integer, Double> fPositivePercents;
    private final Map<Integer, Double> fTotalPercents;
    private final MJEditorPane fCoverageLabel;
    private final MJLabel fRangeLabel;
    private final Graph fGraph;
    private final Runnable fShowHelp;
    private final boolean fNoData;
    private final MulticastChangeListener fChangeListeners = new MulticastChangeListener();
    private int fMinBit;
    private int fMaxBit;
    private boolean fSigned;
    private boolean fSuppressItemListener;
    private int fWordLength;
    private int fFractionLength;
    private static final Color BAR_COLOR = new Color(0, 77, 0);
    private static final Color NEGATIVE_BAR_COLOR = new Color(0, 0, 77);
    public static final Dimension HISTOGRAM_SIZE = new Dimension(252, 185);

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        hashMap.put(1, 650);
        hashMap2.put(1, 650);
        hashMap.put(-1, 144);
        hashMap2.put(-1, 144);
        Histogram.show(true, 8, -1, hashMap, hashMap2, null);
    }

    public static void show(boolean bl, int n, int n2, Map<Integer, Integer> map, Map<Integer, Integer> map2, Runnable runnable) {
        Histogram histogram = new Histogram(UIManager.getColor("control"), bl, n, n2, map, map2, runnable);
        JFrame jFrame = new JFrame();
        jFrame.add(histogram.getComponent());
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.show();
    }

    public Histogram(Color color, boolean bl, int n, int n2, Map<Integer, Integer> map, Map<Integer, Integer> map2, Runnable runnable) {
        this.fShowHelp = runnable;
        this.fComponent = new MJPanel(new GridBagLayout()){

            public Dimension getPreferredSize() {
                return HISTOGRAM_SIZE;
            }
        };
        this.fBackground = color;
        this.fComponent.setOpaque(false);
        this.fWordLength = n;
        this.fFractionLength = n2;
        this.fDefaultWordLength = n;
        this.fDefaultFractionLength = n2;
        this.fDefaultSigned = bl;
        this.fAnyNegative = true;
        this.fSigned = bl;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.addAll(map.keySet());
        treeSet.addAll(map2.keySet());
        this.fNoData = treeSet.isEmpty();
        this.fMinBit = treeSet.isEmpty() ? 1 : (Integer)Collections.min(treeSet);
        int n3 = this.fMaxBit = treeSet.isEmpty() ? 1 : (Integer)Collections.max(treeSet);
        if (this.fMaxBit - this.fMinBit + 1 < this.fWordLength) {
            this.fMaxBit += this.fWordLength - (this.fMaxBit - this.fMinBit + 1);
        }
        if (-this.fFractionLength <= this.fMinBit) {
            this.fMinBit = -this.fFractionLength - 1;
        }
        this.fMaxBit = Math.max(12, this.fMaxBit);
        this.fMinBit = Math.min(-4, this.fMinBit);
        Pair<Integer, Integer> pair = Histogram.sumAndMax(map.values());
        Pair<Integer, Integer> pair2 = Histogram.sumAndMax(map2.values());
        this.fTotalPositive = (Integer)pair.getFirst();
        this.fTotalNegative = (Integer)pair2.getFirst();
        this.fMaxCount = Math.max((Integer)pair2.getSecond(), (Integer)pair.getSecond());
        this.fPositiveCounts = Histogram.normalize(map, this.fMinBit, this.fMaxBit);
        this.fNegativeCounts = Histogram.normalize(map2, this.fMinBit, this.fMaxBit);
        this.fPositivePercents = this.derivePercents(this.fPositiveCounts, this.fNegativeCounts, false);
        this.fTotalPercents = this.derivePercents(this.fPositiveCounts, this.fNegativeCounts, true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fCoverageLabel = new MJEditorPane();
        this.fCoverageLabel.setContentType("text/html");
        this.fCoverageLabel.setBorder(null);
        this.fCoverageLabel.setOpaque(false);
        this.fCoverageLabel.setEditable(false);
        this.fCoverageLabel.setMaximumSize(new Dimension(100, Integer.MAX_VALUE));
        this.fCoverageLabel.setFont(this.fCoverageLabel.getFont().deriveFont((float)this.fCoverageLabel.getFont().getSize() - 1.0f));
        this.fRangeLabel = new MJLabel();
        this.fRangeLabel.setFont(this.fRangeLabel.getFont().deriveFont((float)this.fRangeLabel.getFont().getSize() - 1.0f));
        this.fGraph = new Graph();
        this.fSignedCheck = new MJCheckBox(CoderResources.getString("f2f.check.signed"), this.fSigned);
        if (PlatformInfo.isMacintosh()) {
            this.fSignedCheck.putClientProperty((Object)"JComponent.sizeVariant", (Object)"small");
        } else {
            this.fSignedCheck.setFont(this.fSignedCheck.getFont().deriveFont((float)this.fSignedCheck.getFont().getSize() - 1.0f));
        }
        this.fSignedCheck.setOpaque(false);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(16, 10, 3, 10);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.fComponent.add((Component)((Object)this.fGraph), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 10, 3, 12);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout(0, 0, 0));
        mJPanel.setOpaque(false);
        mJPanel2.setOpaque(false);
        mJPanel.add((Component)this.fCoverageLabel, (Object)"Center");
        mJPanel.add((Component)this.fSignedCheck, (Object)"East");
        mJPanel2.add((Component)this.fRangeLabel, (Object)"East");
        this.fComponent.add((Component)mJPanel, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 10, 0, 12);
        gridBagConstraints.weighty = 0.0;
        this.fComponent.add((Component)mJPanel2, (Object)gridBagConstraints);
        this.fResetAction = new MJAbstractAction(CoderResources.getString("f2f.histogram.reset"), CoderResources.getIcon("undo_ts_16.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                Histogram.this.reset();
            }
        };
        final MJAbstractAction mJAbstractAction = new MJAbstractAction(BuiltInResources.getString((String)"button.help"), HelpAction.ICON){

            public void actionPerformed(ActionEvent actionEvent) {
                Histogram.this.fShowHelp.run();
            }
        };
        this.fResetAction.setTip(this.fResetAction.getName());
        this.fResetAction.setName(null);
        this.fResetAction.setEnabled(false);
        mJAbstractAction.setTip(mJAbstractAction.getName());
        mJAbstractAction.setName(null);
        MJPanel mJPanel3 = new MJPanel();
        mJPanel3.setOpaque(false);
        if (!PlatformInfo.isMacintosh()) {
            mJPanel3.setLayout((LayoutManager)new BorderLayout(0, 0));
            MJToolBar mJToolBar = new MJToolBar();
            mJToolBar.setOpaque(false);
            mJToolBar.setFloatable(false);
            MJButton mJButton = new MJButton((Action)this.fResetAction);
            MJButton mJButton2 = new MJButton((Action)mJAbstractAction);
            mJButton.setOpaque(false);
            mJButton2.setOpaque(false);
            mJToolBar.add((Component)mJButton);
            mJToolBar.add((Component)mJButton2);
            mJPanel3.add((Component)mJToolBar, (Object)"East");
        } else {
            mJPanel3.setLayout((LayoutManager)new FlowLayout(2));
            MJHelpButton mJHelpButton = new MJHelpButton();
            mJHelpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    mJAbstractAction.actionPerformed(actionEvent);
                }
            });
            mJPanel3.add((Component)new MJButton((Action)this.fResetAction));
            mJPanel3.add((Component)mJHelpButton);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.insets.right = 3;
        this.fComponent.add((Component)mJPanel3, (Object)gridBagConstraints);
        this.fSignedCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!Histogram.this.fSuppressItemListener) {
                    Histogram.this.fSigned = Histogram.this.fSignedCheck.isSelected();
                    Histogram.this.fGraph.updateMetrics();
                    Histogram.this.fGraph.revalidate();
                    Histogram.this.fGraph.repaint();
                    Histogram.this.updateLabelsAndResetAction();
                    Histogram.this.fireChange();
                }
            }
        });
        this.updateLabelsAndResetAction();
    }

    public void reset() {
        this.fWordLength = this.fDefaultWordLength;
        this.fFractionLength = this.fDefaultFractionLength;
        this.fSigned = this.fDefaultSigned;
        this.fSuppressItemListener = true;
        this.fSignedCheck.setSelected(this.fSigned);
        this.fSuppressItemListener = false;
        this.fGraph.updateMetrics();
        this.fComponent.revalidate();
        this.fComponent.repaint();
        this.updateLabelsAndResetAction();
        this.fireChange();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public boolean isSigned() {
        return this.fSigned;
    }

    public int getWordLength() {
        return this.fWordLength;
    }

    public int getFractionLength() {
        return this.fFractionLength;
    }

    public void update(boolean bl, int n, int n2) {
        this.fSigned = bl;
        this.fWordLength = n;
        this.fFractionLength = n2;
        this.fSuppressItemListener = true;
        this.fSignedCheck.setSelected(bl);
        this.fSuppressItemListener = false;
        this.updateLabelsAndResetAction();
        this.fGraph.updateMetrics();
        this.fGraph.revalidate();
        this.fGraph.repaint();
    }

    private void fireChange() {
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    private void fireChange(int n, int n2) {
        if (n != this.fWordLength || n2 != this.fFractionLength) {
            this.fChangeListeners.stateChanged(new ChangeEvent(this));
        }
    }

    private Map<Integer, Double> derivePercents(Map<Integer, Integer> map, Map<Integer, Integer> map2, boolean bl) {
        int n = this.fTotalNegative + this.fTotalPositive;
        TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            if (n == 0) {
                treeMap.put(entry.getKey(), 0.0);
                continue;
            }
            double d = entry.getValue().intValue();
            if (bl) {
                d += (double)map2.get(entry.getKey()).intValue();
            }
            treeMap.put(entry.getKey(), d / (double)n);
        }
        return treeMap;
    }

    private static Pair<Integer, Integer> sumAndMax(Collection<Integer> collection) {
        int n = 0;
        int n2 = 0;
        for (Integer n3 : collection) {
            n += n3.intValue();
            n2 = Math.max(n2, n3);
        }
        return new Pair((Object)n, (Object)n2);
    }

    private static Map<Integer, Integer> normalize(Map<Integer, Integer> map, int n, int n2) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (int i = n; i <= n2; ++i) {
            Integer n3 = map.get(i);
            treeMap.put(i, n3 == null ? 0 : n3);
        }
        return treeMap;
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public int getCoverage() {
        int n;
        if (this.fNoData) {
            return 100;
        }
        double d = 0.0;
        for (int i = n = Math.min(this.fMaxBit, this.fWordLength - this.fFractionLength - 1); i >= Math.max(-this.fFractionLength, this.fMinBit); --i) {
            if (this.fSigned) {
                d += this.fTotalPercents.get(i).doubleValue();
                continue;
            }
            if (i >= this.fMaxBit) continue;
            d += this.fPositivePercents.get(i + 1).doubleValue();
        }
        return (int)(d * 100.0);
    }

    private static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    private static String format(double d) {
        String string = new DecimalFormat("##############################0.####").format(d);
        if (string.length() > 7) {
            return new DecimalFormat("0.0#E0").format(d);
        }
        return string;
    }

    private void updateLabelsAndResetAction() {
        Range range = new NumericType(this.fSigned, this.fWordLength, this.fFractionLength, false).getSupportedRange();
        this.fCoverageLabel.setText(MessageFormat.format(CoderResources.getString("f2f.coverage"), this.getCoverage()));
        this.fRangeLabel.setText(MessageFormat.format(CoderResources.getString("f2f.supportedRange"), Histogram.format(range.getMin()), Histogram.format(range.getMax())));
        this.fResetAction.setEnabled(this.fSigned != this.fDefaultSigned || this.fWordLength != this.fDefaultWordLength || this.fFractionLength != this.fDefaultFractionLength);
    }

    private class Graph
    extends MJPanel {
        private Map<Integer, Rectangle2D> fFullBitRects;
        private Shape fSelection;
        private Shape fShadow1;
        private Shape fShadow2;
        private DragMode fDragMode = DragMode.NONE;
        private double fDragStartX;
        private double fDragAnchor;
        private int fAnchorBit;
        private Timer fHoverTimer;
        private double fLeft;
        private double fDecimalPointSpace;
        private double fGraphWidth;
        private double fBoxWidth;
        private double fY;
        private double fEffectiveHeight;
        private double fPositiveHeight;

        Graph() {
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    Graph.this.requestFocus();
                    if (Graph.this.isOverSelection(mouseEvent.getPoint())) {
                        Graph.this.fDragMode = DragMode.MOVE;
                    } else if (Graph.this.isOverLeftMargin(mouseEvent.getPoint())) {
                        Graph.this.fDragMode = DragMode.RESIZE_LEFT;
                    } else if (Graph.this.isOverRightMargin(mouseEvent.getPoint())) {
                        Graph.this.fDragMode = DragMode.RESIZE_RIGHT;
                        Graph.this.fAnchorBit = -Histogram.this.fFractionLength;
                    } else {
                        Graph.this.fDragMode = DragMode.NONE;
                    }
                    Graph.this.fDragStartX = mouseEvent.getX();
                    Graph.this.fDragAnchor = (double)mouseEvent.getX() - Graph.this.fSelection.getBounds().getX();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    Graph.this.updateCursor();
                    Graph.this.fDragMode = DragMode.NONE;
                    Graph.this.updateMetrics();
                    Graph.this.revalidate();
                    Graph.this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Graph.this.updateCursor();
                    if (mouseEvent.getClickCount() == 2) {
                        Histogram.this.reset();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    Graph.this.updateMetrics();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    Graph.this.updateCursor();
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    int n = Histogram.this.fWordLength;
                    int n2 = Histogram.this.fFractionLength;
                    if (Graph.this.fDragMode == DragMode.RESIZE_RIGHT) {
                        int n3 = Graph.this.getBitFromRight(mouseEvent.getPoint(), true);
                        if (n3 != Integer.MIN_VALUE) {
                            int n4 = Histogram.this.fFractionLength + n3;
                            Histogram.this.fFractionLength = -n3;
                            Histogram.this.fWordLength -= n4;
                            Histogram.this.fireChange(n, n2);
                        }
                        Graph.this.updateMetrics();
                        Histogram.this.updateLabelsAndResetAction();
                        Graph.this.revalidate();
                        Graph.this.repaint();
                    } else if (Graph.this.fDragMode == DragMode.RESIZE_LEFT) {
                        double d = (double)mouseEvent.getX() - Graph.this.fSelection.getBounds().getX();
                        if (Graph.this.fSelection.getBounds().getWidth() - d >= 5.0) {
                            int n5 = Graph.this.getBitFromLeft(mouseEvent.getPoint(), true);
                            if (n5 != Integer.MIN_VALUE) {
                                Histogram.this.fWordLength = n5 + Histogram.this.fFractionLength + 1;
                                Histogram.this.fireChange(n, n2);
                            }
                            Graph.this.updateMetrics();
                            Histogram.this.updateLabelsAndResetAction();
                            Graph.this.revalidate();
                            Graph.this.repaint();
                        }
                    } else if (Graph.this.fDragMode == DragMode.MOVE) {
                        Rectangle2D.Double double_ = new Rectangle2D.Double((double)mouseEvent.getX() - Graph.this.fDragAnchor, Graph.this.fSelection.getBounds().getY(), Graph.this.fSelection.getBounds().getWidth(), Graph.this.fSelection.getBounds().getHeight());
                        Point point = new Point((int)((RectangularShape)double_).getX(), Graph.this.getHeight() / 2);
                        if (((RectangularShape)double_).getX() < ((Rectangle2D)Graph.this.fFullBitRects.get(Histogram.this.fMaxBit)).getX()) {
                            int n6 = Graph.this.getBitFromRight(point, false);
                            if (n6 != Integer.MIN_VALUE) {
                                Histogram.this.fFractionLength = -n6;
                                Histogram.this.fireChange(n, n2);
                            }
                        } else {
                            int n7 = Graph.this.getBitFromLeft(point, false);
                            if (n7 != Integer.MIN_VALUE) {
                                Histogram.this.fFractionLength = Histogram.this.fWordLength - n7 - 1;
                                Histogram.this.fireChange(n, n2);
                            }
                        }
                        Histogram.this.updateLabelsAndResetAction();
                        Graph.this.updateMetrics();
                        Graph.this.revalidate();
                        Graph.this.repaint();
                    }
                }
            });
        }

        private void updateCursor() {
            Point point;
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo != null && (point = pointerInfo.getLocation()) != null) {
                SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
                if (this.isOverSelection(point)) {
                    this.setCursor(Cursor.getPredefinedCursor(PlatformInfo.isMacintosh() ? 12 : 13));
                    this.startHoverTimer();
                } else if (this.isOverLeftMargin(point)) {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                    this.startHoverTimer();
                } else if (this.isOverRightMargin(point)) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    this.startHoverTimer();
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    this.stopHoverTimer();
                }
                return;
            }
            this.stopHoverTimer();
        }

        private void startHoverTimer() {
            if (this.fHoverTimer != null) {
                this.fHoverTimer = new Timer(5, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Graph.this.updateCursor();
                    }
                });
                this.fHoverTimer.setRepeats(true);
                this.fHoverTimer.start();
            }
        }

        private void stopHoverTimer() {
            if (this.fHoverTimer != null) {
                this.fHoverTimer.stop();
                this.fHoverTimer = null;
            }
        }

        private boolean isOverSelection(Point point) {
            return this.getXDistanceFromLeft(point, this.fSelection) > 2 && this.getXDistanceFromRight(point, this.fSelection) < -2;
        }

        private boolean isOverLeftMargin(Point point) {
            return this.checkRangeInclusive(-2, 1, this.getXDistanceFromLeft(point, this.fSelection));
        }

        private boolean isOverRightMargin(Point point) {
            return this.checkRangeInclusive(-1, 2, this.getXDistanceFromRight(point, this.fSelection));
        }

        private int getXDistanceFromLeft(Point point, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            int n = (int)((RectangularShape)rectangle).getX();
            while (!shape.contains(new Point(n, (int)point.getY()))) {
                if ((double)n > ((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getHeight()) {
                    return Integer.MIN_VALUE;
                }
                ++n;
            }
            return (int)point.getX() - n;
        }

        private int getXDistanceFromRight(Point point, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            int n = (int)(((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() - 1.0);
            while (!shape.contains(new Point(n, (int)point.getY()))) {
                if ((double)n < ((RectangularShape)rectangle).getX()) {
                    return Integer.MAX_VALUE;
                }
                --n;
            }
            return (int)point.getX() - n;
        }

        private boolean checkRangeInclusive(int n, int n2, int n3) {
            return n3 >= n && n3 <= n2;
        }

        private int getBitFromRight(Point point, boolean bl) {
            for (int i = Histogram.this.fMinBit; i <= Histogram.this.fMaxBit; ++i) {
                Rectangle2D rectangle2D = this.fFullBitRects.get(i);
                Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() * 1.3, rectangle2D.getHeight());
                if (!rectangle2D.contains(point) && (!bl || !double_.contains(point))) continue;
                return i;
            }
            return Integer.MIN_VALUE;
        }

        private int getBitFromLeft(Point point, boolean bl) {
            for (int i = Histogram.this.fMaxBit; i >= Histogram.this.fMinBit; --i) {
                Rectangle2D rectangle2D = this.fFullBitRects.get(i);
                Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() - rectangle2D.getWidth() * 0.3, rectangle2D.getY(), rectangle2D.getWidth() * 1.3, rectangle2D.getHeight());
                if (!rectangle2D.contains(point) && (!bl || !double_.contains(point))) continue;
                return i;
            }
            return Integer.MIN_VALUE;
        }

        private double getLeftBitX(int n) {
            double d = n > Histogram.this.fMaxBit || n < Histogram.this.fMinBit ? this.fLeft - this.fBoxWidth * (double)(n - Histogram.this.fMaxBit) : (double)((int)this.fFullBitRects.get(n).getX());
            return n == -1 ? d + 2.0 : d;
        }

        private void updateMetrics() {
            Rectangle2D rectangle2D;
            double d;
            int n;
            this.fFullBitRects = new TreeMap<Integer, Rectangle2D>();
            this.fLeft = Histogram.this.fAnyNegative ? 8.0 : 2.0;
            this.fDecimalPointSpace = 6.0;
            this.fGraphWidth = (double)this.getWidth() - this.fLeft;
            this.fBoxWidth = (this.fGraphWidth - this.fDecimalPointSpace) / (double)(Histogram.this.fMaxBit - Histogram.this.fMinBit + 1);
            double d2 = 0.0;
            this.fY = 6.0;
            this.fEffectiveHeight = this.getHeight() - 12;
            this.fPositiveHeight = Histogram.this.fAnyNegative ? this.fEffectiveHeight / 2.0 : this.fEffectiveHeight;
            for (n = Histogram.this.fMaxBit; n >= Histogram.this.fMinBit; --n) {
                this.fFullBitRects.put(n, new Rectangle2D.Double(this.fLeft + d2 - (n == -1 ? this.fDecimalPointSpace / 2.0 : 0.0), this.fY, this.fBoxWidth + (n == 0 || n == -1 ? this.fDecimalPointSpace / 2.0 : 0.0), this.fEffectiveHeight));
                d2 += this.fBoxWidth;
                if (n != 0) continue;
                d2 += this.fDecimalPointSpace;
            }
            n = Histogram.this.fWordLength - Histogram.this.fFractionLength - 1;
            int n2 = n - Histogram.this.fWordLength + 1;
            double d3 = this.getLeftBitX(n);
            if (n2 < Histogram.this.fMinBit || n2 > Histogram.this.fMaxBit) {
                d = this.fBoxWidth * (double)Histogram.this.fWordLength;
                if (n >= 0 && n2 < 0) {
                    d += 10.0;
                }
            } else {
                rectangle2D = this.fFullBitRects.get(n2);
                d = rectangle2D.getX() - d3 + rectangle2D.getWidth();
            }
            if (n2 == 0 || n == -1) {
                d -= 2.0;
            }
            this.fSelection = new RoundRectangle2D.Double(d3, this.fY, d, Histogram.this.fSigned ? this.fEffectiveHeight : this.fPositiveHeight, 10.0, 10.0);
            rectangle2D = this.fSelection.getBounds();
            this.fShadow1 = new RoundRectangle2D.Double(rectangle2D.getX() + 1.0, rectangle2D.getY() + 1.0, rectangle2D.getWidth() - 2.0, rectangle2D.getHeight() - 2.0, 10.0, 10.0);
            this.fShadow2 = new RoundRectangle2D.Double(rectangle2D.getX() + 2.0, rectangle2D.getY() + 2.0, rectangle2D.getWidth() - 4.0, rectangle2D.getHeight() - 4.0, 10.0, 10.0);
        }

        public void paintComponent(Graphics graphics) {
            int n;
            if (this.fSelection == null) {
                this.updateMetrics();
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(new Color(0, 0, 0, 0));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(this.fSelection);
            for (Map.Entry<Integer, Rectangle2D> entry : this.fFullBitRects.entrySet()) {
                n = entry.getKey();
                if (n == -1) continue;
                Rectangle2D rectangle2D = entry.getValue();
                graphics2D.setColor(Color.LIGHT_GRAY);
                graphics2D.draw(new Line2D.Double(rectangle2D.getX(), this.fY + this.fPositiveHeight + 2.0, rectangle2D.getX(), this.fY + this.fPositiveHeight - 1.5));
            }
            if (Histogram.this.fAnyNegative) {
                graphics2D.setColor(Color.LIGHT_GRAY);
                graphics2D.draw(new Line2D.Double(0.0, this.fY + this.fPositiveHeight, this.getWidth(), this.fY + this.fPositiveHeight));
            }
            double d = 0.0;
            for (n = Histogram.this.fMaxBit; n >= Histogram.this.fMinBit; --n) {
                int n2 = Histogram.this.fSigned ? n : n + 1;
                Double d2 = 0.0;
                if (n2 <= Histogram.this.fMaxBit) {
                    d2 = (double)((Integer)Histogram.this.fPositiveCounts.get(n2)).intValue() / (double)Histogram.this.fMaxCount;
                }
                Double d3 = (double)((Integer)Histogram.this.fNegativeCounts.get(n)).intValue() / (double)Histogram.this.fMaxCount;
                Rectangle2D.Double double_ = new Rectangle2D.Double(this.fLeft + d, this.fY + this.fPositiveHeight - d2 * (this.fPositiveHeight - 2.0), this.fBoxWidth, d2 * (this.fPositiveHeight - 2.0));
                graphics2D.setColor(BAR_COLOR);
                graphics2D.fill(double_);
                graphics2D.setColor(Color.LIGHT_GRAY);
                graphics2D.draw(double_);
                if (Histogram.this.fAnyNegative) {
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(this.fLeft + d, this.fY + this.fPositiveHeight, this.fBoxWidth, d3 * (this.fPositiveHeight - 2.0));
                    graphics2D.setColor(NEGATIVE_BAR_COLOR);
                    graphics2D.fill(double_2);
                    graphics2D.setColor(Color.LIGHT_GRAY);
                    graphics2D.draw(double_2);
                }
                d += this.fBoxWidth;
                if (n != 0) continue;
                graphics2D.setColor(Color.BLACK);
                graphics2D.fill(new RoundRectangle2D.Double(d + this.fLeft + 1.0, this.fPositiveHeight + 2.0, 4.0, 4.0, 4.0, 4.0));
                d += this.fDecimalPointSpace;
            }
            Area area = new Area(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight() - 14));
            area.subtract(new Area(this.fSelection));
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(Histogram.this.fBackground.getRed(), Histogram.this.fBackground.getGreen(), Histogram.this.fBackground.getBlue(), 170), 0.0f, this.getHeight(), new Color(Histogram.this.fBackground.getRed(), Histogram.this.fBackground.getGreen(), Histogram.this.fBackground.getBlue(), 0)));
            graphics2D.fill(area);
            graphics2D.setColor(new Color(0.6f, 0.6f, 0.6f, 1.0f));
            graphics2D.draw(this.fSelection);
            graphics2D.setColor(new Color(0.4f, 0.4f, 0.4f, 0.3f));
            graphics2D.draw(this.fShadow1);
            graphics2D.setColor(new Color(0.4f, 0.4f, 0.4f, 0.1f));
            graphics2D.draw(this.fShadow2);
            if (Histogram.this.fAnyNegative) {
                graphics2D.setColor(new Color(110, 110, 110));
                graphics2D.drawString("+", 1.0f, (float)this.fPositiveHeight);
                graphics2D.drawString("\u2013", 2.0f, (float)(this.fPositiveHeight + (double)graphics2D.getFontMetrics().getAscent() + 3.0));
            }
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.draw(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, 10.0, 10.0));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    private static enum DragMode {
        NONE,
        MOVE,
        RESIZE_RIGHT,
        RESIZE_LEFT;

    }
}

