/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.graph;

import com.mathworks.toolbox.coder.graph.CircuitComponent;
import com.mathworks.toolbox.coder.graph.Network;
import com.mathworks.toolbox.coder.graph.Signal;
import java.util.HashMap;
import java.util.Map;

public class SignalMap {
    private final Map<String, CircuitComponent> fSources = new HashMap<String, CircuitComponent>();
    private final Map<String, CircuitComponent> fDestinations = new HashMap<String, CircuitComponent>();

    public SignalMap(Network network) {
        for (CircuitComponent circuitComponent : network.getComponents()) {
            for (String string : circuitComponent.getInputs()) {
                this.fDestinations.put(string, circuitComponent);
            }
            for (String string : circuitComponent.getOutputs()) {
                this.fSources.put(string, circuitComponent);
            }
        }
    }

    public CircuitComponent getSource(Signal signal) {
        return this.fSources.get(signal.getId());
    }

    public CircuitComponent getDestination(Signal signal) {
        return this.fDestinations.get(signal.getId());
    }
}

