/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.services.Prefs;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.toolbox.coder.app.CoderRegistry;
import com.mathworks.toolbox.coder.util.CoderLogger;
import com.mathworks.toolbox.coder.util.LRUMap;
import com.mathworks.util.FileSystemListener;
import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.LanguageUtils;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoderFileSupport {
    private static final String M_EXTENSION = ".m";
    private static final String MLX_EXTENSION = ".mlx";
    private static final String KEY_MLX_ENABLED = "CoderMlxEnabled";
    private static final Charset OFFSET_CONVERSION_CHARSET = LanguageUtils.isEnglish() ? Charset.forName("UTF-8") : Charset.defaultCharset();
    private static final CoderLogger LOGGER = new CoderLogger(CoderFileSupport.class);
    private static final FileCache FILE_CACHE = new FileCache(5, 300000);

    private CoderFileSupport() {
    }

    public static boolean isCoderMlxEnabled() {
        return Prefs.exists((String)KEY_MLX_ENABLED) && Prefs.getBooleanPref((String)KEY_MLX_ENABLED);
    }

    public static void setCoderMlxEnabled(boolean bl) {
        if (bl) {
            Prefs.setBooleanPref((String)KEY_MLX_ENABLED, (boolean)bl);
        } else {
            Prefs.remove((String)KEY_MLX_ENABLED);
        }
    }

    public static void setFileCachingEnabled(boolean bl) {
        FILE_CACHE.setCachingEnabled(bl);
    }

    public static boolean isMatlabSourceFile(FileLocation fileLocation) {
        return CoderFileSupport.isMatlabSourceFile(fileLocation.toFile());
    }

    public static boolean isMatlabSourceFile(File file) {
        return CoderFileSupport.isMatlabSourceFile(file.getAbsolutePath());
    }

    public static boolean isMatlabSourceFile(String string) {
        return MLFileUtils.isMFile((String)string) || MlxFileUtils.isMlxFile((String)string) && CoderFileSupport.isCoderMlxEnabled();
    }

    @Nullable
    public static File toExistingSourceFile(File file, String string) {
        File file2 = new File(file, string + M_EXTENSION);
        if (file2.exists()) {
            return file2;
        }
        if (CoderFileSupport.isCoderMlxEnabled()) {
            file2 = new File(file, string + MLX_EXTENSION);
            return file2.exists() ? file2 : null;
        }
        return null;
    }

    @Nullable
    public static String readMatlabSource(FileLocation fileLocation) throws IOException {
        return CoderFileSupport.readMatlabSource(fileLocation.toString());
    }

    @Nullable
    private static String readMatlabSource(String string) throws IOException {
        return CoderFileSupport.readMatlabSource(new File(string));
    }

    @Nullable
    public static String readMatlabSource(File file) throws IOException {
        return FILE_CACHE.getFileText(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMatlabSource(@NotNull String string, @NotNull File file) throws IOException {
        if (MLFileUtils.isMFile((String)file.getAbsolutePath())) {
            String string2 = CoderFileSupport.determineSuitableEncoding(string, file);
            PrintWriter printWriter = new PrintWriter(file, string2);
            try {
                LOGGER.info("Writing M-file: file=[%s] encoding=[%s]", file.getAbsolutePath(), string2);
                printWriter.write(string);
            }
            finally {
                printWriter.flush();
                printWriter.close();
            }
        } else if (MlxFileUtils.isMlxFile((String)file.getAbsolutePath())) {
            LOGGER.info("Writing file as .mlx file: %s", file.getAbsolutePath());
            MlxFileUtils.writeCode((File)file, (String)string);
        } else {
            throw new IllegalArgumentException("Unsupported MATLAB source extension: " + new FileLocation(file).getExtension());
        }
        FILE_CACHE.setFileText(file, string);
    }

    private static String determineSuitableEncoding(String string, File file) {
        Charset charset = SyntaxTextPaneUtilities.getDefaultFileEncoding((File)file);
        return (charset.newEncoder().canEncode(string) ? charset : OFFSET_CONVERSION_CHARSET).displayName();
    }

    @Nullable
    public static String loadMatlabSource(File file) throws IOException {
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(MLX_EXTENSION)) {
            if (MlxFileUtils.isMlxFile((String)file.getAbsolutePath())) {
                LOGGER.info("Reading file as .mlx file: %s", file.getAbsolutePath());
                return MlxFileUtils.getCode((File)file);
            }
            LOGGER.info("MLX support not enabled in MATLAB. Skipping read: %s", file);
            throw new IllegalArgumentException("MLX unsupported: " + file.getPath());
        }
        LOGGER.info("Reading file as text file: %s", file.getAbsolutePath());
        String string = com.mathworks.mlwidgets.explorer.util.FileSystemUtils.readText((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (String)SyntaxTextPaneUtilities.getDefaultFileEncoding((File)file).displayName());
        return CoderFileSupport.stripCRLF(string);
    }

    @NotNull
    public static OffsetConverter getOffsetConverter(File file) throws IOException {
        return FILE_CACHE.getOffsetConverter(file);
    }

    private static String stripCRLF(String string) {
        return string.replaceAll("\r\n", "\n");
    }

    @Nullable
    private static int[] byteToCharOffests(@NotNull String string) throws CharacterCodingException {
        int[] nArray;
        CharsetEncoder charsetEncoder = OFFSET_CONVERSION_CHARSET.newEncoder();
        ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
        if (byteBuffer.limit() == string.length()) {
            nArray = null;
        } else {
            nArray = new int[byteBuffer.limit()];
            charsetEncoder.reset();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) > '\u007f') {
                    String string2 = string.substring(i, i + 1);
                    ByteBuffer byteBuffer2 = charsetEncoder.encode(CharBuffer.wrap(string2));
                    for (int j = 0; j < byteBuffer2.limit(); ++j) {
                        nArray[n++] = i;
                    }
                    continue;
                }
                nArray[n++] = i;
            }
        }
        return nArray;
    }

    static {
        CoderRegistry.getInstance().addChangeObserver(new Runnable(){

            @Override
            public void run() {
                CoderFileSupport.setFileCachingEnabled(CoderRegistry.getInstance().getActiveCount() > 0);
            }
        });
    }

    public static abstract class OffsetConverter {
        public int byteToCharPosition(int n) {
            return this.byteToCharOffset(n - 1);
        }

        public int byteToCharOffsetLength(int n, int n2) {
            int n3 = this.byteToCharOffset(n);
            int n4 = this.byteToCharOffset(n + n2);
            return Math.max(n4 - n3, 0);
        }

        public int byteToCharPositionLength(int n, int n2) {
            return this.byteToCharOffsetLength(n - 1, n2);
        }

        public abstract int byteToCharOffset(int var1);
    }

    private static class TextContext {
        private final String fText;
        private OffsetConverter fOffsetConverter;

        TextContext(@NotNull String string) {
            this.fText = string;
        }

        String getText() {
            return this.fText;
        }

        OffsetConverter getOffsetConverter() {
            if (this.fOffsetConverter == null) {
                try {
                    final int[] nArray = CoderFileSupport.byteToCharOffests(this.getText());
                    this.fOffsetConverter = nArray != null ? new OffsetConverter(){

                        @Override
                        public int byteToCharOffset(int n) {
                            return n >= 0 && n < nArray.length ? nArray[n] : n;
                        }
                    } : new OffsetConverter(){

                        @Override
                        public int byteToCharOffset(int n) {
                            return n;
                        }
                    };
                }
                catch (CharacterCodingException characterCodingException) {
                    this.fOffsetConverter = new OffsetConverter(){

                        @Override
                        public int byteToCharOffset(int n) {
                            return -1;
                        }
                    };
                }
            }
            return this.fOffsetConverter;
        }
    }

    private static class FileCache {
        private final Map<File, TextContext> fCacheMap;
        private final Map<File, Long> fTimestamps;
        private final FileSystemListener fFileSystemListener;
        private final Object fMutex;
        private final int fCapacity;
        private final int fCharFloor;
        private boolean fEnabled;
        private int fCharTotal;

        FileCache(int n, int n2) {
            this.fCapacity = n;
            this.fCharFloor = n2;
            this.fMutex = new Object();
            this.fCacheMap = new CharCountingMap();
            this.fTimestamps = new HashMap<File, Long>();
            this.fFileSystemListener = this.createFileSystemListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCachingEnabled(boolean bl) {
            Object object = this.fMutex;
            synchronized (object) {
                if (bl && !this.fEnabled) {
                    LOGGER.info("Enabling cache, registering FileSystemListener", new Object[0]);
                    FileSystemUtils.getFileSystemNotifier().addFileSystemListener(this.fFileSystemListener);
                } else if (!bl && this.fEnabled) {
                    LOGGER.info("Disabling cache, deregistering FileSystemListener", new Object[0]);
                    FileSystemUtils.getFileSystemNotifier().removeFileSystemListener(this.fFileSystemListener);
                } else {
                    return;
                }
                this.fCacheMap.clear();
                this.fTimestamps.clear();
                this.fCharTotal = 0;
                this.fEnabled = bl;
            }
        }

        @Nullable
        String getFileText(File file) throws IOException {
            TextContext textContext = this.getTextContext(file);
            return textContext != null ? textContext.getText() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFileText(File file, String string) {
            Object object = this.fMutex;
            synchronized (object) {
                if (this.fEnabled) {
                    this.fCacheMap.put(file, new TextContext(string));
                    this.fTimestamps.put(file, file.lastModified());
                }
            }
        }

        @NotNull
        OffsetConverter getOffsetConverter(File file) throws IOException {
            TextContext textContext = this.getTextContext(file);
            return textContext != null ? textContext.getOffsetConverter() : new OffsetConverter(){

                @Override
                public int byteToCharOffset(int n) {
                    return n;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TextContext getTextContext(File file) throws IOException {
            TextContext textContext = null;
            Object object = this.fMutex;
            synchronized (object) {
                if (this.fTimestamps.containsKey(file) && this.fTimestamps.get(file).longValue() == file.lastModified()) {
                    textContext = this.fCacheMap.get(file);
                }
                if (textContext == null) {
                    this.fTimestamps.remove(file);
                    this.fCacheMap.remove(file);
                } else {
                    LOGGER.debug("Text for '%s' served from cache.", file.getAbsolutePath());
                }
            }
            if (textContext == null && (object = CoderFileSupport.loadMatlabSource(file)) != null) {
                textContext = new TextContext((String)object);
            }
            object = this.fMutex;
            synchronized (object) {
                if (this.fEnabled) {
                    if (textContext != null && !this.fCacheMap.containsKey(file)) {
                        this.fTimestamps.put(file, file.lastModified());
                        this.fCacheMap.put(file, textContext);
                        LOGGER.info("File '%s' loaded with timestamp %d and cached.", file.getAbsolutePath(), file.lastModified());
                    } else {
                        textContext = this.fCacheMap.get(file);
                    }
                }
            }
            return textContext;
        }

        private FileSystemListener createFileSystemListener() {
            return new FileSystemListener(){

                public void fileCreated(File file) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileMoved(File file, File file2) {
                    if (FileCache.this.fCacheMap.containsKey(file)) {
                        TextContext textContext;
                        Object object = FileCache.this.fMutex;
                        synchronized (object) {
                            textContext = (TextContext)FileCache.this.fCacheMap.remove(file);
                            if (textContext != null) {
                                FileCache.this.fCacheMap.put(file2, textContext);
                            }
                        }
                        if (textContext != null) {
                            LOGGER.info("Cached file moved from '%s' to '%s', remapping cache entry.", file, file);
                        }
                    }
                }

                public void fileDeleted(File file) {
                    LOGGER.info("Cached file deleted, removing from cache: %s", file);
                    FileCache.this.removeMapping(file);
                }

                public void fileChanged(File file) {
                    LOGGER.info("Cached file changed, removing from cache: %s", file);
                    FileCache.this.removeMapping(file);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeMapping(File file) {
            Object object = this.fMutex;
            synchronized (object) {
                this.fCacheMap.remove(file);
                this.fTimestamps.remove(file);
            }
        }

        private class CharCountingMap
        extends LRUMap<File, TextContext> {
            CharCountingMap() {
                super(new LRUMap.LRUPredicate<File, TextContext>(){

                    @Override
                    public boolean evictEldestEntry(Map.Entry<File, TextContext> entry, Map<File, TextContext> map) {
                        boolean bl;
                        boolean bl2 = bl = map.size() > FileCache.this.fCapacity && FileCache.this.fCharTotal > FileCache.this.fCharFloor;
                        if (bl) {
                            LOGGER.info("Evicting oldest file '%s' from cache: fillRatio='%d/%d', charRatio ='%d/%d'", entry.getKey(), map.size(), FileCache.this.fCapacity, FileCache.this.fCharTotal, FileCache.this.fCharFloor);
                        }
                        return bl;
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onPendingAddition(File file, TextContext textContext) {
                Object object = FileCache.this.fMutex;
                synchronized (object) {
                    FileCache.this.fCharTotal += textContext.getText().length();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onPendingRemoval(File file, TextContext textContext) {
                Object object = FileCache.this.fMutex;
                synchronized (object) {
                    FileCache.this.fCharTotal -= textContext.getText().length();
                }
            }
        }
    }
}

