/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import org.jetbrains.annotations.NotNull;

public final class Interval
implements Comparable<Interval> {
    private final int fStart;
    private final int fEnd;
    private final int fLength;

    public Interval(int n, int n2) {
        this.fStart = n;
        this.fEnd = n2;
        this.fLength = n2 - n;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getLength() {
        return this.fLength;
    }

    public boolean contains(int n) {
        return n >= this.fStart && n < this.fEnd;
    }

    public boolean contains(Interval interval) {
        return this.fStart <= interval.getStart() && this.fEnd >= interval.getEnd();
    }

    @Override
    public int compareTo(@NotNull Interval interval) {
        if (this.equals(interval)) {
            return 0;
        }
        if (this.fStart < interval.getStart()) {
            return -1;
        }
        if (this.fStart == interval.getStart()) {
            return this.fEnd < interval.getEnd() ? -1 : 1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)object;
        return this.fEnd == interval.getEnd() && this.fStart == interval.getStart();
    }

    public int hashCode() {
        int n = this.fStart;
        n = 31 * n + this.fEnd;
        return n;
    }
}

