/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.BuildAction;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.OutputFileType;
import com.mathworks.toolbox.coder.plugin.TargetArtifact;
import com.mathworks.toolbox.coder.plugin.TargetType;
import com.mathworks.toolbox.coder.plugin.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TargetSelectionSection
implements ProjectComponent,
ChangeListener {
    static final String PARAM_TARGET_TAG = "param.target";
    static final String PARAM_GENCODEONLY_TAG = "param.grt.GenCodeOnly";
    private static final String PLUGINDIRDIR = "/toolbox/coder/plugins/coder/resources";
    private WritableConfiguration fConfig;
    private String fTargetParamValue;
    private String fArtifactParamValue;
    private MJComboBox fOutputFileComponent = null;
    private String fOutputFileParamValue;
    private String fOutputSpecifiedParamValue;
    private MJTextField fOutputSpecifiedField = new MJTextField();
    private JLabel fOutputSpecifiedLabel;
    private Map<TargetType, Icon> fTargetIcons = new EnumMap<TargetType, Icon>(TargetType.class);
    private MJRadioButton fLibButton;
    private MJRadioButton fExeButton;
    private JPanel fArtifactPanel;
    private MJCheckBox fGenCodeOnly;
    private boolean fGenCodeOnlyParamValue;

    public TargetSelectionSection(WritableConfiguration writableConfiguration) {
        this.fConfig = writableConfiguration;
        for (TargetType targetType : TargetType.values()) {
            this.fTargetIcons.put(targetType, TargetSelectionSection.loadIcon(targetType.getIconName()));
        }
        this.loadTarget();
    }

    private static Icon loadIcon(String string) {
        String string2 = Matlab.matlabRoot() + PLUGINDIRDIR;
        return new ImageIcon(new File(new File(string2), string).getAbsolutePath().replace(File.separatorChar, '/'));
    }

    private void loadTarget() {
        try {
            this.fTargetParamValue = this.fConfig.getParamAsString(PARAM_TARGET_TAG);
        }
        catch (Exception exception) {
            this.fTargetParamValue = TargetType.MEX_CODE.getKey();
        }
        try {
            this.fArtifactParamValue = this.fConfig.getParamAsString("param.artifact");
        }
        catch (Exception exception) {
            this.fArtifactParamValue = TargetArtifact.LIB.getParamValue();
        }
        if (TargetArtifact.lookupParamValue(this.fArtifactParamValue) == TargetArtifact.MEX) {
            this.fArtifactParamValue = TargetArtifact.LIB.getParamValue();
        }
        try {
            this.fGenCodeOnlyParamValue = this.fConfig.getParamAsBoolean(PARAM_GENCODEONLY_TAG);
        }
        catch (Exception exception) {
            this.fGenCodeOnlyParamValue = false;
        }
        this.loadOutputFile();
    }

    private void changeTarget() {
        this.fConfig.setParamAsString(PARAM_TARGET_TAG, this.fTargetParamValue);
        this.loadOutputFile();
        this.updateArtifactVisibility();
    }

    private void changeOutputFile() {
        String string = TargetType.isMexTarget(this.fTargetParamValue) ? "param.mex.files.output" : "param.grt.files.output";
        this.fConfig.setParamAsString(string, this.fOutputFileParamValue);
        this.updateArtifactVisibility();
    }

    private void changeOutputFileSpecified() {
        String string = TargetType.isMexTarget(this.fTargetParamValue) ? "param.mex.outputfile" : "param.grt.outputfile";
        this.fOutputSpecifiedParamValue = this.fOutputSpecifiedField.getText().trim();
        this.fConfig.setParamAsString(string, this.fOutputSpecifiedParamValue);
    }

    private void loadOutputFile() {
        String string;
        String string2;
        if (TargetType.isMexTarget(this.fTargetParamValue)) {
            string2 = "param.mex.files.output";
            string = "param.mex.outputfile";
        } else {
            string2 = "param.grt.files.output";
            string = "param.grt.outputfile";
        }
        this.fOutputFileParamValue = this.fConfig.getParamAsString(string2);
        this.fOutputSpecifiedParamValue = this.fConfig.getParamAsString(string);
        if (this.fOutputFileComponent != null) {
            this.fOutputFileComponent.setSelectedItem((Object)this.fConfig.getResourceString(this.fOutputFileParamValue));
        }
        if (this.fOutputSpecifiedField != null) {
            this.fOutputSpecifiedField.setText(this.fOutputSpecifiedParamValue);
        }
    }

    private void updateArtifactVisibility() {
        if (this.fArtifactPanel == null) {
            return;
        }
        if (TargetType.isMexTarget(this.fTargetParamValue)) {
            this.fLibButton.setVisible(false);
            this.fExeButton.setVisible(false);
            this.fGenCodeOnly.setVisible(false);
        } else {
            this.fLibButton.setVisible(true);
            this.fExeButton.setVisible(true);
            this.fGenCodeOnly.setVisible(true);
        }
        if (OutputFileType.isSpecified(this.fOutputFileParamValue)) {
            this.fOutputSpecifiedLabel.setVisible(true);
            this.fOutputSpecifiedField.setVisible(true);
        } else {
            this.fOutputSpecifiedLabel.setVisible(false);
            this.fOutputSpecifiedField.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fArtifactParamValue = this.fLibButton.isSelected() ? TargetArtifact.LIB.getParamValue() : TargetArtifact.EXE.getParamValue();
        this.fConfig.setParamAsString("param.artifact", this.fArtifactParamValue);
    }

    public Component getComponent() {
        TargetType targetType2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TargetType targetType2 : TargetType.values()) {
            arrayList.add(targetType2.getKeyAsText((ReadableConfiguration)this.fConfig));
        }
        final MJComboBox mJComboBox = new MJComboBox(arrayList);
        mJComboBox.setToolTipText(CoderResources.getString("target.desc.type"));
        mJComboBox.setSelectedIndex(arrayList.indexOf(this.fConfig.getResourceString(this.fTargetParamValue)));
        mJComboBox.setEditable(false);
        mJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = mJComboBox.getSelectedIndex();
                TargetSelectionSection.this.fTargetParamValue = TargetType.getKeyOf(n);
                TargetSelectionSection.this.changeTarget();
            }
        });
        mJComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                for (TargetType targetType : TargetType.values()) {
                    if (!targetType.getKeyAsText((ReadableConfiguration)TargetSelectionSection.this.fConfig).equals(object)) continue;
                    this.setIcon((Icon)TargetSelectionSection.this.fTargetIcons.get((Object)targetType));
                    break;
                }
                return component;
            }
        });
        String string = "p, 3dlu, p:grow, 3dlu";
        String string2 = "p, 4dlu, p, 4dlu, p";
        targetType2 = new FormLayout(string, string2);
        PanelBuilder panelBuilder = new PanelBuilder((FormLayout)targetType2);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(CoderResources.getString("target.label.type"), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)mJComboBox, cellConstraints.xy(3, 1));
        this.fArtifactPanel = this.getArtifactPanel();
        panelBuilder.add((Component)this.fArtifactPanel, cellConstraints.xyw(1, 3, 3));
        Component component = this.getBuildPanel();
        panelBuilder.add(component, cellConstraints.xyw(1, 5, 4));
        this.updateArtifactVisibility();
        return panelBuilder.getPanel();
    }

    private Component getBuildPanel() {
        MJButton mJButton = new MJButton((Action)new BuildAction(ProjectGUI.getInstance().getCurrentClient()));
        mJButton.setIcon(null);
        this.fGenCodeOnly = new MJCheckBox(CoderResources.getString("target.name.genCodeOnly"));
        this.fGenCodeOnly.setToolTipText(CoderResources.getString("target.name.genCodeOnly.desc"));
        this.fGenCodeOnly.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TargetSelectionSection.this.fGenCodeOnlyParamValue = TargetSelectionSection.this.fGenCodeOnly.isSelected();
                TargetSelectionSection.this.fConfig.setParamAsBoolean(TargetSelectionSection.PARAM_GENCODEONLY_TAG, TargetSelectionSection.this.fGenCodeOnlyParamValue);
            }
        });
        String string = "p:grow, 3dlu, p, 3dlu";
        String string2 = "p";
        FormLayout formLayout = new FormLayout(string, string2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fGenCodeOnly, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)mJButton, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private static MJRadioButton getArtifactButton(TargetArtifact targetArtifact) {
        MJRadioButton mJRadioButton = new MJRadioButton(targetArtifact.getKeyAsText());
        mJRadioButton.setToolTipText(targetArtifact.getToolTipText());
        return mJRadioButton;
    }

    private JPanel getArtifactPanel() {
        OutputFileType outputFileType2;
        this.fLibButton = TargetSelectionSection.getArtifactButton(TargetArtifact.LIB);
        this.fExeButton = TargetSelectionSection.getArtifactButton(TargetArtifact.EXE);
        boolean bl = TargetArtifact.lookupParamValue(this.fArtifactParamValue) == TargetArtifact.EXE;
        this.fLibButton.setSelected(!bl);
        this.fExeButton.setSelected(bl);
        this.fLibButton.addChangeListener((ChangeListener)this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fLibButton);
        buttonGroup.add((AbstractButton)this.fExeButton);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OutputFileType outputFileType2 : OutputFileType.values()) {
            arrayList.add(outputFileType2.getKeyAsText((ReadableConfiguration)this.fConfig));
        }
        this.fOutputFileComponent = new MJComboBox(arrayList);
        this.fOutputFileComponent.setToolTipText(this.fConfig.getResourceString("param.files.output.desc"));
        this.fOutputFileComponent.setSelectedIndex(arrayList.indexOf(this.fConfig.getResourceString(this.fOutputFileParamValue)));
        this.fOutputFileComponent.setEditable(false);
        this.fOutputFileComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TargetSelectionSection.this.fOutputFileComponent.getSelectedIndex();
                TargetSelectionSection.this.fOutputFileParamValue = OutputFileType.getKeyOf(n);
                TargetSelectionSection.this.changeOutputFile();
            }
        });
        this.fOutputSpecifiedField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TargetSelectionSection.this.changeOutputFileSpecified();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TargetSelectionSection.this.changeOutputFileSpecified();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TargetSelectionSection.this.changeOutputFileSpecified();
            }
        });
        String string = "p, 3dlu, p:grow";
        String string2 = "p, 4dlu, p, 6dlu, p, 3dlu, p";
        FormLayout formLayout = new FormLayout(string, string2);
        outputFileType2 = new PanelBuilder(formLayout);
        outputFileType2.setBorder(Utilities.getTitledBorder("target.artifact.title"));
        CellConstraints cellConstraints = new CellConstraints();
        outputFileType2.addLabel(CoderResources.getString("output.label"), cellConstraints.xy(1, 1));
        outputFileType2.add((Component)this.fOutputFileComponent, cellConstraints.xy(3, 1));
        this.fOutputSpecifiedLabel = outputFileType2.addLabel(CoderResources.getString("output.specified.label"), cellConstraints.xy(1, 3));
        outputFileType2.add((Component)this.fOutputSpecifiedField, cellConstraints.xy(3, 3));
        outputFileType2.add((Component)this.fLibButton, cellConstraints.xyw(1, 5, 3));
        outputFileType2.add((Component)this.fExeButton, cellConstraints.xyw(1, 7, 3));
        return outputFileType2.getPanel();
    }

    public void dispose() {
    }
}

