/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.DocumentCellRenderer;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ButtonFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public final class TestFileSelectorPanel {
    private final MJPanel fPanel = new MJPanel((LayoutManager)new FormLayout("fill:d:grow, " + (PlatformInfo.isMacintosh() ? "1dlu" : "3dlu") + ", fill:d, 3dlu", "center:d"));
    private final MJComboBox fComboBox;
    private final MJButton fAddButton;
    private final MJButton fRemoveButton;
    private final WritableConfiguration fConfig;
    private final FileSetInstance fFileSet;
    private final PropertyChangeListener fFileSetListener;
    private final Runnable fPack;
    private boolean fEnabled;

    public TestFileSelectorPanel(WritableConfiguration writableConfiguration, boolean bl) {
        this(writableConfiguration, bl, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public TestFileSelectorPanel(WritableConfiguration writableConfiguration, boolean bl, Runnable runnable) {
        this.fPack = runnable;
        this.fPanel.setOpaque(false);
        this.fEnabled = true;
        this.fComboBox = bl ? new MJComboBox(){

            public Dimension getPreferredSize() {
                return new Dimension(10, (int)super.getPreferredSize().getHeight());
            }

            public Dimension getMinimumSize() {
                return new Dimension(0, (int)super.getMinimumSize().getHeight());
            }
        } : new MJComboBox();
        this.fComboBox.setRenderer((ListCellRenderer)new DocumentCellRenderer());
        this.fConfig = writableConfiguration;
        this.fFileSet = Utilities.getTestFileSet((ReadableConfiguration)this.fConfig);
        this.fAddButton = Utilities.createSmallButton(MiscellaneousIcon.ADD_ENTRY.getIcon(), CoderResources.getString("verification.testfile.add"));
        TestFileSelectorPanel.configureBrowseButton((Component)this.fAddButton, this.fConfig, (JButton)this.fAddButton, new ParameterRunnable<File>(){

            public void run(File file) {
                TestFileSelectorPanel.this.refreshComboBox();
                TestFileSelectorPanel.this.fComboBox.setSelectedItem((Object)file);
                TestFileSelectorPanel.this.fPack.run();
            }
        });
        this.fRemoveButton = Utilities.createSmallButton(MiscellaneousIcon.REMOVE_ENTRY.getIcon(), CoderResources.getString("verification.testfile.remove"));
        this.fRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = (File)TestFileSelectorPanel.this.fComboBox.getSelectedItem();
                File file2 = TestFileSelectorPanel.this.fConfig.getParamAsFile("param.DefaultTestFile");
                if (file2 != null && file2.equals(file)) {
                    TestFileSelectorPanel.this.fConfig.setParamAsFile("param.DefaultTestFile", null);
                }
                if (file != null) {
                    TestFileSelectorPanel.this.fFileSet.remove(Arrays.asList(file));
                }
            }
        });
        JComponent jComponent = ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{this.fAddButton, this.fRemoveButton});
        CellConstraints cellConstraints = new CellConstraints();
        this.fPanel.add((Component)this.fComboBox, (Object)cellConstraints.xy(1, 1));
        this.fPanel.add((Component)jComponent, (Object)cellConstraints.xy(3, 1));
        this.fFileSetListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("files")) {
                    TestFileSelectorPanel.this.refreshComboBox();
                }
            }
        };
        this.fFileSet.addPropertyChangeListener(this.fFileSetListener);
        this.refreshComboBox();
    }

    public void dispose() {
        this.fFileSet.removePropertyChangeListener(this.fFileSetListener);
    }

    public void setToolTipText(String string) {
        this.fComboBox.setToolTipText(string);
    }

    public void setQeNamePrefix(String string) {
        this.fComboBox.setName(string + ".combo");
        this.fAddButton.setName(string + ".add");
        this.fRemoveButton.setName(string + ".remove");
    }

    public File getSelectedFile() {
        if (this.fComboBox.getItemCount() == 1 && this.fComboBox.getSelectedItem() instanceof String) {
            return null;
        }
        return (File)this.fComboBox.getSelectedItem();
    }

    public void setSelectedFile(File file) {
        this.fComboBox.setSelectedItem((Object)file);
    }

    public void setEnabled(boolean bl) {
        this.fEnabled = bl;
        this.fComboBox.setEnabled(bl);
        this.fAddButton.setEnabled(bl);
        this.fRemoveButton.setEnabled(bl);
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    public void addItemListener(ItemListener itemListener) {
        this.fComboBox.addItemListener(itemListener);
    }

    private void refreshComboBox() {
        this.fComboBox.removeAllItems();
        for (File file : this.fFileSet.getFiles()) {
            this.fComboBox.addItem((Object)file);
        }
        if (this.fComboBox.getItemCount() == 0) {
            this.fComboBox.addItem((Object)CoderResources.getString("combo.prompt.noTestFiles"));
            this.fComboBox.setEnabled(false);
        } else {
            this.fComboBox.setEnabled(this.fEnabled);
        }
        boolean bl = this.getSelectedFile() != null;
        this.fPanel.revalidate();
        this.fPanel.repaint();
        this.fComboBox.setEnabled(bl);
        this.fRemoveButton.setEnabled(bl);
    }

    public static void browseForTestFile(Component component, Configuration configuration, ParameterRunnable<File> parameterRunnable) {
        TestFileSelectorPanel.browseForTestFile(component, configuration, parameterRunnable, null);
    }

    public static void browseForTestFile(Component component, Configuration configuration, ParameterRunnable<File> parameterRunnable, Runnable runnable) {
        FileSetInstance fileSetInstance = Utilities.getTestFileSet((ReadableConfiguration)configuration);
        FileChooser fileChooser = FileChooser.create((Component)component, (String)CoderResources.getString("prompt.selectTestFile"), (File)new File(MatlabPath.getCWD()), (boolean)false, (List)fileSetInstance.getDefinition().getFilters());
        File[] fileArray = DeployToolTestUtils.isUsingSimpleFileDialogs() ? DeployToolTestUtils.showSimpleFileChooser() : fileChooser.showOpenDialog();
        if (fileArray != null && fileArray.length > 0) {
            HashSet<File> hashSet = new HashSet<File>(Arrays.asList(fileArray));
            String string = fileSetInstance.validateAdd(hashSet);
            if (string != null) {
                MJOptionPane.showMessageDialog((Component)component, (Object)string, (String)BuiltInResources.getString((String)"error.addfiles.title"), (int)0);
            } else {
                fileSetInstance.add(hashSet);
                for (File file : fileArray) {
                    parameterRunnable.run((Object)file);
                }
            }
        } else if (runnable != null) {
            runnable.run();
        }
    }

    private static void configureBrowseButton(final Component component, final WritableConfiguration writableConfiguration, JButton jButton, final ParameterRunnable<File> parameterRunnable) {
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestFileSelectorPanel.browseForTestFile(component, (Configuration)writableConfiguration, (ParameterRunnable<File>)parameterRunnable);
            }
        });
    }
}

