/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.project.api.XmlWriter;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.CoderSignedMode;
import com.mathworks.toolbox.fixedpoint.NumericTypePanel;
import java.io.Serializable;

public class IDPNumericType
implements Serializable {
    private static final String DATATYPE_MODE_NAME = "DataTypeMode";
    private static final String SIGNED_MODE_NAME = "Signedness";
    private static final String WORDLENGTH_NAME = "WordLength";
    private static final String FRACTIONLENGTH_NAME = "FractionLength";
    private static final String SLOPE_NAME = "Slope";
    private static final String BIAS_NAME = "Bias";
    private NumericTypePanel.DataTypeMode fDataTypeMode = NumericTypePanel.DataTypeMode.FIXED_BINARY;
    private CoderSignedMode fSignedness = CoderSignedMode.SIGNED;
    private Integer fWordLength = Integer.parseInt("16");
    private Integer fFractionLength = Integer.parseInt("15");
    private String fSlope = "2^-15";
    private String fBias = "0";

    public IDPNumericType() {
    }

    public IDPNumericType(IDPNumericType iDPNumericType) {
        this.fDataTypeMode = iDPNumericType.fDataTypeMode;
        this.fSignedness = iDPNumericType.fSignedness;
        this.fWordLength = iDPNumericType.fWordLength;
        this.fFractionLength = iDPNumericType.fFractionLength;
        this.fSlope = iDPNumericType.fSlope;
        this.fBias = iDPNumericType.fBias;
    }

    public NumericTypePanel.DataTypeMode getDataTypeMode() {
        return this.fDataTypeMode;
    }

    public void setDataTypeMode(NumericTypePanel.DataTypeMode dataTypeMode) {
        this.fDataTypeMode = dataTypeMode;
    }

    public void setDataTypeMode(String string) {
        this.setDataTypeMode(Utilities.getEnumeration(string, NumericTypePanel.DataTypeMode.values()));
    }

    public CoderSignedMode getSignedMode() {
        return this.fSignedness;
    }

    public void setSignedMode(CoderSignedMode coderSignedMode) {
        this.fSignedness = coderSignedMode;
    }

    public void setSignedMode(String string) {
        this.setSignedMode(Utilities.getEnumeration(string, CoderSignedMode.values()));
    }

    public void setSignedness(String string) {
        this.setSignedMode(Utilities.getEnumeration(string, CoderSignedMode.values()));
    }

    public Integer getWordLength() {
        return this.fWordLength;
    }

    public void setWordLength(Integer n) {
        this.fWordLength = n;
    }

    public void setWordLength(String string) {
        this.setWordLength(Integer.decode(string));
    }

    public Integer getFractionLength() {
        return this.fFractionLength;
    }

    public void setFractionLength(Integer n) {
        this.fFractionLength = n;
    }

    public void setFractionLength(String string) {
        this.setFractionLength(Integer.decode(string));
    }

    public String getSlope() {
        return this.fSlope;
    }

    public void setSlope(String string) {
        this.fSlope = string;
    }

    public String getBias() {
        return this.fBias;
    }

    public void setBias(String string) {
        this.fBias = string;
    }

    boolean hasSignednessAndWordLength() {
        NumericTypePanel.DataTypeMode dataTypeMode = this.getDataTypeMode();
        return dataTypeMode != NumericTypePanel.DataTypeMode.BOOLEAN && dataTypeMode != NumericTypePanel.DataTypeMode.SINGLE && dataTypeMode != NumericTypePanel.DataTypeMode.DOUBLE;
    }

    boolean hasFractionLength() {
        NumericTypePanel.DataTypeMode dataTypeMode = this.getDataTypeMode();
        return dataTypeMode == NumericTypePanel.DataTypeMode.FIXED_BINARY || dataTypeMode == NumericTypePanel.DataTypeMode.SCALED_BINARY;
    }

    boolean hasSlopeAndBias() {
        NumericTypePanel.DataTypeMode dataTypeMode = this.getDataTypeMode();
        return dataTypeMode == NumericTypePanel.DataTypeMode.FIXED_SLOPE_AND_BIAS || dataTypeMode == NumericTypePanel.DataTypeMode.SCALED_SLOPE_AND_BIAS;
    }

    public void getData(XmlWriter xmlWriter) {
        xmlWriter.writeText(DATATYPE_MODE_NAME, new Object[]{Utilities.quote(this.fDataTypeMode.toSyntaxString())});
        if (this.hasSignednessAndWordLength()) {
            xmlWriter.writeText(SIGNED_MODE_NAME, new Object[]{Utilities.quote(this.fSignedness.toSyntaxString())});
            xmlWriter.writeText(WORDLENGTH_NAME, new Object[]{this.fWordLength});
        }
        if (this.hasFractionLength()) {
            xmlWriter.writeText(FRACTIONLENGTH_NAME, new Object[]{this.fFractionLength});
        }
        if (this.hasSlopeAndBias()) {
            xmlWriter.writeText(SLOPE_NAME, new Object[]{this.fSlope});
            xmlWriter.writeText(BIAS_NAME, new Object[]{this.fBias});
        }
    }
}

