/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.filesetui.FileChangeNotifier;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.project.impl.workflowui.WorkflowStepWidget;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapterFactory;
import com.mathworks.toolbox.coder.mi.FevalCommand;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.EntryPointFileDataWidget;
import com.mathworks.toolbox.coder.plugin.TestBenchConfig;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.plugin.TestFileSelectorPanel;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InputDefinitionWrapper
implements WorkflowStepWidget {
    private final Configuration fConfiguration;
    private final Window fParent;
    private final FixedPointDataAdapter fData;
    private final WorkflowStep fStep;
    private final FileSetInstance fFileSet;
    private final MJPanel fComponent;
    private final TestFileSelectorPanel fSelector;
    private final PropertyChangeListener fExternalChangeListener;
    private final FileChangeNotifier fChangeNotifier;
    private File fEntryPoint;
    private EntryPointFileDataWidget fTable;
    private ChangeListener fChangeListener;
    private boolean fSettingData;

    public InputDefinitionWrapper(MJFrame mJFrame, Configuration configuration) {
        this.fConfiguration = configuration;
        this.fParent = mJFrame;
        this.fData = FixedPointDataAdapterFactory.create(this.fConfiguration);
        this.fStep = configuration.getTarget().getWorkflow().getStepByKey("category.inputtypes");
        this.fFileSet = configuration.getFileSet("fileset.entrypoints");
        this.fChangeNotifier = new FileChangeNotifier(this.fFileSet, (ParameterRunnable)new ParameterRunnable<File>(){

            public void run(File file) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (InputDefinitionWrapper.this.fTable != null) {
                            if (!InputDefinitionWrapper.this.fEntryPoint.exists()) {
                                InputDefinitionWrapper.this.rebuild();
                            } else {
                                InputDefinitionWrapper.this.fTable.fileChanged();
                            }
                        } else if (InputDefinitionWrapper.this.fEntryPoint != null && InputDefinitionWrapper.this.fEntryPoint.exists()) {
                            InputDefinitionWrapper.this.rebuild();
                        }
                    }
                });
            }
        });
        this.fSelector = new TestFileSelectorPanel((WritableConfiguration)this.fConfiguration, false);
        this.fComponent = new MJPanel();
        this.rebuild();
        this.fExternalChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (InputDefinitionWrapper.this.fEntryPoint != null && !InputDefinitionWrapper.this.fSettingData && FileSetInstance.isCustomDataChange((PropertyChangeEvent)propertyChangeEvent)) {
                    InputDefinitionWrapper.this.fTable.setData(InputDefinitionWrapper.this.fFileSet.getCustomData(InputDefinitionWrapper.this.fEntryPoint));
                    InputDefinitionWrapper.this.updateStepState();
                } else if (!FileSetInstance.isCustomDataChange((PropertyChangeEvent)propertyChangeEvent)) {
                    InputDefinitionWrapper.this.rebuild();
                }
            }
        };
        this.fFileSet.addPropertyChangeListener(this.fExternalChangeListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InputDefinitionWrapper.this.updateStepState();
            }
        });
    }

    private void rebuild() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CellConstraints cellConstraints;
                if (InputDefinitionWrapper.this.fTable != null) {
                    InputDefinitionWrapper.this.fTable.removeChangeListener(InputDefinitionWrapper.this.fChangeListener);
                    InputDefinitionWrapper.this.fTable.dispose();
                    InputDefinitionWrapper.this.fTable = null;
                }
                InputDefinitionWrapper.this.fEntryPoint = InputDefinitionWrapper.this.fFileSet.getFiles().isEmpty() ? null : (File)InputDefinitionWrapper.this.fFileSet.getFiles().iterator().next();
                InputDefinitionWrapper.this.fComponent.removeAll();
                InputDefinitionWrapper.this.fComponent.setLayout((LayoutManager)new FormLayout("2dlu, fill:d, 8dlu, fill:d, 0dlu, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu, fill:d, 12dlu, fill:d, 3dlu, fill:d, 3dlu:grow"));
                if (InputDefinitionWrapper.this.fEntryPoint != null && InputDefinitionWrapper.this.fEntryPoint.getAbsoluteFile().exists()) {
                    InputDefinitionWrapper.this.fTable = new EntryPointFileDataWidget(InputDefinitionWrapper.this.fEntryPoint);
                    cellConstraints = InputDefinitionWrapper.this.fFileSet.getCustomData(InputDefinitionWrapper.this.fEntryPoint);
                    if (cellConstraints != null) {
                        InputDefinitionWrapper.this.fTable.setData(InputDefinitionWrapper.this.fFileSet.getCustomData(InputDefinitionWrapper.this.fEntryPoint));
                    }
                    InputDefinitionWrapper.this.fChangeListener = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            InputDefinitionWrapper.this.fSettingData = true;
                            InputDefinitionWrapper.this.fFileSet.setCustomData(InputDefinitionWrapper.this.fEntryPoint, InputDefinitionWrapper.this.fTable.getData().getXML());
                            InputDefinitionWrapper.this.fSettingData = false;
                            InputDefinitionWrapper.this.updateStepState();
                        }
                    };
                    InputDefinitionWrapper.this.fTable.addChangeListener(InputDefinitionWrapper.this.fChangeListener);
                }
                cellConstraints = new CellConstraints();
                InputDefinitionWrapper.this.fComponent.add((Component)new MJLabel(CoderResources.getString("hdl.inputtypes.designName")), (Object)cellConstraints.xy(2, 2));
                InputDefinitionWrapper.this.fComponent.add((Component)new MJLabel(InputDefinitionWrapper.this.fEntryPoint == null ? "" : InputDefinitionWrapper.this.fEntryPoint.getName()), (Object)cellConstraints.xy(4, 2));
                InputDefinitionWrapper.this.fComponent.add((Component)new MJLabel(CoderResources.getString("hdl.inputtypes.testBench")), (Object)cellConstraints.xy(2, 4));
                InputDefinitionWrapper.this.fComponent.add((Component)InputDefinitionWrapper.this.fSelector.getComponent(), (Object)cellConstraints.xy(4, 4));
                if (InputDefinitionWrapper.this.fEntryPoint != null) {
                    InputDefinitionWrapper.this.fComponent.add((Component)new MJLabel(MessageFormat.format(CoderResources.getString("hdl.inputtypes.desc"), InputDefinitionWrapper.this.fEntryPoint.getName())), (Object)cellConstraints.xyw(2, 6, 5));
                    if (InputDefinitionWrapper.this.fTable != null) {
                        InputDefinitionWrapper.this.fComponent.add(InputDefinitionWrapper.this.fTable.getComponent(), (Object)cellConstraints.xyw(2, 8, 5));
                    }
                }
                InputDefinitionWrapper.this.fComponent.revalidate();
                InputDefinitionWrapper.this.fComponent.repaint();
            }
        });
    }

    private void updateStepState() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (InputDefinitionWrapper.this.fTable == null || InputDefinitionWrapper.this.fTable.getEntryPoint() == null) {
                    WorkflowDialog.getInstance().getModel().setResult(InputDefinitionWrapper.this.fStep, null);
                    return;
                }
                for (InputDataProperty inputDataProperty : InputDefinitionWrapper.this.fTable.getEntryPoint().getInputDataProperties()) {
                    if (!inputDataProperty.isUndefined()) continue;
                    WorkflowDialog.getInstance().getModel().setResult(InputDefinitionWrapper.this.fStep, null);
                    return;
                }
                WorkflowDialog.getInstance().getModel().setResult(InputDefinitionWrapper.this.fStep, WorkflowStepResult.COMPLETED);
            }
        });
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fChangeNotifier.dispose();
        if (this.fTable != null) {
            this.fTable.removeChangeListener(this.fChangeListener);
            this.fTable.dispose();
        }
        this.fFileSet.removePropertyChangeListener(this.fExternalChangeListener);
    }

    public void activate() {
    }

    private boolean hasAutoDefinableInputs() {
        for (InputDataProperty inputDataProperty : this.fTable.getEntryPoint().getInputDataProperties()) {
            if (!inputDataProperty.isUndefined() && inputDataProperty.isUserDefined()) continue;
            return true;
        }
        return false;
    }

    public DeploymentProcess createStepRunProcess() {
        if (!this.hasAutoDefinableInputs()) {
            return DeploymentEngine.createProcess((Configuration)this.fConfiguration, (Command[])new Command[]{new DummyCommand()});
        }
        if (Utilities.getTestFileSet((ReadableConfiguration)this.fConfiguration).getFiles().isEmpty()) {
            return DeploymentEngine.createProcess((Configuration)this.fConfiguration, (Command[])new Command[]{new ChooseTestFileCommand(), new AutodefineCommand()});
        }
        this.fData.setDefaultTestFile(this.fSelector.getSelectedFile());
        return DeploymentEngine.createProcess((Configuration)this.fConfiguration, (Command[])new Command[]{new AutodefineCommand()});
    }

    public void reset() {
        XmlWriter xmlWriter = XmlApi.getInstance().create("Inputs");
        XmlReader xmlReader = this.fFileSet.getCustomData(this.fEntryPoint);
        if (xmlReader != null) {
            try {
                XmlReader xmlReader2 = XmlApi.getInstance().read(xmlReader.getXML());
                xmlWriter.writeAttribute("fileName", (Object)xmlReader2.readAttribute("fileName"));
                xmlWriter.writeAttribute("functionName", (Object)xmlReader2.readAttribute("functionName"));
                for (String string : this.getUserInputXml().values()) {
                    xmlWriter.writeXML(string);
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            this.fFileSet.setCustomData(this.fEntryPoint, xmlWriter.getXML());
        }
    }

    public boolean hasIntegratedControlsAndOutput() {
        return false;
    }

    private TestBenchConfig createTestBenchConfig() {
        TestBenchConfig testBenchConfig = new TestBenchConfig(TestBenchRunMode.RUN_FORTYPES);
        testBenchConfig.setTestBenchFile(this.fData.getDefaultTestFile());
        testBenchConfig.setEntryPointFiles(new HashSet<File>(Arrays.asList(this.fEntryPoint)));
        return testBenchConfig;
    }

    private Map<String, String> getUserInputXml() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (InputDataProperty inputDataProperty : this.fTable.getEntryPoint().getInputDataProperties()) {
                if (inputDataProperty.isUndefined() || !inputDataProperty.isUserDefined()) continue;
                XmlWriter xmlWriter = XmlApi.getInstance().create("temp");
                inputDataProperty.getData(xmlWriter);
                hashMap.put(inputDataProperty.getName(), XmlApi.getInstance().read(xmlWriter.getXML()).getChild(new String[0]).getXML());
            }
            return hashMap;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private boolean applyTypes(TestBenchResult testBenchResult, CommandStatus commandStatus) {
        if (!testBenchResult.getEntryPointTypes().isEmpty()) {
            String string = testBenchResult.getEntryPointTypes().entrySet().iterator().next().getValue();
            XmlWriter xmlWriter = XmlApi.getInstance().create("Inputs");
            try {
                XmlReader xmlReader = XmlApi.getInstance().read(string);
                xmlWriter.writeAttribute("fileName", (Object)xmlReader.readAttribute("fileName"));
                xmlWriter.writeAttribute("functionName", (Object)xmlReader.readAttribute("functionName"));
                Map<String, String> map = this.getUserInputXml();
                Object object = xmlReader.getChild(new String[0]);
                while (object.isPresent()) {
                    String object2 = map.get(object.readAttribute("Name"));
                    if (object2 == null) {
                        xmlWriter.writeXML(object.getXML());
                    } else {
                        xmlWriter.writeXML(object2);
                    }
                    object = object.next();
                }
                this.fFileSet.setCustomData(this.fEntryPoint, xmlWriter.getXML());
                for (InputDataProperty inputDataProperty : this.fTable.getEntryPoint().getInputDataProperties()) {
                    if (!inputDataProperty.isUndefined()) continue;
                    commandStatus.printErrorLine(CoderResources.getString("hdl.inputtypes.notAllDefined"));
                    return false;
                }
                return true;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        commandStatus.printErrorLine(CoderResources.getString("hdl.inputtypes.notAllDefined"));
        return false;
    }

    private class AutodefineCommand
    extends FevalCommand {
        AutodefineCommand() {
            super("", "coder.internal.inferTestBench", new Object[0]);
        }

        @Override
        protected Object[] getArguments() {
            return new Object[]{InputDefinitionWrapper.this.createTestBenchConfig()};
        }

        @Override
        protected boolean checkForSuccess(Object object, CommandStatus commandStatus) {
            if (!this.wasCanceled() && object instanceof TestBenchResult) {
                TestBenchResult testBenchResult = (TestBenchResult)object;
                if (testBenchResult.getMessage().isEmpty()) {
                    return InputDefinitionWrapper.this.applyTypes(testBenchResult, commandStatus);
                }
                commandStatus.printErrorLine(testBenchResult.getMessage());
            }
            return false;
        }
    }

    private class ChooseTestFileCommand
    implements Command {
        private ChooseTestFileCommand() {
        }

        public void execute(final CommandStatus commandStatus) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    TestFileSelectorPanel.browseForTestFile(InputDefinitionWrapper.this.fParent, InputDefinitionWrapper.this.fConfiguration, new ParameterRunnable<File>(){

                        public void run(File file) {
                            InputDefinitionWrapper.this.fData.setDefaultTestFile(file);
                            commandStatus.finished();
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                            commandStatus.canceled();
                        }
                    });
                }
            });
        }

        public void cancel() {
        }

        public String toString() {
            return "";
        }
    }

    private class DummyCommand
    implements Command {
        private DummyCommand() {
        }

        public void execute(CommandStatus commandStatus) {
            commandStatus.finished();
        }

        public void cancel() {
        }

        public String toString() {
            return CoderResources.getString("hdl.inputtypes.noop");
        }
    }
}

