/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.toolbox.coder.app.AbstractMexBuildManager;
import com.mathworks.toolbox.coder.app.BuildManager;
import com.mathworks.toolbox.coder.app.FindAdapter;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.PopupHintProvider;
import com.mathworks.toolbox.coder.app.TabbedPane;
import com.mathworks.toolbox.coder.app.ide.AbstractCodeInfoView;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.fixedpoint.HDLCoderDataAdapter;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.workflow.AbstractRequiredInputStep;
import com.mathworks.toolbox.coder.plugin.workflow.HDLGlassPaneRegistry;
import com.mathworks.toolbox.coder.plugin.workflow.TargetInterfacePort;
import com.mathworks.toolbox.coder.plugin.workflow.TargetInterfaceTable;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.widgets.SyntaxTextPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.event.ChangeListener;

public class TargetInterfacePanel
extends AbstractRequiredInputStep {
    private final MJFrame fParent;
    private final MJPanel fComponent;
    private final Configuration fConfiguration;
    private final HDLCoderDataAdapter fDataAdapter;
    private final TargetInterfaceTable fTable;
    private final ParamWidgetBinder fBinder;
    private final PropertyChangeListener fConfigurationListener;
    private CodeInfoView fCodeInfoView;
    private boolean fLoaded;
    private static final String TABLE_TAB_KEY = "table";

    public TargetInterfacePanel(MJFrame mJFrame, Configuration configuration) {
        super(configuration, "category.workflow.targetinterface");
        this.fParent = mJFrame;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fConfiguration = configuration;
        this.fDataAdapter = new HDLCoderDataAdapter(this.fConfiguration);
        this.fTable = new TargetInterfaceTable(configuration);
        this.fCodeInfoView = new CodeInfoView();
        this.fCodeInfoView.getOutputPane().setWorkflowHelpButtonVisible(true);
        this.fComponent.add((Component)this.fCodeInfoView.getComponent());
        this.fBinder = new ParamWidgetBinder(configuration.getProject(), false);
        this.fBinder.register(this.fConfiguration.getTarget().getParam("param.hdl.TargetInterface"), (ParamWidget)this.fTable);
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("param.hdl.TargetInterface")) {
                    TargetInterfacePanel.this.updateStepState();
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
        this.fTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TargetInterfacePanel.this.updateStepState();
                if (!TargetInterfacePanel.this.fTable.isValid()) {
                    TargetInterfacePanel.this.fCodeInfoView.getOutputPane().showErrorMessage(TargetInterfacePanel.this.fTable.getErrorMessage());
                } else {
                    TargetInterfacePanel.this.fCodeInfoView.getOutputPane().showErrorMessage(null);
                }
            }
        });
    }

    public void activate() {
        this.fCodeInfoView.activate();
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fCodeInfoView.dispose();
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
    }

    @Override
    public void reset() {
        this.fTable.reset();
        this.fCodeInfoView.resetActivation();
    }

    @Override
    protected WorkflowStepResult computeStepState() {
        if (!this.fLoaded || !this.fTable.isValid()) {
            return null;
        }
        boolean bl = false;
        for (TargetInterfacePort targetInterfacePort : this.fTable.getPorts()) {
            if (!targetInterfacePort.getPortType().equalsIgnoreCase("Outport") || targetInterfacePort.getSelectedInterface() == null || targetInterfacePort.getSelectedInterface().equals("No Interface Specified")) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return WorkflowStepResult.COMPLETED;
    }

    private class TargetInterfaceBuildManager
    extends AbstractMexBuildManager {
        public TargetInterfaceBuildManager(OutputPane outputPane) {
            super(TargetInterfacePanel.this.fConfiguration, outputPane, "getHDLEmlPortInfo", 4, 0, 1, 2, CoderResources.getString("hdl.target.analyzing"), CoderResources.getString("hdl.target.analyzing"));
        }

        @Override
        protected Object[] getBuildArguments() {
            HDLCoderDataAdapter hDLCoderDataAdapter = new HDLCoderDataAdapter(TargetInterfacePanel.this.fConfiguration);
            return new Object[]{hDLCoderDataAdapter, hDLCoderDataAdapter.getEntryPoints().iterator().next()};
        }

        @Override
        public File getMexFile() {
            return null;
        }

        @Override
        protected String getLastMexInputChecksum() {
            return null;
        }

        @Override
        protected String generateMexInputChecksum() {
            return null;
        }

        @Override
        protected void updateMexInputChecksum() {
        }

        @Override
        protected void handleBuildOutput(Object[] objectArray) {
            ArrayList<TargetInterfacePort> arrayList = new ArrayList<TargetInterfacePort>();
            Object[] objectArray2 = (Object[])objectArray[3];
            Map<String, Integer> map = ConversionUtils.processHeader((Object[])objectArray2[0]);
            Object[] objectArray3 = (Object[])objectArray2[1];
            for (int i = 0; i < objectArray3.length; ++i) {
                Object[] objectArray4 = (Object[])objectArray3[i];
                String string = (String)objectArray4[map.get("PortName")];
                String string2 = (String)objectArray4[map.get("PortType")];
                List<String> list = Arrays.asList((String[])objectArray4[map.get("InterfaceChoice")]);
                String string3 = list.get((int)((double[])objectArray4[map.get("InterfaceIdx")])[0]);
                String string4 = (String)objectArray4[map.get("BitRange")];
                NumericType numericType = new NumericType((String)objectArray4[map.get("DispDataType")]);
                TargetInterfacePort targetInterfacePort = new TargetInterfacePort(string, string2, numericType, list, string3);
                targetInterfacePort.setBitRange(string4);
                arrayList.add(targetInterfacePort);
            }
            TargetInterfacePanel.this.fTable.setPorts(arrayList);
            TargetInterfacePanel.this.fLoaded = true;
            TargetInterfacePanel.this.fCodeInfoView.getOutputPane().activateTab(TargetInterfacePanel.TABLE_TAB_KEY);
            TargetInterfacePanel.this.updateStepState();
        }
    }

    private class HintProvider
    implements PopupHintProvider {
        private HintProvider() {
        }

        @Override
        public String getCurrentHint() {
            return null;
        }

        @Override
        public String getInitialHint() {
            return null;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private class CodeInfoView
    extends AbstractCodeInfoView {
        CodeInfoView() {
            super((Window)TargetInterfacePanel.this.fParent, HDLGlassPaneRegistry.getInstance().getGlassPaneManager((JFrame)TargetInterfacePanel.this.fParent), new Animator(), true);
            this.getEditorView().displayFile(TargetInterfacePanel.this.fDataAdapter.getEntryPoints().iterator().next());
        }

        @Override
        protected PopupHintProvider createHintProvider(PopupBarManager popupBarManager, FindAdapter findAdapter) {
            return new HintProvider();
        }

        @Override
        protected BuildManager createBuildManager(OutputPane outputPane) {
            return new TargetInterfaceBuildManager(outputPane);
        }

        @Override
        protected CodePopupController createCodePopupController(Window window, EditorView editorView, SyntaxTextPane syntaxTextPane, Function function) {
            return null;
        }

        @Override
        protected FunctionScopedEntityLocator createEntityLocator() {
            return null;
        }

        @Override
        protected void initializeTabbedPane(TabbedPane tabbedPane) {
            tabbedPane.addTab(TargetInterfacePanel.TABLE_TAB_KEY, CoderResources.getString("hdl.targetInterface.table"), TargetInterfacePanel.this.fTable.getComponent());
            tabbedPane.addTab("output", CoderResources.getString("f2f.tab.output"));
        }

        @Override
        protected boolean isEntryPoint(File file) {
            return TargetInterfacePanel.this.fDataAdapter.getEntryPoints().contains(file);
        }
    }
}

