/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.table.AbstractComboBoxCellEditor;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.AbstractSimpleCellEditor;
import com.mathworks.project.impl.table.Cell;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.workflow.TargetInterfacePort;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.Predicate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TargetInterfaceTable
implements ParamWidget<XmlReader> {
    private final Configuration fConfiguration;
    private final Map<String, TargetInterfacePort> fPorts;
    private final MJPanel fComponent;
    private final MulticastChangeListener fChangeListeners;
    private final PropertyChangeSupport fPropertySupport;
    private final PropertyChangeListener fPropertyChangeListener;
    private boolean fLoaded;
    private String fErrorMessage;
    private XmlReader fPendingRestore;
    private PropertyTable<TargetInterfacePort> fTable;
    private PropertyTableHighlighter<TargetInterfacePort> fErrorHighlight;
    public static final String VALID_PROPERTY = "Valid";

    public TargetInterfaceTable(Configuration configuration) {
        this.fConfiguration = configuration;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fChangeListeners = new MulticastChangeListener();
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fPorts = new LinkedHashMap<String, TargetInterfacePort>();
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TargetInterfaceTable.this.fChangeListeners.stateChanged(new ChangeEvent(TargetInterfaceTable.this));
            }
        };
    }

    public List<TargetInterfacePort> getPorts() {
        return new ArrayList<TargetInterfacePort>(this.fPorts.values());
    }

    public void setPorts(List<TargetInterfacePort> list) {
        TargetInterfacePort targetInterfacePort3;
        for (TargetInterfacePort list22 : this.fPorts.values()) {
            list22.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fPorts.clear();
        if (this.fTable != null) {
            this.fTable.dispose();
            this.fComponent.remove((Component)this.fTable.getComponent());
        }
        for (TargetInterfacePort targetInterfacePort2 : list) {
            this.fPorts.put(targetInterfacePort2.getKey(), targetInterfacePort2);
            targetInterfacePort2.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fLoaded = true;
        if (this.fPendingRestore != null) {
            this.setData(this.fPendingRestore);
            this.fPendingRestore = null;
            this.validate();
        }
        TreeMap treeMap = new TreeMap();
        for (TargetInterfacePort targetInterfacePort3 : this.fPorts.values()) {
            PropertyTableNode propertyTableNode = (PropertyTableNode)treeMap.get(targetInterfacePort3.getPortType());
            if (propertyTableNode == null) {
                propertyTableNode = new PropertyTableNode(null, true, targetInterfacePort3.getPortType());
                treeMap.put(targetInterfacePort3.getPortType(), propertyTableNode);
            }
            new PropertyTableNode(propertyTableNode, false, Arrays.asList(targetInterfacePort3));
        }
        List<AbstractPropertyTableColumn> list2 = Arrays.asList(new AbstractPropertyTableColumn[]{new NameColumn(), new DataTypeColumn(), new InterfaceColumn(), new BitRangeColumn()});
        targetInterfacePort3 = new PropertyTableModel(list2, new ArrayList(treeMap.values()));
        targetInterfacePort3.expandAll();
        this.fTable = new PropertyTable((PropertyTableModel)targetInterfacePort3, (PropertyTableCellEditorFactory)new EditorFactory());
        this.fComponent.add((Component)this.fTable.getComponent());
    }

    public void reset() {
        this.fComponent.removeAll();
        if (this.fTable != null) {
            this.fTable.dispose();
            this.fTable = null;
            this.fPorts.clear();
            this.fLoaded = false;
        }
    }

    public void dispose() {
        if (this.fTable != null) {
            this.fTable.dispose();
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void setEnabled(boolean bl) {
    }

    public boolean isExternalLabelRequired() {
        return false;
    }

    public void setData(XmlReader xmlReader) {
        if (xmlReader == null) {
            return;
        }
        if (!this.fLoaded) {
            this.fPendingRestore = xmlReader;
            return;
        }
        XmlReader xmlReader2 = xmlReader.getChild(new String[]{"Port"});
        while (xmlReader2.isPresent()) {
            String string;
            TargetInterfacePort targetInterfacePort;
            String string2 = xmlReader2.readText("Name");
            String string3 = xmlReader2.readText("PortType");
            if (string2 != null && string3 != null && (targetInterfacePort = this.fPorts.get(string = TargetInterfacePort.getKey(string2, string3))) != null) {
                String string4 = xmlReader2.readText("SelectedInterface");
                String string5 = xmlReader2.readText("BitRange");
                if (string4 != null) {
                    targetInterfacePort.setSelectedInterface(string4);
                }
                if (string5 != null) {
                    targetInterfacePort.setBitRange(string5);
                }
            }
            xmlReader2 = xmlReader2.next();
        }
    }

    public XmlReader getData() {
        XmlWriter xmlWriter = XmlApi.getInstance().create("TargetInterface");
        for (TargetInterfacePort targetInterfacePort : this.fPorts.values()) {
            XmlWriter xmlWriter2 = xmlWriter.createElement("Port");
            xmlWriter2.writeText("Name", new Object[]{targetInterfacePort.getName()});
            xmlWriter2.writeText("PortType", new Object[]{targetInterfacePort.getPortType()});
            xmlWriter2.writeText("DataType", new Object[]{targetInterfacePort.getDataType()});
            xmlWriter2.writeText("SelectedInterface", new Object[]{targetInterfacePort.getSelectedInterface()});
            xmlWriter2.writeText("BitRange", new Object[]{targetInterfacePort.getBitRange()});
        }
        try {
            return XmlApi.getInstance().read(xmlWriter.getXML());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private void updateDefaultBitRanges() {
        new Matlab().fevalConsoleOutput("getHDLEmlDefaultBitRanges", new Object[]{this.fConfiguration}, 1, new CompletionObserver(){

            public void completed(int n, final Object object) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (object instanceof String) {
                            try {
                                XmlReader xmlReader = XmlApi.getInstance().read((String)object);
                                XmlReader xmlReader2 = xmlReader.getChild(new String[]{"Port"});
                                while (xmlReader2.isPresent()) {
                                    String string = xmlReader2.readText("Name");
                                    String string2 = xmlReader2.readText("PortType");
                                    String string3 = TargetInterfacePort.getKey(string, string2);
                                    String string4 = xmlReader2.readText("BitRange");
                                    TargetInterfacePort targetInterfacePort = (TargetInterfacePort)TargetInterfaceTable.this.fPorts.get(string3);
                                    if (targetInterfacePort != null && (targetInterfacePort.getBitRange() == null || targetInterfacePort.getBitRange().trim().isEmpty())) {
                                        targetInterfacePort.setBitRange(string4);
                                    }
                                    xmlReader2 = xmlReader2.next();
                                }
                                TargetInterfaceTable.this.fTable.getModel().fireChange();
                            }
                            catch (IOException iOException) {
                                throw new IllegalArgumentException("Malformed XML returned from getHDLEmlDefaultBitRanges: " + object);
                            }
                        }
                    }
                });
            }
        });
    }

    private void validate() {
        new Matlab().fevalConsoleOutput("validateHDLEmlPortInfo", new Object[]{this.fConfiguration}, 1, new CompletionObserver(){

            public void completed(int n, final Object object) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (object instanceof String) {
                            try {
                                LinkedHashMap<TargetInterfacePort, String> linkedHashMap = new LinkedHashMap<TargetInterfacePort, String>();
                                XmlReader xmlReader = XmlApi.getInstance().read((String)object);
                                XmlReader xmlReader2 = xmlReader.getChild(new String[]{"Port"});
                                while (xmlReader2.isPresent()) {
                                    String string = xmlReader2.readText("Name");
                                    String string2 = xmlReader2.readText("PortType");
                                    String string3 = TargetInterfacePort.getKey(string, string2);
                                    String string4 = xmlReader2.readText("BitRange");
                                    TargetInterfacePort targetInterfacePort = (TargetInterfacePort)TargetInterfaceTable.this.fPorts.get(string3);
                                    if (targetInterfacePort != null) {
                                        linkedHashMap.put(targetInterfacePort, string4);
                                    }
                                    xmlReader2 = xmlReader2.next();
                                }
                                TargetInterfaceTable.this.fTable.getModel().fireChange();
                                TargetInterfaceTable.this.updateValidationMessages(linkedHashMap);
                            }
                            catch (IOException iOException) {
                                throw new IllegalArgumentException("Malformed XML returned from getHDLEmlDefaultBitRanges: " + object);
                            }
                        }
                    }
                });
            }
        });
    }

    private void updateValidationMessages(Map<TargetInterfacePort, String> map) {
        boolean bl = this.isValid();
        PropertyTableHighlighter propertyTableHighlighter = new PropertyTableHighlighter(null, new Color(170, 0, 0), new ArrayList<TargetInterfacePort>(map.keySet()), (Predicate)new Predicate<Cell<TargetInterfacePort>>(){

            public boolean accept(Cell<TargetInterfacePort> cell) {
                return cell.getColumnIndex() > 1;
            }
        });
        this.fTable.swapHighlighter(this.fErrorHighlight, propertyTableHighlighter);
        this.fErrorHighlight = propertyTableHighlighter;
        this.fErrorMessage = map.isEmpty() ? null : map.values().iterator().next();
        this.fPropertySupport.firePropertyChange(VALID_PROPERTY, bl, this.isValid());
    }

    public boolean isValid() {
        return this.fErrorMessage == null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean showValidationMessage(ValidationMessage validationMessage) {
        return false;
    }

    public void clearValidationMessage() {
    }

    private static Map<String, String> createInterfaceOptionMap(TargetInterfacePort targetInterfacePort) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : targetInterfacePort.getInterfaceChoices()) {
            linkedHashMap.put(string, string);
        }
        return linkedHashMap;
    }

    private class BitRangeEditor
    extends AbstractSimpleCellEditor<TargetInterfacePort> {
        private final TargetInterfacePort fPort;

        BitRangeEditor(PropertyTable<TargetInterfacePort> propertyTable, TargetInterfacePort targetInterfacePort) {
            super(propertyTable);
            this.fPort = targetInterfacePort;
        }

        public void loadData(Object object, String string) {
            this.setData(object, string);
        }

        public void commitData() {
            this.fPort.setBitRange((String)this.getData());
            TargetInterfaceTable.this.validate();
        }
    }

    private class InterfaceEditor
    extends AbstractComboBoxCellEditor<TargetInterfacePort> {
        private final TargetInterfacePort fPort;

        InterfaceEditor(PropertyTable<TargetInterfacePort> propertyTable, TargetInterfacePort targetInterfacePort) {
            super(propertyTable, TargetInterfaceTable.createInterfaceOptionMap(targetInterfacePort));
            this.fPort = targetInterfacePort;
        }

        public void loadData(Object object, String string) {
            this.setData(string);
        }

        public void commitData() {
            if (this.fPort.getSelectedInterface() != null && this.fPort.getSelectedInterface().equals(this.getData())) {
                return;
            }
            this.fPort.setSelectedInterface((String)this.getData());
            this.fPort.setBitRange(null);
            TargetInterfaceTable.this.updateDefaultBitRanges();
            TargetInterfaceTable.this.validate();
        }
    }

    private class EditorFactory
    implements PropertyTableCellEditorFactory<TargetInterfacePort> {
        private EditorFactory() {
        }

        public PropertyTableCellEditor<TargetInterfacePort> createWidget(PropertyTable<TargetInterfacePort> propertyTable, int n, int n2, TargetInterfacePort targetInterfacePort) {
            if (n2 < 2) {
                return null;
            }
            if (n2 == 2) {
                return new InterfaceEditor(propertyTable, targetInterfacePort);
            }
            return new BitRangeEditor(propertyTable, targetInterfacePort);
        }
    }

    private class BitRangeColumn
    extends AbstractPropertyTableColumn<TargetInterfacePort> {
        public BitRangeColumn() {
            super(CoderResources.getString("hdl.targetInterface.bitRange"));
        }

        public String getText(TargetInterfacePort targetInterfacePort) {
            return targetInterfacePort.getBitRange() == null ? "" : targetInterfacePort.getBitRange();
        }

        public boolean isEditable() {
            return true;
        }
    }

    private class InterfaceColumn
    extends AbstractPropertyTableColumn<TargetInterfacePort> {
        public InterfaceColumn() {
            super(CoderResources.getString("hdl.targetInterface.interface"));
        }

        public String getText(TargetInterfacePort targetInterfacePort) {
            return targetInterfacePort.getSelectedInterface();
        }

        public boolean isEditable() {
            return true;
        }
    }

    private class DataTypeColumn
    extends AbstractPropertyTableColumn<TargetInterfacePort> {
        public DataTypeColumn() {
            super(CoderResources.getString("hdl.targetInterface.dataType"));
        }

        public String getText(TargetInterfacePort targetInterfacePort) {
            return targetInterfacePort.getDataType().toString();
        }
    }

    private class NameColumn
    extends AbstractPropertyTableColumn<TargetInterfacePort> {
        public NameColumn() {
            super(CoderResources.getString("hdl.targetInterface.portName"));
        }

        public String getText(TargetInterfacePort targetInterfacePort) {
            return targetInterfacePort.getName();
        }
    }
}

