/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.screener.DependencyFileSystem;
import com.mathworks.toolbox.coder.screener.FileImpactModel;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.toolbox.coder.screener.StoppableVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public final class CallTreeImpactModel {
    private final ScreenerTarget fTarget;
    private final Map<File, Set<File>> fChildren;
    private final Map<File, Set<File>> fParents;
    private final Map<File, FileImpactModel> fFiles;

    public CallTreeImpactModel(ScreenerTarget screenerTarget) {
        this.fTarget = screenerTarget;
        this.fChildren = new HashMap<File, Set<File>>();
        this.fParents = new HashMap<File, Set<File>>();
        this.fFiles = new HashMap<File, FileImpactModel>();
    }

    public ScreenerTarget getTarget() {
        return this.fTarget;
    }

    public Set<File> getRootFiles() {
        TreeSet<File> treeSet = new TreeSet<File>();
        for (File file : this.fFiles.keySet()) {
            if (this.fParents.containsKey(file) && !this.fParents.get(file).isEmpty()) continue;
            treeSet.add(file);
        }
        return treeSet;
    }

    public void addInvocation(File file, File file2) {
        if (!file.equals(file2)) {
            CallTreeImpactModel.add(this.fChildren, file, file2);
            CallTreeImpactModel.add(this.fParents, file2, file);
        }
    }

    public void setFileImpact(File file, FileImpactModel fileImpactModel) {
        this.fFiles.put(file, fileImpactModel);
    }

    public FileImpactModel getFileImpact(File file) {
        return this.fFiles.get(file);
    }

    public void visitAll(@Nullable File file, StoppableVisitor<File> stoppableVisitor) {
        if (file == null) {
            for (File file2 : this.fFiles.keySet()) {
                if (!stoppableVisitor.visit(file2)) break;
            }
            return;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        HashSet<File> hashSet = new HashSet<File>();
        linkedList.offer(file);
        while (!linkedList.isEmpty()) {
            File file3 = (File)linkedList.poll();
            if (!hashSet.add(file3)) continue;
            if (!stoppableVisitor.visit(file3)) break;
            Set<File> set = this.fChildren.get(file3);
            if (set == null) continue;
            for (File file4 : set) {
                linkedList.offer(file4);
            }
        }
    }

    public void visitAll(StoppableVisitor<File> stoppableVisitor) {
        this.visitAll(null, stoppableVisitor);
    }

    public void visitAllNonMathWorks(@Nullable File file, final StoppableVisitor<File> stoppableVisitor) {
        this.visitAll(file, new StoppableVisitor<File>(){

            @Override
            public boolean visit(File file) {
                return DependencyFileSystem.isInToolbox(file.getAbsolutePath()) || !CallTreeImpactModel.this.isSupportedScreenerFile(file) || stoppableVisitor.visit(file);
            }
        });
    }

    public void visitAllNonMathWorks(StoppableVisitor<File> stoppableVisitor) {
        this.visitAllNonMathWorks(null, stoppableVisitor);
    }

    public List<File> getNonMathWorksFilesInvoked(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Set<File> set = this.fChildren.get(file);
        if (set != null) {
            for (File file2 : set) {
                if (DependencyFileSystem.isInToolbox(file2.getAbsolutePath())) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    public List<File> getMathWorksFilesInvoked(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Set<File> set = this.fChildren.get(file);
        if (set != null) {
            for (File file2 : set) {
                if (!DependencyFileSystem.isInToolbox(file2.getAbsolutePath())) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    private boolean isSupportedScreenerFile(File file) {
        return CoderFileSupport.isMatlabSourceFile(file) || this.fFiles.get(file) != null;
    }

    private static <T> void add(Map<T, Set<T>> map, T t, T t2) {
        Set<T> set = map.get(t);
        if (set == null) {
            set = new HashSet<T>();
            map.put(t, set);
        }
        set.add(t2);
    }
}

