/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.PropertyTableSearchPredicate;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.CodeBasePieChart;
import com.mathworks.toolbox.coder.screener.DependencyFileSystem;
import com.mathworks.toolbox.coder.screener.FileImpactModel;
import com.mathworks.toolbox.coder.screener.MatlabFunctionSupport;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.toolbox.coder.screener.SectionedReportView;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

public final class CodeBaseOverview {
    private final List<File> fRootFiles;
    private final ScreenerReportModel fModel;
    private final SectionedReportView fComponent;
    private static final String USER_FILTER = "user";
    private static final int INDENTATION_MARGIN = PlatformInfo.isMacintosh() ? 30 : 18;

    public CodeBaseOverview(ScreenerReportModel screenerReportModel) {
        PropertyTableNode propertyTableNode;
        File file2;
        this.fRootFiles = new ArrayList<File>(screenerReportModel.getRootFiles());
        this.fModel = screenerReportModel;
        this.fComponent = new SectionedReportView(!PlatformInfo.isMacintosh());
        ArrayList<AbstractPropertyTableColumn> arrayList = new ArrayList<AbstractPropertyTableColumn>();
        arrayList.add(new FileColumn());
        arrayList.add(new ScoreColumn());
        arrayList.add(new LinesColumn());
        ArrayList<PropertyTableNode> arrayList2 = new ArrayList<PropertyTableNode>();
        for (File file2 : this.fRootFiles) {
            propertyTableNode = new PropertyTableNode(null, false, Arrays.asList(file2));
            this.populateChildren((PropertyTableNode<File>)propertyTableNode, new HashSet<File>());
            arrayList2.add(propertyTableNode);
        }
        PropertyTableSearchPredicate<File> propertyTableSearchPredicate = new PropertyTableSearchPredicate<File>(){

            public boolean accept(File file, String string) {
                if (string.equals(CodeBaseOverview.USER_FILTER)) {
                    return !DependencyFileSystem.isInToolbox(file.getAbsolutePath());
                }
                return true;
            }
        };
        file2 = new PropertyTableModel(arrayList, (PropertyTableSearchPredicate)propertyTableSearchPredicate, arrayList2);
        propertyTableNode = new PropertyTable((PropertyTableModel)file2);
        propertyTableNode.setAllowSelectingExpandableRows(true);
        file2.expandAll();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout());
        mJPanel.setOpaque(false);
        final MJCheckBox mJCheckBox = new MJCheckBox(CoderResources.getString("screener.check.showMathWorksFunctions"));
        if (!PlatformInfo.isMacintosh()) {
            mJCheckBox.setOpaque(false);
        }
        mJPanel.add((Component)mJCheckBox);
        MJLabel mJLabel = new MJLabel(CoderResources.getString("screener.distribution.desc" + (screenerReportModel.hasDifferentFileScores() ? ".extra" : "")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        this.fComponent.startSection(gridBagConstraints, CoderResources.getString("screener.header.distribution"));
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = INDENTATION_MARGIN;
        this.fComponent.add((Component)mJLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 0;
        this.fComponent.add(new CodeBasePieChart(screenerReportModel).getComponent(), gridBagConstraints);
        this.fComponent.endSection(gridBagConstraints);
        this.fComponent.startSection(gridBagConstraints, CoderResources.getString("screener.header.callTree"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 3;
        gridBagConstraints.anchor = 10;
        this.fComponent.add((Component)mJPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        this.fComponent.add(propertyTableNode.getComponent(), gridBagConstraints);
        mJCheckBox.addItemListener(new ItemListener((PropertyTableModel)file2){
            final /* synthetic */ PropertyTableModel val$tableModel;
            {
                this.val$tableModel = propertyTableModel;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!mJCheckBox.isSelected()) {
                    this.val$tableModel.setSearchText(CodeBaseOverview.USER_FILTER);
                } else {
                    this.val$tableModel.setSearchText(null);
                }
            }
        });
        file2.setSearchText(USER_FILTER);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void populateChildren(PropertyTableNode<File> propertyTableNode, Set<File> set) {
        for (File file : this.fModel.getNonMathWorksFilesInvoked((File)propertyTableNode.getValue(0))) {
            PropertyTableNode propertyTableNode2 = new PropertyTableNode(propertyTableNode, false, Arrays.asList(file));
            if (!set.add(file)) continue;
            this.populateChildren((PropertyTableNode<File>)propertyTableNode2, set);
        }
        for (File file : this.fModel.getMathWorksFilesInvoked((File)propertyTableNode.getValue(0))) {
            new PropertyTableNode(propertyTableNode, false, Arrays.asList(file));
        }
    }

    private class ScoreColumn
    extends AbstractPropertyTableColumn<File> {
        ScoreColumn() {
            super(CoderResources.getString("screener.codeBase.column.score"));
        }

        public String getText(File file) {
            if (!CodeBaseOverview.this.fRootFiles.contains(file)) {
                FileImpactModel fileImpactModel = CodeBaseOverview.this.fModel.getFileImpact(file);
                if (fileImpactModel == null) {
                    return MatlabFunctionSupport.isSupported(new FileLocation(file), new FileLocation(file).getNameBeforeDot(), CodeBaseOverview.this.fModel.getTarget()) == false ? CoderResources.getString("screener.function.unsupported") : CoderResources.getString("screener.function.supported");
                }
                int n = CodeBaseOverview.this.fModel.getFileScore(file);
                return Integer.toString(n);
            }
            return Integer.toString(CodeBaseOverview.this.fModel.getScore().getScore());
        }
    }

    private class LinesColumn
    extends AbstractPropertyTableColumn<File> {
        LinesColumn() {
            super(CoderResources.getString("screener.codeBase.column.lines"));
        }

        public String getText(File file) {
            FileImpactModel fileImpactModel = CodeBaseOverview.this.fModel.getFileImpact(file);
            return fileImpactModel == null ? "" : Integer.toString(CodeBaseOverview.this.fModel.getFileImpact(file).getLineCount());
        }
    }

    private static class FileColumn
    extends AbstractPropertyTableColumn<File> {
        FileColumn() {
            super(CoderResources.getString("screener.codeBase.column.file"));
        }

        public String getText(File file) {
            if (DependencyFileSystem.isInToolbox(file.getAbsolutePath())) {
                return new FileLocation(file).getNameBeforeDot();
            }
            return file.getName();
        }
    }
}

