/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.util;

import com.mathworks.toolbox.coder.model.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionTree {
    private static final Comparator<Expression> START_COMPARATOR = new Comparator<Expression>(){

        @Override
        public int compare(Expression expression, Expression expression2) {
            return Integer.compare(expression.getStart(), expression2.getStart());
        }
    };
    private static final Comparator<Expression> END_COMPARATOR = new Comparator<Expression>(){

        @Override
        public int compare(Expression expression, Expression expression2) {
            return Integer.compare(expression.getEnd(), expression2.getEnd());
        }
    };
    private static final Comparator<Expression> LENGTH_COMPARATOR = new Comparator<Expression>(){

        @Override
        public int compare(Expression expression, Expression expression2) {
            return Integer.compare(expression.getLength(), expression2.getLength());
        }
    };
    private final Node fRoot;

    public ExpressionTree(Collection<Expression> collection) {
        this.fRoot = new Node(collection);
    }

    @NotNull
    public List<Expression> getExpressions(int n) {
        return this.fRoot.getExpressions(n);
    }

    @NotNull
    public List<Expression> getSortedExpressions(int n) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.getExpressions(n));
        Collections.sort(arrayList, LENGTH_COMPARATOR);
        return arrayList;
    }

    @Nullable
    public Expression getNarrowestExpression(int n) {
        List<Expression> list = this.getSortedExpressions(n);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    public Expression getWidestExpression(int n) {
        List<Expression> list = this.getSortedExpressions(n);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private static Expression[] sort(Collection<Expression> collection, boolean bl) {
        Expression[] expressionArray = collection.toArray(new Expression[collection.size()]);
        if (expressionArray.length == 0) {
            return expressionArray;
        }
        Arrays.sort(expressionArray, bl ? START_COMPARATOR : END_COMPARATOR);
        return expressionArray;
    }

    private static int averageMidpoint(Collection<Expression> collection) {
        double d = 0.0;
        for (Expression expression : collection) {
            d += (double)expression.getStart() + (double)expression.getLength() / 2.0;
        }
        return (int)(d / (double)collection.size());
    }

    private static int searchByStart(int n, Expression[] expressionArray) {
        if (expressionArray.length == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = expressionArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            int n5 = expressionArray[n4].getStart();
            if (n5 <= n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return Math.min(Math.max(0, n2), expressionArray.length);
    }

    private static int searchByEnd(int n, Expression[] expressionArray) {
        int n2 = 0;
        int n3 = expressionArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            int n5 = expressionArray[n4].getEnd();
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return Math.min(Math.max(0, n2), expressionArray.length);
    }

    private static class Node {
        private final Expression[] fExpStarts;
        private final Expression[] fExpEnds;
        private final int fCenter;
        private final Node fLeft;
        private final Node fRight;

        Node(Collection<Expression> collection) {
            this.fCenter = ExpressionTree.averageMidpoint(collection);
            LinkedList<Expression> linkedList = new LinkedList<Expression>();
            LinkedList<Expression> linkedList2 = new LinkedList<Expression>();
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            for (Expression expression : collection) {
                if (expression.getLength() <= 0) continue;
                if (expression.getEnd() <= this.fCenter) {
                    linkedList.add(expression);
                    continue;
                }
                if (expression.getStart() > this.fCenter) {
                    arrayList.add(expression);
                    continue;
                }
                linkedList2.add(expression);
            }
            this.fExpStarts = ExpressionTree.sort(linkedList2, true);
            this.fExpEnds = ExpressionTree.sort(linkedList2, false);
            this.fLeft = !linkedList.isEmpty() ? new Node(linkedList) : null;
            this.fRight = !arrayList.isEmpty() ? new Node(arrayList) : null;
        }

        @NotNull
        List<Expression> getExpressions(int n) {
            return this.getExpressions(n, new LinkedList<Expression>());
        }

        private List<Expression> getExpressions(int n, List<Expression> list) {
            int n2;
            int n3;
            Expression[] expressionArray;
            if (n < this.fCenter && this.fLeft != null) {
                this.fLeft.getExpressions(n, list);
            }
            if (n <= this.fCenter) {
                expressionArray = this.fExpStarts;
                n3 = ExpressionTree.searchByStart(n, this.fExpStarts);
                n2 = 0;
            } else {
                expressionArray = this.fExpEnds;
                n2 = ExpressionTree.searchByEnd(n, this.fExpEnds);
                n3 = expressionArray.length;
            }
            list.addAll(Arrays.asList(expressionArray).subList(n2, n3));
            if (n > this.fCenter && this.fRight != null) {
                this.fRight.getExpressions(n, list);
            }
            return list;
        }
    }
}

