/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa;

import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.wfa.CoderStepModel;
import com.mathworks.toolbox.coder.wfa.OverviewPanel;
import com.mathworks.toolbox.coder.wfa.build.GenerateCodeSummaryView;
import com.mathworks.toolbox.coder.wfa.build.GenerateCodeView;
import com.mathworks.toolbox.coder.wfa.build.HDLGenerateCodeView;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.core.StepSummaryView;
import com.mathworks.toolbox.coder.wfa.core.StepView;
import com.mathworks.toolbox.coder.wfa.core.StepViewFactory;
import com.mathworks.toolbox.coder.wfa.fixedpoint.FixedPointSummaryView;
import com.mathworks.toolbox.coder.wfa.fixedpoint.FixedPointView;
import com.mathworks.toolbox.coder.wfa.hdltarget.ChooseTargetSummaryView;
import com.mathworks.toolbox.coder.wfa.hdltarget.ChooseTargetView;
import com.mathworks.toolbox.coder.wfa.inputtypes.DefineInputTypesSummaryView;
import com.mathworks.toolbox.coder.wfa.inputtypes.DefineInputTypesView;
import com.mathworks.toolbox.coder.wfa.screener.ScreenerSummaryView;
import com.mathworks.toolbox.coder.wfa.screener.ScreenerView;
import com.mathworks.toolbox.coder.wfa.setup.ChooseSourceCodeSummaryView;
import com.mathworks.toolbox.coder.wfa.setup.ChooseSourceCodeView;
import com.mathworks.toolbox.coder.wfa.synthesis.SynthesisSummaryView;
import com.mathworks.toolbox.coder.wfa.synthesis.SynthesisView;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class CoderStepViewFactory
extends StepViewFactory {
    private final CoderApp fApp;
    private static final Map<Step, Class<? extends StepView>> VIEW_CLASSES = new HashMap<Step, Class<? extends StepView>>();
    private static final Map<Step, Class<? extends StepSummaryView>> SUMMARY_CLASSES = new HashMap<Step, Class<? extends StepSummaryView>>();

    public CoderStepViewFactory(CoderApp coderApp) {
        this.fApp = coderApp;
    }

    @Override
    protected StepView createView(Step step, StepModel stepModel) {
        if (step == StepModel.OVERVIEW) {
            return new OverviewPanel(this.fApp, stepModel, this);
        }
        return this.instantiateUI(VIEW_CLASSES.get(step), this.fApp, stepModel, step);
    }

    @Override
    protected StepSummaryView createSummaryView(Step step, StepModel stepModel) {
        return this.instantiateUI(SUMMARY_CLASSES.get(step), this.fApp, stepModel, this, step);
    }

    private <T> T instantiateUI(Class<? extends T> clazz, Object ... objectArray) {
        try {
            Constructor<?> constructor = clazz.getConstructors()[0];
            return (T)constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalStateException(reflectiveOperationException);
        }
    }

    static {
        VIEW_CLASSES.put(CoderStepModel.CHOOSE_SOURCE_FILES_STEP, ChooseSourceCodeView.class);
        VIEW_CLASSES.put(CoderStepModel.REVIEW_POTENTIAL_ISSUES_STEP, ScreenerView.class);
        VIEW_CLASSES.put(CoderStepModel.DEFINE_INPUT_TYPES_STEP, DefineInputTypesView.class);
        VIEW_CLASSES.put(CoderStepModel.CONVERT_TO_FIXED_POINT_STEP, FixedPointView.class);
        VIEW_CLASSES.put(CoderStepModel.HDL_CHOOSE_TARGET_STEP, ChooseTargetView.class);
        VIEW_CLASSES.put(CoderStepModel.GENERATE_CODE_STEP, GenerateCodeView.class);
        VIEW_CLASSES.put(CoderStepModel.HDL_GENERATE_CODE_STEP, HDLGenerateCodeView.class);
        VIEW_CLASSES.put(CoderStepModel.HDL_SYNTHESIS_STEP, SynthesisView.class);
        SUMMARY_CLASSES.put(CoderStepModel.CHOOSE_SOURCE_FILES_STEP, ChooseSourceCodeSummaryView.class);
        SUMMARY_CLASSES.put(CoderStepModel.REVIEW_POTENTIAL_ISSUES_STEP, ScreenerSummaryView.class);
        SUMMARY_CLASSES.put(CoderStepModel.DEFINE_INPUT_TYPES_STEP, DefineInputTypesSummaryView.class);
        SUMMARY_CLASSES.put(CoderStepModel.CONVERT_TO_FIXED_POINT_STEP, FixedPointSummaryView.class);
        SUMMARY_CLASSES.put(CoderStepModel.HDL_CHOOSE_TARGET_STEP, ChooseTargetSummaryView.class);
        SUMMARY_CLASSES.put(CoderStepModel.GENERATE_CODE_STEP, GenerateCodeSummaryView.class);
        SUMMARY_CLASSES.put(CoderStepModel.HDL_GENERATE_CODE_STEP, GenerateCodeSummaryView.class);
        SUMMARY_CLASSES.put(CoderStepModel.HDL_SYNTHESIS_STEP, SynthesisSummaryView.class);
    }
}

