/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.app.TaskListener;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.AnimationUtils;
import com.mathworks.toolbox.coder.wfa.core.CardboardCutout;
import com.mathworks.toolbox.coder.wfa.core.NavigationBar;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.core.StepModelAdapter;
import com.mathworks.toolbox.coder.wfa.core.StepView;
import com.mathworks.toolbox.coder.wfa.core.StepViewFactory;
import com.mathworks.toolbox.coder.wfa.toolbar.WorkflowToolbar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class WorkflowAdvisor {
    private final MJPanel fComponent;
    private final MJPanel fContentWrapper;
    private final StepModel fModel;
    private final CoderApp fApp;
    private final StepViewFactory fViewFactory;
    private final WorkflowToolbar fToolbar;
    private final NavigationBar fBackBar;
    private final NavigationBar fNextBar;
    private final Map<Step, CardboardCutout> fCardboardCutouts;
    private Step fSelectedStep;
    private double fTransitionRatio;
    private Step fNextSelectedStep;
    private boolean fSuppressBarWidthUpdate;

    public WorkflowAdvisor(CoderApp coderApp, final StepModel stepModel, StepViewFactory stepViewFactory) {
        this.fApp = coderApp;
        this.fViewFactory = stepViewFactory;
        this.fModel = stepModel;
        this.fCardboardCutouts = new HashMap<Step, CardboardCutout>();
        this.fToolbar = new WorkflowToolbar(coderApp, this);
        this.fBackBar = new NavigationBar(coderApp, this.fModel, true);
        this.fNextBar = new NavigationBar(coderApp, this.fModel, false);
        this.fTransitionRatio = 1.0;
        this.fApp.setAdvisor(this);
        this.fContentWrapper = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                if (WorkflowAdvisor.this.fSelectedStep != null) {
                    this.doLayout(WorkflowAdvisor.this.fSelectedStep, WorkflowAdvisor.this.fTransitionRatio <= 0.5 || WorkflowAdvisor.this.fTransitionRatio == 1.0 || WorkflowAdvisor.this.fSelectedStep == StepModel.OVERVIEW);
                }
                if (WorkflowAdvisor.this.fNextSelectedStep != null) {
                    this.doLayout(WorkflowAdvisor.this.fNextSelectedStep, WorkflowAdvisor.this.fTransitionRatio > 0.5 || WorkflowAdvisor.this.fNextSelectedStep == StepModel.OVERVIEW);
                }
            }

            public void paintComponent(Graphics graphics) {
                graphics.setColor(UIManager.getColor("control"));
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }

            private void doLayout(Step step, boolean bl) {
                StepView stepView = WorkflowAdvisor.this.fViewFactory.getView(step, WorkflowAdvisor.this.fModel);
                Component component = stepView.getComponent();
                Dimension dimension = stepView.getComponent().getPreferredSize();
                dimension.width = Math.min(dimension.width, this.getWidth());
                dimension.height = Math.min(dimension.height, this.getHeight());
                if (stepView.shouldStretch()) {
                    dimension.width = this.getWidth();
                    dimension.height = this.getHeight();
                }
                int n = 0;
                int n2 = 0;
                int n3 = this.getWidth() / 2 - dimension.width / 2;
                int n4 = this.getHeight() / 2 - dimension.height / 2;
                if (WorkflowAdvisor.this.fTransitionRatio < 1.0) {
                    component = (Component)WorkflowAdvisor.this.fCardboardCutouts.get(step);
                    if (WorkflowAdvisor.this.fNextSelectedStep != null && WorkflowAdvisor.this.fSelectedStep != null) {
                        n = stepModel.isAfter(WorkflowAdvisor.this.fNextSelectedStep, WorkflowAdvisor.this.fSelectedStep) ? (n += (int)(step == WorkflowAdvisor.this.fNextSelectedStep ? (double)this.getWidth() - WorkflowAdvisor.this.fTransitionRatio * (double)this.getWidth() : -WorkflowAdvisor.this.fTransitionRatio * (double)this.getWidth())) : (n += (int)(step == WorkflowAdvisor.this.fNextSelectedStep ? (double)(-this.getWidth()) + WorkflowAdvisor.this.fTransitionRatio * (double)this.getWidth() : WorkflowAdvisor.this.fTransitionRatio * (double)this.getWidth()));
                    }
                }
                if (!bl) {
                    n -= dimension.width + 1;
                }
                ((Component)component).setVisible(bl);
                component.setBounds(n3 + n, n4 + n2, Math.min(this.getWidth(), dimension.width), Math.min(this.getHeight(), dimension.height));
            }

            public Dimension getPreferredSize() {
                return WorkflowAdvisor.this.fSelectedStep == null ? new Dimension(0, 0) : WorkflowAdvisor.this.fViewFactory.getView(WorkflowAdvisor.this.fSelectedStep, WorkflowAdvisor.this.fModel).getComponent().getPreferredSize();
            }
        };
        this.fContentWrapper.setLayout(null);
        this.fComponent = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                Dimension dimension = WorkflowAdvisor.this.fToolbar.getComponent().getPreferredSize();
                Dimension dimension2 = WorkflowAdvisor.this.fBackBar.getComponent().getPreferredSize();
                Dimension dimension3 = WorkflowAdvisor.this.fNextBar.getComponent().getPreferredSize();
                WorkflowAdvisor.this.fToolbar.getComponent().setBounds(0, 0, this.getWidth(), dimension.height);
                boolean bl = WorkflowAdvisor.this.fSelectedStep != null && WorkflowAdvisor.this.fViewFactory.getView(WorkflowAdvisor.this.fSelectedStep, WorkflowAdvisor.this.fModel).needsNarrowNavigationBars();
                int n = bl ? dimension2.width : 24;
                int n2 = bl ? dimension3.width : 24;
                WorkflowAdvisor.this.fContentWrapper.setBounds(n, dimension.height, this.getWidth() - n - n2, this.getHeight() - dimension.height);
                WorkflowAdvisor.this.fBackBar.getComponent().setBounds(0, dimension.height, dimension2.width, this.getHeight() - dimension.height);
                WorkflowAdvisor.this.fNextBar.getComponent().setBounds(this.getWidth() - dimension3.width, dimension.height, dimension3.width, this.getHeight() - dimension.height);
            }
        };
        this.fComponent.setLayout(null);
        this.fComponent.add((Component)this.fToolbar.getComponent());
        this.fComponent.add((Component)this.fContentWrapper);
        this.fComponent.add((Component)this.fBackBar.getComponent());
        this.fComponent.add((Component)this.fNextBar.getComponent());
        this.fComponent.setComponentZOrder((Component)this.fBackBar.getComponent(), 0);
        this.fComponent.setComponentZOrder((Component)this.fNextBar.getComponent(), 0);
        this.fComponent.setComponentZOrder((Component)this.fContentWrapper, 1);
        this.fComponent.setComponentZOrder((Component)this.fToolbar.getComponent(), 1);
        for (Step step : this.fModel.getSteps()) {
            this.fModel.refreshCompletion(step);
        }
        Step step = this.fApp.getModel().getCurrentWorkflowStep(this.fModel);
        if (step != null) {
            this.autoAdvance(step);
        } else {
            this.fToolbar.showOverview();
        }
        stepModel.addStepModelListener(new StepModelAdapter(){

            @Override
            public void stepSelected(Step step, boolean bl) {
                WorkflowAdvisor.this.hideOverview();
                WorkflowAdvisor.this.select(stepModel.getCurrentStep(), bl);
            }

            @Override
            public void stepCompletionChanged(Step step, boolean bl) {
                if (step == WorkflowAdvisor.this.fSelectedStep) {
                    WorkflowAdvisor.this.fNextBar.setVisible(bl && WorkflowAdvisor.this.fModel.getNextStep() != null, true);
                }
            }
        });
        this.fApp.getIDEView().addInstallListener(new Runnable(){

            @Override
            public void run() {
                WorkflowAdvisor.this.updateBarWidth();
            }
        });
        this.fNextBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowAdvisor.this.getApp().getEditManager().saveAll();
            }
        });
        this.fApp.getIDEView().getCodeInfoView().getOutputPane().addTaskListener(new TaskListener(){

            @Override
            public void taskStarted(String string) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WorkflowAdvisor.this.fNextBar.setEnabled(false);
                        WorkflowAdvisor.this.fBackBar.setEnabled(false);
                        WorkflowAdvisor.this.fToolbar.getOverviewButton().setNavigationEnabled(false);
                    }
                });
            }

            private void taskEnded() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WorkflowAdvisor.this.fNextBar.setEnabled(true);
                        WorkflowAdvisor.this.fBackBar.setEnabled(true);
                        WorkflowAdvisor.this.fToolbar.getOverviewButton().setNavigationEnabled(true);
                    }
                });
            }

            @Override
            public void taskSucceeded(String string) {
                this.taskEnded();
            }

            @Override
            public void taskFailed(String string) {
                this.taskEnded();
            }

            @Override
            public void taskCanceled(String string) {
                this.taskEnded();
            }
        });
    }

    public WorkflowToolbar getToolbar() {
        return this.fToolbar;
    }

    public CoderApp getApp() {
        return this.fApp;
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public StepModel getModel() {
        return this.fModel;
    }

    private void select(final Step step, final boolean bl) {
        HintPopupFrame.closeAllPopups();
        if (this.fSelectedStep == null) {
            this.finishSelect(step, bl);
        } else {
            boolean bl2;
            boolean bl3 = bl2 = this.fSelectedStep == StepModel.OVERVIEW;
            if (this.fSelectedStep.equals(step)) {
                this.fToolbar.hideOverview();
                return;
            }
            if (this.fSelectedStep == StepModel.OVERVIEW) {
                this.updateBarVisibility(step);
            }
            if (step == StepModel.OVERVIEW) {
                this.fSuppressBarWidthUpdate = true;
            } else if (bl) {
                this.fSuppressBarWidthUpdate = false;
            }
            this.fToolbar.getComponent().requestFocus();
            this.fNextSelectedStep = step;
            AnimationTrack animationTrack = AnimationTrack.ACCELERATING;
            if (step == StepModel.OVERVIEW || this.fSelectedStep == StepModel.OVERVIEW) {
                animationTrack = AnimationTrack.SLOW_ACCELERATING;
            }
            CardboardCutout cardboardCutout = new CardboardCutout(this.fViewFactory.getView(this.fSelectedStep, this.fModel).getComponent());
            CardboardCutout cardboardCutout2 = new CardboardCutout(this.fViewFactory.getView(this.fNextSelectedStep, this.fModel).getComponent());
            this.fCardboardCutouts.put(this.fSelectedStep, cardboardCutout);
            this.fCardboardCutouts.put(this.fNextSelectedStep, cardboardCutout2);
            this.fContentWrapper.removeAll();
            this.fContentWrapper.add((Component)((Object)cardboardCutout));
            this.fContentWrapper.add((Component)((Object)cardboardCutout2));
            this.fContentWrapper.setComponentZOrder((Component)((Object)cardboardCutout2), 0);
            this.fContentWrapper.setComponentZOrder((Component)((Object)cardboardCutout), 1);
            this.fTransitionRatio = 0.0;
            this.fContentWrapper.revalidate();
            this.fContentWrapper.repaint();
            if (bl2) {
                this.fTransitionRatio = 1.0;
                this.finishSelect(step, bl);
                this.fContentWrapper.revalidate();
                this.fContentWrapper.repaint();
                this.animateOverviewCollapse();
            } else {
                this.fApp.getAnimator().animate(animationTrack, new Animation(){

                    @Override
                    public void step(double d) {
                        WorkflowAdvisor.this.fTransitionRatio = d;
                        WorkflowAdvisor.this.fContentWrapper.revalidate();
                        WorkflowAdvisor.this.fContentWrapper.repaint();
                        if (d == 1.0) {
                            WorkflowAdvisor.this.finishSelect(step, bl);
                        }
                    }
                });
            }
        }
    }

    private void finishSelect(final Step step, final boolean bl) {
        StepView stepView;
        this.fToolbar.getOverviewButton().setNavigationEnabled(step != StepModel.OVERVIEW);
        StepView stepView2 = this.fViewFactory.getView(step, this.fModel);
        this.updateBarVisibility(step);
        if (this.fSelectedStep != null && (stepView = this.fViewFactory.getView(this.fSelectedStep, this.fModel)) != null) {
            stepView.deactivate();
        }
        this.fCardboardCutouts.remove(this.fSelectedStep);
        this.fCardboardCutouts.remove(this.fNextSelectedStep);
        this.fSelectedStep = step;
        this.fApp.getModel().setCurrentWorkflowStep(step);
        this.fNextSelectedStep = null;
        this.fTransitionRatio = 1.0;
        this.fToolbar.setHeadlineText(this.fSelectedStep.getName(this.fApp.getModel()));
        this.fToolbar.setStepComponents(new ArrayList(0));
        this.fContentWrapper.removeAll();
        this.fContentWrapper.add((Component)stepView2.getComponent());
        this.fContentWrapper.revalidate();
        this.fContentWrapper.repaint();
        if (step != StepModel.OVERVIEW) {
            this.fToolbar.hideOverview();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkflowAdvisor.this.fViewFactory.getView(step, WorkflowAdvisor.this.fModel).activate(WorkflowAdvisor.this.fToolbar.getContext(step), bl);
                WorkflowAdvisor.this.updateBarWidth();
                if (WorkflowAdvisor.this.fSelectedStep != StepModel.OVERVIEW) {
                    WorkflowAdvisor.this.fSuppressBarWidthUpdate = false;
                }
            }
        });
    }

    private void autoAdvance(Step step) {
        for (Step step2 : this.fModel.getSteps()) {
            this.fViewFactory.getView(step2, this.fModel);
            if (step2 != step) continue;
            break;
        }
        this.fModel.setCurrentStep(step, false);
        this.finishSelect(step, false);
    }

    private void updateBarVisibility(Step step) {
        if (step == null) {
            return;
        }
        if (step == StepModel.OVERVIEW) {
            this.fBackBar.setVisible(false, false);
            this.fNextBar.setVisible(false, false);
        } else {
            this.fBackBar.setVisible(step != this.fModel.getSteps().iterator().next(), true);
            this.fNextBar.setVisible(this.fModel.isCompleted(step) && this.fModel.getNextStep() != null, true);
        }
    }

    private void updateBarWidth() {
        if (!this.fSuppressBarWidthUpdate) {
            StepView stepView = this.fViewFactory.getView(this.fSelectedStep, this.fModel);
            boolean bl = stepView.needsNarrowNavigationBars();
            this.fBackBar.setNarrow(bl);
            this.fNextBar.setNarrow(bl);
        }
    }

    public boolean showOverview() {
        if (this.fSelectedStep == null) {
            this.select(StepModel.OVERVIEW, true);
            return true;
        }
        return false;
    }

    public StepView getSelectedView() {
        return this.fViewFactory.getView(this.fSelectedStep, this.fModel);
    }

    public StepView getOverview() {
        return this.fViewFactory.getView(StepModel.OVERVIEW, this.fModel);
    }

    public void hideOverview() {
        this.fViewFactory.getView(this.fSelectedStep, this.fModel).closeSheet(this.fViewFactory.getView(StepModel.OVERVIEW, this.fModel).getComponent());
    }

    public Step getSelectedStep() {
        return this.fSelectedStep;
    }

    public void dispose() {
        this.fViewFactory.dispose();
    }

    private void animateOverviewCollapse() {
        AnimationUtils.animateMoveInGlassPane(this.fApp.getAnimator(), this.fApp.getGlassPaneManager(), this.fApp.getWindow(), new Rectangle(100, 100, this.fComponent.getWidth() - 200, this.fComponent.getHeight() - 200), (Component)this.fComponent, this.fToolbar.getOverviewButton().getBounds(), this.fToolbar.getComponent());
    }
}

