/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.toolbox.coder.wfa.files.FileScopedNode;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Icon;

public abstract class AbstractExpansionContext
implements ExpansionContext<FileScopedNode> {
    private final Collection<ExpansionChangeListener<FileScopedNode>> fListeners;
    private final FileScopedNode fNode;

    AbstractExpansionContext(FileScopedNode fileScopedNode, Class<?> clazz) {
        IllegalArgumentException illegalArgumentException = null;
        if (fileScopedNode != null && clazz != null && !clazz.isAssignableFrom(fileScopedNode.getValueType())) {
            illegalArgumentException = new IllegalArgumentException(String.format("Node value type mismatch: Expected %s but found %s", clazz, fileScopedNode.getValueType()));
        }
        if (illegalArgumentException != null) {
            throw illegalArgumentException;
        }
        this.fNode = fileScopedNode;
        this.fListeners = new LinkedList<ExpansionChangeListener<FileScopedNode>>();
    }

    AbstractExpansionContext(FileScopedNode fileScopedNode) {
        this(fileScopedNode, null);
    }

    public FileScopedNode createChildPlaceholder() {
        return new FileScopedNode(this.getItem(), "...");
    }

    public FileScopedNode getItem() {
        return this.fNode;
    }

    public Icon getOpenIcon(FileScopedNode fileScopedNode) {
        return null;
    }

    public void addListener(ExpansionChangeListener<FileScopedNode> expansionChangeListener) {
        this.fListeners.add(expansionChangeListener);
    }

    public void removeListener(ExpansionChangeListener<FileScopedNode> expansionChangeListener) {
        this.fListeners.remove(expansionChangeListener);
    }

    public void close() {
    }

    public void refresh() {
    }

    protected void fireExpansionChange(GroupingTableTransaction<FileScopedNode> groupingTableTransaction) {
        for (ExpansionChangeListener<FileScopedNode> expansionChangeListener : this.fListeners) {
            expansionChangeListener.childrenChanged(groupingTableTransaction);
        }
    }

    protected void firePopulationStateChanged() {
        for (ExpansionChangeListener<FileScopedNode> expansionChangeListener : this.fListeners) {
            expansionChangeListener.hasChildrenChanged();
        }
    }
}

