/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.fixedpoint;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.DefaultTestHarnessAdapter;
import com.mathworks.toolbox.coder.app.TestHarness;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointController;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.wfa.core.CustomCommandWindow;
import com.mathworks.toolbox.coder.wfa.core.PopupBarOptionPanel;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;

public final class FixedPointTestOptionPanel
extends PopupBarOptionPanel {
    private final CoderApp fApp;
    private final FixedPointController fController;
    private final CustomCommandWindow fCommandWindow;
    private final TestHarness fTestHarness;

    public FixedPointTestOptionPanel(CoderApp coderApp, FixedPointController fixedPointController, MJToggleButton mJToggleButton, final Runnable runnable) {
        super(mJToggleButton);
        this.fApp = coderApp;
        this.fController = fixedPointController;
        this.getContentPane().setLayout((LayoutManager)new FormLayout("3dlu, 200px:grow, 3dlu, fill:d, 3dlu, fill:d, 3dlu, fill:d", "1dlu:grow, center:d, 1dlu:grow"));
        this.fCommandWindow = new CustomCommandWindow(coderApp.getModel().getTestSnippets()){

            @Override
            protected void run(String string, final Runnable runnable2) {
                FixedPointTestOptionPanel.this.runAction(new Runnable(){

                    @Override
                    public void run() {
                        runnable2.run();
                        runnable.run();
                    }
                });
            }
        };
        this.fCommandWindow.setUseBusyAffordance(false);
        this.fTestHarness = new TestHarness(coderApp.getModel(), new DefaultTestHarnessAdapter(this.fCommandWindow));
        Component component = this.fApp.createWidget(this.fController.getData().getVerificationLoggingKey());
        Component component2 = this.fApp.createWidget(this.fController.getData().getOverflowDetectionKey());
        CellConstraints cellConstraints = new CellConstraints();
        this.getContentPane().add((Component)this.fCommandWindow.getComponent(), (Object)cellConstraints.xy(2, 2));
        this.getContentPane().add(component, (Object)cellConstraints.xy(4, 2));
        this.getContentPane().add(component2, (Object)cellConstraints.xy(6, 2));
    }

    @Override
    public void activate() {
        this.fCommandWindow.activate();
    }

    @Override
    public String getCloseButtonText() {
        return CoderResources.getString("f2f.find.done");
    }

    @Override
    protected void runAction() {
        this.fCommandWindow.run();
    }

    private void runAction(final Runnable runnable) {
        String string = this.fCommandWindow.getText().trim();
        if (!string.isEmpty()) {
            this.fApp.getModel().getTestSnippets().add(string);
            this.fTestHarness.createContext(this.fCommandWindow.getText(), TestBenchRunMode.RUN_ORIGINAL, new ParameterRunnable<TestHarness.TestBenchContext>(){

                public void run(final TestHarness.TestBenchContext testBenchContext) {
                    Runnable runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            FixedPointTestOptionPanel.this.fController.testNumerics(Arrays.asList(testBenchContext.getConfig().getTestBenchFile()), testBenchContext.isSynthetic(), new Runnable(){

                                @Override
                                public void run() {
                                    testBenchContext.dispose();
                                    if (runnable != null) {
                                        runnable.run();
                                    }
                                }
                            });
                        }
                    };
                    if (FixedPointTestOptionPanel.this.fController.getStatus().needsValidation()) {
                        FixedPointTestOptionPanel.this.fController.validateTypes(true, runnable2);
                    } else {
                        runnable2.run();
                    }
                }
            }, this.fApp.getIDEView().getCodeInfoView().getOutputPane());
        }
    }

    @Override
    protected boolean shouldStretch() {
        return true;
    }
}

