/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.fixedpoint;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.SourceSet;
import com.mathworks.toolbox.coder.app.ide.AbstractCodeInfoView;
import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.EditorViewContentEvent;
import com.mathworks.toolbox.coder.app.ide.EditorViewContentListener;
import com.mathworks.toolbox.coder.app.ide.FileSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.FunctionSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.IDEContext;
import com.mathworks.toolbox.coder.app.ide.IDEFileSidebar;
import com.mathworks.toolbox.coder.app.ide.IDELayout;
import com.mathworks.toolbox.coder.app.ide.IDEView;
import com.mathworks.toolbox.coder.fixedpoint.AdvancedSettingsTable;
import com.mathworks.toolbox.coder.fixedpoint.AnalysisTable;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.ConversionStatusManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointBuildManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointController;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapterFactory;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointToolPanel;
import com.mathworks.toolbox.coder.fixedpoint.FunctionSelector;
import com.mathworks.toolbox.coder.fixedpoint.GlobalFixedPointRegistry;
import com.mathworks.toolbox.coder.fixedpoint.replace.ExpandedReplacementsTable;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.CodeCoverageModel;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.AbstractCoderStepView;
import com.mathworks.toolbox.coder.wfa.build.BuildButton;
import com.mathworks.toolbox.coder.wfa.core.ActionButton;
import com.mathworks.toolbox.coder.wfa.core.DescriptionLabel;
import com.mathworks.toolbox.coder.wfa.core.DropDownButton;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.files.CallTreeFileSetView;
import com.mathworks.toolbox.coder.wfa.files.FileSetView;
import com.mathworks.toolbox.coder.wfa.fixedpoint.ComputeDerivedRangesButton;
import com.mathworks.toolbox.coder.wfa.fixedpoint.FixedPointAppFacet;
import com.mathworks.toolbox.coder.wfa.fixedpoint.FixedPointTestOptionPanel;
import com.mathworks.toolbox.coder.wfa.fixedpoint.RunSimulationButton;
import com.mathworks.toolbox.coder.wfa.fixedpoint.SimulationOptionPanel;
import com.mathworks.toolbox.coder.wfa.fixedpoint.StaticAnalysisOptionPanel;
import com.mathworks.toolbox.coder.wfa.toolbar.SaveButton;
import com.mathworks.toolbox.coder.wfa.toolbar.Separator;
import com.mathworks.toolbox.coder.wfa.toolbar.SettingsButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import com.mathworks.toolbox.coder.wfa.verification.TestDropDownButton;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.ReturnRunnable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FixedPointView
extends AbstractCoderStepView {
    private static final String PARAM_CONVERSION_VIEW_ENABLED = "param.EnableFixedPointStep";
    private final AbstractCodeInfoView fCodeInfoView;
    private final FixedPointBuildManager fBuildManager;
    private final FixedPointDataAdapter fDataAdapter;
    private final MJToggleButton fSettingsButton;
    private final MJButton fBuildButton;
    private final DropDownButton fRunSimulationButton;
    private final DropDownButton fComputeDerivedRangesButton;
    private final TestDropDownButton fTestButton;
    private final AdvancedSettingsTable fSettingsTable;
    private final ConversionModel fConversionModel;
    private final CodeCoverageModel fCoverageModel;
    private final FixedPointController fController;
    private final ExpandedReplacementsTable fFunctionReplacementsTable;
    private final AnalysisTable fAnalysisTable;
    private final StaticAnalysisOptionPanel fStaticAnalysisOptions;
    private final SimulationOptionPanel fSimulationOptions;
    private final FixedPointTestOptionPanel fTestOptions;
    private final List<Component> fToolbarComponents;
    private final Context fContext;
    private final FunctionScopedEntityLocator fEntityLocator;
    private final ParameterRunnable<SourceSet> fPrimarySourceObserver;
    private final PropertyChangeListener fEditManagerListener;
    private final ChangeListener fScreenerListener;
    private final FixedPointAppFacet fFacetModel;
    private ToolbarContext fToolbarContext;
    private Runnable fDeactivationRunnable;
    private boolean fInitialBuildStarted;
    private boolean fTableInitialized;
    private boolean fConversionExplicitlySet;
    private boolean fBuildSucceeded;
    private boolean fAlreadyReadyBefore;
    private boolean fSimmedOrDerived;
    private boolean fGlobalDisable;
    private boolean fActive;
    private static final String TABLE_TAB_KEY = "f2f-table";

    public FixedPointView(CoderApp coderApp, StepModel stepModel, Step step) {
        super(coderApp, stepModel, step);
        this.fDataAdapter = FixedPointDataAdapterFactory.create(coderApp.getModel().getConfiguration());
        this.fConversionModel = new ConversionModel();
        this.fFacetModel = this.getApp().getModel().getInstalledFacet(FixedPointAppFacet.class);
        if (this.fFacetModel == null) {
            throw new IllegalStateException("FixedPointAppFacet is not installed");
        }
        this.fFacetModel.bind(this, this.fDataAdapter);
        File file = (File)this.getApp().getModel().getEntryPointFileSet().getFiles().iterator().next();
        this.fCodeInfoView = coderApp.getIDEView().getCodeInfoView();
        ConversionStatusManager conversionStatusManager = new ConversionStatusManager(this.fDataAdapter, this.fConversionModel);
        this.fFunctionReplacementsTable = new ExpandedReplacementsTable(this.fConversionModel.getFunctionReplacementsModel(), this.fConversionModel, coderApp);
        this.fConversionModel.getFunctionReplacementsModel().setScreener(this.getApp().getModel().getScreenerModel());
        this.fConversionModel.getFunctionReplacementsModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FixedPointView.this.fConversionModel.serialize(FixedPointView.this.fDataAdapter);
            }
        });
        this.fAnalysisTable = new AnalysisTable(this.fDataAdapter, conversionStatusManager, this.fConversionModel, new FunctionSelector(){

            @Override
            public void select(Function function) {
                FixedPointView.this.fContext.select(new FunctionSelectionEvent(FixedPointView.this.fAnalysisTable, function));
            }
        }, coderApp.getPopupBarManager(), file, coderApp, new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.reset(true);
            }
        });
        this.fEntityLocator = new FunctionScopedEntityLocator(this.getApp().getModel(), this.fConversionModel);
        this.fContext = new Context();
        this.fContext.addSelector(this.fAnalysisTable);
        this.fContext.setVisibleFileSetKeys("input-files");
        this.fBuildManager = new FixedPointBuildManager(this.fDataAdapter, file, this.fContext, this.fConversionModel, new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.fConversionModel.fireQueuedPropertyChanges();
            }
        }, new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.enterReadyState();
                FixedPointView.this.fConversionModel.fireQueuedPropertyChanges();
            }
        }, new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.fConversionModel.setExpressions(Collections.emptyList());
                FixedPointView.this.initializeTable();
                FixedPointView.this.fConversionModel.fireQueuedPropertyChanges();
                FixedPointView.this.selectDefaultFunction();
            }
        });
        this.fCoverageModel = new CodeCoverageModel(this.fDataAdapter);
        GlobalFixedPointRegistry.getInstance().registerInstance(this.fDataAdapter, coderApp);
        this.fController = new FixedPointController(this.fDataAdapter, this.fConversionModel, conversionStatusManager, this.fBuildManager, this.fCoverageModel, this.fAnalysisTable, this.fContext, this.fCodeInfoView.getPopupBarManager(), this.fCodeInfoView.getNotificationManager(), TABLE_TAB_KEY, new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.fAnalysisTable.stopEditing();
            }
        }, this.createPostDeriveRunnable(), this.createSidebarErrorHandler());
        this.fAnalysisTable.setProposedTypeUpdater(this.fController.getProposedTypesUpdater());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.fContext.activateTab(FixedPointView.TABLE_TAB_KEY);
                FixedPointView.this.fContext.setCoverageModel(FixedPointView.this.fCoverageModel);
                FixedPointView.this.fSimmedOrDerived = true;
                FixedPointView.this.updateActionState();
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.saveAllEditedFiles();
                FixedPointView.this.fSimulationOptions.runAction();
            }
        };
        ReturnRunnable<Boolean> returnRunnable = new ReturnRunnable<Boolean>(){

            public Boolean run() {
                String string = FixedPointView.this.getApp().getModel().getTestSnippets().getLastCommand();
                return string != null && !string.trim().isEmpty();
            }
        };
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.saveAllEditedFiles();
                FixedPointView.this.fController.runStaticAnalysis(new ParameterRunnable<Boolean>(){

                    public void run(Boolean bl) {
                        if (bl.booleanValue()) {
                            FixedPointView.this.fController.prepareForStaticAnalysis(true);
                        }
                    }
                });
            }
        };
        Runnable runnable4 = new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.saveAllEditedFiles();
                FixedPointView.this.fTestOptions.runAction();
            }
        };
        this.fRunSimulationButton = new RunSimulationButton(this.getApp(), runnable2, returnRunnable);
        this.fComputeDerivedRangesButton = new ComputeDerivedRangesButton(runnable3);
        this.fTestButton = new TestDropDownButton(this.getApp(), runnable4, returnRunnable);
        this.fSettingsButton = new SettingsButton();
        this.fBuildButton = new BuildButton(true);
        this.fSettingsTable = new AdvancedSettingsTable(this.fController.getData(), this.getApp().getModel().getGenericArtifact() != GenericArtifact.FIXED_POINT);
        this.fSimulationOptions = new SimulationOptionPanel(coderApp, this.fController, this.fRunSimulationButton, runnable);
        this.fTestOptions = new FixedPointTestOptionPanel(coderApp, this.fController, this.fTestButton, new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.displayConvertedFiles();
            }
        });
        this.fStaticAnalysisOptions = new StaticAnalysisOptionPanel(coderApp, this.fController, this.fComputeDerivedRangesButton, null);
        final List<DropDownButton> list = Arrays.asList(this.fRunSimulationButton, this.fComputeDerivedRangesButton, this.fTestButton);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource().equals(FixedPointView.this.fRunSimulationButton) && FixedPointView.this.fRunSimulationButton.isSelected()) {
                    FixedPointView.this.fAnalysisTable.hideMissingDesignRangeHint();
                    FixedPointView.deselectOthers(this, FixedPointView.this.fRunSimulationButton, list);
                    FixedPointView.this.getApp().getPopupBarManager().show(FixedPointView.this.fSimulationOptions);
                } else if (itemEvent.getSource().equals(FixedPointView.this.fComputeDerivedRangesButton) && FixedPointView.this.fComputeDerivedRangesButton.isSelected()) {
                    FixedPointView.deselectOthers(this, FixedPointView.this.fComputeDerivedRangesButton, list);
                    FixedPointView.this.getApp().getPopupBarManager().show(FixedPointView.this.fStaticAnalysisOptions);
                } else if (itemEvent.getSource().equals(FixedPointView.this.fTestButton) && FixedPointView.this.fTestButton.isSelected()) {
                    FixedPointView.deselectOthers(this, FixedPointView.this.fTestButton, list);
                    FixedPointView.this.getApp().getPopupBarManager().show(FixedPointView.this.fTestOptions);
                } else if (itemEvent.getSource().equals(FixedPointView.this.fSettingsButton) && FixedPointView.this.fSettingsButton.isSelected()) {
                    FixedPointView.deselectOthers(this, FixedPointView.this.fSettingsButton, list);
                } else if (!(FixedPointView.this.fRunSimulationButton.isSelected() || FixedPointView.this.fComputeDerivedRangesButton.isSelected() || FixedPointView.this.fTestButton.isSelected())) {
                    FixedPointView.this.getApp().getPopupBarManager().closePopup();
                }
                if (itemEvent.getSource().equals(FixedPointView.this.fSettingsButton)) {
                    FixedPointView.this.startSettingsExpandOrCollapse();
                }
            }
        };
        this.fComputeDerivedRangesButton.addItemListener(itemListener);
        this.fRunSimulationButton.addItemListener(itemListener);
        this.fTestButton.addItemListener(itemListener);
        this.fSettingsButton.addItemListener(itemListener);
        this.fToolbarComponents = new ArrayList<Component>();
        this.fToolbarComponents.add((Component)((Object)new SaveButton(coderApp)));
        this.fToolbarComponents.add((Component)((Object)new Separator()));
        this.fToolbarComponents.add((Component)this.fSettingsButton);
        this.fToolbarComponents.add((Component)((Object)this.fRunSimulationButton));
        this.fToolbarComponents.add((Component)((Object)this.fComputeDerivedRangesButton));
        this.fToolbarComponents.add((Component)((Object)new Separator()));
        this.fToolbarComponents.add((Component)this.fBuildButton);
        this.fToolbarComponents.add((Component)((Object)this.fTestButton));
        coderApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("generic-artifact") && !FixedPointView.this.fConversionExplicitlySet && FixedPointView.this.getApp().getModel().getGenericArtifact() == GenericArtifact.FIXED_POINT) {
                    FixedPointView.this.setConversionEnabled(true);
                } else if (FixedPointView.this.fSettingsTable.isProposedTypeInputChange(propertyChangeEvent)) {
                    FixedPointView.this.fController.updateProposedTypes();
                }
            }
        });
        this.fCodeInfoView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FixedPointView.this.updateActionState();
            }
        });
        this.fBuildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FixedPointView.this.validateOrRedirect();
            }
        });
        final RequestFilter requestFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                FixedPointView.this.showRefreshButtonIfNecessary();
            }
        }, 1000);
        requestFilter.setName("Instrumented MEX Updater");
        this.fPrimarySourceObserver = new ParameterRunnable<SourceSet>(){

            public void run(SourceSet sourceSet) {
                requestFilter.request();
            }
        };
        this.fEditManagerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                requestFilter.request();
            }
        };
        this.fScreenerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!FixedPointView.this.fInitialBuildStarted) {
                    FixedPointView.this.fInitialBuildStarted = true;
                    FixedPointView.this.fBuildManager.doInitialBuildIfNecessary();
                }
            }
        };
        this.updateActionState();
    }

    private void validateOrRedirect() {
        this.saveAllEditedFiles();
        this.fBuildManager.checkInstrumentedMex(new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                if (bl.booleanValue()) {
                    FixedPointView.this.fBuildSucceeded = false;
                    FixedPointView.this.getApp().getIDEView().getCodeInfoView().getPopupBarManager().hideSpecialHint();
                    FixedPointView.this.fController.validateTypes(true, new Runnable(){

                        @Override
                        public void run() {
                            FixedPointView.this.displayConvertedFiles();
                            FixedPointView.this.fBuildSucceeded = true;
                            FixedPointView.this.updateActionState();
                            FixedPointView.this.resetForFreshData();
                            FixedPointView.this.fDeactivationRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    FixedPointView.this.fFacetModel.updateFixedPointSourceSet();
                                }
                            };
                        }
                    });
                } else {
                    FixedPointView.this.fSimmedOrDerived = false;
                    FixedPointView.this.updateActionState();
                    FixedPointView.this.getApp().getIDEView().getCodeInfoView().getPopupBarManager().showSpecialHint(CoderResources.getString("f2f.hint.stateOutdated"));
                }
            }
        });
    }

    private void resetForFreshData() {
        EditorView editorView = this.getApp().getIDEView().getCodeInfoView().getEditorView();
        editorView.getTextMapper().resetAll();
        editorView.getEntityLocator().reset();
    }

    private ParameterRunnable<Boolean> createPostDeriveRunnable() {
        return new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                FixedPointView.this.fSimmedOrDerived = FixedPointView.this.fSimmedOrDerived || bl != false;
            }
        };
    }

    private void installAppListeners() {
        this.getApp().getModel().getPrimarySourceSet().addSourceSetObserver(this.fPrimarySourceObserver);
        this.getApp().getEditManager().addPropertyChangeListener(this.fEditManagerListener);
        this.getApp().getModel().getScreenerModel().addChangeListener(this.fScreenerListener);
    }

    private void uninstallAppListeners() {
        this.getApp().getModel().getPrimarySourceSet().removeSourceSetObserver(this.fPrimarySourceObserver);
        this.getApp().getEditManager().removePropertyChangeListener(this.fEditManagerListener);
        this.getApp().getModel().getScreenerModel().removeChangeListener(this.fScreenerListener);
    }

    private void saveAllEditedFiles() {
        this.getApp().getEditManager().saveAll();
    }

    private void showRefreshButtonIfNecessary() {
        this.fBuildManager.checkInstrumentedMex(new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                if (!bl.booleanValue()) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (FixedPointView.this.fInitialBuildStarted) {
                                OutputPane outputPane = FixedPointView.this.getApp().getIDEView().getCodeInfoView().getOutputPane();
                                outputPane.showCustomAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        FixedPointView.this.saveAllEditedFiles();
                                        FixedPointView.this.fBuildManager.doInitialBuildIfNecessary();
                                    }
                                }, CoderResources.getString("f2f.task.refresh.buttonLabel"), null);
                            }
                        }
                    });
                }
            }
        });
    }

    private ParameterRunnable<Collection<BuildError>> createSidebarErrorHandler() {
        return new ParameterRunnable<Collection<BuildError>>(){

            public void run(Collection<BuildError> collection) {
                if (FixedPointView.this.fContext.getSidebar() != null) {
                    if (FixedPointView.this.fContext.getSidebar().getFunctionTreeView() != null) {
                        FixedPointView.this.fContext.getSidebar().getFunctionTreeView().setErrors(collection);
                    }
                    if (FixedPointView.this.fContext.getSidebar().getCallTreeView() != null) {
                        FixedPointView.this.fContext.getSidebar().getCallTreeView().setErrors(collection);
                    }
                    FixedPointView.this.updateFunctionView(FixedPointView.this.fContext.getSidebar());
                }
                FixedPointView.this.getApp().getIDEView().getCodeInfoView().getEditorView().setBuildErrors(new ArrayList<BuildError>(collection), true);
            }
        };
    }

    private void updateActionState() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean bl = !FixedPointView.this.fGlobalDisable && FixedPointView.this.fConversionModel.hasVariableNames() && !FixedPointView.this.fCodeInfoView.getOutputPane().isRunningTask();
                FixedPointView.this.fRunSimulationButton.setEnabled(bl);
                FixedPointView.this.fComputeDerivedRangesButton.setEnabled(bl);
                FixedPointView.this.fSettingsButton.setEnabled(bl);
                boolean bl2 = !FixedPointView.this.fGlobalDisable && FixedPointView.this.fSimmedOrDerived && FixedPointView.this.fConversionModel.hasVariableNames() && !FixedPointView.this.fCodeInfoView.getOutputPane().isRunningTask() && FixedPointView.this.fConversionModel.hasAllProposedTypes() && !FixedPointView.this.fCodeInfoView.getOutputPane().hasBuildErrors();
                FixedPointView.this.fBuildButton.setEnabled(bl2);
                FixedPointView.this.fTestButton.setEnabled(bl2 && FixedPointView.this.fBuildSucceeded);
            }
        });
    }

    @Override
    public void activate(ToolbarContext toolbarContext, boolean bl) {
        this.fActive = true;
        this.fToolbarContext = toolbarContext;
        this.getApp().getModel().setSuppressScreenerUpdate(true);
        if (bl) {
            this.setConversionEnabled(true);
            this.fConversionExplicitlySet = true;
        } else if (this.getApp().getModel().getGenericArtifact() == GenericArtifact.FIXED_POINT) {
            this.setConversionEnabled(true);
        }
        if (this.isConversionEnabled()) {
            this.getApp().setFixedPointController(this.fController);
            toolbarContext.setStepComponents(this.fToolbarComponents);
            this.installIDEView(this.fContext);
            IDEView iDEView = this.getApp().getIDEView();
            this.fContext.clearBanner();
            this.fAnalysisTable.hideMissingDesignRangeHint();
            this.fConversionModel.deserialize(this.fDataAdapter, false);
            if (iDEView.getFileSets().getSelectedFile() == null) {
                File file = (File)this.getApp().getModel().getEntryPointFileSet().getFiles().iterator().next();
                this.fContext.select(new FileSelectionEvent(null, file));
                this.fAnalysisTable.setSelectedFunction(this.fConversionModel.getEntryPointFunction(file));
            }
            if (!this.fInitialBuildStarted && this.getApp().getModel().getScreenerModel().getReportModel() != null) {
                this.fInitialBuildStarted = true;
                this.fBuildManager.doInitialBuildIfNecessary();
            }
        } else {
            this.getContentPane().removeAll();
            CellConstraints cellConstraints = new CellConstraints();
            this.getContentPane().setLayout((LayoutManager)new FormLayout("16dlu:grow, center:d, 16dlu:grow", "16dlu:grow, fill:d, 10dlu, fill:d, 16dlu:grow"));
            DescriptionLabel descriptionLabel = new DescriptionLabel(CoderResources.getString("wfa.fixedpoint.prompt"));
            ActionButton actionButton = new ActionButton(CoderResources.getString("wfa.fixedpoint.enable"), CoderResources.getIcon("fixedpoint.png"));
            this.getContentPane().add((Component)descriptionLabel.getComponent(), cellConstraints.xy(2, 2));
            this.getContentPane().add((Component)((Object)actionButton), cellConstraints.xy(2, 4));
            actionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FixedPointView.this.setConversionEnabled(true);
                    FixedPointView.this.fConversionExplicitlySet = true;
                    FixedPointView.this.fDataAdapter.setModeAutomatic(true);
                    FixedPointView.this.getContentPane().removeAll();
                    FixedPointView.this.activate(FixedPointView.this.fToolbarContext, true);
                }
            });
            actionButton.setFont(CoderApp.getFont().deriveFont(16.0f));
        }
        this.fFacetModel.viewActivated();
    }

    @Override
    public void deactivate() {
        this.fActive = false;
        this.saveAllEditedFiles();
        this.fFacetModel.viewDeactivated();
        this.fCodeInfoView.getEditorView().resetViewModifications();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fAnalysisTable.dispose();
        this.fFunctionReplacementsTable.dispose();
        this.fContext.dispose();
        GlobalFixedPointRegistry.getInstance().removeInstance(this.fDataAdapter);
    }

    @Override
    public boolean shouldStretch() {
        return true;
    }

    @Override
    protected String getHelpKey() {
        return this.fSettingsButton.isSelected() ? "help_button_fixed_point_settings" : "help_button_convert_to_fixed_point";
    }

    boolean isActive() {
        return this.fActive;
    }

    private void selectDefaultFunction() {
        Function function;
        if (this.fCodeInfoView.getEditorView().getCurrentFunction() != null) {
            function = this.fCodeInfoView.getEditorView().getCurrentFunction();
        } else if (this.fAnalysisTable.getSelectedFunction() != null) {
            function = this.fAnalysisTable.getSelectedFunction();
        } else {
            Set set;
            function = this.fContext.getSidebar().getSelectedFunction("input-files");
            if (function == null && !(set = this.getApp().getModel().getEntryPointFileSet().getFiles()).isEmpty()) {
                function = this.fConversionModel.getEntryPointFunction((File)set.iterator().next());
            }
        }
        if (function != null) {
            this.fContext.select(function);
            this.fAnalysisTable.setSelectedFunction(function);
            this.fCodeInfoView.getEditorView().displayFunction(function, false);
        }
    }

    private void enterReadyState() {
        this.initializeTable();
        if (this.fDataAdapter.isModeAutomatic() || this.getApp().getModel().getGenericArtifact() == GenericArtifact.FIXED_POINT) {
            this.fContext.addTab("functionReplacements", CoderResources.getString("f2f.tab.functionReplacements"), this.fFunctionReplacementsTable.getComponent());
        }
        if (!this.fAlreadyReadyBefore) {
            this.fContext.activateTab(TABLE_TAB_KEY);
            this.fAlreadyReadyBefore = true;
        }
    }

    private void reset(boolean bl) {
        if (!this.fTableInitialized) {
            return;
        }
        this.fConversionModel.reset(bl);
        this.fAnalysisTable.dataChanged();
        this.fDataAdapter.setSourceCodeChecksum(Double.toString(Math.random()));
        this.fDataAdapter.setValidationChecksum(Double.toString(Math.random()));
        this.fDataAdapter.setStaticAnalysisChecksum("");
        this.fCodeInfoView.getOutputPane().reset();
        new Matlab().evalConsoleOutput("coderprivate.Float2FixedManager.instance.resetEntireTable()");
    }

    private static void deselectOthers(ItemListener itemListener, MJToggleButton mJToggleButton, List<? extends MJToggleButton> list) {
        for (MJToggleButton mJToggleButton2 : list) {
            if (mJToggleButton2.equals(mJToggleButton)) continue;
            mJToggleButton2.removeItemListener(itemListener);
            mJToggleButton2.setSelected(false);
            mJToggleButton2.addItemListener(itemListener);
        }
    }

    private void initializeTable() {
        if (!this.fTableInitialized) {
            this.fContext.addTab(TABLE_TAB_KEY, CoderResources.getString("wfa.fixedpoint.table"), this.fAnalysisTable.getComponent());
            this.fTableInitialized = true;
        }
    }

    private void startSettingsExpandOrCollapse() {
        if (this.fSettingsButton.isSelected()) {
            this.displaySheet((Component)this.fSettingsTable.getComponent(), 0, true, true, new Runnable(){

                @Override
                public void run() {
                    FixedPointView.this.fSettingsButton.setSelected(false);
                }
            });
        } else {
            this.closeSheet(this.fSettingsTable.getComponent());
        }
    }

    private void displayConvertedFiles() {
        final TreeSet<File> treeSet = new TreeSet<File>();
        File file = this.getApp().getModel().getEntryPoint();
        File file2 = new File(file.getParentFile(), "codegen" + File.separator + new FileLocation(file).getNameBeforeDot() + File.separator + "fixpt");
        String string = new FileLocation(file).getNameBeforeDot() + this.fDataAdapter.getGeneratedFileSuffix();
        File file3 = null;
        File[] fileArray = file2.listFiles();
        if (fileArray != null) {
            for (File file4 : fileArray) {
                if (file4.isDirectory()) continue;
                treeSet.add(file4);
                if (file3 != null || !file4.getName().startsWith(string) || !CoderFileSupport.isMatlabSourceFile(file4)) continue;
                file3 = file4;
            }
        }
        File[] fileArray2 = file3;
        SwingUtilities.invokeLater(new Runnable((File)fileArray2){
            final /* synthetic */ File val$finalFileToSelect;
            {
                this.val$finalFileToSelect = file;
            }

            @Override
            public void run() {
                FixedPointView.this.fFacetModel.setFixedPointOutput(treeSet);
                if (this.val$finalFileToSelect != null) {
                    FixedPointView.this.fContext.select(new FileSelectionEvent(null, this.val$finalFileToSelect));
                }
            }
        });
    }

    private boolean isConversionEnabled() {
        return this.getApp().getModel().getGenericArtifact() == GenericArtifact.FIXED_POINT || this.getApp().getModel().getConfiguration().getParamAsBoolean(PARAM_CONVERSION_VIEW_ENABLED);
    }

    private void setConversionEnabled(boolean bl) {
        this.getApp().getModel().getConfiguration().setParamAsBoolean(PARAM_CONVERSION_VIEW_ENABLED, bl);
    }

    private static <T extends FileSetView> void runOnSidebarView(IDEFileSidebar iDEFileSidebar, Class<T> clazz, ParameterRunnable<T> parameterRunnable) {
        for (FileSetView fileSetView : iDEFileSidebar.getFileSetViewsByType(clazz)) {
            parameterRunnable.run((Object)fileSetView);
        }
    }

    private void updateFunctionView(IDEFileSidebar iDEFileSidebar) {
        if (iDEFileSidebar.getFunctionTreeView() != null) {
            iDEFileSidebar.getFunctionTreeView().setFunctions(this.fConversionModel.getFunctionsByFile());
        }
        iDEFileSidebar.toggleInputFlatViewState(!this.fConversionModel.getFunctions().isEmpty());
    }

    private void setAppCallTree(boolean bl) {
        this.getApp().getModel().setCallTree(bl ? this.fConversionModel.getCallTree() : null);
    }

    private void updateCallTreeView(IDEFileSidebar iDEFileSidebar) {
        FixedPointView.runOnSidebarView(iDEFileSidebar, CallTreeFileSetView.class, new ParameterRunnable<CallTreeFileSetView>(){

            public void run(CallTreeFileSetView callTreeFileSetView) {
                callTreeFileSetView.setCallTree(FixedPointView.this.fConversionModel.getCallTree());
            }
        });
        iDEFileSidebar.toggleCallTreeViewEnabled(this.fConversionModel.getCallTree() != null);
    }

    void setGlobalDisable(boolean bl) {
        if (this.fGlobalDisable != bl) {
            this.fGlobalDisable = bl;
            this.updateActionState();
        }
    }

    void showEntryPointAlteredDialog() {
        MJOptionPane.showMessageDialog((Component)this.getComponent(), (Object)MessageFormat.format(CoderResources.getString("f2f.warning.entryPointsChanged"), CoderResources.getString("wfa.inputTypes.title")), (String)CoderResources.getString("f2f.warning.entryPointsChanged.title"), (int)1);
    }

    private class Context
    extends IDEContext {
        private final EditorViewContentListener fContentListener;
        private final Predicate<Boolean> fActivationTest;
        private PropertyChangeListener fModelListener;
        private SourceSet fStartingSourceSet;

        private Context() {
            this.fActivationTest = new Predicate<Boolean>(){

                public boolean accept(Boolean bl) {
                    return bl == false;
                }
            };
            this.fContentListener = new EditorViewContentListener(){

                @Override
                public void handleEditorViewContentEvent(EditorViewContentEvent editorViewContentEvent) {
                    if (editorViewContentEvent.getSourceType().equals((Object)CodableEntity.Type.FUNCTION)) {
                        EditorView editorView = editorViewContentEvent.getEditorView();
                        Function function = (Function)editorViewContentEvent.getSource();
                        if (editorView.getCurrentFunction() != null && function != null || editorView.getCurrentFunction() == null && function == null) {
                            FixedPointView.this.fAnalysisTable.setSelectedFunction(function);
                        }
                    }
                }
            };
            this.setLocator(FixedPointView.this.fEntityLocator);
        }

        @Override
        public CodePopupController createCodePopupController(Window window, EditorView editorView) {
            return FixedPointToolPanel.createFixedPointPopupController(window, editorView, FixedPointView.this.fAnalysisTable);
        }

        @Override
        public void activate(final IDEFileSidebar iDEFileSidebar, IDELayout iDELayout, OutputPane outputPane, EditorView editorView) {
            super.activate(iDEFileSidebar, iDELayout, outputPane, editorView);
            editorView.setErrorsCloseable(true);
            FixedPointView.this.installAppListeners();
            iDEFileSidebar.setCurrentUnifiedModel(FixedPointView.this.fConversionModel);
            if (iDEFileSidebar.getFunctionTreeView() != null) {
                iDEFileSidebar.getFunctionTreeView().setFunctions(null);
            }
            FixedPointView.this.setAppCallTree(true);
            this.fStartingSourceSet = FixedPointView.this.getApp().getModel().getActiveInputSourceSet();
            FixedPointView.this.getApp().getModel().setActiveInputSourceSet(FixedPointView.this.getApp().getModel().getPrimarySourceSet().getKey());
            SourceSet sourceSet = FixedPointView.this.getApp().getModel().getFixedPointSourceSet();
            if (sourceSet != null) {
                sourceSet.addActivationPredicate(this.fActivationTest);
            }
            this.fModelListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("CallTree") || propertyChangeEvent.getPropertyName().equals("KeyTree")) {
                        FixedPointView.this.updateFunctionView(iDEFileSidebar);
                        FixedPointView.this.updateCallTreeView(iDEFileSidebar);
                        FixedPointView.this.setAppCallTree(true);
                        File file = FixedPointView.this.getApp().getModel().getEntryPoint();
                        EditorView editorView = FixedPointView.this.getApp().getIDEView().getCodeInfoView().getEditorView();
                        if (editorView.getCurrentFunction() == null && editorView.getCurrentFile() != null && editorView.getCurrentFile().equals(file)) {
                            editorView.displayFunction(new Function(file, new FileLocation(file).getNameBeforeDot()));
                        }
                    }
                    FixedPointView.this.resetForFreshData();
                }
            };
            FixedPointView.this.fConversionModel.addPropertyChangeListener(this.fModelListener);
            FixedPointView.this.updateFunctionView(iDEFileSidebar);
            FixedPointView.this.updateCallTreeView(iDEFileSidebar);
            FixedPointView.this.getApp().getIDEView().getCodeInfoView().getEditorView().setCloseFunctionConverter(new Converter<EditorLoadContext, Function>(){

                public Function convert(EditorLoadContext editorLoadContext) {
                    if (editorLoadContext.exists() && editorLoadContext.hasFile() && (FixedPointView.this.getApp().getModel().getActiveInputSourceSet().getFiles().contains(editorLoadContext.getFile()) || FixedPointView.this.getApp().getModel().getOutputFiles().contains(editorLoadContext.getFile()))) {
                        return null;
                    }
                    Collection<Function> collection = FixedPointView.this.fConversionModel.getEntryPointFunctions();
                    return !collection.isEmpty() ? collection.iterator().next() : null;
                }
            });
        }

        @Override
        public void deactivate() {
            SourceSet sourceSet;
            super.deactivate();
            FixedPointView.this.uninstallAppListeners();
            FixedPointView.this.setAppCallTree(false);
            this.getSidebar().setCurrentUnifiedModel(null);
            if (this.fStartingSourceSet != null) {
                FixedPointView.this.getApp().getModel().setActiveInputSourceSet(this.fStartingSourceSet.getKey());
            }
            if (FixedPointView.this.fDeactivationRunnable != null) {
                FixedPointView.this.fDeactivationRunnable.run();
            }
            if ((sourceSet = FixedPointView.this.getApp().getModel().getFixedPointSourceSet()) != null) {
                sourceSet.removeActivationPredicate(this.fActivationTest);
            }
            if (!FixedPointView.this.fBuildSucceeded) {
                FixedPointDataAdapterFactory.create(FixedPointView.this.getApp().getModel().getConfiguration()).setModeAutomatic(false);
            }
            FixedPointView.this.fAnalysisTable.hideMissingDesignRangeHint();
            FixedPointView.this.getApp().getIDEView().getCodeInfoView().getEditorView().removeEditorViewContentListener(this.fContentListener);
            FixedPointView.this.fConversionModel.removeChangeListener(this.fModelListener);
            FixedPointView.this.getApp().getIDEView().getCodeInfoView().getEditorView().setCloseFunctionConverter(null);
        }

        @Override
        public void sidebarFunctionChanged(Function function) {
            if (function != null) {
                FixedPointView.this.fAnalysisTable.setSelectedFunction(function);
            }
        }
    }
}

