/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.fixedpoint;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.DefaultTestHarnessAdapter;
import com.mathworks.toolbox.coder.app.TestHarness;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointController;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.wfa.core.CustomCommandWindow;
import com.mathworks.toolbox.coder.wfa.core.PopupBarOptionPanel;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimulationOptionPanel
extends PopupBarOptionPanel {
    private final CoderApp fApp;
    private final FixedPointController fController;
    private final Runnable fPostRun;
    private final CustomCommandWindow fCommandWindow;
    private final TestHarness fTestHarness;

    public SimulationOptionPanel(CoderApp coderApp, FixedPointController fixedPointController, MJToggleButton mJToggleButton, Runnable runnable) {
        super(mJToggleButton);
        this.fApp = coderApp;
        this.fController = fixedPointController;
        this.fPostRun = runnable;
        this.fCommandWindow = new CustomCommandWindow(coderApp.getModel().getTestSnippets()){

            @Override
            public void run(String string, Runnable runnable) {
                SimulationOptionPanel.this.runAction(runnable);
            }
        };
        this.fCommandWindow.setUseBusyAffordance(false);
        this.fTestHarness = new TestHarness(coderApp.getModel(), new DefaultTestHarnessAdapter(this.fCommandWindow));
        this.getContentPane().setLayout((LayoutManager)new FormLayout("3dlu, 200px:grow, 3dlu, fill:d, 3dlu, fill:d, 3dlu, fill:d", "1dlu:grow, center:d, 1dlu:grow"));
        Component component = this.fApp.createWidget(this.fController.getData().getHistogramKey());
        Component component2 = this.fApp.createWidget(this.fController.getData().getCoverageKey());
        CellConstraints cellConstraints = new CellConstraints();
        this.getContentPane().add((Component)this.fCommandWindow.getComponent(), (Object)cellConstraints.xy(2, 2));
        this.getContentPane().add(component, (Object)cellConstraints.xy(4, 2));
        this.getContentPane().add(component2, (Object)cellConstraints.xy(6, 2));
    }

    @Override
    public void activate() {
        this.fCommandWindow.activate();
    }

    @Override
    public String getCloseButtonText() {
        return CoderResources.getString("f2f.find.done");
    }

    @Override
    protected void runAction() {
        this.fCommandWindow.run();
    }

    private void runAction(final Runnable runnable) {
        final String string = this.fCommandWindow.getText().trim();
        if (!string.isEmpty()) {
            this.fApp.getModel().getTestSnippets().add(string);
            this.fTestHarness.createContext(this.fCommandWindow.getText(), TestBenchRunMode.RUN_ORIGINAL, new ParameterRunnable<TestHarness.TestBenchContext>(){

                public void run(final TestHarness.TestBenchContext testBenchContext) {
                    SimulationOptionPanel.this.fApp.getEditManager().saveAll();
                    Runnable runnable3 = new Runnable(){

                        @Override
                        public void run() {
                            testBenchContext.dispose();
                            SimulationOptionPanel.this.fPostRun.run();
                            if (runnable != null) {
                                runnable.run();
                            }
                        }
                    };
                    Runnable runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            testBenchContext.dispose();
                        }
                    };
                    SimulationOptionPanel.this.fController.runSimulation(new FixedPointController.SimulationContext(){

                        @Override
                        @NotNull
                        public List<File> getTestFiles() {
                            return Arrays.asList(testBenchContext.getConfig().getTestBenchFile());
                        }

                        @Override
                        public boolean isSynthetic() {
                            return testBenchContext.isSynthetic();
                        }

                        @Override
                        @Nullable
                        public String getCodeIfSynthetic(File file) {
                            return string;
                        }
                    }, runnable3, runnable2);
                }
            }, this.fApp.getIDEView().getCodeInfoView().getOutputPane());
        }
    }

    @Override
    protected boolean shouldStretch() {
        return true;
    }
}

