/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.hdltarget;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.OptionListWithDefault;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.wfa.AbstractCoderStepView;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import com.mathworks.util.Holder;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.Pair;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChooseTargetView
extends AbstractCoderStepView {
    private final Configuration fConfiguration;
    private final MJPanel fPanel;
    private final Param fWorkflowParam;
    private final Param fPlatformParam;
    private final Param fToolParam;
    private final Param fFamilyParam;
    private final Param fDeviceParam;
    private final Param fPackageParam;
    private final Param fSpeedParam;
    private final Param fInputClockParam;
    private final Param fSystemClockParam;
    private final Param fExecutionModeParam;
    private final Param fIpCoreNameParam;
    private final Param fIpCoreVersionParam;
    private final Set<String> fCascadingParamKeys;
    private final ParamWidgetBinder fBinder;
    private final PropertyChangeListener fConfigurationListener;
    private final HyperlinkTextLabel fBoardManagerLink;
    private final HyperlinkTextLabel fRefreshLink;
    private final MJPanel fRefreshWrapper;
    private final MJLabel fIpCoreLabel;
    private final MJLabel fFrequencyLabel;
    private final Map<String, MJLabel> fLabels;
    private final Map<String, ComboBox> fComboBoxes;
    private final BusyAffordance fBusyAffordance;
    private boolean fSuppressUpdateOptions;
    private static final String GET_MORE_BOARDS_CALLBACK = "hwconnectinstaller.launchInstaller('StartAtStep', 'SelectPackage', 'BaseProduct', 'HDL Coder');";
    private static final String CREATE_CUSTOM_BOARD_CALLBACK = "DAStudio.Dialog(boardmanagergui.NewBoardWizard(''));";
    public static final String WORKFLOW_PARAM_KEY = "param.hdl.Workflow";
    public static final String PLATFORM_PARAM_KEY = "param.hdl.TargetPlatform";
    public static final String SYNTHESIS_TOOL_PARAM_KEY = "param.hdl.SynthesisTool";

    public ChooseTargetView(CoderApp coderApp, StepModel stepModel, Step step) {
        super(coderApp, stepModel, step);
        this.fConfiguration = coderApp.getModel().getConfiguration();
        this.fPanel = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                ChooseTargetView.this.redoLayout();
            }

            public Dimension getPreferredSize() {
                Dimension dimension = ChooseTargetView.this.computePreferredSize();
                dimension.width = Math.max(dimension.width, 600);
                return dimension;
            }
        };
        this.fPanel.setLayout(null);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.fPanel);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        Target target = this.fConfiguration.getTarget();
        this.fBinder = new ParamWidgetBinder(this.fConfiguration.getProject(), false);
        this.fComboBoxes = new LinkedHashMap<String, ComboBox>();
        this.fWorkflowParam = target.getParam(WORKFLOW_PARAM_KEY);
        this.fPlatformParam = target.getParam(PLATFORM_PARAM_KEY);
        this.fToolParam = target.getParam(SYNTHESIS_TOOL_PARAM_KEY);
        this.fBoardManagerLink = Utilities.createLink(CoderResources.getString("link.boardManager"), "link.boardManager", new Runnable(){

            @Override
            public void run() {
                new Matlab().evalConsoleOutput("fpgaBoardManager();");
            }
        });
        this.fRefreshLink = Utilities.createLink(CoderResources.getString("link.refreshList"), "link.refreshToolList", new Runnable(){

            @Override
            public void run() {
                ChooseTargetView.this.fConfiguration.setForcedDisabled(ChooseTargetView.this.fToolParam.getKey(), true);
                ChooseTargetView.this.fRefreshLink.setEnabled(false);
                ChooseTargetView.this.fBusyAffordance.getComponent().setVisible(true);
                ChooseTargetView.this.fBusyAffordance.start();
                new Matlab().evalConsoleOutput("getHDLToolInfo('refresh');", new CompletionObserver(){

                    public void completed(int n, Object object) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChooseTargetView.this.updateOptions(ChooseTargetView.this.fWorkflowParam.getKey(), true);
                                ChooseTargetView.this.fBusyAffordance.getComponent().setVisible(false);
                                ChooseTargetView.this.fBusyAffordance.stop();
                                ChooseTargetView.this.fConfiguration.setForcedDisabled(ChooseTargetView.this.fToolParam.getKey(), false);
                                ChooseTargetView.this.fRefreshLink.setEnabled(true);
                            }
                        });
                    }
                });
            }
        });
        this.fRefreshWrapper = new MJPanel((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d", "0dlu:grow, fill:d, 0dlu:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fRefreshWrapper.add((Component)this.fRefreshLink.getComponent(), (Object)cellConstraints.xy(1, 2));
        this.fRefreshWrapper.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(3, 2));
        this.fLabels = new HashMap<String, MJLabel>();
        this.fFamilyParam = target.getParam("param.hdl.SynthesisToolChipFamily");
        this.fDeviceParam = target.getParam("param.hdl.SynthesisToolDeviceName");
        this.fPackageParam = target.getParam("param.hdl.SynthesisToolPackageName");
        this.fSpeedParam = target.getParam("param.hdl.SynthesisToolSpeedValue");
        this.fInputClockParam = target.getParam("param.hdl.InputFrequency");
        this.fSystemClockParam = target.getParam("param.hdl.TargetFrequency");
        this.fExecutionModeParam = target.getParam("param.hdl.ExecutionMode");
        this.fIpCoreNameParam = target.getParam("param.hdl.IPCoreName");
        this.fIpCoreVersionParam = target.getParam("param.hdl.IPCoreVersion");
        this.fFrequencyLabel = new MJLabel(CoderResources.getString("hdl.target.clockFrequency"));
        this.fIpCoreLabel = new MJLabel(CoderResources.getString("hdl.target.ipCoreSettings"));
        this.fCascadingParamKeys = new HashSet<String>();
        this.fCascadingParamKeys.addAll(Arrays.asList(this.fWorkflowParam.getKey(), this.fPlatformParam.getKey(), this.fToolParam.getKey(), this.fFamilyParam.getKey(), this.fDeviceParam.getKey(), this.fPackageParam.getKey()));
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(ChooseTargetView.this.fWorkflowParam.getKey())) {
                    ChooseTargetView.this.rebuild();
                }
                if (propertyChangeEvent.getPropertyName().equals(ChooseTargetView.this.fToolParam.getKey()) || propertyChangeEvent.getPropertyName().equals(ChooseTargetView.this.fPlatformParam.getKey()) || propertyChangeEvent.getPropertyName().equals(ChooseTargetView.this.fWorkflowParam.getKey())) {
                    ChooseTargetView.this.getModel().refreshCompletion(ChooseTargetView.this.getStep());
                }
                if (ChooseTargetView.this.fCascadingParamKeys.contains(propertyChangeEvent.getPropertyName()) && !ChooseTargetView.this.fSuppressUpdateOptions) {
                    ChooseTargetView.this.updateOptions(propertyChangeEvent.getPropertyName(), false);
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
        this.rebuild();
        this.updateOptions(this.fWorkflowParam.getKey(), true);
    }

    private void rebuild() {
        this.fPanel.removeAll();
        this.fPanel.add((Component)this.getLabel(this.fWorkflowParam));
        this.fPanel.add(this.fBinder.createOrGet(this.fWorkflowParam));
        ComboBox comboBox = this.createOrGetComboBox(this.fPlatformParam);
        if (!this.isGenericAsicFpga()) {
            this.fPanel.add((Component)this.getLabel(this.fPlatformParam));
            this.fPanel.add((Component)((Object)comboBox));
            this.fPanel.add((Component)this.fBoardManagerLink.getComponent());
        }
        this.fPanel.add((Component)this.getLabel(this.fToolParam));
        this.fPanel.add((Component)((Object)this.createOrGetComboBox(this.fToolParam)));
        this.fPanel.add((Component)this.fRefreshWrapper);
        this.fPanel.add((Component)this.getLabel(this.fFamilyParam));
        this.fPanel.add((Component)((Object)this.createOrGetComboBox(this.fFamilyParam)));
        this.fPanel.add((Component)this.getLabel(this.fDeviceParam));
        this.fPanel.add((Component)((Object)this.createOrGetComboBox(this.fDeviceParam)));
        this.fPanel.add((Component)this.getLabel(this.fPackageParam));
        this.fPanel.add((Component)((Object)this.createOrGetComboBox(this.fPackageParam)));
        this.fPanel.add((Component)this.getLabel(this.fSpeedParam));
        this.fPanel.add((Component)((Object)this.createOrGetComboBox(this.fSpeedParam)));
        if (this.isTurnkey()) {
            this.fPanel.add((Component)this.fFrequencyLabel);
            this.fPanel.add((Component)this.getLabel(this.fInputClockParam));
            this.fPanel.add(this.fBinder.createOrGet(this.fInputClockParam));
            this.fPanel.add((Component)this.getLabel(this.fSystemClockParam));
            this.fPanel.add(this.fBinder.createOrGet(this.fSystemClockParam));
        } else if (this.isIpCore()) {
            this.fPanel.add((Component)this.fIpCoreLabel);
            this.fPanel.add((Component)this.getLabel(this.fIpCoreNameParam));
            this.fPanel.add(this.fBinder.createOrGet(this.fIpCoreNameParam));
            this.fPanel.add((Component)this.getLabel(this.fIpCoreVersionParam));
            this.fPanel.add(this.fBinder.createOrGet(this.fIpCoreVersionParam));
            this.fPanel.add((Component)this.getLabel(this.fExecutionModeParam));
            this.fPanel.add(this.fBinder.createOrGet(this.fExecutionModeParam));
        }
        this.fPanel.revalidate();
        this.fPanel.repaint();
        this.getModel().refreshCompletion(this.getStep());
    }

    @Override
    public void activate(ToolbarContext toolbarContext, boolean bl) {
    }

    private boolean isGenericAsicFpga() {
        return ChooseTargetView.isGenericAsicFpga(this.getApp().getModel());
    }

    public static boolean isGenericAsicFpga(CoderAppModel coderAppModel) {
        return coderAppModel.getConfiguration().getParamAsString(WORKFLOW_PARAM_KEY).equals("option.workflow.GenericAsicFpga");
    }

    private boolean isTurnkey() {
        return this.fConfiguration.getParamAsString(this.fWorkflowParam.getKey()).equals("option.workflow.FpgaTurnkey");
    }

    private boolean isIpCore() {
        return this.fConfiguration.getParamAsString(this.fWorkflowParam.getKey()).equals("option.workflow.IpCore");
    }

    private Dimension computePreferredSize() {
        if (this.fPanel.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        Object[] objectArray = new Object[]{this.fWorkflowParam, new Pair((Object)this.fPlatformParam, (Object)this.fBoardManagerLink.getComponent()), new Pair((Object)this.fToolParam, (Object)this.fRefreshWrapper), new Pair((Object)this.fFamilyParam, (Object)this.fDeviceParam), new Pair((Object)this.fPackageParam, (Object)this.fSpeedParam)};
        Dimension dimension = this.computePreferredSize(objectArray);
        if (this.isIpCore()) {
            dimension.height = (int)((double)dimension.height + (30.0 + this.fIpCoreLabel.getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fIpCoreNameParam).getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fExecutionModeParam).getPreferredSize().getHeight()));
        } else if (this.isTurnkey()) {
            dimension.height = (int)((double)dimension.height + (24.0 + this.fFrequencyLabel.getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fInputClockParam).getPreferredSize().getHeight()));
        }
        dimension.height += 32;
        return dimension;
    }

    private Dimension computePreferredSize(Object[] objectArray) {
        Dimension dimension = new Dimension();
        for (Object object : objectArray) {
            Dimension dimension2;
            Object object2;
            Dimension dimension3;
            if (object instanceof Param) {
                dimension3 = this.getLabel((Param)object).getPreferredSize();
                object2 = this.fBinder.createOrGet((Param)object).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension3.width + 6 + ((Dimension)object2).width);
                dimension.height += Math.max(((Dimension)object2).height, dimension3.height) + 6;
                continue;
            }
            if (!(object instanceof Pair)) continue;
            dimension3 = (Param)((Pair)object).getFirst();
            object2 = ((Pair)object).getSecond();
            Dimension dimension4 = this.getLabel((Param)dimension3).getPreferredSize();
            Dimension dimension5 = this.fBinder.createOrGet((Param)dimension3).getPreferredSize();
            if (object2 instanceof Component) {
                dimension2 = ((Component)object2).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension4.width + 12 + dimension5.width + dimension2.width);
            } else {
                dimension2 = this.getLabel((Param)object2).getPreferredSize();
                Dimension dimension6 = this.fBinder.createOrGet((Param)object2).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension4.width + 16 + dimension5.width + dimension2.width + dimension6.width);
            }
            dimension.height += Math.max(dimension5.height, dimension4.height) + 6;
        }
        return dimension;
    }

    private void redoLayout() {
        Dimension dimension;
        if (this.fPanel.getComponentCount() == 0) {
            return;
        }
        int n = 3;
        int n2 = 24;
        Holder holder = new Holder((Object)0);
        Holder holder2 = new Holder((Object)n2);
        Holder holder3 = new Holder((Object)3);
        Holder holder4 = new Holder((Object)0);
        int n3 = this.fRefreshWrapper.getPreferredSize().width;
        this.layoutLabel(this.fWorkflowParam, n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder);
        if (!this.isGenericAsicFpga()) {
            this.layoutLabel(this.fPlatformParam, this.fBoardManagerLink.getComponent(), n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder);
            n3 = Math.max(n3, this.fBoardManagerLink.getComponent().getPreferredSize().width);
        }
        this.layoutLabel(this.fToolParam, (Component)this.fRefreshWrapper, n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder);
        this.layoutLabel(this.fFamilyParam, this.fDeviceParam, n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder, (Holder<Integer>)holder4);
        this.layoutLabel(this.fPackageParam, this.fSpeedParam, n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder, (Holder<Integer>)holder4);
        if (this.isTurnkey()) {
            holder2.set((Object)((Integer)holder2.get() + 24));
            dimension = this.fFrequencyLabel.getPreferredSize();
            this.fFrequencyLabel.setBounds(n, ((Integer)holder2.get()).intValue(), dimension.width, dimension.height);
            holder4.set((Object)Math.max((Integer)holder4.get(), this.getLabel((Param)this.fSystemClockParam).getPreferredSize().width));
        } else if (this.isIpCore()) {
            holder2.set((Object)((Integer)holder2.get() + 24));
            dimension = this.fIpCoreLabel.getPreferredSize();
            this.fIpCoreLabel.setBounds(n, ((Integer)holder2.get()).intValue(), dimension.width, dimension.height);
            holder4.set((Object)Math.max((Integer)holder4.get(), this.getLabel((Param)this.fIpCoreVersionParam).getPreferredSize().width));
        }
        n = (Integer)holder3.get() + 16;
        holder2.set((Object)n2);
        int n4 = (Integer)holder.get();
        n4 = Math.max(n4, this.fPanel.getWidth() - n - 40);
        n4 = Math.min(this.fPanel.getWidth() - n - 8, n4);
        this.layoutComponent(this.fWorkflowParam, n, (Holder<Integer>)holder2, n4);
        if (!this.isGenericAsicFpga()) {
            this.layoutComponent(this.fPlatformParam, this.fBoardManagerLink.getComponent(), n3, n, (Holder<Integer>)holder2, n4);
        }
        this.layoutComponent(this.fToolParam, (Component)this.fRefreshWrapper, n3, n, (Holder<Integer>)holder2, n4);
        this.layoutComponent(this.fFamilyParam, this.fDeviceParam, (int)((Integer)holder4.get()), n, (Holder<Integer>)holder2, n4);
        this.layoutComponent(this.fPackageParam, this.fSpeedParam, (int)((Integer)holder4.get()), n, (Holder<Integer>)holder2, n4);
        int n5 = (Integer)holder2.get();
        holder2.set((Object)0);
        if (this.isTurnkey()) {
            this.layoutIndentedComponent((Component)this.fFrequencyLabel, this.fInputClockParam, this.fSystemClockParam, (Integer)holder4.get(), n, (Holder<Integer>)holder2, n4);
            n5 = (Integer)holder2.get();
        } else if (this.isIpCore()) {
            this.layoutIndentedComponent((Component)this.fIpCoreLabel, this.fIpCoreNameParam, this.fIpCoreVersionParam, (Integer)holder4.get(), n, (Holder<Integer>)holder2, n4);
            this.layoutIndentedComponent((Component)this.fIpCoreLabel, this.fExecutionModeParam, this.fIpCoreNameParam, n, (Holder<Integer>)holder2, n4);
            n5 = (Integer)holder2.get();
        }
    }

    private void layoutComponent(Param param, int n, Holder<Integer> holder, int n2) {
        Component component = this.fBinder.createOrGet(param);
        Dimension dimension = component.getPreferredSize();
        component.setBounds(n, (Integer)holder.get(), n2, dimension.height);
        holder.set((Object)((Integer)holder.get() + dimension.height + 6));
    }

    private void layoutComponent(Param param, Component component, int n, int n2, Holder<Integer> holder, int n3) {
        Component component2 = this.fBinder.createOrGet(param);
        Dimension dimension = component2.getPreferredSize();
        Dimension dimension2 = component.getPreferredSize();
        component2.setBounds(n2, (Integer)holder.get(), n3 - n - 6, dimension.height);
        component.setBounds(n2 + n3 - n, (Integer)holder.get() + dimension.height / 2 - dimension2.height / 2, n, dimension2.height);
        holder.set((Object)((Integer)holder.get() + dimension.height + 6));
    }

    private void layoutComponent(Param param, Param param2, int n, int n2, Holder<Integer> holder, int n3) {
        Component component = this.fBinder.createOrGet(param);
        Dimension dimension = component.getPreferredSize();
        MJLabel mJLabel = this.getLabel(param2);
        Component component2 = this.fBinder.createOrGet(param2);
        Dimension dimension2 = mJLabel.getPreferredSize();
        Dimension dimension3 = component2.getPreferredSize();
        int n4 = this.getLabel((Param)param2).getPreferredSize().height;
        component.setBounds(n2, (Integer)holder.get(), n3 / 2 - n / 2 - 8, dimension.height);
        mJLabel.setBounds(component.getX() + component.getWidth() + 8 + n - dimension2.width, (Integer)holder.get() + dimension3.height / 2 - n4 / 2, dimension2.width, n4);
        component2.setBounds(mJLabel.getX() + mJLabel.getWidth() + 6, (Integer)holder.get() + dimension.height / 2 - dimension3.height / 2, n3 / 2 - n / 2 - 6, dimension3.height);
        holder.set((Object)((Integer)holder.get() + dimension.height + 6));
    }

    private void layoutIndentedComponent(Component component, Param param, Param param2, int n, Holder<Integer> holder, int n2) {
        Component component2 = this.fBinder.createOrGet(param);
        MJLabel mJLabel = this.getLabel(param);
        int n3 = component.getY() + component.getHeight() + 6;
        if ((Integer)holder.get() != 0) {
            n3 = (Integer)holder.get();
        }
        Dimension dimension = mJLabel.getPreferredSize();
        Dimension dimension2 = this.getLabel(param2).getPreferredSize();
        Dimension dimension3 = component2.getPreferredSize();
        mJLabel.setBounds(n - dimension2.width - 6, n3 + dimension3.height / 2 - dimension.height / 2, dimension.width, dimension.height);
        if (param.getType() == ParamType.INT) {
            dimension3.width = 75;
        }
        component2.setBounds(n + dimension.width - dimension2.width, n3, n2 - dimension.width + dimension2.width, dimension3.height);
        holder.set((Object)(n3 + component2.getHeight() + 6));
    }

    private void layoutIndentedComponent(Component component, Param param, Param param2, int n, int n2, Holder<Integer> holder, int n3) {
        Component component2 = this.fBinder.createOrGet(param);
        Component component3 = this.fBinder.createOrGet(param2);
        MJLabel mJLabel = this.getLabel(param);
        MJLabel mJLabel2 = this.getLabel(param2);
        if ((Integer)holder.get() == 0) {
            holder.set((Object)(component.getY() + component.getHeight() + 6));
        }
        Dimension dimension = mJLabel.getPreferredSize();
        Dimension dimension2 = component2.getPreferredSize();
        Dimension dimension3 = mJLabel2.getPreferredSize();
        Dimension dimension4 = component3.getPreferredSize();
        mJLabel.setBounds(n2 - 6 - dimension.width, (Integer)holder.get() + dimension2.height / 2 - dimension.height / 2, dimension.width, dimension.height);
        if (param.getType() == ParamType.INT) {
            dimension2.width = 75;
        }
        dimension2.width = Math.min(dimension2.width, n3 / 2 - n / 2 - 10);
        component2.setBounds(n2, (Integer)holder.get(), dimension2.width, dimension2.height);
        mJLabel2.setBounds(n2 + n3 / 2 - n / 2, (Integer)holder.get() + dimension4.height / 2 - dimension3.height / 2, n, dimension3.height);
        if (param2.getType() == ParamType.INT) {
            dimension4.width = 75;
        }
        dimension4.width = Math.min(dimension4.width, n3 / 2 - n / 2 - 10);
        component3.setBounds(mJLabel2.getX() + mJLabel2.getWidth() + 6, (Integer)holder.get(), dimension4.width + 3, dimension4.height);
        holder.set((Object)((Integer)holder.get() + dimension2.height + 6));
    }

    private void layoutLabel(Param param, int n, Holder<Integer> holder, Holder<Integer> holder2, Holder<Integer> holder3) {
        this.layoutLabel(param, null, null, n, holder, holder2, holder3, null);
    }

    private void layoutLabel(Param param, Param param2, int n, Holder<Integer> holder, Holder<Integer> holder2, Holder<Integer> holder3, Holder<Integer> holder4) {
        this.layoutLabel(param, param2, null, n, holder, holder2, holder3, holder4);
    }

    private void layoutLabel(Param param, Component component, int n, Holder<Integer> holder, Holder<Integer> holder2, Holder<Integer> holder3) {
        this.layoutLabel(param, null, component, n, holder, holder2, holder3, null);
    }

    private void layoutLabel(Param param, Param param2, Component component, int n, Holder<Integer> holder, Holder<Integer> holder2, Holder<Integer> holder3, Holder<Integer> holder4) {
        Dimension dimension = this.getLabel(param).getPreferredSize();
        Dimension dimension2 = this.fBinder.createOrGet(param).getPreferredSize();
        this.getLabel(param).setBounds(n, (Integer)holder.get() + dimension2.height / 2 - dimension.height / 2, dimension.width, dimension.height);
        holder2.set((Object)Math.max((Integer)holder2.get(), dimension.width));
        Dimension dimension3 = this.fBinder.createOrGet(param).getPreferredSize();
        int n2 = 0;
        if (param2 != null) {
            n2 = (int)((double)n2 + (this.getLabel(param2).getPreferredSize().getWidth() + 10.0 + this.fBinder.createOrGet(param2).getPreferredSize().getWidth()));
        } else if (component != null) {
            n2 = (int)((double)n2 + (10.0 + component.getPreferredSize().getWidth()));
        }
        holder3.set((Object)Math.max((Integer)holder3.get(), dimension3.width + n2));
        if (holder4 != null) {
            holder4.set((Object)Math.max((Integer)holder4.get(), this.getLabel((Param)param2).getPreferredSize().width));
        }
        holder.set((Object)((Integer)holder.get() + 6 + Math.max(dimension.height, dimension3.height)));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fBinder.dispose();
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
    }

    @Override
    protected String getHelpKey() {
        return "help_button_choose_target";
    }

    private MJLabel getLabel(Param param) {
        MJLabel mJLabel = this.fLabels.get(param.getKey());
        if (mJLabel == null) {
            mJLabel = new MJLabel(param.getName() + ":");
            this.fLabels.put(param.getKey(), mJLabel);
        }
        return mJLabel;
    }

    private ComboBox createOrGetComboBox(Param param) {
        ComboBox comboBox = this.fComboBoxes.get(param.getKey());
        if (comboBox == null) {
            comboBox = new ComboBox(param);
            this.fComboBoxes.put(param.getKey(), comboBox);
            this.fBinder.register(param, (ParamWidget)comboBox);
        }
        return comboBox;
    }

    private boolean hasToolSelected() {
        String string = this.fConfiguration.getParamAsString(this.fToolParam.getKey());
        return string != null && !string.equals("No synthesis tool available on system path") && !string.equals("No synthesis tool specified");
    }

    private boolean hasXilinxToolSelected() {
        String string = this.fConfiguration.getParamAsString(this.fToolParam.getKey());
        return string != null && (string.equals("Xilinx ISE") || string.equals("Xilinx Vivado"));
    }

    private void updateOptions(final String string, final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChooseTargetView.this.fComboBoxes.isEmpty()) {
                    return;
                }
                for (ComboBox comboBox : ChooseTargetView.this.fComboBoxes.values()) {
                    comboBox.setEnabled(false);
                }
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Param param;
                        LinkedHashMap<Param, String> linkedHashMap = new LinkedHashMap<Param, String>();
                        linkedHashMap.put(ChooseTargetView.this.fWorkflowParam, "Workflow");
                        linkedHashMap.put(ChooseTargetView.this.fPlatformParam, "Board");
                        linkedHashMap.put(ChooseTargetView.this.fToolParam, "Tool");
                        linkedHashMap.put(ChooseTargetView.this.fFamilyParam, "Family");
                        linkedHashMap.put(ChooseTargetView.this.fDeviceParam, "Device");
                        linkedHashMap.put(ChooseTargetView.this.fPackageParam, "Package");
                        linkedHashMap.put(ChooseTargetView.this.fSpeedParam, "Speed");
                        Iterator iterator = linkedHashMap.entrySet().iterator();
                        while (iterator.hasNext() && !(param = (Param)iterator.next().getKey()).getKey().equals(string)) {
                        }
                        param = new LinkedHashMap();
                        ChooseTargetView.this.loadCascadingOptions(linkedHashMap, iterator, (Map)param, bl);
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable((Map)param){
                            final /* synthetic */ Map val$options;
                            {
                                this.val$options = map;
                            }

                            @Override
                            public void run() {
                                ChooseTargetView.this.fSuppressUpdateOptions = true;
                                for (Map.Entry entry : this.val$options.entrySet()) {
                                    ComboBox comboBox = (ComboBox)((Object)ChooseTargetView.this.fComboBoxes.get(entry.getKey()));
                                    comboBox.updateOptions((OptionListWithDefault)entry.getValue());
                                }
                                for (Map.Entry entry : ChooseTargetView.this.fComboBoxes.entrySet()) {
                                    if (((String)entry.getKey()).equals(ChooseTargetView.this.fToolParam.getKey())) {
                                        ((ComboBox)((Object)entry.getValue())).setEnabled(true);
                                    }
                                    if (((String)entry.getKey()).equals(ChooseTargetView.this.fPlatformParam.getKey())) {
                                        ((ComboBox)((Object)entry.getValue())).setEnabled(!ChooseTargetView.this.isGenericAsicFpga());
                                    }
                                    if (((String)entry.getKey()).equals(ChooseTargetView.this.fFamilyParam.getKey()) || ((String)entry.getKey()).equals(ChooseTargetView.this.fDeviceParam.getKey())) {
                                        ((ComboBox)((Object)entry.getValue())).setEnabled(ChooseTargetView.this.hasToolSelected() && ChooseTargetView.this.isGenericAsicFpga());
                                    }
                                    if (!((String)entry.getKey()).equals(ChooseTargetView.this.fPackageParam.getKey()) && !((String)entry.getKey()).equals(ChooseTargetView.this.fSpeedParam.getKey())) continue;
                                    ((ComboBox)((Object)entry.getValue())).setEnabled(ChooseTargetView.this.hasXilinxToolSelected() && ChooseTargetView.this.isGenericAsicFpga());
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ChooseTargetView.this.fSuppressUpdateOptions = false;
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    private void loadCascadingOptions(Map<Param, String> map, Iterator<Map.Entry<Param, String>> iterator, Map<String, OptionListWithDefault> map2, boolean bl) {
        if (iterator.hasNext()) {
            Object object;
            Map.Entry<Param, String> entry = iterator.next();
            List<String> list = this.getArguments(map, entry.getValue());
            try {
                object = Matlab.mtFevalConsoleOutput((String)"getHDLToolInfo", (Object[])list.toArray(), (int)2);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            String[] stringArray = (String[])((Object[])object)[0];
            Object object2 = ((Object[])object)[1];
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            Object object3 = stringArray;
            int n = ((String[])object3).length;
            for (int i = 0; i < n; ++i) {
                String string = object3[i];
                linkedHashMap.put(string, string);
            }
            if (bl && (object3 = this.fConfiguration.getParamAsString(entry.getKey().getKey())) != null && linkedHashMap.containsKey(object3)) {
                object2 = object3;
            }
            this.fConfiguration.setParamAsString(entry.getKey().getKey(), (String)object2);
            map2.put(entry.getKey().getKey(), new OptionListWithDefault(linkedHashMap, (String)object2));
            this.loadCascadingOptions(map, iterator, map2, bl);
        } else if (this.isTurnkey()) {
            try {
                List<String> list = this.getArguments(map, "targetFrequency");
                Object object = Matlab.mtFevalConsoleOutput((String)"getHDLToolInfo", (Object[])list.toArray(), (int)1);
                int n = Integer.parseInt((String)object);
                if (n > 0) {
                    this.fConfiguration.setParamAsInt(this.fInputClockParam.getKey(), n);
                    this.fConfiguration.setParamAsInt(this.fSystemClockParam.getKey(), n);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    private List<String> getArguments(Map<Param, String> map, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        for (Map.Entry<Param, String> entry : map.entrySet()) {
            if (entry.getValue().equals(string)) break;
            arrayList.add(entry.getValue());
            if (entry.getKey().getOptions() != null && !entry.getKey().getOptions().isEmpty()) {
                arrayList.add((String)entry.getKey().getOptions().get(this.fConfiguration.getParamAsString(entry.getKey().getKey())));
                continue;
            }
            arrayList.add(this.fConfiguration.getParamAsString(entry.getKey().getKey()));
        }
        return arrayList;
    }

    private class ComboBox
    extends MJComboBox
    implements ParamWidget<String> {
        private final MulticastChangeListener fChangeListeners;

        ComboBox(Param param) {
            this.setName(param.getKey() + ".combobox");
            this.fChangeListeners = new MulticastChangeListener();
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    Object object = ComboBox.this.getSelectedItem();
                    Object object2 = itemEvent.getItem();
                    if (object2 == object && ComboBox.this.getSelectedIndex() >= 0) {
                        String string = null;
                        if (object != null && object.equals("Get more...")) {
                            ComboBox.this.setSelectedItem("Generic Xilinx Platform");
                            string = ChooseTargetView.GET_MORE_BOARDS_CALLBACK;
                        } else if (object != null && object.equals("Get more boards...")) {
                            ComboBox.this.setSelectedItem("Choose a platform");
                            string = ChooseTargetView.GET_MORE_BOARDS_CALLBACK;
                        } else if (object != null && object.equals("Create custom board...")) {
                            ComboBox.this.setSelectedItem("Choose a platform");
                            string = ChooseTargetView.CREATE_CUSTOM_BOARD_CALLBACK;
                        } else {
                            ComboBox.this.fChangeListeners.stateChanged(new ChangeEvent((Object)ComboBox.this));
                        }
                        if (string != null) {
                            new Matlab().evalConsoleOutput(string);
                        }
                    }
                }
            });
        }

        public Component getComponent() {
            return this;
        }

        public void dispose() {
        }

        public void updateOptions(OptionListWithDefault optionListWithDefault) {
            this.removeAllItems();
            for (String string : optionListWithDefault.getOptions().keySet()) {
                this.addItem(string);
            }
            this.setSelectedItem(optionListWithDefault.getDefault());
        }

        public boolean isExternalLabelRequired() {
            return true;
        }

        public void setData(String string) {
            this.setSelectedItem(string);
        }

        public String getData() {
            return (String)this.getSelectedItem();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.fChangeListeners.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.fChangeListeners.removeChangeListener(changeListener);
        }

        public boolean showValidationMessage(ValidationMessage validationMessage) {
            return false;
        }

        public void clearValidationMessage() {
        }
    }
}

