/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.setup;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ScoreGauge;
import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ScreenerSummary {
    private final CoderApp fApp;
    private final MJPanel fComponent;
    private final BusyAffordance fBusyAffordance;
    private int fLastScore;
    private List<ScreenerProblemType> fLastProblems;

    public ScreenerSummary(CoderApp coderApp) {
        this.fApp = coderApp;
        this.fComponent = new MJPanel();
        this.fComponent.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_32x32);
        this.fBusyAffordance.getComponent().setName("screener.wheel");
        coderApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ScreenerSummary.this.fApp.getModel().isEntryPointSelectionRelated(propertyChangeEvent)) {
                    ScreenerSummary.this.rebuild();
                }
            }
        });
        coderApp.getModel().getScreenerModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ScreenerSummary.this.rebuild();
            }
        });
        this.rebuild();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void rebuild() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenerReportModel screenerReportModel = ScreenerSummary.this.fApp.getModel().getScreenerModel().getReportModel();
                if (screenerReportModel == null) {
                    ScreenerSummary.this.fLastProblems = null;
                    ScreenerSummary.this.fLastScore = 0;
                    ScreenerSummary.this.fComponent.removeAll();
                    if (!ScreenerSummary.this.fApp.getModel().getEntryPointFileSet().getFiles().isEmpty()) {
                        ScreenerSummary.this.fComponent.removeAll();
                        ScreenerSummary.this.fBusyAffordance.start();
                        ScreenerSummary.this.fComponent.add((Component)ScreenerSummary.this.fBusyAffordance.getComponent());
                    } else {
                        MJLabel mJLabel = new MJLabel(CoderResources.getString("wfa.screener.summary.empty"));
                        mJLabel.setName("screener.label.empty");
                        ScreenerSummary.this.fApp;
                        mJLabel.setFont(CoderApp.getFont().deriveFont(14.0f));
                        mJLabel.setForeground(new Color(130, 130, 130));
                        ScreenerSummary.this.fBusyAffordance.stop();
                        ScreenerSummary.this.fComponent.add((Component)mJLabel);
                    }
                } else if (ScreenerSummary.this.fLastProblems == null || !ScreenerSummary.this.fLastProblems.equals(screenerReportModel.getProblemsByImpact()) || ScreenerSummary.this.fLastScore != screenerReportModel.getScore().getScore()) {
                    ScreenerSummary.this.fBusyAffordance.stop();
                    ScreenerSummary.this.fComponent.removeAll();
                    ScreenerSummary.this.fLastProblems = screenerReportModel.getProblemsByImpact();
                    ScreenerSummary.this.fLastScore = screenerReportModel.getScore().getScore();
                    ScreenerSummary.this.fComponent.add((Component)((Object)new SummaryPanel(screenerReportModel)));
                }
                ScreenerSummary.this.fComponent.revalidate();
                ScreenerSummary.this.fComponent.repaint();
            }
        });
    }

    private class SummaryPanel
    extends MJPanel {
        private final MJLabel fSummaryLabel;
        private final MJLabel fReadinessLabel;
        private final ScoreGauge fScoreWidget;
        private int fProblemWidth;

        SummaryPanel(ScreenerReportModel screenerReportModel) {
            this.setLayout(null);
            int n = screenerReportModel.getScore().getScore();
            this.fSummaryLabel = new MJLabel(CoderResources.getString("wfa.screener.summary." + n));
            this.fSummaryLabel.setName("screener.label.summary");
            ScreenerSummary.this.fApp;
            this.fSummaryLabel.setFont(CoderApp.getFont().deriveFont(14.0f));
            this.fReadinessLabel = new MJLabel(CoderResources.getString("wfa.screener.score") + ": " + n);
            ScreenerSummary.this.fApp;
            this.fReadinessLabel.setFont(CoderApp.getFont().deriveFont(1, 14.0f));
            this.fReadinessLabel.setName("screener.label.readiness");
            this.fScoreWidget = new ScoreGauge(ScreenerSummary.this.fApp.getAnimator(), screenerReportModel.getScore().getScore());
            this.add((Component)this.fSummaryLabel);
            this.add((Component)this.fReadinessLabel);
            this.add(this.fScoreWidget.getComponent());
            for (ScreenerProblemType screenerProblemType : screenerReportModel.getProblemsByImpact()) {
                MJLabel mJLabel = new MJLabel("- " + CoderResources.getString("wfa.screener.problem." + StringUtils.upperCaseToCamelCase((String)screenerProblemType.toString(), (boolean)false)));
                mJLabel.setName("screener.problem." + StringUtils.upperCaseToCamelCase((String)screenerProblemType.toString(), (boolean)false));
                ScreenerSummary.this.fApp;
                mJLabel.setFont(CoderApp.getFont());
                this.add((Component)mJLabel);
                this.fProblemWidth = Math.max(this.fProblemWidth, mJLabel.getPreferredSize().width);
            }
        }

        public void doLayout() {
            super.doLayout();
            int n = (int)((double)(this.getHeight() / 2) - this.getPreferredSize().getHeight() / 2.0);
            Dimension dimension = this.fSummaryLabel.getPreferredSize();
            Dimension dimension2 = this.fReadinessLabel.getPreferredSize();
            Dimension dimension3 = this.fScoreWidget.getComponent().getPreferredSize();
            this.fSummaryLabel.setBounds(this.getWidth() / 2 - dimension.width / 2, n, dimension.width, dimension.height);
            this.fReadinessLabel.setBounds(this.getWidth() / 2 - dimension2.width / 2, (n += dimension.height + 6) + dimension2.height / 2 - dimension2.height / 2, dimension2.width, dimension2.height);
            this.fScoreWidget.getComponent().setBounds(this.getWidth() / 2 - dimension3.width / 2, n += dimension2.height + 6, dimension3.width, dimension3.height);
            n += dimension3.height + 6;
            for (Component component : this.getComponents()) {
                if (component == this.fSummaryLabel || component == this.fReadinessLabel || component == this.fScoreWidget.getComponent()) continue;
                Dimension dimension4 = component.getPreferredSize();
                component.setBounds(this.getWidth() / 2 - this.fProblemWidth / 2, n, dimension4.width, dimension4.height);
                n += dimension4.height + 6;
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            for (Component component : this.getComponents()) {
                Dimension dimension2 = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height += dimension2.height + 6;
            }
            dimension.height -= 6;
            return dimension;
        }
    }
}

