/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.widgets.Transition;
import com.mathworks.toolbox.coder.widgets.TransitionFactory;
import com.mathworks.toolbox.coder.widgets.TransitionTarget;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Stack;

public class TransitionPanel
extends MJPanel {
    private final Collection<TransitionContext> fTransitions;
    private boolean fFrozen;
    private boolean fPaintOverride;
    private TransitionFactory fTransitionFactory;
    private TransitionContext fCurrentTransition;

    public TransitionPanel(LayoutManager layoutManager, TransitionFactory transitionFactory) {
        super(layoutManager);
        this.fTransitionFactory = transitionFactory;
        this.fTransitions = new Stack<TransitionContext>();
        this.setOpaque(false);
    }

    public TransitionPanel(LayoutManager layoutManager) {
        this(layoutManager, null);
    }

    public TransitionPanel(TransitionFactory transitionFactory) {
        this(new BorderLayout(), transitionFactory);
    }

    public void setTransitionFactory(TransitionFactory transitionFactory) {
        this.fTransitionFactory = transitionFactory;
    }

    protected TransitionTarget createTransitionTarget(boolean bl) {
        return this.isSized() ? new SnapshotTarget() : new TransitionTarget.EmptyTransitionTarget();
    }

    public void markTransitionStart() {
        this.fCurrentTransition = new TransitionContext();
        this.fFrozen = true;
        this.fCurrentTransition.setStart(this.createTransitionTarget(true));
    }

    public void markTransitionEnd() {
        if (this.fCurrentTransition == null) {
            return;
        }
        this.revalidate();
        this.repaint();
        this.fCurrentTransition.setEnd(this.createTransitionTarget(false));
    }

    public void transition() {
        if (this.fCurrentTransition == null || this.fCurrentTransition.getStart() == null) {
            this.resetState();
            return;
        }
        if (this.fCurrentTransition.getEnd() == null) {
            this.markTransitionEnd();
        }
        this.fTransitions.add(this.fCurrentTransition);
        this.fCurrentTransition.start();
        this.fCurrentTransition = null;
    }

    public boolean isSized() {
        return this.getWidth() > 0 && this.getHeight() > 0;
    }

    private void transitionFinished(TransitionContext transitionContext) {
        this.fTransitions.remove(transitionContext);
        if (this.fTransitions.isEmpty()) {
            this.resetState();
        }
    }

    private void resetState() {
        this.fFrozen = false;
        this.fPaintOverride = false;
        this.fCurrentTransition = null;
        this.fTransitions.clear();
        this.revalidate();
        this.repaint();
    }

    public boolean isTransitioning() {
        return !this.fTransitions.isEmpty();
    }

    public void paint(Graphics graphics) {
        if (!this.fFrozen || this.fPaintOverride) {
            super.paint(graphics);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.fTransitions.size() == 1) {
                this.fTransitions.iterator().next().getTransition().paintTransition(graphics2D, this.getWidth(), this.getHeight());
            } else if (!this.fTransitions.isEmpty()) {
                BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                graphics2D2.setComposite(AlphaComposite.getInstance(3, 1.0f / (float)this.fTransitions.size()));
                for (TransitionContext transitionContext : this.fTransitions) {
                    Graphics2D graphics2D3 = (Graphics2D)graphics2D2.create();
                    transitionContext.getTransition().paintTransition(graphics2D3, bufferedImage.getWidth(), bufferedImage.getHeight());
                    graphics2D3.dispose();
                }
                graphics2D2.dispose();
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
            graphics2D.dispose();
        }
    }

    private class TransitionContext {
        private TransitionTarget fStart;
        private TransitionTarget fEnd;
        private Transition fTransition;

        private TransitionContext() {
        }

        private TransitionTarget getStart() {
            return this.fStart;
        }

        private void setStart(TransitionTarget transitionTarget) {
            this.fStart = transitionTarget;
        }

        private TransitionTarget getEnd() {
            return this.fEnd;
        }

        private void setEnd(TransitionTarget transitionTarget) {
            this.fEnd = transitionTarget;
        }

        private Transition getTransition() {
            return this.fTransition;
        }

        private void start() {
            if (this.fTransition != null || TransitionPanel.this.fTransitionFactory == null) {
                return;
            }
            this.fTransition = TransitionPanel.this.fTransitionFactory.createTransition(this.getStart(), this.getEnd(), new Runnable(){

                @Override
                public void run() {
                    TransitionPanel.this.repaint();
                }
            });
            this.fTransition.addCompletionTask(new Runnable(){

                @Override
                public void run() {
                    TransitionPanel.this.transitionFinished(TransitionContext.this);
                }
            });
            this.fTransition.start();
        }
    }

    private class SnapshotTarget
    implements TransitionTarget {
        private final BufferedImage fState;

        SnapshotTarget() {
            this.fState = new BufferedImage(TransitionPanel.this.getWidth(), TransitionPanel.this.getHeight(), 2);
            Graphics2D graphics2D = this.fState.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            TransitionPanel.this.fPaintOverride = true;
            TransitionPanel.this.paint(graphics2D);
            TransitionPanel.this.fPaintOverride = false;
            graphics2D.dispose();
        }

        @Override
        public void paintTarget(Graphics2D graphics2D) {
            graphics2D.drawImage((Image)this.fState, 0, 0, null);
        }

        @Override
        public void init() {
        }

        @Override
        public Dimension getTargetSize() {
            return new Dimension(this.fState.getWidth(), this.fState.getHeight());
        }
    }
}

