/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class LayoutPrefs
extends MJPanel {
    static final String TYPE = "Layout";
    public static final String TOOLBAR = "LayoutToolBar";
    public static final String STATUSBAR = "LayoutStatusBar";
    public static final String TOOLNAMES = "LayoutToolNames";
    public static final String EXTENSION = "LayoutExtension";
    public static final String FULLPATH = "LayoutFullPath";
    public static final String ACTIVATE = "LayoutActivate";
    public static final String EXPORT = "LayoutExport";
    public static final String COMMENTS = "LayoutMCodeComments";
    public static final String CHANGEDEFAULTCALLBACK = "LayoutChangeDefaultCallback";
    private static LayoutPrefs sLayoutPrefs;
    static boolean sShowToolBar;
    static boolean sShowStatusBar;
    static boolean sShowToolNames;
    static boolean sShowExtension;
    static boolean sShowFullPath;
    static boolean sSaveActivate;
    static boolean sSaveExport;
    static boolean sAddMCodeComments;
    static boolean sChangeDefaultCallback;
    private static final String[] PREF_KEYS;
    private MJCheckBox[] fBoxes;

    public static boolean getLayoutBooleanPref(String string) {
        return Prefs.getBooleanPref((String)string, (boolean)LayoutPrefs.getDefaultLayoutPref(string));
    }

    static boolean getDefaultLayoutPref(String string) {
        boolean bl = true;
        if (string != null) {
            if (string.equals(TOOLNAMES) || string.equals(FULLPATH)) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private LayoutPrefs() {
    }

    private void readPrefs() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.toolbox.matlab.guide.resources.RES_Layout");
        int n = PREF_KEYS.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + "p, 4dlu";
        }
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p", string), (JPanel)((Object)this));
        CellConstraints cellConstraints = new CellConstraints();
        this.fBoxes = new MJCheckBox[n];
        for (int i = 0; i < n; ++i) {
            String string2 = resourceBundle.getString(PREF_KEYS[i]);
            this.fBoxes[i] = new MJCheckBox(string2);
            this.fBoxes[i].setSelected(LayoutPrefs.getLayoutBooleanPref(PREF_KEYS[i]));
            panelBuilder.add((Component)this.fBoxes[i], cellConstraints.xy(1, (i + 1) * 2 - 1));
        }
    }

    private void storePrefs() {
        int n = this.fBoxes.length;
        for (int i = 0; i < n; ++i) {
            if (this.fBoxes[i].isSelected() == LayoutPrefs.getLayoutBooleanPref(PREF_KEYS[i])) continue;
            Prefs.setBooleanPref((String)PREF_KEYS[i], (boolean)this.fBoxes[i].isSelected());
        }
    }

    public static MJPanel createPrefsPanel() {
        sLayoutPrefs = new LayoutPrefs();
        sLayoutPrefs.readPrefs();
        return sLayoutPrefs;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl) {
            sLayoutPrefs.storePrefs();
        }
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"creating_guis"), "preferences"};
    }

    public static ConfirmationDialogPrefsPanel.DialogItem[] getDialogItems() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.toolbox.matlab.guide.resources.RES_Layout");
        return new ConfirmationDialogPrefsPanel.DialogItem[]{new ConfirmationDialogPrefsPanel.DialogItem(resourceBundle.getString(ACTIVATE), ACTIVATE, "GUIDE", LayoutPrefs.getDefaultLayoutPref(ACTIVATE)), new ConfirmationDialogPrefsPanel.DialogItem(resourceBundle.getString(EXPORT), EXPORT, "GUIDE", LayoutPrefs.getDefaultLayoutPref(EXPORT)), new ConfirmationDialogPrefsPanel.DialogItem(resourceBundle.getString(CHANGEDEFAULTCALLBACK), CHANGEDEFAULTCALLBACK, "GUIDE", LayoutPrefs.getDefaultLayoutPref(CHANGEDEFAULTCALLBACK))};
    }

    static {
        PREF_KEYS = new String[]{TOOLNAMES, EXTENSION, FULLPATH, COMMENTS};
        sShowToolBar = LayoutPrefs.getLayoutBooleanPref(TOOLBAR);
        sShowStatusBar = LayoutPrefs.getLayoutBooleanPref(STATUSBAR);
        sShowToolNames = LayoutPrefs.getLayoutBooleanPref(TOOLNAMES);
        sShowExtension = LayoutPrefs.getLayoutBooleanPref(EXTENSION);
        sShowFullPath = LayoutPrefs.getLayoutBooleanPref(FULLPATH);
        sSaveActivate = LayoutPrefs.getLayoutBooleanPref(ACTIVATE);
        sSaveExport = LayoutPrefs.getLayoutBooleanPref(EXPORT);
        sAddMCodeComments = LayoutPrefs.getLayoutBooleanPref(COMMENTS);
        sChangeDefaultCallback = LayoutPrefs.getLayoutBooleanPref(CHANGEDEFAULTCALLBACK);
        Prefs.addListener((PrefListener)new PrefChanged(), (String)TYPE);
    }

    private static class PrefChanged
    implements PrefListener {
        private PrefChanged() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            sShowToolBar = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.TOOLBAR);
            sShowStatusBar = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.STATUSBAR);
            sShowToolNames = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.TOOLNAMES);
            sShowExtension = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.EXTENSION);
            sShowFullPath = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.FULLPATH);
            sSaveActivate = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.ACTIVATE);
            sSaveExport = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.EXPORT);
            sAddMCodeComments = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.COMMENTS);
            sChangeDefaultCallback = LayoutPrefs.getLayoutBooleanPref(LayoutPrefs.CHANGEDEFAULTCALLBACK);
        }
    }
}

