/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.dragdrop;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragTracker;
import com.mathworks.toolbox.matlab.guide.scroll.ScrollPanel;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoFigure;
import com.mathworks.toolbox.matlab.guide.utils.LayoutWorker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class CornerDrag
extends DragTracker {
    private static final int MIN_WIDTH = 72;
    private static final int MIN_HEIGHT = 24;
    private Component fTarget;
    private Object fHandle;
    private Object fAdapter;
    private Rectangle fAperture;
    private Point fOffsetPt;
    private Point fCurrentPt;
    private boolean fIsDragging = false;

    public CornerDrag(LayoutArea layoutArea, Component component) {
        super(layoutArea);
        this.fTarget = component;
        this.init();
    }

    public CornerDrag(LayoutArea layoutArea, Object object, Object object2) {
        super(layoutArea);
        this.fHandle = object;
        this.fAdapter = object2;
        this.init();
    }

    private void init() {
        this.fOffsetPt = this.fLayoutArea.getLocation();
        for (Container container = this.fLayoutArea.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof ScrollPanel)) continue;
            this.fAperture = ((ScrollPanel)container).getAperture();
            break;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fLayoutArea.selectAll(false);
        this.fLayoutArea.drawNow();
        if (this.fLayoutArea.getLayoutStatusBar() != null) {
            this.fLayoutArea.getLayoutStatusBar().setPosition(this.fLayoutArea.getRuntimeArea().getRuntimeBounds());
        }
        this.fIsDragging = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.fLayoutArea.getLayoutEditor().setCursor(this.fLayoutArea.getCursor());
        Graphics graphics = this.getXORGraphics(this.fLayoutArea.getParent(), true);
        this.drawMarquee(graphics);
        this.fCurrentPt = this.pinPoint(mouseEvent.getPoint());
        this.drawMarquee(graphics);
        graphics.dispose();
        Rectangle rectangle = this.fLayoutArea.getRuntimeArea().getRuntimeBounds();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + this.fLayoutArea.getHeight() - this.fCurrentPt.y, this.fCurrentPt.x, this.fCurrentPt.y);
        if (this.fLayoutArea.getLayoutStatusBar() != null) {
            this.fLayoutArea.getLayoutStatusBar().setPosition(rectangle2);
        }
        this.fIsDragging = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.fLayoutArea.getLayoutEditor().setCursor(Cursor.getDefaultCursor());
        if (this.fIsDragging) {
            Graphics graphics = this.getXORGraphics();
            this.drawMarquee(graphics);
            graphics.dispose();
            this.fCurrentPt = this.pinPoint(mouseEvent.getPoint());
            if (this.fTarget != null) {
                this.fTarget.setSize(this.fCurrentPt.x, this.fCurrentPt.y);
            } else if (this.fHandle != null) {
                LayoutLooper.resizeFigure(this.fHandle, this.fCurrentPt, new ResizeObserver(this.fLayoutArea, this.fAdapter));
            }
        }
        this.fIsDragging = false;
    }

    private Point pinPoint(Point point) {
        if (this.fAperture != null) {
            if (point.x < this.fAperture.x) {
                point.x = this.fAperture.x;
            } else if (point.x > this.fAperture.x + this.fAperture.width) {
                point.x = this.fAperture.x + this.fAperture.width;
            }
            if (point.y < this.fAperture.y) {
                point.y = this.fAperture.y;
            } else if (point.y > this.fAperture.y + this.fAperture.height) {
                point.y = this.fAperture.y + this.fAperture.height;
            }
        }
        if (point.x < 72) {
            point.x = 72;
        }
        if (point.y < 24) {
            point.y = 24;
        }
        return point;
    }

    private void drawMarquee(Graphics graphics) {
        if (this.fCurrentPt != null) {
            graphics.drawRect(this.fOffsetPt.x, this.fOffsetPt.y, this.fCurrentPt.x - 1, this.fCurrentPt.y - 1);
        }
    }

    private static class ResizeObserver
    implements CompletionObserver {
        private Object fAdapter;
        private LayoutArea fLayoutArea;

        ResizeObserver(LayoutArea layoutArea, Object object) {
            this.fAdapter = object;
            this.fLayoutArea = layoutArea;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                Object[] objectArray = (Object[])object;
                Vector<Object[]> vector = new Vector<Object[]>(1);
                Object[] objectArray2 = new Object[]{objectArray[0], objectArray[1]};
                vector.add(objectArray2);
                UndoFigure undoFigure = new UndoFigure(this.fLayoutArea, vector);
                this.fLayoutArea.setProperties(objectArray2);
                this.fLayoutArea.fireUndoEvent(undoFigure);
                Object[] objectArray3 = new Object[]{this.fAdapter};
                ObjectRegistry.getLayoutRegistry().change(objectArray3);
            }
        }
    }
}

