/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.undoredo;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import com.mathworks.toolbox.matlab.guide.undoredo.LayoutUndoableEdit;
import java.util.Vector;

public class UndoAdd
extends LayoutUndoableEdit {
    private LayoutArea fLayout;
    private int fWrapperCount;
    private LOControlWrapper[] fWrappers;
    private LOWrapperOwner[] fOwners;

    public UndoAdd(LayoutArea layoutArea, Vector vector) {
        this.fLayout = layoutArea;
        this.fWrapperCount = vector.size();
        this.fWrappers = new LOControlWrapper[this.fWrapperCount];
        this.fOwners = new LOWrapperOwner[this.fWrapperCount];
        for (int i = 0; i < this.fWrapperCount; ++i) {
            this.fWrappers[i] = (LOControlWrapper)vector.elementAt(i);
            this.fOwners[i] = this.fWrappers[i].getParent();
            if (this.fOwners[i] != null) continue;
            this.fOwners[i] = this.fLayout;
        }
    }

    @Override
    public void undo() {
        this.fLayout.selectAll(false);
        Vector<GObjectWrapper> vector = new Vector<GObjectWrapper>(this.fWrapperCount);
        for (int i = 0; i < this.fWrapperCount; ++i) {
            if (this.fWrappers[i].isGObject()) {
                GObjectWrapper gObjectWrapper = (GObjectWrapper)this.fWrappers[i];
                this.fLayout.removeServices(this.fWrappers[i]);
                this.fLayout.unregister(this.fWrappers[i]);
                vector.addElement(gObjectWrapper);
                this.fOwners[i].removeWrapper(gObjectWrapper, false);
                continue;
            }
            this.fLayout.removeServices(this.fWrappers[i]);
            this.fLayout.unregister(this.fWrappers[i]);
            this.fOwners[i].removeWrapper(this.fWrappers[i], true);
        }
        if (vector.size() > 0) {
            GObjectWrapper[] gObjectWrapperArray = new GObjectWrapper[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                gObjectWrapperArray[i] = (GObjectWrapper)vector.elementAt(i);
            }
            LayoutLooper.deleteGObjects(gObjectWrapperArray, this.fLayout);
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    public void redo() {
        this.fLayout.selectAll(false);
        Vector<GObjectWrapper> vector = new Vector<GObjectWrapper>(this.fWrapperCount);
        for (int i = 0; i < this.fWrapperCount; ++i) {
            if (this.fWrappers[i].isGObject()) {
                GObjectWrapper gObjectWrapper = (GObjectWrapper)this.fWrappers[i];
                this.fLayout.selectObject(gObjectWrapper, true);
                vector.addElement(gObjectWrapper);
                this.fOwners[i].addWrapper(gObjectWrapper, -1, false);
                if (!gObjectWrapper.isBean()) continue;
                this.fLayout.addServices(gObjectWrapper);
                continue;
            }
            this.fLayout.selectObject(this.fWrappers[i], true);
            this.fOwners[i].addWrapper(this.fWrappers[i], -1, true);
            this.fLayout.register(this.fWrappers[i]);
            this.fLayout.addServices(this.fWrappers[i]);
        }
        if (vector.size() > 0) {
            GObjectWrapper[] gObjectWrapperArray = new GObjectWrapper[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                gObjectWrapperArray[i] = (GObjectWrapper)vector.elementAt(i);
            }
            LayoutLooper.requestGObjects(this.fOwners, gObjectWrapperArray, this.fLayout);
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    String getUndoTypeKey() {
        return "undo.add";
    }
}

