/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocPage;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.HelpLocationRegistry;
import com.mathworks.html.ChildUrlRelativizer;
import com.mathworks.html.FileUrl;
import com.mathworks.html.RelativeUrl;
import com.mathworks.html.Url;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DocUrlParser {
    private final DocRoot<? extends Url> fDocRoot;
    private final Map<String, File> fAltLocalDocRoots;
    private final HelpLocationRegistry fRegistry;
    private final Iterable<DocUrlNavigationRule> fDocUrlNavigationRules;

    public DocUrlParser(DocRoot<? extends Url> docRoot, Iterable<File> iterable, DocumentationSet documentationSet, Iterable<DocUrlNavigationRule> iterable2) {
        this.fDocRoot = docRoot;
        this.fAltLocalDocRoots = DocUrlParser.buildAltDocRootMap(iterable);
        this.fRegistry = new HelpLocationRegistry(documentationSet);
        this.fDocUrlNavigationRules = iterable2;
    }

    private static Map<String, File> buildAltDocRootMap(Iterable<File> iterable) {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (File file : iterable) {
            try {
                hashMap.put(file.getCanonicalPath(), file);
            }
            catch (IOException iOException) {
                hashMap.put(file.getAbsolutePath(), file);
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public DocPage resolve(Url url) {
        RelativeUrl relativeUrl;
        DocPage docPage = this.resolveUnderDocRoot(url);
        if (docPage != null && docPage.getDocSetItem() != null) {
            return docPage;
        }
        if (url.getType() == Url.UrlType.FILE && (relativeUrl = this.getRelativeUrlFromAlternateDocRoot(url)) != null) {
            DocPage docPage2 = this.toDocPage(relativeUrl);
            if (docPage2 != null) {
                return docPage2;
            }
            return new DocPage(null, relativeUrl);
        }
        return docPage;
    }

    public DocPage resolveUnderDocRoot(Url url) {
        DocPage docPage;
        if (this.fDocRoot.isSearchPageUrl(url)) {
            return null;
        }
        RelativeUrl relativeUrl = this.fDocRoot.getRelativeUrlTo(url, this.fDocUrlNavigationRules);
        if (relativeUrl != null && (docPage = this.toDocPage(relativeUrl)) != null) {
            return docPage;
        }
        return relativeUrl != null ? new DocPage(null, relativeUrl) : null;
    }

    private RelativeUrl getRelativeUrlFromAlternateDocRoot(Url url) {
        for (File file : this.fAltLocalDocRoots.values()) {
            ChildUrlRelativizer childUrlRelativizer = new ChildUrlRelativizer((Url)new FileUrl(file));
            RelativeUrl relativeUrl = childUrlRelativizer.getRelativeUrlTo(url);
            if (relativeUrl == null) continue;
            return relativeUrl;
        }
        return null;
    }

    public boolean isAlternateDocRoot(File file) {
        try {
            return this.fAltLocalDocRoots.containsKey(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return this.fAltLocalDocRoots.containsKey(file.getAbsolutePath());
        }
    }

    private DocPage toDocPage(RelativeUrl relativeUrl) {
        String string = relativeUrl.getRelativePath();
        String[] stringArray = string.split("/");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('/');
            }
            stringBuilder.append(string2);
            DocSetItem docSetItem = this.fRegistry.getItemByHelpLocation(stringBuilder.toString());
            if (docSetItem == null) continue;
            if (string.length() > stringBuilder.length()) {
                String string3 = string.substring(stringBuilder.length() + 1);
                RelativeUrl relativeUrl2 = new RelativeUrl(string3, relativeUrl.getParameters(), relativeUrl.getTarget());
                return new DocPage(docSetItem, relativeUrl2);
            }
            return new DocPage(docSetItem, new RelativeUrl("", relativeUrl.getParameters(), relativeUrl.getTarget()));
        }
        return null;
    }
}

