/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.json;

import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonPrimitive;
import com.mathworks.help.helpui.json.JsonString;
import java.util.LinkedList;
import java.util.List;

public class JsonArray
extends JsonEntity {
    private final List<JsonEntity> fItems = new LinkedList<JsonEntity>();

    public void addEntity(JsonEntity jsonEntity) {
        this.fItems.add(jsonEntity);
    }

    public void addString(String string) {
        this.fItems.add(new JsonString(string));
    }

    public void addInt(int n) {
        this.addPrimitive(new JsonPrimitive(n));
    }

    public void addBoolean(boolean bl) {
        this.addPrimitive(new JsonPrimitive(bl));
    }

    public void addPrimitive(JsonPrimitive jsonPrimitive) {
        this.fItems.add(jsonPrimitive);
    }

    @Override
    public String getJsonString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (JsonEntity jsonEntity : this.fItems) {
            stringBuilder.append(jsonEntity.getJsonString()).append(',');
        }
        if (!this.fItems.isEmpty()) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int size() {
        return this.fItems.size();
    }

    public String getJsonStringAtIndex(int n) {
        JsonEntity jsonEntity = this.fItems.get(n);
        return jsonEntity == null ? null : ((Object)jsonEntity).toString();
    }
}

