/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.json;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonStringUtils {
    private static final Pattern NON_ASCII_PATTERN = Pattern.compile("[^\\x00-\\x7f]+");

    private JsonStringUtils() {
    }

    public static String escapeJsonString(String string) {
        String string2 = string.replaceAll("[\"\\\\]", "\\\\$0");
        string2 = JsonStringUtils.escapeNonAsciiCharacters(string2);
        string2 = string2.replaceAll("\\n", "\\\\n");
        return string2;
    }

    private static String escapeNonAsciiCharacters(String string) {
        Matcher matcher = NON_ASCII_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = JsonStringUtils.unicodeEscape(matcher.group());
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string2));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String unicodeEscape(String string) {
        char[] cArray;
        if (string.isEmpty()) {
            return string;
        }
        if (string.length() == 1) {
            return JsonStringUtils.unicodeEscape(string.charAt(0));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : cArray = string.toCharArray()) {
            stringBuilder.append(JsonStringUtils.unicodeEscape(c));
        }
        return stringBuilder.toString();
    }

    private static String unicodeEscape(char c) {
        return String.format("\\u%04x", c);
    }

    public static String toJsonString(String string) {
        return "\"" + JsonStringUtils.escapeJsonString(string) + "\"";
    }
}

