/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer;

import com.mathworks.messageservice.MessageService;
import com.mathworks.peermodel.PeerModelManagerSyncable;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observable;
import com.mathworks.peermodel.impl.EventImpl;
import com.mathworks.peermodel.synchronizer.PeerSynchronizer;
import com.mathworks.peermodel.synchronizer.utils.EventCoalescer;
import com.mathworks.peermodel.synchronizer.utils.ImageDifferencer;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BatchedPeerSynchronizer
extends PeerSynchronizer {
    protected EventCoalescer eventCoalescer = new EventCoalescer(this);

    public BatchedPeerSynchronizer(String namespace, PeerModelManagerSyncable manager, MessageService messageService) {
        super(namespace, manager, messageService);
    }

    public BatchedPeerSynchronizer(String namespace, PeerModelManagerSyncable manager, MessageService messageService, boolean isClient) {
        super(namespace, manager, messageService, isClient);
    }

    @Override
    public void remove() {
        super.remove();
        this.eventCoalescer.cleanUp();
    }

    public EventCoalescer getEventCoalescer() {
        return this.eventCoalescer;
    }

    @Override
    public void rootSetObserver(Event event) {
        this.addNodeListeners(event.getTarget());
        if (this.shouldSync(event)) {
            this.eventCoalescer.add(event);
        }
    }

    @Override
    public void rootDestroyedObserver(Event event) {
        if (this.shouldSync(event)) {
            this.eventCoalescer.add(event);
        }
    }

    @Override
    public void childMovedObserver(Event event) {
        if (this.shouldSync(event)) {
            this.eventCoalescer.add(event);
        }
    }

    public void childMovingObserver(Event event) {
        if (this.shouldSync(event)) {
            this.eventCoalescer.flushNow();
        }
    }

    @Override
    public void childAddedObserver(Event event) {
        PeerNode child = (PeerNode)event.getData().get("child");
        this.addNodeListeners(child);
        if (this.shouldSync(event) && this.isReady()) {
            this.eventCoalescer.add(event);
        }
    }

    @Override
    public void subTreeDestroyedObserver(Event event) {
        this.removeNodeListenersRecursive((PeerNode)event.getData().get("child"));
        if (this.shouldSync(event) && this.isReady()) {
            this.eventCoalescer.add(event);
        }
    }

    public void propertySetObserver(Event event) {
        if (this.shouldSync(event) && this.isReady() && (event.getTarget().hasParent() || event.getTarget().equals(this.manager.getRoot()))) {
            Object newValue = event.getData().get("newValue");
            Object oldValue = event.getData().get("oldValue");
            if (newValue instanceof BufferedImage) {
                if (oldValue != null && oldValue instanceof BufferedImage && ((BufferedImage)newValue).getType() == ((BufferedImage)oldValue).getType() && ((BufferedImage)newValue).getWidth() == ((BufferedImage)oldValue).getWidth() && ((BufferedImage)newValue).getHeight() == ((BufferedImage)oldValue).getHeight()) {
                    Collection<Map<String, Object>> diffImages = ImageDifferencer.computeImageDifferences((BufferedImage)oldValue, (BufferedImage)newValue);
                    if (!diffImages.isEmpty()) {
                        HashMap data = new HashMap();
                        data.put("key", event.getData().get("key"));
                        data.put("newValue", diffImages);
                        EventImpl imageUpdateEvent = new EventImpl("imageUpdate", this.originator, event.getTarget(), data);
                        this.eventCoalescer.add((Event)imageUpdateEvent);
                    }
                } else {
                    this.eventCoalescer.add(event);
                }
            } else {
                this.eventCoalescer.add(event);
            }
        }
    }

    public void propertyUnsetObserver(Event event) {
        this.eventCoalescer.add(event);
    }

    @Override
    public void peerEventObserver(Event event) {
        if (this.shouldSync(event)) {
            if (this.isReady()) {
                this.eventCoalescer.add(event);
            } else {
                this.peerEventQueue.add(event);
            }
        }
    }

    @Override
    protected void addSyncManagerListeners() {
        super.addSyncManagerListeners();
        this.addListener((Observable)this.manager, "childMoving");
    }

    @Override
    protected void removeSyncManagerListeners() {
        super.removeSyncManagerListeners();
        this.removeListener((Observable)this.manager, "childMoving");
    }

    @Override
    protected void addNodeListeners(PeerNode target) {
        this.addListener((Observable)target, "childAdded");
        this.addListener((Observable)target, "childDetached");
        this.addListener((Observable)target, "childReattached");
        this.addListener((Observable)target, "subTreeDestroyed");
        this.addListener((Observable)target, "propertySet");
        this.addListener((Observable)target, "propertyUnset");
        this.addListener((Observable)target, "peerEvent");
    }

    @Override
    protected void removeNodeListeners(PeerNode target) {
        this.removeListener((Observable)target, "childAdded");
        this.removeListener((Observable)target, "childDetached");
        this.removeListener((Observable)target, "childReattached");
        this.removeListener((Observable)target, "subTreeDestroyed");
        this.removeListener((Observable)target, "propertySet");
        this.removeListener((Observable)target, "propertyUnset");
        this.removeListener((Observable)target, "peerEvent");
    }

    @Override
    protected void addSyncMessageSubscriptions() {
        this.subscribe("rootSet");
        this.subscribe("rootDestroyed");
        this.subscribe("getFullUpdate");
        this.subscribe("fullUpdate");
        this.subscribe("childMoved");
        this.subscribe("childDetached");
        this.subscribe("childReattached");
        this.subscribe("subTreeAdded");
        this.subscribe("subTreeDestroyed");
        this.subscribe("propertiesSet");
        this.subscribe("imageUpdate");
        this.subscribe("propertiesUnset");
        this.subscribe("peerEvent");
    }

    @Override
    protected void removeSyncMessageSubscriptions() {
        this.unsubscribe("rootSet");
        this.unsubscribe("rootDestroyed");
        this.unsubscribe("getFullUpdate");
        this.unsubscribe("fullUpdate");
        this.unsubscribe("childMoved");
        this.unsubscribe("childDetached");
        this.unsubscribe("childReattached");
        this.unsubscribe("subTreeAdded");
        this.unsubscribe("subTreeDestroyed");
        this.unsubscribe("propertiesSet");
        this.unsubscribe("imageUpdate");
        this.unsubscribe("propertiesUnset");
        this.unsubscribe("peerEvent");
    }
}

