/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer;

import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.peermodel.PeerModelManagerSyncable;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.PeerNodeSyncable;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.impl.EventImpl;
import com.mathworks.peermodel.synchronizer.BatchedPeerSynchronizer;
import com.mathworks.peermodel.synchronizer.utils.ImageDifferencer;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CollabPeerSynchronizer
extends BatchedPeerSynchronizer {
    public CollabPeerSynchronizer(String namespace, PeerModelManagerSyncable manager, MessageService messageService) {
        super(namespace, manager, messageService);
    }

    public CollabPeerSynchronizer(String namespace, PeerModelManagerSyncable manager, MessageService messageService, boolean isClient) {
        super(namespace, manager, messageService, isClient);
    }

    @Override
    public void propertySetObserver(Event event) {
        if (this.shouldSync(event) && this.isReady() && (event.getTarget().hasParent() || event.getTarget().equals(this.manager.getRoot()))) {
            String key = (String)event.getData().get("key");
            Object newValue = event.getData().get("newValue");
            Object oldValue = event.getData().get("oldValue");
            this.incrementVersionVector(event.getTarget(), key);
            HashMap<String, Map> versionVectors = new HashMap<String, Map>();
            versionVectors.put(key, ((PeerNodeSyncable)event.getTarget()).getVersionVector(key));
            HashMap<String, HashMap<String, Map>> data = new HashMap<String, HashMap<String, Map>>();
            data.putAll(event.getData());
            data.put("versionVector", versionVectors);
            event = new EventImpl(event.getType(), event.getTarget(), data);
            if (newValue instanceof BufferedImage) {
                if (oldValue != null && oldValue instanceof BufferedImage && ((BufferedImage)newValue).getType() == ((BufferedImage)oldValue).getType() && ((BufferedImage)newValue).getWidth() == ((BufferedImage)oldValue).getWidth() && ((BufferedImage)newValue).getHeight() == ((BufferedImage)oldValue).getHeight()) {
                    Collection<Map<String, Object>> diffImages = ImageDifferencer.computeImageDifferences((BufferedImage)oldValue, (BufferedImage)newValue);
                    if (!diffImages.isEmpty()) {
                        HashMap<String, Object> diffData = new HashMap<String, Object>();
                        diffData.put("key", key);
                        diffData.put("newValue", diffImages);
                        EventImpl imageUpdateEvent = new EventImpl("imageUpdate", this.originator, event.getTarget(), diffData);
                        this.eventCoalescer.add((Event)imageUpdateEvent);
                    }
                } else {
                    this.eventCoalescer.add(event);
                }
            } else {
                this.eventCoalescer.add(event);
            }
        }
    }

    @Override
    public void publishPropertiesSetMessage(Event event) {
        if (this.manager.hasById(event.getTarget().getId())) {
            Map<String, Object> message = this.createNewMessage();
            message.put("targetId", event.getTarget().getId());
            message.put("properties", event.getData().get("newValues"));
            message.put("versionVector", event.getData().get("versionVector"));
            this.messageService.publish(this.getChannel(event.getType()), message);
        }
    }

    @Override
    public void propertiesSetSubscriber(Message message) {
        Map data;
        String targetId;
        if (this.shouldSync() && this.manager.hasById(targetId = (String)(data = (Map)message.getData()).get("targetId"))) {
            PeerNode node = this.manager.getById(targetId);
            if (data.get("properties") instanceof Map) {
                Map properties = (Map)data.get("properties");
                HashSet keys = new HashSet(properties.keySet());
                for (String key : keys) {
                    Map versionVectors = (Map)data.get("versionVector");
                    Map otherVersionVector = null;
                    if (versionVectors != null) {
                        otherVersionVector = (Map)versionVectors.get(key);
                    }
                    if (!this.shouldUpdateProperty(node, key, otherVersionVector) || properties.get(key) == null) {
                        properties.remove(key);
                    }
                    this.updateVersionVector(node, key, otherVersionVector);
                }
                node.setProperties(properties, this.originator);
            }
        }
    }

    private void incrementVersionVector(PeerNode node, String key) {
        PeerNodeSyncable syncable = (PeerNodeSyncable)node;
        if (this.isClient() || syncable.getVersionVector(key) != null) {
            syncable.incrementVersionVector(key, this.getClientId(), this.getAllPeers());
        }
    }

    private void updateVersionVector(PeerNode node, String key, Map<String, Double> otherVersionVector) {
        ((PeerNodeSyncable)node).mergeVersionVectors(key, otherVersionVector);
    }

    private boolean shouldUpdateProperty(PeerNode node, String key, Map<String, Double> otherVersionVector) {
        PeerNodeSyncable syncNode = (PeerNodeSyncable)node;
        Map versionVector = syncNode.getVersionVector(key);
        if (this.isClient()) {
            return versionVector == null || otherVersionVector != null;
        }
        if (versionVector == null || otherVersionVector == null) {
            return true;
        }
        if (versionVector.containsKey(this.getClientId()) | otherVersionVector.containsKey(this.getClientId())) {
            return true;
        }
        Integer localVersion = (Integer)versionVector.get(this.getClientId());
        Double remoteVersion = otherVersionVector.get(this.getClientId());
        return localVersion == null || remoteVersion == null || (double)localVersion.intValue() <= remoteVersion;
    }

    @Override
    protected Map<String, Object> convertNode(PeerNode node, int index) {
        Map<String, Object> props = super.convertNode(node, index);
        Map versionVectors = ((PeerNodeSyncable)node).getVersionVectors();
        if (versionVectors != null) {
            props.put("versionVectors", versionVectors);
        }
        return props;
    }

    @Override
    protected void updateNodeRecursive(PeerNodeSyncable node, Map<String, Object> data, boolean replaceProps) {
        if (data.containsKey("versionVectors")) {
            Map vector = (Map)data.get("versionVectors");
            for (Map.Entry entry : vector.entrySet()) {
                node.mergeVersionVectors((String)entry.getKey(), (Map)entry.getValue());
            }
        }
        super.updateNodeRecursive(node, data, replaceProps);
    }
}

