/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentPrimitiveReader;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.util.DefaultSyncICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.mwSystem;
import java.io.File;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class I2C
extends InstrumentPrimitiveReader {
    private static final int SUCCESS = 0;
    protected Object[] fConstructorArgs = new Object[3];
    protected int fRemoteAddress = 0;
    protected int fId = 0;
    protected int fBoardIndex = 0;
    protected double fBitRate = 100.0;
    protected String fBoardSerial = "0";
    protected int fPullupResistors = 1;
    protected String fVendor;
    protected long configurationHandle = 0L;
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final int VENDOR_DRIVER_NAME = 3;
    protected static final int VENDOR_DRIVER_DESCRIPTION = 4;
    protected static final int VENDOR_DRIVER_VERSION = 5;
    private static final String[] I2C_ADAPTORS = AdaptorInfo.I2C_ADAPTORS;
    private static final String[] I2C_NAME = AdaptorInfo.I2C_VENDORS;
    protected static final Object[] BOARDINDEXVALUES = new Object[]{new Double(0.0), new Double(8.0)};
    protected static final Object[] BOARDSERIALVALUES = new Object[]{new Double(0.0), new Double(2.147483647E9)};
    protected static final Object[] REMOTEADDRESSES = new Object[]{new Double(0.0), new Double(7.0)};
    protected static final Object[] BITRATES = new Object[]{new Double(0.0), new Double(Double.MAX_VALUE)};
    protected static final Object[] PULLUP_VALS = new Object[]{"none", "both"};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Type", "string", "none", "", "i2c", "always", 0, 0), new ICProp("BitRate", "double", "bounded", BITRATES, new Double(100.0), "never", 1, 0), new ICProp("BoardIndex", "double", "none", BOARDINDEXVALUES, new Integer(0), "always", 1, 0), new ICProp("BoardSerial", "string", "none", BOARDSERIALVALUES, "0", "always", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("fPullupResistors", "string", "enum", PULLUP_VALS, "both", "never", 1, 0), new ICProp("RemoteAddress", "double", "bounded", REMOTEADDRESSES, new Integer(0), "never", 1, 0), new ICProp("Vendor", "string", "none", "", "", "always", 1, 0)};
    protected static final ResourceBundle sI2CResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.resources.RES_I2C");

    public I2C() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            I2C.displayError("The Instrument Control Toolbox license check failed when trying to execute: 'i2c'.");
        }
        this.objectProps = DefaultSyncICProp.addObjectPropsToDefaultProps(objectICProps);
    }

    I2C(String string, String string2, int n, int n2) throws TMException {
        if (!string2.equalsIgnoreCase("Test")) {
            try {
                mwSystem.load((String)string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                I2C.displayError(unsatisfiedLinkError.getMessage());
            }
            this.fConstructorArgs[0] = string2;
            this.fConstructorArgs[1] = new Integer(n);
            this.fConstructorArgs[2] = new Integer(n2);
        }
        this.fBoardIndex = n;
        this.fRemoteAddress = n2;
        this.fVendor = string2;
        this.type = "i2c";
        this.displayName = "I2C connection";
        this.objectProps = DefaultSyncICProp.addObjectPropsToDefaultProps(objectICProps);
        this.name = "I2C-" + this.fBoardIndex + "-" + Integer.toHexString(this.fRemoteAddress) + "h";
        try {
            this.openHardware();
            this.fBoardSerial = this.getHardwareBoardSerial(this.fId);
            this.fPullupResistors = this.nativeGetPullupResistors(this.fId);
            this.closeHardware();
        }
        catch (Exception exception) {
            this.fBoardSerial = "0";
            this.fPullupResistors = 0;
        }
    }

    @Override
    public String getConstructor() {
        return new String("i2c('" + this.fVendor + "', " + this.fBoardIndex + ", " + this.fRemoteAddress + ");");
    }

    @Override
    public String getConstructorDescription() {
        return "Vendor - " + this.getVendor() + ", BoardIndex - " + Integer.toString(this.fBoardIndex) + ", RemoteAddress - " + this.getRemoteAddress();
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'BoardIndex'," + this.fBoardIndex + ",'RemoteAddress', " + this.fRemoteAddress + ", 'Tag', '" + this.tag + "');";
    }

    @Override
    public void dispose() throws TMException {
        super.dispose();
    }

    @Override
    protected void addToPoller() {
        Poller.addInstrument(this);
        if (this.timerFcn == ACTION) {
            return;
        }
        if (!this.wasTimerStarted) {
            this.createTimer();
        } else {
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    @Override
    public void openHardware() throws Exception {
        this.fId = this.nativeOpen(this.fBoardIndex);
        if (this.fId < 0) {
            this.fId = 0;
            I2C.displayError(sInstrumentResources.getString("Instrument.general.openfailed"));
        }
    }

    @Override
    protected void updatePropsOnOpen() throws Exception {
        try {
            this.setBitRate(this.fBitRate);
            this.setPullupResistors(this.fPullupResistors);
        }
        catch (Exception exception) {
            this.fPullupResistors = 0;
        }
    }

    @Override
    public void closeHardware() throws Exception {
        this.nativeClose(this.fId);
    }

    public final Object[] hexread(int n, int n2, int n3) throws Exception {
        int n4;
        Object[] objectArray = new Object[3];
        if (this.status != 1) {
            I2C.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if ((n4 = n * DATASIZE[n2]) > this.inputBufferSize) {
            I2C.displayError(sInstrumentResources.getString("Instrument.general.readtoomuch"));
        }
        try {
            Object[] objectArray2 = this.nativeReadImpl(this.fId, this.configurationHandle, this.fRemoteAddress, n4);
            int n5 = (Integer)objectArray2[1];
            if (n5 > 0) {
                this.valuesReceived += (long)n5;
                this.writeRawDataToFile(objectArray2[0], n5, n2, "<", "", n3);
                objectArray[0] = this.convertBinaryData((byte[])objectArray2[0], n2, n4);
                objectArray[1] = new Integer(n4 / DATASIZE[n2]);
                objectArray[2] = null;
                return objectArray;
            }
            I2C.displayError(sInstrumentResources.getString("Instrument.general.i2creadfailed"));
        }
        catch (Exception exception) {
            objectArray[0] = "";
            objectArray[1] = INTEGER_ZERO;
            objectArray[2] = exception.getMessage();
        }
        return objectArray;
    }

    public final void fwrite(Object object, int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray;
        Object object2;
        this.verifyObjectState();
        if (DATASIZE[n2] * n > this.outputBufferSize - this.bytesToOutput) {
            throw new TMException("The number of bytes written must be less than or equal to OutputBufferSize-BytesToOutput.");
        }
        if (object instanceof Long[]) {
            object2 = new int[n];
            for (int i = 0; i < n; ++i) {
                object2[i] = ((Long[])object)[i].intValue();
            }
            objectArray = this.writeBinary(object2, n, n2, n3);
            this.valuesSent += (long)((Integer)objectArray[0]).intValue();
            this.writeRawDataToFile(object2, n, n2, ">", "", n4);
        } else {
            objectArray = this.writeBinarySync(object, n, n2);
            this.valuesSent += (long)((Integer)objectArray[0]).intValue();
            this.writeRawDataToFile(object, n, n2, ">", "", n4);
        }
        object2 = (String)objectArray[1];
        if (!((String)object2).equals("")) {
            throw new TMException((String)object2);
        }
        objectArray = null;
    }

    protected Object[] writeBinarySync(Object object, int n, int n2) throws Exception {
        int n3 = this.writeBinaryToHardware(object, n, n2);
        Object[] objectArray = new Object[2];
        if (n3 < this.getSuccessValue()) {
            objectArray[0] = INTEGER_ZERO;
            objectArray[1] = this.getErrorMessageFromHardware(n3);
        } else {
            objectArray[0] = new Integer(n3);
            objectArray[1] = "";
        }
        return objectArray;
    }

    protected Object[] writeBinary(Object object, int n, int n2, int n3) throws Exception {
        this.writeTransferMode = n3;
        switch (n3) {
            case 0: {
                return this.writeBinarySync(object, n, n2);
            }
        }
        throw new TMException("Invalid TransferMode specified.");
    }

    public static ICProp[] getProperties() {
        return DefaultSyncICProp.addObjectPropsToDefaultProps(objectICProps);
    }

    protected int writeBinaryToHardware(Object object, int n, int n2) throws Exception {
        int n3;
        byte[] byArray = BinarySwapBytes.getBinaryDataToWrite(object, n2, this.byteOrder);
        if (byArray == null) {
            byArray = new byte[]{0};
            n3 = 0;
        } else {
            n3 = byArray.length;
        }
        int n4 = this.nativeWriteImpl(this.fId, this.configurationHandle, this.fRemoteAddress, byArray, n3);
        return n4;
    }

    public String getVendor() {
        return this.fVendor;
    }

    public void setVendor(String string) throws TMException {
        I2C.displayError(this.createReadOnlyPropertyError("Vendor"));
    }

    public int getBoardIndex() throws TMException {
        return this.fBoardIndex;
    }

    public void setBoardIndex(int n) throws TMException {
        I2C.displayError(this.createReadOnlyPropertyError("BoardIndex"));
    }

    public void setBitRate(double d) throws TMException {
        if (d < 1.0) {
            I2C.displayError(sI2CResources.getString("I2c.opFailed.minimumClockSpeed"));
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            I2C.displayError(sI2CResources.getString("I2c.opFailed.maximumClockSpeed"));
        }
        if (Math.floor(d) != d) {
            I2C.displayWarning(sI2CResources.getString("I2c.warning.nonIntegerRate"));
            d = Math.floor(d);
        }
        if (this.status == 1) {
            this.nativeSetBitRate(this.fId, this.configurationHandle, d);
            this.fBitRate = this.nativeGetBitRate(this.fId, this.configurationHandle);
            if (this.fBitRate != d) {
                I2C.displayWarning(MessageFormat.format(sI2CResources.getString("I2c.warning.adjustedBitRate"), String.valueOf(d), String.valueOf(this.fBitRate)));
            }
        } else {
            this.fBitRate = d;
        }
        this.postPropertyChangedEvent("BitRate", new Double(this.fBitRate));
    }

    public double getBitRate() {
        return this.fBitRate;
    }

    @Override
    protected int getSuccessValue() {
        return 0;
    }

    public int getPullupResistors() throws TMException {
        if (this.status == 1) {
            return this.nativeGetPullupResistors(this.fId);
        }
        return this.fPullupResistors;
    }

    public void setPullupResistors(int n) throws TMException {
        if (this.status == 1 && this.nativeSetPullupResistors(this.fId, n) < 0) {
            I2C.displayError(sInstrumentResources.getString("Instrument.general.operationfailed"));
        } else {
            this.fPullupResistors = n;
            this.postPropertyChangedEvent("PullupResistors", PULLUP_VALS[this.fPullupResistors]);
        }
    }

    public void setBoardSerial(double d) throws TMException {
        I2C.displayError(this.createReadOnlyPropertyError("BoardSerial"));
    }

    public String getBoardSerial() throws TMException {
        if (this.status == 1) {
            String string = this.getHardwareBoardSerial(this.fId);
            return string;
        }
        return this.fBoardSerial;
    }

    public String getRemoteDisplayAddress() {
        return Integer.toHexString(this.fRemoteAddress) + "h";
    }

    public int getRemoteAddress() {
        return this.fRemoteAddress;
    }

    public void setRemoteAddress(String string) throws TMException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            I2C.displayError(sI2CResources.getString("I2c.RemoteAddress.invalidString"));
        }
        if (0 <= n && n <= Integer.MAX_VALUE) {
            this.fRemoteAddress = n;
        } else {
            I2C.displayError(sI2CResources.getString("I2c.RemoteAddress.outOfBounds"));
        }
        this.setName("I2C-" + this.fBoardIndex + "-" + Integer.toHexString(this.fRemoteAddress) + "h");
        this.postPropertyChangedEvent("RemoteAddress", new Integer(this.fRemoteAddress));
    }

    public void setRemoteAddress(int n) throws TMException {
        if (0 <= n && n <= Integer.MAX_VALUE) {
            this.fRemoteAddress = n;
        } else {
            I2C.displayError(sI2CResources.getString("I2c.RemoteAddress.outOfBounds"));
        }
        this.setName("I2C-" + this.fBoardIndex + "-" + Integer.toHexString(this.fRemoteAddress) + "h");
        this.postPropertyChangedEvent("RemoteAddress", new Integer(this.fRemoteAddress));
    }

    @Override
    public void setHardwareTimeout(double d) throws TMException {
        this.timeout = (double)this.nativeSetHardwareTimeout(this.fId, this.fBoardIndex, (int)(d * 1000.0)) / 1000.0;
        this.postPropertyChangedEvent("HardwareTimeout", new BigDecimal(this.timeout));
    }

    @Override
    public double getHardwareTimeout() {
        double d = (double)this.nativeGetHardwareTimeout(this.fId) / 1000.0;
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    public Object[] hardwareInfo(String string, String string2, String string3) throws TMException {
        Object[] objectArray = new Object[8];
        objectArray[0] = string;
        objectArray[1] = I2C.jarVersion();
        objectArray[2] = this.fConstructorArgs[0];
        objectArray[5] = this.HwInfo(3);
        objectArray[6] = this.HwInfo(4);
        try {
            Integer[][] integerArray = this.findAllBoards();
            objectArray[7] = integerArray[0];
            objectArray[3] = integerArray[1];
        }
        catch (TMException tMException) {
            objectArray[7] = null;
            objectArray[3] = null;
        }
        objectArray[4] = "i2c('" + this.fConstructorArgs[0] + "', BoardIndex, RemoteAddress);";
        return objectArray;
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector vector = new Vector();
        this.addPVPair(vector, "ByteOrder", BYTE_ORDER[this.byteOrder]);
        this.addPVPair(vector, "InputBufferSize", this.inputBufferSize);
        this.addPVPair(vector, "ObjectVisibility", this.bool2OnOff(this.objectVisibility));
        this.addPVPair(vector, "OutputBufferSize", this.outputBufferSize);
        this.addPVPair(vector, "RecordDetail", RECORD_DETAIL[this.recordDetail]);
        this.addPVPair(vector, "RecordMode", RECORD_MODE[this.recordMode]);
        this.addPVPair(vector, "RecordName", this.recordName);
        this.addPVPair(vector, "Tag", this.tag);
        this.addPVPair(vector, "Timeout", this.timeout);
        this.addPVPair(vector, "TimerPeriod", this.timerPeriod);
        return null;
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("I2C-" + this.fBoardIndex + "-" + Integer.toHexString(this.fRemoteAddress) + "h");
                continue;
            }
            if (string.equals("BoardIndex")) {
                iCPropArray[i].setDefaultValue(this.fBoardIndex);
                continue;
            }
            if (string.equals("BoardSerial")) {
                iCPropArray[i].setDefaultValue(this.fBoardSerial);
                continue;
            }
            if (string.equals("RemoteAddress")) {
                iCPropArray[i].setDefaultValue(this.fRemoteAddress);
                continue;
            }
            if (string.equals("PullupResistors")) {
                iCPropArray[i].setDefaultValue(this.fPullupResistors);
                continue;
            }
            if (!string.equals("Vendor")) continue;
            iCPropArray[i].setDefaultValue(this.fVendor);
        }
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        String string = LINESEP + "   I2C Object : " + this.name + LINESEP + LINESEP + "   Communication Settings " + LINESEP + "      BoardIndex          " + this.fBoardIndex + LINESEP + "      BoardSerial         " + this.fBoardSerial + LINESEP + "      BitRate:            " + (int)this.fBitRate + " kHz" + LINESEP + "      RemoteAddress:      " + Integer.toHexString(this.fRemoteAddress) + 'h' + LINESEP + "      Vendor:             " + this.fVendor + LINESEP + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + LINESEP;
        System.out.println(string);
    }

    @Override
    public String setDisplay() {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + LINESEP + "    InputBufferSize" + LINESEP + "    Name" + LINESEP + "    ObjectVisibility: [ {on} | off ] " + LINESEP + "    OutputBufferSize" + LINESEP + "    RecordDetail: [ {compact} | verbose ]" + LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + LINESEP + "    RecordName" + LINESEP + "    Tag" + LINESEP + "    Timeout" + LINESEP + "    TimerFcn: string -or- function handle -or- cell array" + LINESEP + "    TimerPeriod" + LINESEP + "    UserData" + LINESEP + "    " + LINESEP + "    I2C specific properties:" + LINESEP + "    BitRate" + LINESEP + "    BoardIndex" + LINESEP + "    BoardSerial" + LINESEP + "    PullupResistors [ {both} | none ]" + LINESEP + "    RemoteAddress" + LINESEP + "    TargetPower [ {both} | none ]" + LINESEP + "    Vendor" + LINESEP + "       " + LINESEP;
    }

    public static String[] findValidAdaptors(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < I2C_ADAPTORS.length; ++i) {
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            String string2 = Instrument.extension();
            try {
                Class<?> clazz = Class.forName("com.mathworks.toolbox.instrument.I2C" + I2C_NAME[i].toUpperCase());
                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class, Integer.TYPE, Integer.TYPE);
                I2C i2C = (I2C)constructor.newInstance(string + Instrument.FILESEP + I2C_ADAPTORS[i] + string2, I2C_NAME[i].toLowerCase(), 0, 0);
                arrayList.add(I2C_NAME[i]);
                i2C.dispose();
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    protected String getErrorMessageFromHardware(int n) {
        return this.nativeGetErrorMessageFromHardware(n);
    }

    @Override
    protected void disposeMLArrayRefs() {
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"Vendor:", this.fVendor, "RemoteAddress:", Integer.toHexString(this.fRemoteAddress)};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return this.fVendor + ":" + this.fBoardSerial + ":[Remote Address: 0x" + Integer.toHexString(this.fRemoteAddress) + "]";
    }

    abstract Integer[][] findAllBoards() throws TMException;

    public abstract boolean hasI2CSlaveReturnedAck() throws TMException;

    protected abstract String HwInfo(int var1);

    protected abstract int nativeOpen(int var1) throws TMException;

    protected abstract int nativeClose(int var1) throws TMException;

    protected abstract Object[] nativeReadImpl(int var1, long var2, int var4, int var5) throws TMException;

    protected abstract int nativeWriteImpl(int var1, long var2, int var4, byte[] var5, int var6) throws TMException;

    protected abstract int[] nativeFindBoards() throws TMException;

    protected abstract String getHardwareBoardSerial(int var1) throws TMException;

    protected abstract double nativeGetBitRate(int var1, long var2) throws TMException;

    protected abstract double nativeSetBitRate(int var1, long var2, double var4) throws TMException;

    protected abstract int nativeGetPullupResistors(int var1) throws TMException;

    protected abstract int nativeSetPullupResistors(int var1, int var2) throws TMException;

    protected abstract int nativeSetHardwareTimeout(int var1, int var2, int var3) throws TMException;

    protected abstract int nativeGetHardwareTimeout(int var1);

    protected abstract String nativeGetErrorMessageFromHardware(int var1);
}

