/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.InstrumentAsync;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.util.Calendar;

public abstract class InstrumentAsyncContinuous
extends InstrumentAsync {
    protected static final int CONTINUOUS = 0;
    protected static final int MANUAL = 1;
    protected static final String[] RA_MODES = new String[]{"continuous", "manual"};
    protected static final int CR = 13;
    protected static final int LF = 10;
    protected static final int CRLF = 256;
    protected static final int LFCR = 257;
    protected static final String STR_CARRIAGE = new Character('\r').toString();
    protected static final String STR_LINEFEED = new Character('\n').toString();
    protected int readAsyncMode = 0;
    protected int terminator = 10;
    protected String terminatorChar = STR_LINEFEED;
    protected byte[] terminatorByte = this.terminatorChar.getBytes();
    protected MLArrayRef terminatorObject;
    protected Object displayTerminator = "'LF'";
    protected int readTerminator = 10;
    protected int writeTerminator = 10;
    protected String writeTerminatorChar = STR_LINEFEED;
    protected char char0 = this.terminatorChar.charAt(0);
    protected char char1 = this.terminatorChar.charAt(0);
    protected int tlength = this.terminatorChar.length();
    protected int numOfTerminatorsFound = 0;
    protected byte[] dataToWriteAsync = null;
    protected boolean asyncWriteFlag = false;
    protected int datatype = 0;
    protected int localBytesToOutput = 0;

    public final void setReadAsyncMode(int n) {
        this.readAsyncMode = n;
        this.postPropertyChangedEvent("ReadAsyncMode", RA_MODES[this.readAsyncMode]);
    }

    public final int getReadAsyncMode() {
        return this.readAsyncMode;
    }

    public final void setTerminator(MLArrayRef mLArrayRef) throws TMException {
        if (NativeMatlab.nativeIsMatlabThread()) {
            this.setTerminatorOnMatlabThread(mLArrayRef);
        } else {
            final MLArrayRef mLArrayRef2 = mLArrayRef;
            MatlabMCR matlabMCR = MatlabMCRFactory.getForCurrentMCR();
            matlabMCR.whenMatlabReady(new Runnable(){

                @Override
                public void run() {
                    try {
                        InstrumentAsyncContinuous.this.setTerminatorOnMatlabThread(mLArrayRef2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected final void setTerminatorOnMatlabThread(MLArrayRef mLArrayRef) throws TMException {
        if (this.getTransferStatus() != 0) {
            InstrumentAsyncContinuous.displayError("Terminator " + NOASYNCOP);
        }
        int[] nArray = this.getTerminatorInteger(mLArrayRef);
        this.readTerminator = nArray[0];
        this.writeTerminator = nArray[1];
        this.constructTerminatorVariables(mLArrayRef);
        if (this.status == 0) {
            this.terminator = this.readTerminator;
            this.terminatorObject = mLArrayRef;
            this.postPropertyChangedEvent("Terminator", this.terminatorObject);
            return;
        }
        try {
            this.terminatorObject.dispose();
            this.setHardwareTerminator(this.readTerminator);
            this.terminator = this.readTerminator;
            this.terminatorObject = mLArrayRef;
            this.postPropertyChangedEvent("Terminator", this.terminatorObject);
        }
        catch (Exception exception) {
            InstrumentAsyncContinuous.displayError(exception.getMessage());
        }
    }

    public final MLArrayRef getTerminator() {
        return this.terminatorObject;
    }

    private final void constructTerminatorVariables(MLArrayRef mLArrayRef) {
        switch (this.readTerminator) {
            case -1: {
                this.terminatorChar = "";
                break;
            }
            case 256: {
                this.terminatorChar = STR_CARRIAGE + STR_LINEFEED;
                break;
            }
            case 257: {
                this.terminatorChar = STR_LINEFEED + STR_CARRIAGE;
                break;
            }
            default: {
                this.terminatorChar = new Character((char)this.readTerminator).toString();
            }
        }
        this.terminatorByte = this.terminatorChar.getBytes();
        this.tlength = this.terminatorByte.length;
        if (this.tlength > 0) {
            this.char0 = this.terminatorChar.charAt(0);
        }
        if (this.tlength == 2) {
            this.char1 = this.terminatorChar.charAt(1);
        }
        switch (this.writeTerminator) {
            case -1: {
                this.writeTerminatorChar = "";
                break;
            }
            case 256: {
                this.writeTerminatorChar = STR_CARRIAGE + STR_LINEFEED;
                break;
            }
            case 257: {
                this.writeTerminatorChar = STR_LINEFEED + STR_CARRIAGE;
                break;
            }
            default: {
                this.writeTerminatorChar = new Character((char)this.writeTerminator).toString();
            }
        }
        if (mLArrayRef.getType() == 1) {
            Object[] objectArray = (Object[])mLArrayRef.getData();
            switch (objectArray.length) {
                case 1: {
                    this.displayTerminator = "{" + this.createDisplay(objectArray[0]) + "}";
                    break;
                }
                case 2: {
                    this.displayTerminator = "{" + this.createDisplay(objectArray[0]) + "," + this.createDisplay(objectArray[1]) + "}";
                }
            }
        } else {
            this.displayTerminator = this.createDisplay(mLArrayRef.getData());
        }
    }

    protected String createDisplay(Object object) {
        String string = "";
        if (object instanceof Double) {
            string = object.toString();
            return string.substring(0, string.indexOf("."));
        }
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            if (dArray.length == 0) {
                return "[]";
            }
            string = new Double(dArray[0]).toString();
            return string.substring(0, string.indexOf("."));
        }
        if (object == null || object.equals("")) {
            return "''";
        }
        if (object instanceof String || object instanceof Character) {
            return "'" + object + "'";
        }
        return string;
    }

    @Override
    protected synchronized void updateWriteTransferStatus(boolean bl) {
        if (bl) {
            switch (this.transferStatus) {
                case 1: {
                    this.transferStatus = 3;
                    break;
                }
                case 0: {
                    this.transferStatus = 2;
                }
            }
        } else {
            switch (this.transferStatus) {
                case 3: {
                    this.transferStatus = 1;
                    break;
                }
                case 2: {
                    this.transferStatus = 0;
                }
            }
        }
    }

    @Override
    protected synchronized void updateReadTransferStatus(boolean bl) {
        if (bl) {
            switch (this.transferStatus) {
                case 2: {
                    this.transferStatus = 3;
                    break;
                }
                case 0: {
                    this.transferStatus = 1;
                }
            }
        } else {
            switch (this.transferStatus) {
                case 3: {
                    this.transferStatus = 2;
                    break;
                }
                case 1: {
                    this.transferStatus = 0;
                }
            }
        }
    }

    @Override
    public boolean supportsAsynchronousOperations() {
        return true;
    }

    @Override
    protected void verifyReadOperation() throws TMException {
        if (this.transferStatus == 1) {
            InstrumentAsyncContinuous.displayError("An asynchronous read is already in progress.");
        }
        if (this.readAsyncMode == 1) {
            this.hardwareFlushInput();
            this.updateReadTransferStatus(true);
        }
    }

    @Override
    protected int getAsyncActionType(int n, int n2) {
        return n;
    }

    @Override
    protected boolean okToPollRead() {
        boolean bl = false;
        switch (this.readAsyncMode) {
            case 0: {
                bl = this.getBytesAvailableFromHardware() != 0 && this.inputBufferSize - this.getBytesAvailable() > 0;
                break;
            }
            case 1: {
                boolean bl2 = bl = this.readAsyncCount > 0 && this.getBytesAvailableFromHardware() != 0;
            }
        }
        if (this.readAsyncCount == 0 && this.readAsyncMode == 1) {
            this.hardwareFlushInput();
        }
        return bl;
    }

    @Override
    protected int readBinaryFromHardwareAsync(int n) {
        if (this.readAsyncMode == 0) {
            this.updateReadTransferStatus(false);
        }
        this.queueAction(IREADASYNCMODE_ACTION);
        this.queueAction(IREADASYNCMODE_ACTION);
        return this.getSuccessValue();
    }

    @Override
    protected byte[] readAsynchronousDataFromHardware(int n) {
        int n2 = 0;
        byte[] byArray = null;
        switch (this.readAsyncMode) {
            case 0: {
                this.updateReadTransferStatus(true);
                n2 = this.calculateAmountToRead(this.inputBufferSize - this.getBytesAvailable());
                byArray = this.readBytes(n2);
                this.putDataInputBuffer(byArray);
                this.updateReadTransferStatus(false);
                break;
            }
            case 1: {
                n2 = this.calculateAmountToRead(this.readAsyncCount);
                byArray = this.readBytes(n2);
                this.putDataInputBuffer(byArray);
                this.readAsyncCount -= byArray.length;
                if (this.readAsyncCount != 0 && this.numOfTerminatorsFound <= 0) break;
                this.updateReadTransferStatus(false);
                this.readAsyncCount = 0;
            }
        }
        byArray = null;
        return null;
    }

    private int calculateAmountToRead(int n) {
        int n2 = this.getBytesAvailableFromHardware();
        if (n > n2) {
            n = n2;
        }
        return n;
    }

    protected void putDataInputBuffer(byte[] byArray) {
        this.numOfTerminatorsFound = 0;
        if (byArray == null) {
            return;
        }
        byte by = this.inputBuffer.getLastByte();
        int n = 0;
        int n2 = 0;
        byte by2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            by2 = byArray[i];
            if (by2 < 0) {
                n = byArray.length - n2;
                break;
            }
            if (this.tlength == 1 && by2 == this.char0 || this.tlength == 2 && by == this.char0 && by2 == this.char1) {
                ++this.numOfTerminatorsFound;
                this.inputBuffer.addData(byArray, 1, null, n2, ++n);
                n2 += n;
                n = 0;
            } else {
                ++n;
            }
            by = byArray[i];
        }
        if (n != 0) {
            this.inputBuffer.addData(byArray, 0, null, n2, n);
        }
    }

    @Override
    protected int okToGenerateTerminatorBytesAvailableEvent(byte[] byArray) {
        if (this.ignoreReadEvents) {
            return 0;
        }
        return this.numOfTerminatorsFound;
    }

    @Override
    protected boolean okToGenerateReadAsyncTimeoutEvents() {
        return this.readAsyncMode == 1;
    }

    @Override
    protected boolean isReadAsyncOperationComplete(int n, int n2) {
        switch (n2) {
            case 0: {
                switch (this.readAsyncMode) {
                    case 0: {
                        return this.getBytesAvailable() >= n || this.inputBuffer.isReadComplete(1);
                    }
                    case 1: {
                        return this.getBytesAvailable() >= n || this.readAsyncCount == 0 || this.inputBuffer.isReadComplete(1);
                    }
                }
                break;
            }
            case 1: {
                switch (this.readAsyncMode) {
                    case 0: {
                        return this.getBytesAvailable() >= n;
                    }
                    case 1: {
                        return this.getBytesAvailable() >= n || this.readAsyncCount == 0;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected void hardwareStopAsync() throws TMException {
        this.readAsyncMode = 1;
        this.hardwareFlushOutput();
        this.updateReadTransferStatus(false);
        this.updateWriteTransferStatus(false);
    }

    @Override
    protected void hardwareFlushOutput() throws TMException {
        this.updateWriteTransferStatus(false);
        this.dataToWriteAsync = null;
        this.asyncWriteFlag = false;
        this.bytesToOutput = 0;
        this.localBytesToOutput = 0;
    }

    @Override
    protected void stopHardwareDueToReadTimeout() {
    }

    @Override
    protected int writeBinaryToHardwareAsync(byte[] byArray) {
        this.queueAction(IWRITEASYNC_ACTION);
        this.queueAction(INTEGER_ZERO);
        this.dataToWriteAsync = byArray;
        this.asyncWriteFlag = true;
        this.localBytesToOutput = byArray.length;
        return this.getSuccessValue();
    }

    @Override
    protected void writeAsyncData(int n) {
        if (this.dataToWriteAsync == null) {
            this.updateWriteTransferStatus(false);
            this.bytesToOutput = 0;
            this.localBytesToOutput = 0;
            return;
        }
        int n2 = this.dataToWriteAsync.length;
        int n3 = n;
        int n4 = n3 + this.getBlockSizeForWrite();
        if (n4 > n2) {
            n4 = n2;
        }
        int n5 = n4 - n3;
        int n6 = this.GetOutputDataType();
        this.valuesSent += (long)(n5 / DATASIZE[n6]);
        this.localBytesToOutput -= n5;
        int n7 = this.writeAsyncDataToHardware(n3, n5);
        if (n7 < this.getSuccessValue()) {
            this.updateWriteTransferStatus(false);
            this.bytesToOutput = 0;
            this.localBytesToOutput = 0;
            this.dataToWriteAsync = null;
            this.executeErrorEvent(Calendar.getInstance(), this.getErrorMessageFromHardware(n7));
        }
        if (n4 != n2 && (this.transferStatus == 2 || this.transferStatus == 3)) {
            this.queueAction(IWRITEASYNC_ACTION);
            this.queueAction(n4);
            this.bytesToOutput = this.localBytesToOutput;
        } else {
            this.updateWriteTransferStatus(false);
            this.dataToWriteAsync = null;
            this.bytesToOutput = 0;
            this.localBytesToOutput = 0;
            this.cleanupWriteAsync();
        }
    }

    @Override
    protected String getAsciiMessage(Object[] objectArray) {
        return this.getAsciiMessage(objectArray, this.writeTerminatorChar);
    }

    @Override
    protected String getAsciiMessage(String string) {
        return this.getAsciiMessage(string, this.writeTerminatorChar);
    }

    @Override
    protected void verifyWriteOperation(int n) throws TMException {
        if (this.transferStatus == 2) {
            InstrumentAsyncContinuous.displayError("An asynchronous write is already in progress.");
        }
    }

    @Override
    protected boolean supportReadAsyncMode() {
        return true;
    }

    @Override
    protected Object[] readAsciiFromHardware(int n, double d) throws Exception {
        this.ignoreReadEvents = true;
        this.readAsyncCount = n;
        this.readAsyncStartTime = InstrumentAsyncContinuous.currentNanoTicTime();
        while (!InstrumentAsyncContinuous.nanoTicTimeout(this.readAsyncStartTime, d) && this.readAsyncCount > 0) {
            Thread.sleep(SLEEPTIME);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = this.inputBuffer.getDataWithInfo(n);
        if (objectArray2 != null) {
            objectArray[0] = new String((byte[])objectArray2[0]);
            objectArray[1] = new Integer(this.getSuccessValue());
        } else {
            objectArray[0] = new Integer(this.getReadTimeoutErrorCode());
        }
        this.ignoreReadEvents = false;
        this.updateReadTransferStatus(false);
        return objectArray;
    }

    @Override
    protected Object[] readBinaryFromHardware(int n, double d) throws Exception {
        this.ignoreReadEvents = true;
        this.readAsyncCount = this.inputBuffer.getBytesAvailable() - n;
        this.readAsyncStartTime = InstrumentAsyncContinuous.currentNanoTicTime();
        while (!InstrumentAsyncContinuous.nanoTicTimeout(this.readAsyncStartTime, d) && this.inputBuffer.getBytesAvailable() < n) {
            if (this.readAsyncCount == 0) {
                this.readAsyncCount = n - this.inputBuffer.getBytesAvailable();
                this.readAsyncStartTime = InstrumentAsyncContinuous.nanoBadTime();
            }
            Thread.sleep(SLEEPTIME);
        }
        int n2 = this.inputBuffer.getBytesAvailable();
        this.readAsyncCount = 0;
        this.readAsyncStartTime = InstrumentAsyncContinuous.nanoBadTime();
        if (n2 != n) {
            Object[] objectArray = new Object[]{null};
            this.ignoreReadEvents = false;
            return objectArray;
        }
        Object[] objectArray = this.inputBuffer.getDataWithInfo(n2);
        objectArray[1] = new Integer(n2);
        this.ignoreReadEvents = false;
        this.updateReadTransferStatus(false);
        return objectArray;
    }

    @Override
    protected String removeTerminator(String string) {
        if (this.terminator == -1) {
            return string;
        }
        if (string.endsWith(this.terminatorChar)) {
            return string.substring(0, string.length() - this.terminatorChar.length());
        }
        return string;
    }

    @Override
    protected String wasAsciiReadSuccessful(String string, int n, int n2) {
        if (ctrlc_flag) {
            return "Ctrl-C was hit before the data was read.";
        }
        if (n2 != 0) {
            return "";
        }
        if (n == 0 && string.length() == this.inputBufferSize && !string.endsWith(this.terminatorChar)) {
            return "The input buffer was filled before the Terminator was reached.";
        }
        if (n == 0 && string.length() != this.inputBufferSize && this.terminatorChar.equals("")) {
            return "A timeout occurred.";
        }
        if (n != 0 && string.length() != n && this.terminatorChar.equals("")) {
            return "A timeout occurred before SIZE values were available.";
        }
        if (n == 0 && string.length() != this.inputBufferSize && !string.endsWith(this.terminatorChar)) {
            return "A timeout occurred before the Terminator was reached.";
        }
        if (n != 0 && string.length() != n && !string.endsWith(this.terminatorChar) && !this.terminatorChar.equals("")) {
            return "A timeout occurred before the Terminator was reached or SIZE values were available.";
        }
        if (n != 0 && string.length() < n && string.endsWith(this.terminatorChar)) {
            return "The Terminator was reached before SIZE values were available.";
        }
        return "";
    }

    @Override
    protected String wasBinaryReadSuccessful(int n, int n2, String string, int n3) {
        if (n < n2) {
            return "The specified amount of data was not returned within the Timeout period.";
        }
        return "";
    }

    @Override
    protected String getTimeoutMessage(int n, int n2) {
        if (n2 == 0) {
            if (n == 0) {
                if (this.terminatorChar.equals("")) {
                    return "A timeout occurred.";
                }
                return "A timeout occurred before the Terminator was reached.";
            }
            if (this.terminatorChar.equals("")) {
                return "A timeout occurred before SIZE values were available.";
            }
            return "A timeout occurred before the Terminator was reached or SIZE values were available.";
        }
        return "The specified amount of data was not returned within the Timeout period.";
    }

    protected abstract void setHardwareTerminator(int var1) throws TMException;

    protected abstract int[] getTerminatorInteger(MLArrayRef var1) throws TMException;

    protected abstract int getBytesAvailableFromHardware();

    protected abstract byte[] readBytes(int var1);

    protected abstract int getBlockSizeForWrite();

    protected abstract int writeAsyncDataToHardware(int var1, int var2);

    protected abstract void cleanupWriteAsync();

    protected abstract int getReadTimeoutErrorCode();
}

