/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.Pxi;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Vector;

public final class PxiVisa
extends Pxi
implements ActionListener {
    private MLArrayRef interruptFcn = ACTION;
    private MLArrayRef triggerFcn = ACTION;
    private VISA visa;
    private int defaultRM;
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("BusNumber", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("ChassisNumber", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("DeviceNumber", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("FunctionNumber", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("InterruptFcn", "callback", "callback", "", "", "never", 1, 0), new ICProp("MappedMemoryBase", "string", "none", "", "0H", "always", 1, 0), new ICProp("MappedMemorySize", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("MemoryIncrement", "string", "enum", MIncVals, "block", "never", 1, 0), new ICProp("ModelName", "string", "none", "", "", "always", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("SlotNumber", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("SlotPath", "String", "none", "", "", "always", 1, 0), new ICProp("TriggerBusNumber", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("TriggerFcn", "callback", "callback", "", "", "never", 1, 0), new ICProp("TriggerLine", "string", "enum", TRIGGER_LINES, "TTL0", "never", 1, 0), new ICProp("TriggerType", "string", "enum", TRIGGER_TYPES, "hardware", "never", 1, 0), new ICProp("Type", "string", "none", "", "visa-pxi", "always", 0, 0)};

    public PxiVisa() {
        this.deleteInstrumentObject(this);
    }

    public PxiVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            PxiVisa.displayError("The Instrument Control Toolbox license check failed when trying to execute: 'visa'.");
        }
        try {
            this.rsrcName = string3;
            if (this.rsrcName.matches("PXI\\d+::\\d+::INSTR")) {
                int n = this.rsrcName.indexOf("::");
                this.busNumber = Integer.parseInt(this.rsrcName.substring(3, n));
                int n2 = this.rsrcName.lastIndexOf("::");
                this.deviceNumber = Integer.parseInt(this.rsrcName.substring(n + 2, n2));
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.info[0] = string + FILESEP + string2;
            this.info[1] = PxiVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.name = "VISA-PXI" + this.busNumber + "-" + this.deviceNumber;
            this.type = "visa-pxi";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
            this.displayName = "VISA-PXI";
            this.visaobj = this.visa;
            this.objectPolls = false;
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    public String getInspectorToolbarObjectName() {
        return "VISA-PXI";
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "MemoryIncrement", MEMINC[this.memoryIncrement]);
        this.addPVPair(vector, "TriggerLine", TRIGGER_LINES[this.triggerLine]);
        this.addPVPair(vector, "TriggerType", TRIGGER_TYPES[this.triggerType]);
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public void setInterruptFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("InterruptFcn", 3, mLArrayRef);
        if (this.interruptFcn != ACTION) {
            this.interruptFcn.dispose();
        }
        this.interruptFcn = mLArrayRef2;
        this.disabledCallbacks[3] = 0;
        this.postPropertyChangedEvent("InterruptFcn", this.interruptFcn);
    }

    public MLArrayRef getInterruptFcn() {
        return this.interruptFcn;
    }

    public void clrdevice() throws TMException {
        this.verifyObjectState();
        PxiVisa.displayError("CLRDEVICE is supported for GPIB, VISA-GPIB, VISA-VXI, VISA-USB, VISA-TCPIP, VISA-SERIAL  and VISA-RSIB objects. ");
    }

    public void setTriggerFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("TriggerFcn", 7, mLArrayRef);
        if (this.triggerFcn != ACTION) {
            this.triggerFcn.dispose();
        }
        this.triggerFcn = mLArrayRef2;
        this.disabledCallbacks[7] = 0;
        if (this.status == 0) {
            this.postPropertyChangedEvent("TriggerFcn", this.triggerFcn);
            return;
        }
        if (this.triggerFcn == ACTION) {
            this.visa.EnableAction(this, this.handle, 204, 0);
        } else {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
        this.postPropertyChangedEvent("TriggerFcn", this.triggerFcn);
    }

    public MLArrayRef getTriggerFcn() {
        return this.triggerFcn;
    }

    public void setTriggerLine(int n) throws TMException {
        if (this.status == 0) {
            this.triggerLine = n;
            this.postPropertyChangedEvent("TriggerLine", TRIGGER_LINES[this.triggerLine]);
            return;
        }
        boolean bl = false;
        if (this.triggerFcn != ACTION) {
            bl = true;
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 0);
        }
        try {
            this.setHardwareTriggerLine(n);
            this.triggerLine = n;
            this.postPropertyChangedEvent("TriggerLine", TRIGGER_LINES[this.triggerLine]);
        }
        catch (Exception exception) {
            if (bl) {
                this.visa.EnableAction(this, this.handle, 204, 1);
            }
            PxiVisa.displayError(exception.getMessage());
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
    }

    public int getTriggerLine() {
        return this.triggerLine;
    }

    public void setTriggerType(int n) throws TMException {
        if (this.status == 0) {
            this.triggerType = n;
            this.postPropertyChangedEvent("TriggerType", TRIGGER_TYPES[this.triggerType]);
            return;
        }
        boolean bl = false;
        if (this.triggerFcn != ACTION) {
            bl = true;
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 0);
        }
        try {
            this.setHardwareTriggerType(n);
            this.triggerType = n;
            this.postPropertyChangedEvent("TriggerType", TRIGGER_TYPES[this.triggerType]);
        }
        catch (Exception exception) {
            if (bl) {
                this.visa.EnableAction(this, this.handle, 204, 1);
            }
            PxiVisa.displayError(exception.getMessage());
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
    }

    public int getTriggerType() {
        return this.triggerType;
    }

    protected void setHardwareTriggerLine(int n) throws TMException {
        int n2 = this.visa.Set(this.handle, 205, n);
        if (n2 < 0) {
            PxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
        }
    }

    protected void setHardwareTriggerType(int n) throws TMException {
        int n2 = 0;
        switch (this.triggerType) {
            case 0: {
                n2 = this.visa.Set(this.handle, 205, this.triggerLine);
                break;
            }
            case 10: {
                n2 = this.visa.Set(this.handle, 205, this.triggerType);
            }
        }
        if (n2 < 0) {
            PxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
        }
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-PXI" + this.busNumber + "-" + this.deviceNumber);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", PxiVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "PxiVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected void openHardware() throws TMException {
        int[] nArray;
        if (this.isInUse()) {
            PxiVisa.displayError("The specified configuration: " + this.rsrcName + " is not available. " + LINESEP + "Use INSTRHWINFO for a list of available configurations." + " Use INSTRFIND to " + LINESEP + "determine if other instrument " + "objects are connected to the requested instrument.");
        }
        if ((nArray = this.visa.Create(this, this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
        } else {
            PxiVisa.displayError("Could not open VISA object. Use INSTRHWINFO for a list of available configurations.");
        }
    }

    @Override
    protected void updatePropsOnOpen() throws Exception {
        String[] stringArray = new String[7];
        int n = 0;
        this.getChassisNumber();
        this.getSlotNumber();
        this.getBusNumber();
        this.getDeviceNumber();
        this.getFunctionNumber();
        this.getModelName();
        this.name = "VISA-PXI" + this.busNumber + "-" + this.deviceNumber;
        try {
            this.setHardwareMemoryIncrement(this.memoryIncrement);
        }
        catch (Exception exception) {
            stringArray[n++] = "MemoryIncrement";
        }
        try {
            this.setHardwareTimeout(this.timeout);
            this.timeout = this.getHardwareTimeout();
        }
        catch (Exception exception) {
            stringArray[n++] = "Timeout";
        }
        try {
            this.setHardwareTriggerLine(this.triggerLine);
            if (this.triggerFcn != ACTION) {
                this.visa.EnableAction(this, this.handle, 204, 1);
            }
        }
        catch (Exception exception) {
            stringArray[n++] = "TriggerLine";
        }
        if (n == 0) {
            return;
        }
        TMStringUtil.warning((String)this.constrctUpdatePropsOnOpenWarning(stringArray));
    }

    @Override
    protected void closeHardware() throws Exception {
        int n;
        if (this.objectPolls) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if (this.mappedMemorySize != 0) {
            this.visa.UnMapAddress(this.handle);
            this.mappedMemorySize = 0;
            this.mappedMemoryBase = "0H";
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            PxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
        this.handle = 0;
    }

    private boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof PxiVisa)) continue;
            PxiVisa pxiVisa = (PxiVisa)e;
            if (!(pxiVisa.rsrcName.equals(this.rsrcName) & pxiVisa.status == 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.interruptFcn != ACTION) {
            this.interruptFcn.dispose();
        }
        if (this.triggerFcn != ACTION) {
            this.triggerFcn.dispose();
        }
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    public void interruptAction() {
        if (!this.interruptFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(3, "Interrupt", this.eventTime, new ICEvent("Interrupt", PxiVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    public void triggerAction(int n) {
        if (!this.triggerFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(7, "Trigger", this.eventTime, new ICEvent("Trigger", n - 10, PxiVisa.constructClockVector(this.eventTime)));
        }
    }

    public void trigger() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Trigger(this.handle);
        if (n < 0) {
            PxiVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("ChassisNumber")) {
                iCPropArray[i].setDefaultValue(this.chassisNumber);
                continue;
            }
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("VISA-PXI" + this.busNumber + "-" + this.deviceNumber);
                continue;
            }
            if (string.equals("RsrcName")) {
                iCPropArray[i].setDefaultValue(this.rsrcName);
                continue;
            }
            if (!string.equals("Alias")) continue;
            iCPropArray[i].setDefaultValue(this.alias);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        String string = LINESEP + "   VISA-PXI Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + "   Communication Address " + LINESEP + "      ChassisNumber:      " + this.chassisNumber + LINESEP + "      BusNumber:       \t  " + this.busNumber + LINESEP + "      DeviceNumber:       " + this.deviceNumber + LINESEP + "      FunctionNumber:     " + this.functionNumber + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
        System.out.println(string);
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    VISA-PXI specific properties:" + LINESEP + "    BusNumber" + LINESEP + "    ChassisNumber" + LINESEP + "    DeviceNumber" + LINESEP + "    FunctionNumber" + LINESEP + "    InterruptFcn: string -or- function handle -or- cell array" + LINESEP + "    MemoryIncrement [ {block} | FIFO ] " + LINESEP + "    TriggerFcn: string -or- function handle -or- cell array" + LINESEP + "    TriggerLine: [ {TTL0} | TTL1 | TTL2 | TTL3 | TTL4 | TTL5 | TTL6 | TTL7 ]" + LINESEP + "    TriggerType: [ {hardware} | software ] " + LINESEP + " " + LINESEP;
    }
}

