/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.driver.DriverPageInfo;
import com.mathworks.toolbox.instrument.device.drivers.DriverUtil;
import com.mathworks.toolbox.instrument.guiutil.NewObjectDialog;
import com.mathworks.toolbox.instrument.util.ICUtil;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CreateObjectDialog
extends MJPanel
implements ActionListener,
MouseListener,
WindowListener,
InstrumentObjectListener {
    private static final long serialVersionUID = 1L;
    protected static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.browser.resources.RES_BROWSER");
    private static final String ACTION = "ACTION";
    private static final int OK = 0;
    private static final int CLOSE = 1;
    private static final int HELP = 2;
    private static final int CREATE_INTERFACE = 3;
    private static final int SCAN_RESOURCES = 4;
    private static final int kDefaultDriverLabelWidth = 300;
    private InstrumentControlBrowser browser;
    private MJFrame frame;
    private MJDialog dialog;
    private MJPanel configurePanel;
    private MJPanel interfacePanel;
    private MJComboBox interfaceBox;
    private MJButton createInterfaceButton;
    private MJButton scanResourcesButton;
    private MJPanel resourcePanel;
    private MJComboBox resourceBox;
    private MJLabel rsrcintfLabel;
    private String resourceStr = sResources.getString("DeviceObjectCreateDialog.ResourceLabel");
    private String interfaceStr = sResources.getString("DeviceObjectCreateDialog.InterfaceLabel");
    private MJLabel driverNameLabel;
    private MJLabel driverPathLabel;
    private MJButton okButton;
    private MJCheckBox selectTreeNodeOption;
    private MJCheckBox showDialogOption;
    private DriverPageInfo driverPageInfo;
    private String driverNameWithPath = "";
    private String driverName = "";
    private String driverPath = "";
    private MJLabel tempLabel = new MJLabel("");
    private Hashtable<Instrument, String> instrumentObjects = new Hashtable();
    private DeviceObjectWorker createObjectWorker = null;
    private VisaReourcesWorker visaResourcesWorker;

    public CreateObjectDialog() {
        this.setLayout(new GridBagLayout());
        this.layoutPanel();
    }

    public void update(DriverPageInfo driverPageInfo) {
        this.driverPageInfo = driverPageInfo;
        this.driverNameWithPath = driverPageInfo.getDriverNameWithPath();
        this.driverName = DriverUtil.parseDriverName(this.driverNameWithPath);
        this.driverPath = DriverUtil.parseDriverPath(this.driverNameWithPath);
        this.driverNameLabel.setText(this.driverName);
        this.driverPathLabel.setText(this.driverPath);
        if (this.driverPageInfo.getMatlabDriverType() == 0) {
            this.rsrcintfLabel.setText(this.interfaceStr);
            this.updateInterfacePanel((JPanel)this.resourcePanel, (JPanel)this.interfacePanel);
            this.updateInterfaceComboBox();
            Instrument.addInstrumentObjectListener(this);
        } else {
            this.rsrcintfLabel.setText(this.resourceStr);
            this.updateInterfacePanel((JPanel)this.interfacePanel, (JPanel)this.resourcePanel);
        }
        this.selectTreeNodeOption.setSelected(driverPageInfo.getSelectTreeNode());
        this.showDialogOption.setSelected(false);
        Object object = driverPageInfo.getInterface();
        if (object == null) {
            if (this.interfaceBox.getItemCount() > 0) {
                this.interfaceBox.setSelectedIndex(0);
            }
            return;
        }
        String string = this.instrumentObjects.get(object);
        if (string != null) {
            this.interfaceBox.setSelectedItem((Object)string);
        } else if (this.interfaceBox.getItemCount() > 0) {
            this.interfaceBox.setSelectedIndex(0);
        }
    }

    private void layoutPanel() {
        ICUtil.addComponent((Container)((Object)this), (Component)this.createInterfacePanel(), 0, 0, 1.0, 0.0, 1, 1, 2, new Insets(4, 4, 4, 4), 17);
        ICUtil.addComponent((Container)((Object)this), (Component)this.createChoicesPanel(), 0, 1, 1.0, 0.0, 1, 1, 2, new Insets(0, 4, 4, 4), 17);
        ICUtil.addComponent((Container)((Object)this), (Component)this.createButtonPanel(), 0, 2, 1.0, 1.0, 1, 1, 1, new Insets(4, 4, 4, 4), 15);
    }

    private MJPanel createInterfacePanel() {
        this.configurePanel = new MJPanel((LayoutManager)new GridBagLayout());
        this.interfaceBox = new MJComboBox();
        this.createInterfaceButton = new MJButton(sResources.getString("DeviceObjectCreateDialog.CreateLabel"));
        this.createInterfaceButton.addActionListener((ActionListener)this);
        this.createInterfaceButton.putClientProperty((Object)ACTION, (Object)new Integer(3));
        this.resourceBox = new MJComboBox();
        this.scanResourcesButton = new MJButton(sResources.getString("DeviceObjectCreateDialog.ScanLabel"));
        this.scanResourcesButton.addActionListener((ActionListener)this);
        this.scanResourcesButton.putClientProperty((Object)ACTION, (Object)new Integer(4));
        this.rsrcintfLabel = new MJLabel(this.interfaceStr);
        ICUtil.addComponent((Container)this.configurePanel, (Component)new MJLabel(sResources.getString("DeviceObjectCreateDialog.DriverNameLabel")), 0, 0, 0.0, 0.0, 1, 1, 0, new Insets(0, 0, 0, 4), 17);
        this.driverNameLabel = new MJLabel();
        ICUtil.addComponent((Container)this.configurePanel, (Component)this.driverNameLabel, 1, 0, 0.0, 0.0, 1, 1, 2, new Insets(0, 0, 0, 0), 17);
        ICUtil.addComponent((Container)this.configurePanel, (Component)this.rsrcintfLabel, 0, 1, 0.0, 0.0, 1, 1, 0, new Insets(4, 0, 0, 4), 17);
        this.interfacePanel = new MJPanel((LayoutManager)new GridBagLayout());
        ICUtil.addComponent((Container)this.interfacePanel, (Component)this.interfaceBox, 0, 0, 1.0, 0.0, 1, 1, 2, new Insets(0, 0, 0, 0), 17);
        ICUtil.addComponent((Container)this.interfacePanel, (Component)this.createInterfaceButton, 1, 0, 0.0, 0.0, 1, 1, 0, new Insets(0, 4, 0, 0), 17);
        this.resourcePanel = new MJPanel((LayoutManager)new GridBagLayout());
        ICUtil.addComponent((Container)this.resourcePanel, (Component)this.resourceBox, 0, 0, 1.0, 0.0, 1, 1, 2, new Insets(0, 0, 0, 0), 17);
        ICUtil.addComponent((Container)this.resourcePanel, (Component)this.scanResourcesButton, 1, 0, 0.0, 0.0, 1, 1, 0, new Insets(0, 4, 0, 0), 17);
        ICUtil.addComponent((Container)this.configurePanel, (Component)this.interfacePanel, 1, 1, 1.0, 0.0, 1, 1, 2, new Insets(4, 0, 0, 0), 17);
        ICUtil.addComponent((Container)this.configurePanel, (Component)new MJLabel(sResources.getString("DeviceObjectCreateDialog.DriverPathLabel")), 0, 2, 0.0, 0.0, 1, 1, 0, new Insets(4, 0, 0, 4), 17);
        this.driverPathLabel = new MJLabel();
        this.driverPathLabel.addMouseListener((MouseListener)this);
        ICUtil.addComponent((Container)this.configurePanel, (Component)this.driverPathLabel, 1, 2, 0.0, 0.0, 1, 1, 2, new Insets(4, 0, 0, 0), 17);
        ICUtil.addComponent((Container)this.configurePanel, (Component)this.driverNameLabel, 1, 0, 0.0, 0.0, 1, 1, 2, new Insets(0, 0, 0, 0), 17);
        ICUtil.setPreferredWidth((JComponent)this.interfacePanel, 300);
        ICUtil.setPreferredWidth((JComponent)this.resourcePanel, 300);
        this.configurePanel.setBorder((Border)BorderFactory.createTitledBorder(sResources.getString("DeviceObjectCreateDialog.CreationBorderTitle")));
        return this.configurePanel;
    }

    private MJPanel createChoicesPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(2, 1, 0, 0));
        this.selectTreeNodeOption = new MJCheckBox(sResources.getString("DeviceObjectCreateDialog.SelectNodeOption"));
        this.showDialogOption = new MJCheckBox(sResources.getString("DeviceObjectCreateDialog.SkipDialogOption"));
        this.selectTreeNodeOption.setSelected(false);
        this.showDialogOption.setSelected(false);
        this.selectTreeNodeOption.setName("Select the tree node CheckBox");
        this.showDialogOption.setName("Don't show again CheckBox");
        mJPanel.add((Component)this.selectTreeNodeOption);
        mJPanel.add((Component)this.showDialogOption);
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(sResources.getString("DeviceObjectCreateDialog.OptionsBorderTitle")));
        return mJPanel;
    }

    private MJPanel createButtonPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2, 0, 0));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(1, 3, 4, 0));
        this.okButton = new MJButton(sResources.getString("DeviceObjectCreateDialog.OkButton"));
        this.okButton.putClientProperty((Object)ACTION, (Object)new Integer(0));
        this.okButton.addActionListener((ActionListener)this);
        this.okButton.setName("OK Button");
        MJButton mJButton = new MJButton(sResources.getString("DeviceObjectCreateDialog.CancelButton"));
        mJButton.putClientProperty((Object)ACTION, (Object)new Integer(1));
        mJButton.addActionListener((ActionListener)this);
        mJButton.setName("Cancel Button");
        mJPanel2.add((Component)this.okButton);
        mJPanel2.add((Component)mJButton);
        mJPanel.add((Component)mJPanel2);
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        return mJPanel;
    }

    public void showAsDialog(MJFrame mJFrame, InstrumentControlBrowser instrumentControlBrowser) {
        this.frame = mJFrame;
        this.browser = instrumentControlBrowser;
        this.dialog = new MJDialog((Frame)this.frame, sResources.getString("DeviceObjectCreateDialog.Title"), true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getRootPane().setDefaultButton((JButton)this.okButton);
        this.okButton.setEnabled(true);
        this.dialog.getContentPane().add((Component)((Object)this));
        this.dialog.pack();
        this.dialog.setResizable(false);
        ICUtil.centerWindow((Window)this.frame, (Window)this.dialog);
        this.dialog.addWindowListener((WindowListener)this);
        this.dialog.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.okButton.setEnabled(false);
                if (this.createObjectWorker == null) {
                    this.createObjectWorker = new DeviceObjectWorker();
                }
                this.createObjectWorker.configure(this.driverNameWithPath, this.getSecondArgumentForDeviceConstructor(), false, true);
                this.createObjectWorker.start();
                break;
            }
            case 1: {
                this.closeWindow();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                new NewObjectDialog(1).showAsDialog(this.frame);
                break;
            }
            case 4: {
                this.visaResourcesWorker = new VisaReourcesWorker();
                this.visaResourcesWorker.start();
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindow();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.tempLabel.setText(this.driverPath);
        if (this.driverPathLabel.getWidth() < this.tempLabel.getPreferredSize().width) {
            this.driverPathLabel.setToolTipText(this.driverPath);
        } else {
            this.driverPathLabel.setToolTipText(null);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.driverPathLabel.setToolTipText(null);
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        string2 = this.getInstrumentNameForComboBox(instrument.getName());
        this.interfaceBox.addItem((Object)string2);
        this.instrumentObjects.put(instrument, string2);
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
    }

    public void createObject(DriverPageInfo driverPageInfo) {
        if (this.driverPageInfo.getMatlabDriverType() != 0) {
            this.createObjectWorker.configure(driverPageInfo.getDriverNameWithPath(), driverPageInfo.getSecondArgument(), driverPageInfo.getSelectTreeNode(), false);
        } else {
            Object[] objectArray = new Object[]{driverPageInfo.getSecondArgument(), driverPageInfo.getInstrfindArgs()};
            this.createObjectWorker.configure(driverPageInfo.getDriverNameWithPath(), objectArray, driverPageInfo.getSelectTreeNode(), false);
        }
        this.createObjectWorker.start();
    }

    private void closeWindow() {
        if (this.driverPageInfo.getMatlabDriverType() == 0) {
            Instrument.removeInstrumentObjectListener(this);
        }
        this.driverPageInfo.setShowDialog(!this.showDialogOption.isSelected());
        if (this.showDialogOption.isSelected()) {
            Instrument instrument;
            this.driverPageInfo.setSecondArgument(this.getSecondArgumentForStorage());
            if (this.driverPageInfo.getMatlabDriverType() == 0 && (instrument = this.getInstrument()) != null) {
                this.driverPageInfo.setInstrfindArgs(this.getInstrument().getInstrfindArgs());
            }
        }
        this.dialog.dispose();
        this.driverPageInfo.setSelectTreeNode(this.selectTreeNodeOption.isSelected());
        this.driverPageInfo.setInterface(this.getSecondArgumentForDeviceConstructor());
        if (this.selectTreeNodeOption.isSelected()) {
            this.browser.selectLastDeviceObjectInTree();
        }
    }

    private void updateInterfacePanel(JPanel jPanel, JPanel jPanel2) {
        this.configurePanel.remove((Component)jPanel);
        ICUtil.addComponent((Container)this.configurePanel, jPanel2, 1, 1, 1.0, 0.0, 1, 1, 2, new Insets(4, 0, 0, 0), 17);
        this.repaint();
    }

    private void updateInterfaceComboBox() {
        Instrument instrument = this.getInstrument();
        this.instrumentObjects.clear();
        this.interfaceBox.removeAllItems();
        Vector<Instrument> vector = Instrument.getNonLockedObjects();
        String string = "";
        Instrument instrument2 = null;
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            instrument2 = vector.elementAt(i);
            string = this.getInstrumentNameForComboBox(instrument2.getName());
            this.interfaceBox.addItem((Object)string);
            this.instrumentObjects.put(instrument2, string);
            if (!instrument2.equals(instrument)) continue;
            n = i;
        }
        if (n != -1) {
            this.interfaceBox.setSelectedIndex(n);
        } else if (this.interfaceBox.getItemCount() > 0) {
            this.interfaceBox.setSelectedIndex(0);
        }
    }

    private String getInstrumentNameForComboBox(String string) {
        int n = 0;
        for (int i = 0; i < this.interfaceBox.getItemCount(); ++i) {
            String string2 = (String)this.interfaceBox.getItemAt(i);
            if (!string2.equals(string) && !string2.startsWith(string + " (")) continue;
            ++n;
        }
        if (n == 0) {
            return string;
        }
        return string + " (" + n + ")";
    }

    private Instrument getInstrument() {
        String string = (String)this.interfaceBox.getSelectedItem();
        if (string == null) {
            return null;
        }
        Enumeration<Instrument> enumeration = this.instrumentObjects.keys();
        while (enumeration.hasMoreElements()) {
            Instrument instrument = enumeration.nextElement();
            String string2 = this.instrumentObjects.get(instrument);
            if (!string2.equals(string)) continue;
            return instrument;
        }
        return null;
    }

    private String getVisaResource() {
        String string = (String)this.resourceBox.getSelectedItem();
        return string == null ? null : string.trim();
    }

    private Object getSecondArgumentForDeviceConstructor() {
        if (this.driverPageInfo.getMatlabDriverType() == 0) {
            return this.getInstrument();
        }
        return this.getVisaResource();
    }

    private String getSecondArgumentForStorage() {
        if (this.driverPageInfo.getMatlabDriverType() == 0) {
            if (this.getInstrument() != null) {
                return this.getInstrument().getConstructor();
            }
            return "";
        }
        return "";
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void populateResourcesBox(String[] stringArray) {
        this.resourceBox.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            this.resourceBox.addItem((Object)stringArray[i]);
        }
    }

    class DeviceObjectWorker
    extends MatlabWorker<Object> {
        private Object[] args = new Object[]{"privateCreateObjHelper", "device", "", ""};
        private boolean selectNode = false;
        private boolean dialogShown = true;

        DeviceObjectWorker() {
        }

        public void configure(String string, Object object, boolean bl, boolean bl2) {
            this.args[2] = string;
            this.args[3] = object;
            this.selectNode = bl;
            this.dialogShown = bl2;
        }

        public Object runOnMatlabThread() {
            String string = null;
            try {
                DeviceObjectWorker.feval((String)"instrgate", (Object[])this.args, (int)0, (boolean)false);
            }
            catch (Exception exception) {
                string = exception.getMessage();
            }
            return string;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (object != null && object instanceof String) {
                TMStringUtil.error((MJFrame)CreateObjectDialog.this.frame, (String)sResources.getString("DeviceObjectCreateDialog.ErrorTitle"), (String)object.toString());
            } else if (this.dialogShown) {
                CreateObjectDialog.this.closeWindow();
            } else if (this.selectNode) {
                CreateObjectDialog.this.browser.selectLastDeviceObjectInTree();
            }
            CreateObjectDialog.this.okButton.setEnabled(true);
        }
    }

    class VisaReourcesWorker
    extends MatlabWorker<Object> {
        private Object[] args = new Object[]{"privateFindHwInfo", "visa"};

        VisaReourcesWorker() {
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (object == null) {
                return;
            }
            String[] stringArray = (String[])object;
            CreateObjectDialog.this.populateResourcesBox(stringArray);
        }

        public Object runOnMatlabThread() throws Exception {
            Object object = null;
            try {
                object = VisaReourcesWorker.feval((String)"instrgate", (Object[])this.args, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object;
        }
    }
}

